/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.crypto.fragments;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.RKSuiteIdentifier;
import at.asitplus.regkassen.common.TurnoverCounterType;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.RK_SUITE_ID, VerificationInputOutput.AESKEY}, verificationID=VerificationID.CRYPTO_TURNOVER_COUNTER, version=1)
public class CryptoTurnoverCounterVerificationModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        verificationResult.setVerificationState(VerificationState.PASS);
        VerificationProperty verificationProperty = verificationResult.getInputData(VerificationInputOutput.RECEIPT);
        Object object = verificationResult.getInputData(VerificationInputOutput.AESKEY);
        String string = CashBoxUtils.getValueFromMachineCode((String)verificationProperty.getValue(), (MachineCodeValue)MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE);
        if (TurnoverCounterType.TRA.getEncodedValue().equals(string) || TurnoverCounterType.STO.getEncodedValue().equals(string)) {
            try {
                verificationResult.addOutput(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE, new String(CashBoxUtils.base64Decode((String)string, (boolean)false), "UTF-8"));
                verificationResult.setVerificationState(VerificationState.PASS);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                verificationResult.setVerificationState(VerificationState.FAIL);
                verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_UNDECODABLE, new String[0]);
                verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)unsupportedEncodingException));
            }
            return verificationResult;
        }
        string = verificationResult.getInputData(VerificationInputOutput.RK_SUITE_ID).getValue();
        try {
            string = RKSuiteIdentifier.valueOf((String)string);
        }
        catch (Exception exception) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.RKSUITE_UNKNOWN, new String[0]);
            verificationResult.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        object = object.getValue();
        if (Placeholder.NULL.name().equals(object)) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.AESKEY_NOT_PROVIDED, new String[0]);
            return verificationResult;
        }
        try {
            long l = CryptoUtil.decryptTurnOverCounter((String)CashBoxUtils.getValueFromMachineCode((String)verificationProperty.getValue(), (MachineCodeValue)MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE), (String)string.getHashAlgorithmForPreviousSignatureValue(), (String)CashBoxUtils.getValueFromMachineCode((String)verificationProperty.getValue(), (MachineCodeValue)MachineCodeValue.CASHBOX_ID), (String)CashBoxUtils.getValueFromMachineCode((String)verificationProperty.getValue(), (MachineCodeValue)MachineCodeValue.RECEIPT_IDENTIFIER), (String)object);
            verificationResult.addOutput(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE, Long.toString(l));
            verificationResult.setVerificationState(VerificationState.PASS);
        }
        catch (Exception exception) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_DECRYPTION_ERROR, new String[0]);
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)exception));
        }
        return verificationResult;
    }
}

