/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.entrypoint;

import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.entrypoint.AbstractEntryPoint;
import at.asitplus.regkassen.verification.modules.entrypoint.Whitelist;
import java.util.HashSet;

@VerificationModule(verificationID=VerificationID.VERIFICATION_FROM_APP, version=1, inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.SID, VerificationInputOutput.AUTH_CODE, VerificationInputOutput.AUTH_LEVEL})
public class AppEntryPoint
extends AbstractEntryPoint {
    public VerificationResult afterVerify(VerificationResult verificationResult) {
        if (verificationResult.getVerificationState() == VerificationState.PASS) {
            if (verificationResult.getSubResult(VerificationID.DBCALL_CHECK_CACHED_RESULT) != null) {
                verificationResult.setDetailedMessage(I18nDetailedMessageID.RECEIPT_PREVIOUSLY_VERIFIED_OK, new String[0]);
                return this.clean(verificationResult);
            }
            if (verificationResult.getSubResult(VerificationID.TYPE_OF_RECEIPT_START).getVerificationState() == VerificationState.PASS) {
                verificationResult.setDetailedMessage(I18nDetailedMessageID.RECEIPT_START_OK, new String[0]);
                return this.clean(verificationResult);
            }
            verificationResult.setDetailedMessage(I18nDetailedMessageID.RECEIPT_OK, new String[0]);
            return this.clean(verificationResult);
        }
        VerificationResult verificationResult2 = verificationResult.getSubResult(VerificationID.DBCALL_CHECK_CACHED_RESULT);
        if (verificationResult2 != null && verificationResult2.getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        verificationResult2 = verificationResult.getSubResult(VerificationID.DBCALL_VERIFICATION_REGISTERED);
        if (verificationResult2 == null || verificationResult2.getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        verificationResult2 = verificationResult.getSubResult(VerificationID.TIMEOFRECEIPT_WITHIN_PERIOD);
        if (verificationResult2 != null && verificationResult2.getVerificationState() == VerificationState.FAIL) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TIME_OUT_OF_RANGE, new String[0]);
            return this.clean(verificationResult);
        }
        if (verificationResult.getSubResult(VerificationID.CONSTRAINTS_PRE_DB).getVerificationState() == VerificationState.FAIL) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_GENERIC, new String[0]);
            return this.clean(verificationResult);
        }
        if (verificationResult.getSubResult(VerificationID.DBCALL_SID).getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        if (verificationResult.getSubResult(VerificationID.MATCH_COMPANY).getVerificationState() == VerificationState.FAIL) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.MISMATCH_COMPANY, new String[0]);
            return this.clean(verificationResult);
        }
        if (verificationResult.getSubResult(VerificationID.DBCALL_CASHBOX).getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        if (verificationResult.getSubResult(VerificationID.DBCALL_SIGDEVICE).getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        verificationResult2 = verificationResult.getSubResult(VerificationID.DBCALL_LOG_VERIFICATION_RESULT);
        if (verificationResult2 != null && verificationResult2.getVerificationState() == VerificationState.FAIL) {
            return this.failInternal(verificationResult);
        }
        verificationResult2 = verificationResult.getSubResult(VerificationID.STATE_CONSOLIDATED);
        if (verificationResult2 != null && verificationResult2.getVerificationState() == VerificationState.FAIL && verificationResult.getSubResult(VerificationID.TYPE_OF_RECEIPT_START).getVerificationState() == VerificationState.PASS) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.RECEIPT_START_STATE_FAIL, new String[0]);
            return this.clean(verificationResult);
        }
        verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_GENERIC, new String[0]);
        return this.clean(verificationResult);
    }

    private VerificationResult failInternal(VerificationResult verificationResult) {
        verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
        return this.clean(verificationResult);
    }

    private VerificationResult clean(VerificationResult verificationResult) {
        verificationResult.clearVerificationResults();
        HashSet<VerificationInputOutput> hashSet = new HashSet<VerificationInputOutput>();
        HashSet<VerificationInputOutput> hashSet2 = new HashSet<VerificationInputOutput>();
        Whitelist.whitelist(verificationResult, hashSet, hashSet2);
        return verificationResult;
    }
}

