/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.format;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.modules.GroupVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatChainingValueVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatSerialNumberVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatSignatureVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatTaxSetVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatTimeFormatVerificationModule;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatTurnoverVerificationModule;
import at.asitplus.regkassen.verification.modules.semantic.SemanticRKSuiteVerificationModule;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT}, version=1, verificationID=VerificationID.FORMAT)
public class FormatVerificationModule
extends GroupVerificationModule {
    public static VerificationResult verifyRKSuite(String string) {
        SemanticRKSuiteVerificationModule semanticRKSuiteVerificationModule = new SemanticRKSuiteVerificationModule();
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.RK_STRING, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.RK_SUITE))});
        return semanticRKSuiteVerificationModule.verifySingle((VerificationResult)string);
    }

    public static VerificationResult verifyTimeAndDateFormat(String string) {
        FormatTimeFormatVerificationModule formatTimeFormatVerificationModule = new FormatTimeFormatVerificationModule();
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.RECEIPT_DATE_AND_TIME, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.RECEIPT_DATE_AND_TIME))});
        return formatTimeFormatVerificationModule.verifySingle((VerificationResult)string);
    }

    private VerificationResult verifyTax(String string, VerificationID object, MachineCodeValue machineCodeValue) {
        object = new FormatTaxSetVerificationModule();
        string = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)machineCodeValue);
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.SUM_TAX, string)});
        return object.verifySingle((VerificationResult)string);
    }

    private VerificationResult verifyTurnoverValue(String string) {
        FormatTurnoverVerificationModule formatTurnoverVerificationModule = new FormatTurnoverVerificationModule();
        string = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE);
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.ENCRYPTED_TURN_OVER_VALUE, string)});
        return formatTurnoverVerificationModule.verifySingle((VerificationResult)string);
    }

    public static VerificationResult verifySerialNumber(String string, VerificationResult verificationResult) {
        FormatSerialNumberVerificationModule formatSerialNumberVerificationModule = new FormatSerialNumberVerificationModule();
        string = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID);
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID, string), verificationResult.getOutputData(VerificationInputOutput.SYSTEM_TYPE)});
        return formatSerialNumberVerificationModule.verifySingle((VerificationResult)string);
    }

    private VerificationResult verifyChainValue(String string) {
        FormatChainingValueVerificationModule formatChainingValueVerificationModule = new FormatChainingValueVerificationModule();
        string = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CHAINING_VALUE_PREVIOUS_RECEIPT);
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.CHAINING_VALUE_PREVIOUS_RECEIPT, string)});
        return formatChainingValueVerificationModule.verifySingle((VerificationResult)string);
    }

    private VerificationResult verifySignature(String string) {
        FormatSignatureVerificationModule formatSignatureVerificationModule = new FormatSignatureVerificationModule();
        string = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.SIGNATURE_VALUE);
        string = FormatVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.SIGNATURE_VALUE, string)});
        return formatSignatureVerificationModule.verifySingle((VerificationResult)string);
    }

    @Override
    public VerificationResult doVerify(VerificationResult verificationResult) {
        Object object = verificationResult.getInputData(VerificationInputOutput.RECEIPT);
        object = object.getValue();
        VerificationResult verificationResult2 = FormatVerificationModule.verifyRKSuite((String)object);
        verificationResult.addVerificationResult(verificationResult2);
        verificationResult.addVerificationResult(FormatVerificationModule.verifyTimeAndDateFormat((String)object));
        verificationResult.addVerificationResult(this.verifyTax((String)object, VerificationID.FORMAT_TAX_SET, MachineCodeValue.SUM_TAX_SET_NORMAL));
        verificationResult.addVerificationResult(this.verifyTax((String)object, VerificationID.FORMAT_TAX_SET, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1));
        verificationResult.addVerificationResult(this.verifyTax((String)object, VerificationID.FORMAT_TAX_SET, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2));
        verificationResult.addVerificationResult(this.verifyTax((String)object, VerificationID.FORMAT_TAX_SET, MachineCodeValue.SUM_TAX_SET_NULL));
        verificationResult.addVerificationResult(this.verifyTax((String)object, VerificationID.FORMAT_TAX_SET, MachineCodeValue.SUM_TAX_SET_BESONDERS));
        verificationResult.addVerificationResult(this.verifyTurnoverValue((String)object));
        verificationResult.addVerificationResult(FormatVerificationModule.verifySerialNumber((String)object, verificationResult2));
        verificationResult.addVerificationResult(this.verifyChainValue((String)object));
        verificationResult.addVerificationResult(this.verifySignature((String)object));
        return verificationResult;
    }
}

