/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.format.fragments;

import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatBase64ValidityVerificationModule;
import com.google.common.base.Throwables;

@VerificationModule(inputProperties={VerificationInputOutput.BASE64_STRING}, verificationID=VerificationID.FORMAT_BASE64_DECODE_ENCODE, version=1)
public class FormatBase64EncodeDecodeVerificationModule
extends BaseVerificationModule {
    private VerificationResult verifyBase64Validity(String string) {
        FormatBase64ValidityVerificationModule formatBase64ValidityVerificationModule = new FormatBase64ValidityVerificationModule();
        string = FormatBase64EncodeDecodeVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.BASE64_CHARS, string)});
        return formatBase64ValidityVerificationModule.verifySingle((VerificationResult)string);
    }

    protected void checkBase64DecodeEncode(VerificationResult verificationResult, boolean bl) {
        VerificationState verificationState = VerificationState.FAIL;
        String string = verificationResult.getInputData(VerificationInputOutput.BASE64_STRING).getValue();
        try {
            byte[] byArray = CashBoxUtils.base64Decode((String)string, (boolean)bl);
            String string2 = CashBoxUtils.base64Encode((byte[])byArray, (boolean)bl);
            verificationState = string2.equals(string) ? VerificationState.PASS : VerificationState.FAIL;
            return;
        }
        catch (Throwable throwable) {
            verificationState = VerificationState.FAIL;
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)throwable));
            return;
        }
        finally {
            verificationResult.setVerificationState(verificationState);
        }
    }

    public VerificationResult doVerify(VerificationResult verificationResult) {
        VerificationProperty verificationProperty = verificationResult.getInputData(VerificationInputOutput.BASE64_STRING);
        verificationProperty = this.verifyBase64Validity(verificationProperty.getValue());
        verificationResult.addVerificationResult((VerificationResult)verificationProperty);
        if (verificationProperty.getVerificationState() != VerificationState.PASS) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        try {
            this.checkBase64DecodeEncode(verificationResult, false);
        }
        catch (Throwable throwable) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)throwable));
        }
        return verificationResult;
    }
}

