/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.format.fragments;

import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import com.google.common.base.Throwables;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

@VerificationModule(inputProperties={VerificationInputOutput.SUM_TAX}, verificationID=VerificationID.FORMAT_TAX_SET, version=1)
public class FormatTaxSetVerificationModule
extends BaseVerificationModule {
    protected boolean checkTaxSetFormatIsANumber(String string) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);
        numberFormat = (DecimalFormat)numberFormat;
        try {
            numberFormat.parse(string).doubleValue();
            return true;
        }
        catch (ParseException parseException) {
            numberFormat = NumberFormat.getNumberInstance(Locale.US);
            numberFormat = (DecimalFormat)numberFormat;
            try {
                numberFormat.parse(string).doubleValue();
                return true;
            }
            catch (ParseException parseException2) {
                return true;
            }
        }
    }

    protected boolean checkTaxSetFormat(String stringArray) {
        String[] stringArray2 = stringArray.split(",");
        stringArray = stringArray.split("\\.");
        if (stringArray2.length == 2 && stringArray2[1].length() == 2) {
            return true;
        }
        return stringArray.length == 2 && stringArray[1].length() == 2;
    }

    public VerificationResult doVerify(VerificationResult verificationResult) {
        String string = verificationResult.getInputData(VerificationInputOutput.SUM_TAX).getValue();
        try {
            boolean bl = this.checkTaxSetFormatIsANumber(string);
            VerificationState verificationState = bl ? VerificationState.PASS : VerificationState.FAIL;
            if (verificationState == VerificationState.PASS) {
                verificationState = this.checkTaxSetFormat(string) ? VerificationState.PASS : VerificationState.FAIL;
            }
            verificationResult.setVerificationState(verificationState);
        }
        catch (Throwable throwable) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)throwable));
        }
        return verificationResult;
    }
}

