/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.format.fragments;

import at.asitplus.regkassen.common.TurnoverCounterType;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.format.fragments.FormatBase64ContraintsVerificationModule;

@VerificationModule(inputProperties={VerificationInputOutput.ENCRYPTED_TURN_OVER_VALUE}, verificationID=VerificationID.FORMAT_ENCRYPTED_TURN_OVER_VALUE_BASE64, version=1)
public class FormatTurnoverVerificationModule
extends FormatBase64ContraintsVerificationModule {
    public FormatTurnoverVerificationModule() {
        super(VerificationInputOutput.ENCRYPTED_TURN_OVER_VALUE, 4, 16);
    }

    @Override
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        String string = verificationResult.getInputData(VerificationInputOutput.ENCRYPTED_TURN_OVER_VALUE).getValue();
        if ((verificationResult = super.doVerify(verificationResult)).getVerificationState() != VerificationState.PASS) {
            return verificationResult;
        }
        TurnoverCounterType turnoverCounterType = TurnoverCounterType.toTurnoverCunterType((String)string);
        if (turnoverCounterType == null) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_INVALID, new String[0]);
            return verificationResult;
        }
        if (turnoverCounterType == TurnoverCounterType.NORMAL && !this.checkLengthContraints(string)) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_INVALID_LENGTH, new String[0]);
            return verificationResult;
        }
        verificationResult.setVerificationState(VerificationState.PASS);
        return verificationResult;
    }
}

