/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.receipttype;

import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeNullReceiptVerificationModule;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeOfReceiptHelper;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeStandardReceiptVerificationModule;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeStartReceiptVerificationModule;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeStoReceiptVerificationModule;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeTraReceiptVerificationModule;
import java.util.Collection;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.DECRYPTED_TURNOVER_VALUE}, verificationID=VerificationID.TYPE_OF_RECEIPT, version=1)
public class TypeofReceiptVerificationModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        Collection collection = this.getInputData(verificationResult).values();
        verificationResult.addVerificationResult(new TypeStartReceiptVerificationModule().verifySingle(TypeofReceiptVerificationModule.prepareInput(collection)));
        verificationResult.addVerificationResult(new TypeStandardReceiptVerificationModule().verifySingle(TypeofReceiptVerificationModule.prepareInput(collection)));
        verificationResult.addVerificationResult(new TypeTraReceiptVerificationModule().verifySingle(TypeofReceiptVerificationModule.prepareInput(collection)));
        verificationResult.addVerificationResult(new TypeStoReceiptVerificationModule().verifySingle(TypeofReceiptVerificationModule.prepareInput(collection)));
        verificationResult.addVerificationResult(new TypeNullReceiptVerificationModule().verifySingle(TypeofReceiptVerificationModule.prepareInput(collection)));
        return verificationResult;
    }

    public VerificationResult afterVerify(VerificationResult verificationResult) {
        verificationResult.setVerificationState(VerificationState.FAIL);
        int n = 0;
        VerificationResult verificationResult2 = null;
        for (VerificationResult verificationResult3 : verificationResult.getVerificationResultList()) {
            if (verificationResult3.getVerificationState() != VerificationState.PASS) continue;
            ++n;
            verificationResult2 = verificationResult3;
        }
        if (n == 0) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TYPEOFRECEIPT_UNKNOWN, new String[0]);
        } else if (n == 1) {
            verificationResult.addOutput(new VerificationProperty(VerificationInputOutput.TYPE_RECEIPT, (Enum)TypeOfReceiptHelper.getTypeFromVerificationID(verificationResult2.getVerificationId())));
            verificationResult.setVerificationState(VerificationState.PASS);
        } else {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TYPEOFRECEIPT_INTERNAL_ERROR, new String[0]);
        }
        return verificationResult;
    }
}

