/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.receipttype.fragments;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.RKSuiteIdentifier;
import at.asitplus.regkassen.common.TurnoverCounterType;
import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import com.google.common.base.Throwables;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class TypeOfReceiptHelper {
    private static final MachineCodeValue[] TAX_POSITIONS = new MachineCodeValue[]{MachineCodeValue.SUM_TAX_SET_NORMAL, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2, MachineCodeValue.SUM_TAX_SET_BESONDERS, MachineCodeValue.SUM_TAX_SET_NULL};
    private static final Map<VerificationID, TypeOfReceipt> VERIFICATION_ID_TO_TYPE_OF_RECEIPT = new HashMap<VerificationID, TypeOfReceipt>();

    public static TypeOfReceipt getTypeFromVerificationID(VerificationID verificationID) {
        return VERIFICATION_ID_TO_TYPE_OF_RECEIPT.get(verificationID);
    }

    public static int getNumberofNonZeroTaxSets(String string) {
        int n = 0;
        MachineCodeValue[] machineCodeValueArray = TAX_POSITIONS;
        int n2 = TAX_POSITIONS.length;
        for (int i = 0; i < n2; ++i) {
            Object object = machineCodeValueArray[i];
            if ("0.00".equals(object = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)object)) || "0,00".equals(object)) continue;
            ++n;
        }
        return n;
    }

    public static void isTurnoverTRA(String string, VerificationResult verificationResult, boolean bl) {
        TypeOfReceiptHelper.isTurnoverValue(string, verificationResult, TurnoverCounterType.TRA, bl);
    }

    public static void isTurnoverSTO(String string, VerificationResult verificationResult, boolean bl) {
        TypeOfReceiptHelper.isTurnoverValue(string, verificationResult, TurnoverCounterType.STO, bl);
    }

    public static void isTurnoverValue(String string, VerificationResult verificationResult, TurnoverCounterType turnoverCounterType, boolean bl) {
        boolean bl2 = turnoverCounterType.getDecodedValue().equals(string);
        if (bl2 != bl) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            if (bl) {
                verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_NEQ, new String[]{turnoverCounterType.getDecodedValue()});
                return;
            }
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_EQ, new String[]{turnoverCounterType.getDecodedValue()});
        }
    }

    public static void isDerivedFromCashBoxID(String string, VerificationResult verificationResult, RKSuiteIdentifier object, boolean bl) {
        try {
            block5: {
                block4: {
                    object = CryptoUtil.computeChainingValue((String)CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CASHBOX_ID), (RKSuiteIdentifier)object);
                    boolean bl2 = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CHAINING_VALUE_PREVIOUS_RECEIPT).equals(object);
                    if (bl2 == bl) break block4;
                    verificationResult.setVerificationState(VerificationState.FAIL);
                    if (bl) break block5;
                    verificationResult.setDetailedMessage(I18nDetailedMessageID.CHAINING_VALUE_COUNTER_EQ, new String[0]);
                }
                return;
            }
            verificationResult.setDetailedMessage(I18nDetailedMessageID.CHAINING_VALUE_COUNTER_NEQ, new String[0]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)noSuchAlgorithmException));
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.CHAINING_VALUE_ERROR, new String[0]);
        }
    }

    static {
        VERIFICATION_ID_TO_TYPE_OF_RECEIPT.put(VerificationID.TYPE_OF_RECEIPT_NULL, TypeOfReceipt.NULL_BELEG);
        VERIFICATION_ID_TO_TYPE_OF_RECEIPT.put(VerificationID.TYPE_OF_RECEIPT_STANDARD, TypeOfReceipt.STANDARD_BELEG);
        VERIFICATION_ID_TO_TYPE_OF_RECEIPT.put(VerificationID.TYPE_OF_RECEIPT_START, TypeOfReceipt.START_BELEG);
        VERIFICATION_ID_TO_TYPE_OF_RECEIPT.put(VerificationID.TYPE_OF_RECEIPT_STO, TypeOfReceipt.STORNO_BELEG);
        VERIFICATION_ID_TO_TYPE_OF_RECEIPT.put(VerificationID.TYPE_OF_RECEIPT_TRA, TypeOfReceipt.TRAINING_BELEG);
    }
}

