/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.receipttype.fragments;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.RKSuiteIdentifier;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.receipttype.fragments.TypeOfReceiptHelper;
import com.google.common.base.Throwables;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.DECRYPTED_TURNOVER_VALUE}, verificationID=VerificationID.TYPE_OF_RECEIPT_START, version=1)
public class TypeStartReceiptVerificationModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        verificationResult.setVerificationState(VerificationState.PASS);
        String string = verificationResult.getInputData(VerificationInputOutput.RECEIPT).getValue();
        if (TypeOfReceiptHelper.getNumberofNonZeroTaxSets(string) > 0) {
            verificationResult.setVerificationState(VerificationState.FAIL);
        }
        String string2 = verificationResult.getInputData(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE).getValue();
        TypeOfReceiptHelper.isTurnoverSTO(string2, verificationResult, false);
        TypeOfReceiptHelper.isTurnoverTRA(string2, verificationResult, false);
        TypeOfReceiptHelper.isDerivedFromCashBoxID(string, verificationResult, RKSuiteIdentifier.fromRKString((String)CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.RK_SUITE)), true);
        try {
            long l = Long.parseLong(string2);
            if (l != 0L) {
                verificationResult.setVerificationState(VerificationState.FAIL);
                verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_NONZERO, new String[0]);
            }
        }
        catch (Exception exception) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.TURNOVER_COUNTER_NAN, new String[0]);
            verificationResult.setStackTrace(Throwables.getStackTraceAsString((Throwable)exception));
        }
        return verificationResult;
    }
}

