/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.resourceinjection;

import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.resourceinjection.ResourceInjector$1;
import at.asitplus.regkassen.verification.resourceinjection.ResourceNotFoundException;
import at.asitplus.regkassen.verification.resourceinjection.ResourceRepository;
import java.text.MessageFormat;
import java.util.Locale;

public class ResourceInjector {
    private static ResourceRepository rsrcRepo = new ResourceInjector$1();

    public static void setRsrcRepo(ResourceRepository resourceRepository) {
        rsrcRepo = resourceRepository;
    }

    public static VerificationResult transform(VerificationResult verificationResult, Locale locale) {
        ResourceInjector.doTransform(verificationResult, locale);
        return verificationResult;
    }

    private static void doTransform(VerificationResult object, Locale locale) {
        String string3 = object.getVerificationId().name() + "-" + object.getVersion() + "-name";
        String string2 = object.getVerificationId().name() + "-" + object.getVersion() + "-desc";
        try {
            object.setVerificationName(rsrcRepo.getString(string3, locale));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            object.setVerificationName(object.getVerificationId().name() + " v" + object.getVersion());
        }
        try {
            object.setVerificationTextualDescription(rsrcRepo.getString(string2, locale));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            object.setVerificationTextualDescription(object.getVerificationId().getDescription());
        }
        if (object.getDetailedMsgID() != null) {
            try {
                object.setVerificationResultDetailedMessage(MessageFormat.format(rsrcRepo.getString(object.getDetailedMsgID().name(), locale), object.getDetailedMsgParams()));
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                object.setVerificationResultDetailedMessage(MessageFormat.format(object.getDetailedMsgID().getDefaultFormatString(), object.getDetailedMsgParams()));
            }
        }
        for (String string3 : object.getVerificationResultList()) {
            ResourceInjector.doTransform((VerificationResult)string3, locale);
        }
    }
}

