/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import net.cli.OperatingSystem;

public class CliUtils {
    public static ProcessBuilder createProcessBuilder(String cmd) {
        OperatingSystem.Type os = OperatingSystem.getOperatingSystem();
        if (os != null) {
            ProcessBuilder builder = null;
            switch (os) {
                case WINDOWS: {
                    builder = new ProcessBuilder("cmd.exe", "/c", cmd);
                    break;
                }
                case LINUX: {
                    builder = new ProcessBuilder("bash", "-c", cmd);
                    break;
                }
                case MAC: {
                    builder = new ProcessBuilder("bash", "-c", cmd);
                    break;
                }
            }
            if (builder != null) {
                builder.redirectErrorStream(true);
                return builder;
            }
        }
        return null;
    }
}

