/*
 * Decompiled with CFR 0.152.
 */
package net.cli.service;

import java.io.File;
import net.cli.OperatingSystem;
import net.cli.service.IService;
import net.cli.service.os.linux.LinuxService;
import net.cli.service.os.linux.tomcat.TomcatLinuxService;
import net.cli.service.os.mac.MacService;
import net.cli.service.os.mac.tomcat.TomcatMacService;
import net.cli.service.os.windows.WindowsService;
import net.cli.service.os.windows.tomcat.TomcatWindowsService;
import net.cli.service.tomcat.ITomcatService;

public class ServiceUtils {
    public static IService getService(String serviceName) {
        OperatingSystem.Type os;
        String sunArchDataModel = System.getProperty("sun.arch.data.model");
        if (sunArchDataModel != null && (sunArchDataModel.equals("32") || sunArchDataModel.equals("64")) && (os = OperatingSystem.getOperatingSystem()) != null) {
            switch (os) {
                case WINDOWS: {
                    return new WindowsService(serviceName, Integer.parseInt(sunArchDataModel));
                }
                case LINUX: {
                    return new LinuxService(serviceName, Integer.parseInt(sunArchDataModel));
                }
                case MAC: {
                    return new MacService(serviceName, Integer.parseInt(sunArchDataModel));
                }
            }
        }
        return null;
    }

    public static ITomcatService getTomcatService(String serviceName, File serviceDir) {
        OperatingSystem.Type os;
        String sunArchDataModel = System.getProperty("sun.arch.data.model");
        if (sunArchDataModel != null && (sunArchDataModel.equals("32") || sunArchDataModel.equals("64")) && (os = OperatingSystem.getOperatingSystem()) != null) {
            switch (os) {
                case WINDOWS: {
                    return new TomcatWindowsService(serviceName, Integer.parseInt(sunArchDataModel), serviceDir);
                }
                case LINUX: {
                    return new TomcatLinuxService(serviceName, Integer.parseInt(sunArchDataModel), serviceDir);
                }
                case MAC: {
                    return new TomcatMacService(serviceName, Integer.parseInt(sunArchDataModel), serviceDir);
                }
            }
        }
        return null;
    }
}

