/*
 * Decompiled with CFR 0.152.
 */
package net.cli.service.os.linux.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import net.cli.CommandException;
import net.cli.CommandExecutor;
import net.cli.service.os.linux.LinuxService;
import net.cli.service.tomcat.ITomcatService;

public class TomcatLinuxService
extends LinuxService
implements ITomcatService {
    private File serviceDir;

    public TomcatLinuxService(String serviceName, int architecture, File serviceDir) {
        super(serviceName, architecture);
        this.serviceDir = serviceDir;
    }

    @Override
    public boolean installService(File javaDir, Integer jvmMs, Integer jvmMx) throws CommandException {
        File file = new File("/etc/init.d", super.getServiceName());
        if (file.exists()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/sh\n");
        sb.append("#\n");
        sb.append("# /etc/init.d/" + super.getServiceName() + " -- startup script for the Tomcat servlet engine\n");
        sb.append("#\n");
        sb.append("# Modifications are:\n");
        sb.append("#   * Remove authbind.\n");
        sb.append("#   * Remove JVM_TMP. We will use CATALINA_BASE/temp\n");
        sb.append("#   * Explicitly set JAVA_HOME. No need to figure out where it is.\n");
        sb.append("#   * Remove SECURITY. We are not using the Java security manager.\n");
        sb.append("#   * Remove references to DEFAULT. We have no defaults to use.\n");
        sb.append("#   * Explicitly provide values for variables that are supposed to be set while installing the tomcat package.\n");
        sb.append("#   * Remove references to POLICY_CACHE.\n");
        sb.append("#\n");
        sb.append("### BEGIN INIT INFO\n");
        sb.append("# Provides:          " + super.getServiceName() + "\n");
        sb.append("# Required-Start:    $local_fs $remote_fs $network\n");
        sb.append("# Required-Stop:     $local_fs $remote_fs $network\n");
        sb.append("# Should-Start:      $named\n");
        sb.append("# Should-Stop:       $named\n");
        sb.append("# Default-Start:     2 3 4 5\n");
        sb.append("# Default-Stop:      0 1 6\n");
        sb.append("# Short-Description: Start " + super.getServiceName() + ".\n");
        sb.append("# Description:       Start the " + super.getServiceName() + " servlet engine.\n");
        sb.append("### END INIT INFO\n");
        sb.append("\n");
        sb.append("set -e\n");
        sb.append("\n");
        sb.append("PATH=/bin:/usr/bin:/sbin:/usr/sbin\n");
        sb.append("NAME=" + super.getServiceName() + "\n");
        sb.append("DESC=\"Tomcat servlet engine\"\n");
        sb.append("\n");
        sb.append("if [ `id -u` -ne 0 ]; then\n");
        sb.append("        echo \"You need root privileges to run this script\"\n");
        sb.append("        exit 1\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append("# Make sure tomcat is started with system locale\n");
        sb.append("if [ -r /etc/default/locale ]; then\n");
        sb.append("        . /etc/default/locale\n");
        sb.append("        export LANG\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append(". /lib/lsb/init-functions\n");
        sb.append("\n");
        sb.append("if [ -r /etc/default/rcS ]; then\n");
        sb.append("        . /etc/default/rcS\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append("# Run Tomcat as this user ID and group ID\n");
        sb.append("TOMCAT8_USER=root\n");
        sb.append("TOMCAT8_GROUP=root\n");
        sb.append("\t\t\n");
        sb.append("export JAVA_HOME=" + javaDir.getAbsolutePath() + "\n");
        sb.append("\t\t\n");
        sb.append("# Directory where the Tomcat binary distribution resides\n");
        sb.append("CATALINA_HOME=" + this.serviceDir.getAbsolutePath() + "\n");
        sb.append("\n");
        sb.append("# Directory for per-instance configuration files and webapps\n");
        sb.append("CATALINA_BASE=" + this.serviceDir.getAbsolutePath() + "\n");
        sb.append("\t\t\n");
        sb.append("# Default Java options\n");
        sb.append("# Set java.awt.headless=true if JAVA_OPTS is not set so the\n");
        sb.append("# Xalan XSL transformer can work without X11 display on JDK 1.4+\n");
        sb.append("# It also looks like the default heap size of 64M is not enough for most cases\n");
        sb.append("# so the maximum heap size is set to " + jvmMs + "M\n");
        sb.append("if [ -z \"$JAVA_OPTS\" ]; then\n");
        sb.append("        JAVA_OPTS=\"-Djava.awt.headless=true -server -Xms" + jvmMs + "M -Xmx" + jvmMx + "M\"\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append("if [ ! -f \"$CATALINA_HOME/bin/bootstrap.jar\" ]; then\n");
        sb.append("        log_failure_msg \"$NAME is not installed\"\n");
        sb.append("        exit 1\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append("# pid file has to be in $CATALINA_BASE (or $CATALINA_HOME?)\n");
        sb.append("CATALINA_PID=\"$CATALINA_BASE/tomcat.pid\"\n");
        sb.append("\t\t\n");
        sb.append("CATALINA_SH=\"$CATALINA_HOME/bin/catalina.sh\"\n");
        sb.append("CATALINA_TMPDIR=\"$CATALINA_BASE/temp\"\n");
        sb.append("\t\t\n");
        sb.append("# Look for Java Secure Sockets Extension (JSSE) JARs\n");
        sb.append("if [ -z \"${JSSE_HOME}\" -a -r \"${JAVA_HOME}/jre/lib/jsse.jar\" ]; then\n");
        sb.append("    JSSE_HOME=\"${JAVA_HOME}/jre/\"\n");
        sb.append("fi\n");
        sb.append("\n");
        sb.append("catalina_sh() {\n");
        sb.append("        # Escape any double quotes in the value of JAVA_OPTS\n");
        sb.append("        JAVA_OPTS=\"$(echo $JAVA_OPTS | sed 's/\\\"/\\\\\\\"/g')\"\n");
        sb.append("        \t\t\n");
        sb.append("        # Define the command to run Tomcat's catalina.sh as a daemon\n");
        sb.append("        # set -a tells sh to export assigned variables to spawned shells.\n");
        sb.append("        TOMCAT_SH=\"set -a; JAVA_HOME=\\\"$JAVA_HOME\\\"; \\\n");
        sb.append("                CATALINA_HOME=\\\"$CATALINA_HOME\\\"; \\\n");
        sb.append("                CATALINA_BASE=\\\"$CATALINA_BASE\\\"; \\\n");
        sb.append("                JAVA_OPTS=\\\"$JAVA_OPTS\\\"; \\\n");
        sb.append("                CATALINA_PID=\\\"$CATALINA_PID\\\"; \\\n");
        sb.append("                CATALINA_TMPDIR=\\\"$CATALINA_TMPDIR\\\"; \\\n");
        sb.append("                LANG=\\\"$LANG\\\"; JSSE_HOME=\\\"$JSSE_HOME\\\"; \\\n");
        sb.append("                cd \\\"$CATALINA_BASE\\\"; \\\n");
        sb.append("                \\\"$CATALINA_SH\\\" $@\"\n");
        sb.append("\n");
        sb.append("        # Run the catalina.sh script as a daemon\n");
        sb.append("        set +e\n");
        sb.append("        touch \"$CATALINA_PID\" \"$CATALINA_BASE\"/logs/catalina.out\n");
        sb.append("        chown $TOMCAT8_USER \"$CATALINA_PID\" \"$CATALINA_BASE\"/logs/catalina.out\n");
        sb.append("        start-stop-daemon --start -b -u \"$TOMCAT8_USER\" -g \"$TOMCAT8_GROUP\" \\\n");
        sb.append("                -c \"$TOMCAT8_USER\" -d \"$CATALINA_TMPDIR\" -p \"$CATALINA_PID\" \\\n");
        sb.append("                -x /bin/bash -- -c \"$TOMCAT_SH\"\n");
        sb.append("        status=\"$?\"\n");
        sb.append("        set +a -e\n");
        sb.append("        return $status\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("case \"$1\" in\n");
        sb.append("  start)\n");
        sb.append("        if [ -z \"$JAVA_HOME\" ]; then\n");
        sb.append("                log_failure_msg \"no JDK found - please set JAVA_HOME\"\n");
        sb.append("                exit 1\n");
        sb.append("        fi\n");
        sb.append("\n");
        sb.append("        if [ ! -d \"$CATALINA_BASE/conf\" ]; then\n");
        sb.append("                log_failure_msg \"invalid CATALINA_BASE: $CATALINA_BASE\"\n");
        sb.append("                exit 1\n");
        sb.append("        fi\n");
        sb.append("\n");
        sb.append("        log_daemon_msg \"Starting $DESC\" \"$NAME\"\n");
        sb.append("        if start-stop-daemon --test --start --pidfile \"$CATALINA_PID\" \\\n");
        sb.append("                --user $TOMCAT8_USER --exec \"$JAVA_HOME/bin/java\" \\\n");
        sb.append("                >/dev/null; then\n");
        sb.append("                \n");
        sb.append("                catalina_sh start\n");
        sb.append("                sleep 5\n");
        sb.append("                if start-stop-daemon --test --start --pidfile \"$CATALINA_PID\" \\\n");
        sb.append("                        --user $TOMCAT8_USER --exec \"$JAVA_HOME/bin/java\" \\\n");
        sb.append("                        >/dev/null; then\n");
        sb.append("                        if [ -f \"$CATALINA_PID\" ]; then\n");
        sb.append("                                rm -f \"$CATALINA_PID\"\n");
        sb.append("                        fi\n");
        sb.append("                        log_end_msg 1\n");
        sb.append("                else\n");
        sb.append("                        log_end_msg 0\n");
        sb.append("                fi\n");
        sb.append("        else\n");
        sb.append("                log_progress_msg \"(already running)\"\n");
        sb.append("                log_end_msg 0\n");
        sb.append("        fi\n");
        sb.append("        ;;\n");
        sb.append("  stop)\n");
        sb.append("        log_daemon_msg \"Stopping $DESC\" \"$NAME\"\n");
        sb.append("\n");
        sb.append("        set +e\n");
        sb.append("        if [ -f \"$CATALINA_PID\" ]; then\n");
        sb.append("                start-stop-daemon --stop --pidfile \"$CATALINA_PID\" \\\n");
        sb.append("                        --user \"$TOMCAT8_USER\" \\\n");
        sb.append("                        --retry=TERM/20/KILL/5 >/dev/null\n");
        sb.append("                if [ $? -eq 1 ]; then\n");
        sb.append("                        log_progress_msg \"$DESC is not running but pid file exists, cleaning up\"\n");
        sb.append("                elif [ $? -eq 3 ]; then\n");
        sb.append("                        PID=\"`cat $CATALINA_PID`\"\n");
        sb.append("                        log_failure_msg \"Failed to stop $NAME (pid $PID)\"\n");
        sb.append("                        exit 1\n");
        sb.append("                fi\n");
        sb.append("                rm -f \"$CATALINA_PID\"\n");
        sb.append("        else\n");
        sb.append("                log_progress_msg \"(not running)\"\n");
        sb.append("        fi\n");
        sb.append("        log_end_msg 0\n");
        sb.append("        set -e\n");
        sb.append("        ;;\n");
        sb.append("   status)\n");
        sb.append("        set +e\n");
        sb.append("        start-stop-daemon --test --start --pidfile \"$CATALINA_PID\" \\\n");
        sb.append("                --user $TOMCAT8_USER --exec \"$JAVA_HOME/bin/java\" \\\n");
        sb.append("                >/dev/null 2>&1\n");
        sb.append("        if [ \"$?\" = \"0\" ]; then\n");
        sb.append("\n");
        sb.append("                if [ -f \"$CATALINA_PID\" ]; then\n");
        sb.append("                    log_success_msg \"$DESC is not running, but pid file exists.\"\n");
        sb.append("                        exit 1\n");
        sb.append("                else\n");
        sb.append("                    log_success_msg \"$DESC is not running.\"\n");
        sb.append("                        exit 3\n");
        sb.append("                fi\n");
        sb.append("        else\n");
        sb.append("                log_success_msg \"$DESC is running with pid `cat $CATALINA_PID`\"\n");
        sb.append("        fi\n");
        sb.append("        set -e\n");
        sb.append("        ;;\n");
        sb.append("  restart|force-reload)\n");
        sb.append("        if [ -f \"$CATALINA_PID\" ]; then\n");
        sb.append("                $0 stop\n");
        sb.append("                sleep 1\n");
        sb.append("        fi\n");
        sb.append("        $0 start\n");
        sb.append("        ;;\n");
        sb.append("  try-restart)\n");
        sb.append("        if start-stop-daemon --test --start --pidfile \"$CATALINA_PID\" \\\n");
        sb.append("                --user $TOMCAT8_USER --exec \"$JAVA_HOME/bin/java\" \\\n");
        sb.append("                >/dev/null; then\n");
        sb.append("                $0 start\n");
        sb.append("        fi\n");
        sb.append("        ;;\n");
        sb.append("  *)\n");
        sb.append("        log_success_msg \"Usage: $0 {start|stop|restart|try-restart|force-reload|status}\"\n");
        sb.append("        exit 1\n");
        sb.append("        ;;\n");
        sb.append("esac\n");
        sb.append("\n");
        sb.append("exit 0");
        try (PrintWriter writer = null;){
            try {
                writer = new PrintWriter(file);
                writer.println(new String(sb));
                writer.flush();
            }
            catch (FileNotFoundException fnfex) {
                throw new CommandException(fnfex);
            }
        }
        String cmd = "chmod +x " + file.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        int statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        cmd = "systemctl daemon-reload";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        cmd = "update-rc.d " + super.getServiceName() + " defaults";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        cmd = "systemctl daemon-reload";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        return file.exists();
    }

    @Override
    public boolean removeService() throws CommandException {
        File file = new File("/etc/init.d", super.getServiceName());
        if (!file.exists()) {
            return false;
        }
        String cmd = "chmod +x " + file.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        int statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            return false;
        }
        cmd = "systemctl daemon-reload";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            return false;
        }
        cmd = "update-rc.d " + super.getServiceName() + " remove";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            return false;
        }
        cmd = "systemctl daemon-reload";
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            return false;
        }
        return file.delete();
    }
}

