/*
 * Decompiled with CFR 0.152.
 */
package net.cli.service.os.mac.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import net.cli.CommandException;
import net.cli.CommandExecutor;
import net.cli.service.os.mac.MacService;
import net.cli.service.tomcat.ITomcatService;

public class TomcatMacService
extends MacService
implements ITomcatService {
    private File serviceDir;

    public TomcatMacService(String serviceName, int architecture, File serviceDir) {
        super(serviceName, architecture);
        this.serviceDir = serviceDir;
    }

    @Override
    public boolean installService(File runtimeDir, Integer jvmMs, Integer jvmMx) throws CommandException {
        File file = new File("/Library/LaunchDaemons", String.valueOf(super.getServiceName()) + ".plist");
        if (file.exists()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        sb.append("<plist version=\"1.0\">\n");
        sb.append("\t<dict>\n");
        sb.append("\t\t<key>Disabled</key>\n");
        sb.append("\t\t<false/>\n");
        sb.append("\t\t<key>EnvironmentVariables</key>\n");
        sb.append("\t\t<dict>\n");
        sb.append("\t\t\t<key>CATALINA_HOME</key>\n");
        sb.append("\t\t\t<string>" + this.serviceDir.getAbsolutePath() + "</string>\n");
        sb.append("\t\t\t<key>CATALINA_BASE</key>\n");
        sb.append("\t\t\t<string>" + this.serviceDir.getAbsolutePath() + "</string>\n");
        sb.append("\t\t\t<key>JRE_HOME</key>\n");
        sb.append("\t\t\t<string>" + runtimeDir.getAbsolutePath() + "</string>\n");
        sb.append("\t\t</dict>\n");
        sb.append("\t\t<key>Label</key>\n");
        sb.append("\t\t<string>" + super.getServiceName() + "</string>\n");
        sb.append("\t\t<key>OnDemand</key>\n");
        sb.append("\t\t<false/>\n");
        sb.append("\t\t<key>ProgramArguments</key>\n");
        sb.append("\t\t<array>\n");
        sb.append("\t\t\t<string>" + this.serviceDir.getAbsolutePath() + "/bin/launchd_wrapper.sh</string>\n");
        sb.append("\t\t</array>\n");
        sb.append("\t\t<key>RunAtLoad</key>\n");
        sb.append("\t\t<true/>\n");
        sb.append("\t\t<key>ServiceDescription</key>\n");
        sb.append("\t\t<string>" + super.getServiceName() + "</string>\n");
        sb.append("\t\t<key>StandardErrorPath</key>\n");
        sb.append("\t\t<string>" + this.serviceDir.getAbsolutePath() + "/logs/launchd.stderr</string>\n");
        sb.append("\t\t<key>StandardOutPath</key>\n");
        sb.append("\t\t<string>" + this.serviceDir.getAbsolutePath() + "/logs/launchd.stdout</string>\n");
        sb.append("\t\t<key>UserName</key>\n");
        sb.append("\t\t<string>root</string>\n");
        sb.append("\t</dict>\n");
        sb.append("</plist>");
        try (PrintWriter writer = null;){
            try {
                writer = new PrintWriter(file);
                writer.println(new String(sb));
                writer.flush();
            }
            catch (FileNotFoundException fnfex) {
                throw new CommandException(fnfex);
            }
        }
        String cmd = "chmod +x " + file.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        int statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        cmd = "chown root " + file.getAbsolutePath();
        builder = new ProcessBuilder("bash", "-c", cmd);
        builder.redirectErrorStream(true);
        statusCode = CommandExecutor.execute(builder, super.getListener());
        if (statusCode != 0) {
            file.delete();
            return false;
        }
        return file.exists();
    }

    @Override
    public boolean removeService() throws CommandException {
        File file = new File("/Library/LaunchDaemons", String.valueOf(super.getServiceName()) + ".plist");
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }
}

