/*
 * Decompiled with CFR 0.152.
 */
package net.launcher.service;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import net.cli.CommandException;
import net.cli.jre.IJRE;
import net.cli.jre.JREUtils;
import net.launcher.service.client.FileServiceClient;
import net.obj.rc.beans.RcLoginMessage;
import net.obj.rc.beans.RcMessage;
import net.obj.rc.beans.payload.IRcTaskManager;
import net.obj.rc.beans.payload.RcpSetUniqueId;
import net.obj.rc.beans.payload.RcpTask;
import net.obj.rc.client.IRcMessageListener;
import net.obj.rc.client.RcClient;
import org.apache.tomcat.util.codec.binary.Base64;

@WebServlet(urlPatterns={"/rest/*"}, loadOnStartup=1)
public class LauncherService
extends HttpServlet
implements IRcMessageListener,
IRcTaskManager {
    private static final long serialVersionUID = 1L;
    private static final String version = "0.20beta";
    private static LauncherUpdate launcherUpdate = null;
    private static RcClient rcClient = null;
    private Gson gson = new Gson();
    private Vector<RcpTask> rcpTasks = new Vector();

    private RcLoginMessage getRcLogin() {
        RcLoginMessage rcLogin = null;
        String uniqueId = null;
        File dir = new File(".");
        String fn = this.getProperty("config-properties-file", null);
        if (fn != null) {
            File file = new File(dir, fn);
            Properties properties = this.loadProperties(file);
            uniqueId = properties.getProperty("unique.id");
            if (uniqueId != null) {
                rcLogin = new RcLoginMessage();
                rcLogin.setUniqueId(uniqueId);
                rcLogin.setVersion(version);
            } else {
                String customerCd = properties.getProperty("customer_cd");
                String siteCd = properties.getProperty("site_cd");
                String siteNm = properties.getProperty("site_nm");
                String stationCd = properties.getProperty("station_cd");
                String stationNm = properties.getProperty("station_nm");
                if (customerCd != null && siteCd != null && siteNm != null && stationCd != null && stationNm != null) {
                    rcLogin = new RcLoginMessage();
                    rcLogin.setCustomerCd(customerCd);
                    rcLogin.setSiteCd(siteCd);
                    rcLogin.setSiteNm(siteNm);
                    rcLogin.setStationCd(stationCd);
                    rcLogin.setStationNm(stationNm);
                    rcLogin.setVersion(version);
                }
            }
        }
        return rcLogin;
    }

    private void storeRcLogin(String uniqueId) {
        String fn = this.getProperty("config-properties-file", null);
        if (fn != null) {
            File dir = new File(".");
            File file = new File(dir, fn);
            Properties properties = new Properties();
            properties.setProperty("unique.id", uniqueId);
            this.storeProperties(file, properties);
        }
    }

    public void init() throws ServletException {
        super.init();
        RcLoginMessage rcLogin = this.getRcLogin();
        if (rcLogin != null) {
            rcClient = new RcClient(this.getProperty("rc-service-ws-uri", null), rcLogin, this);
            rcClient.start();
        }
        launcherUpdate = new LauncherUpdate();
        launcherUpdate.start();
    }

    private Properties loadProperties(File file) {
        Properties properties;
        block12: {
            properties = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (Exception cause) {
                    cause.printStackTrace();
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private void storeProperties(File file, Properties properties) {
        block12: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    properties.store(fos, "");
                }
                catch (Exception cause) {
                    cause.printStackTrace();
                    if (fos == null) break block12;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getProperty(String key, String defaultValue) {
        try {
            Object value;
            InitialContext c = new InitialContext();
            Object o = c.lookup("java:comp/env");
            if (o instanceof Context && (value = ((Context)o).lookup(key)) != null) {
                return value.toString();
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return defaultValue;
    }

    private String calcFileHash(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        FileInputStream fis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((b = fis.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, b);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] byteArray = messageDigest.digest();
        messageDigest.reset();
        messageDigest = null;
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    private String getRemoteHash(String remotePath) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        FileServiceClient client = new FileServiceClient(this.getProperty("file-service-url", null));
        return client.getRemoteHash(remotePath);
    }

    private String downloadRemoteFile(File localTempFile, String remotePath) throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        FileServiceClient client = new FileServiceClient(this.getProperty("file-service-url", null));
        String hash = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(localTempFile);
            hash = client.download(remotePath, fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hash;
    }

    private void deleteCascade(File f) {
        if (f.isDirectory()) {
            File[] af;
            File[] fileArray = af = f.listFiles();
            int n = af.length;
            int n2 = 0;
            while (n2 < n) {
                File cf = fileArray[n2];
                if (!cf.getName().equals(".") && !cf.getName().equals("..")) {
                    if (cf.isFile()) {
                        cf.delete();
                    }
                    if (cf.isDirectory()) {
                        this.deleteCascade(cf);
                    }
                }
                ++n2;
            }
        }
        f.delete();
    }

    private void dirCascade(File f) {
        if (f.isDirectory()) {
            File[] af;
            File[] fileArray = af = f.listFiles();
            int n = af.length;
            int n2 = 0;
            while (n2 < n) {
                File cf = fileArray[n2];
                if (!cf.getName().equals(".") && !cf.getName().equals("..")) {
                    if (cf.isFile()) {
                        this.log("FILE " + cf.getAbsolutePath());
                    }
                    if (cf.isDirectory()) {
                        this.deleteCascade(cf);
                    }
                }
                ++n2;
            }
        }
        this.log("DIR " + f.getAbsolutePath());
    }

    private void renameCascade(File f, String from, String to) {
        if (f.isDirectory()) {
            File[] af;
            File[] fileArray = af = f.listFiles();
            int n = af.length;
            int n2 = 0;
            while (n2 < n) {
                File cf = fileArray[n2];
                if (!cf.getName().equals(".") && !cf.getName().equals("..")) {
                    if (cf.isFile() && f.getName().equals(from)) {
                        File toF = new File(f.getParentFile(), to);
                        f.renameTo(toF);
                    }
                    if (cf.isDirectory()) {
                        this.renameCascade(cf, from, to);
                    }
                }
                ++n2;
            }
        }
        if (f.getName().equals(from)) {
            File toF = new File(f.getParentFile(), to);
            f.renameTo(toF);
        }
    }

    public void unzip(File file, File dir, String fileName) throws IOException {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            fis = new FileInputStream(file);
            zis = new ZipInputStream(fis);
            while ((zipEntry = zis.getNextEntry()) != null) {
                this.unzip(zis, zipEntry, dir, fileName);
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void unzip(InputStream stream, ZipEntry entry, File dir, String fileName) throws IOException {
        String fn = entry.getName();
        if (!fn.endsWith(fileName)) {
            return;
        }
        File file = new File(dir, fileName);
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = null;
            try {
                int b;
                fos = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((b = stream.read(buffer)) != -1) {
                    fos.write(buffer, 0, b);
                }
                fos.flush();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void replaceDir(File srcDir, File destDir) throws IOException {
        if (destDir.exists()) {
            this.deleteCascade(destDir);
        }
        if (!destDir.exists()) {
            srcDir.renameTo(destDir);
        }
    }

    private boolean processRest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().startsWith(String.valueOf(super.getServletContext().getContextPath()) + "/rest")) {
            String command = request.getRequestURI().substring((String.valueOf(super.getServletContext().getContextPath()) + "/rest").length());
            if (command.isEmpty()) {
                command = "/";
            }
            if (command.startsWith("/") && command.split("/").length > 1) {
                String function = command.split("/")[1];
                if (function.equals("update")) {
                    launcherUpdate.forceUpdate();
                    return true;
                }
                response.sendError(501);
                return true;
            }
            response.sendError(500);
            return true;
        }
        return false;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.processRest(request, response)) {
            return;
        }
        response.sendError(204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            for (RcpTask art : this.rcpTasks) {
                art.stopTask("service destroy() invoked");
            }
        }
        if (rcClient != null) {
            rcClient.shutdown();
            rcClient = null;
        }
        if (launcherUpdate != null) {
            launcherUpdate.shutDown();
            launcherUpdate = null;
        }
        super.destroy();
    }

    @Override
    public void processMessage(Session session, RcMessage rcMessage) throws Exception {
        String sp;
        String[] asp;
        String p = rcMessage.getPayload();
        if (p != null && (asp = (sp = p.replace('.', '\t')).split("\t")).length == 2) {
            Class<?> cls;
            String className = new String(Base64.decodeBase64((byte[])asp[0].getBytes()));
            String json = new String(Base64.decodeBase64((byte[])asp[1].getBytes()));
            Object obj = this.gson.fromJson(json, cls = Class.forName(className));
            if (obj != null) {
                RcpSetUniqueId rcpSetUniqueId;
                if (obj instanceof RcpTask) {
                    RcpTask rcpTask = (RcpTask)obj;
                    rcpTask.setRcTaskManager(this);
                    rcpTask.setToSessionId(rcMessage.getFromSessionId());
                    rcpTask.setPayloadId(rcMessage.getPayloadId());
                    this.startRcpTask(rcpTask);
                } else if (obj instanceof RcpSetUniqueId && (rcpSetUniqueId = (RcpSetUniqueId)obj).getUniqueId() != null) {
                    this.storeRcLogin(rcpSetUniqueId.getUniqueId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRcpTask(RcpTask rcpTask) {
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            this.rcpTasks.add(rcpTask);
        }
        Thread t = new Thread(rcpTask);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcpTaskEnded(RcpTask rcpTask) {
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            this.rcpTasks.remove(rcpTask);
        }
    }

    @Override
    public void reportProgress(String toSessionId, Integer payloadId, String message) {
        RcMessage rcMessage = new RcMessage();
        rcMessage.setToSessionId(toSessionId);
        String pay1 = String.class.getName();
        String pay2 = this.gson.toJson((Object)message);
        rcMessage.setPayloadId(payloadId);
        rcMessage.setPayload(String.valueOf(Base64.encodeBase64URLSafeString((byte[])pay1.getBytes())) + "." + Base64.encodeBase64URLSafeString((byte[])pay2.getBytes()));
        rcClient.sendMessage(rcMessage);
    }

    private class LauncherUpdate
    extends Thread {
        private boolean stop = false;
        private Object stopSem = new Object();
        private long nextDL = System.currentTimeMillis();

        private LauncherUpdate() {
        }

        public void forceUpdate() {
            this.nextDL = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                File[] af;
                Object object = this.stopSem;
                synchronized (object) {
                    try {
                        this.stopSem.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() <= this.nextDL) continue;
                this.nextDL = System.currentTimeMillis() + 60000L;
                File localLogDir = new File("./logs");
                localLogDir.mkdirs();
                File[] fileArray = af = localLogDir.listFiles();
                int n = af.length;
                int n2 = 0;
                while (n2 < n) {
                    File df = fileArray[n2];
                    if (df.getName().endsWith(".log")) {
                        df.delete();
                    }
                    ++n2;
                }
                File localDownloadDir = new File("./downloads");
                localDownloadDir.mkdirs();
                File[] fileArray2 = af = localDownloadDir.listFiles();
                int n3 = af.length;
                n = 0;
                while (n < n3) {
                    File df = fileArray2[n];
                    if (df.getName().endsWith(".dl")) {
                        df.delete();
                    }
                    ++n;
                }
                String remotePath = "launcher-service.war";
                File webappsDir = new File("./webapps");
                File webappsWarFile = new File(webappsDir, "launcher-service.war");
                File localWarDir = new File("./appbase");
                localWarDir.mkdirs();
                File localWarFile = new File(localWarDir, "launcher-service.war");
                try {
                    File tempFile;
                    String downloadFileHash;
                    String localWarHash = "";
                    try {
                        localWarHash = LauncherService.this.calcFileHash(localWarFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String remoteWarHash = LauncherService.this.getRemoteHash(remotePath);
                    if (remoteWarHash.equals(localWarHash) || !(downloadFileHash = LauncherService.this.downloadRemoteFile(tempFile = File.createTempFile("launcher-service-", ".dl", localDownloadDir), remotePath)).equals(remoteWarHash)) continue;
                    LauncherService.this.unzip(webappsWarFile, localWarDir, "launcher-service.jar");
                    localWarFile.delete();
                    tempFile.renameTo(localWarFile);
                    Path source = FileSystems.getDefault().getPath(localWarFile.getAbsolutePath(), new String[0]);
                    Path dest = FileSystems.getDefault().getPath(webappsWarFile.getAbsolutePath(), new String[0]);
                    Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                    IJRE jre = JREUtils.getJRE();
                    try {
                        jre.spawnJRE("./appbase/launcher-service.jar", "net.launcher.service.RestartService", new String[]{"launch-9980"});
                    }
                    catch (CommandException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutDown() {
            this.stop = true;
            Object object = this.stopSem;
            synchronized (object) {
                this.stopSem.notifyAll();
            }
        }
    }
}

