/*
 * Decompiled with CFR 0.152.
 */
package net.obj.rc.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import net.obj.rc.beans.RcLoginMessage;
import net.obj.rc.beans.RcMessage;
import net.obj.rc.client.IRcMessageListener;
import org.apache.tomcat.websocket.WsSession;

@ClientEndpoint
public class RcClient
extends Thread {
    private static WebSocketContainer CONTAINER = ContainerProvider.getWebSocketContainer();
    private boolean stop = false;
    private Object stopSem = new Object();
    private IRcMessageListener listener = null;
    private WsSession wsSession = null;
    private String uriString;
    private RcLoginMessage rcLogin;

    public RcClient(String uriString, RcLoginMessage rcLogin, IRcMessageListener listener) {
        this.uriString = uriString;
        this.rcLogin = rcLogin;
        this.listener = listener;
    }

    @OnOpen
    public void onOpen(Session session) {
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.setMaxTextMessageBufferSize(0x100000);
        if (session instanceof WsSession) {
            this.wsSession = (WsSession)session;
            Gson gson = new Gson();
            try {
                System.err.println(new Date() + " [OPEN] > " + gson.toJson((Object)this.rcLogin));
                this.wsSession.getBasicRemote().sendText(gson.toJson((Object)this.rcLogin));
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    public void sendMessage(RcMessage rcMessage) {
        if (this.wsSession != null) {
            Gson gson = new Gson();
            try {
                this.wsSession.getBasicRemote().sendText(gson.toJson((Object)rcMessage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        if (this.wsSession != null && this.listener != null) {
            RcMessage rcMessage = null;
            Gson gson = new Gson();
            rcMessage = (RcMessage)gson.fromJson(message, RcMessage.class);
            try {
                this.listener.processMessage(session, rcMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session, CloseReason reason) {
        System.err.println(new Date() + " [CLOSE] > " + session + ":" + reason);
        if (this.wsSession != null) {
            this.wsSession = null;
        }
        Object object = this.stopSem;
        synchronized (object) {
            this.stopSem.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            if (this.wsSession == null) {
                try {
                    CONTAINER.connectToServer((Object)this, new URI(this.uriString));
                }
                catch (DeploymentException deploymentException) {
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.stop) break;
            Object object = this.stopSem;
            synchronized (object) {
                try {
                    this.stopSem.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.wsSession != null) {
            this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "shutdown"), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "shutdown"));
            this.wsSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stop = true;
        Object object = this.stopSem;
        synchronized (object) {
            this.stopSem.notifyAll();
        }
    }
}

