/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.oracle.webservices.internal.api.databinding.JavaCallInfo;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.databinding.ClientCallBridge;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageContextFactory;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.client.sei.BodyBuilder;
import com.sun.xml.internal.ws.client.sei.MessageFiller;
import com.sun.xml.internal.ws.client.sei.ResponseBuilder;
import com.sun.xml.internal.ws.client.sei.ValueGetter;
import com.sun.xml.internal.ws.client.sei.ValueGetterFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetter;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class StubHandler
implements ClientCallBridge {
    private final BodyBuilder bodyBuilder;
    private final MessageFiller[] inFillers;
    protected final String soapAction;
    protected final boolean isOneWay;
    protected final JavaMethodImpl javaMethod;
    protected final Map<QName, CheckedExceptionImpl> checkedExceptions;
    protected SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    protected ResponseBuilder responseBuilder;
    protected MessageContextFactory packetFactory;

    public StubHandler(JavaMethodImpl javaMethodImpl, MessageContextFactory messageContextFactory) {
        this.checkedExceptions = new HashMap<QName, CheckedExceptionImpl>();
        for (CheckedExceptionImpl object2 : javaMethodImpl.getCheckedExceptions()) {
            this.checkedExceptions.put(object2.getBond().getTypeInfo().tagName, object2);
        }
        String string = javaMethodImpl.getBinding().getSOAPAction();
        this.soapAction = javaMethodImpl.getInputAction() != null && string != null && !string.equals("") ? javaMethodImpl.getInputAction() : string;
        this.javaMethod = javaMethodImpl;
        this.packetFactory = messageContextFactory;
        this.soapVersion = this.javaMethod.getBinding().getSOAPVersion();
        List<ParameterImpl> list = javaMethodImpl.getRequestParameters();
        BodyBuilder bodyBuilder = null;
        ArrayList<MessageFiller> arrayList = new ArrayList<MessageFiller>();
        block11: for (ParameterImpl parameterImpl : list) {
            ValueGetter valueGetter = this.getValueGetterFactory().get(parameterImpl);
            switch (parameterImpl.getInBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            bodyBuilder = new BodyBuilder.RpcLit((WrapperParameter)parameterImpl, this.soapVersion, this.getValueGetterFactory());
                            continue block11;
                        }
                        bodyBuilder = new BodyBuilder.DocLit((WrapperParameter)parameterImpl, this.soapVersion, this.getValueGetterFactory());
                        continue block11;
                    }
                    bodyBuilder = new BodyBuilder.Bare(parameterImpl, this.soapVersion, valueGetter);
                    continue block11;
                }
                case HEADER: {
                    arrayList.add(new MessageFiller.Header(parameterImpl.getIndex(), parameterImpl.getXMLBridge(), valueGetter));
                    continue block11;
                }
                case ATTACHMENT: {
                    arrayList.add(MessageFiller.AttachmentFiller.createAttachmentFiller(parameterImpl, valueGetter));
                    continue block11;
                }
                case UNBOUND: {
                    continue block11;
                }
            }
            throw new AssertionError();
        }
        if (bodyBuilder == null) {
            switch (this.soapVersion) {
                case SOAP_11: {
                    bodyBuilder = BodyBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    bodyBuilder = BodyBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.bodyBuilder = bodyBuilder;
        this.inFillers = arrayList.toArray(new MessageFiller[arrayList.size()]);
        this.isOneWay = javaMethodImpl.getMEP().isOneWay();
        this.responseBuilder = this.buildResponseBuilder(javaMethodImpl, ValueSetterFactory.SYNC);
    }

    ResponseBuilder buildResponseBuilder(JavaMethodImpl javaMethodImpl, ValueSetterFactory valueSetterFactory) {
        Object object;
        List<ParameterImpl> list = javaMethodImpl.getResponseParameters();
        ArrayList<ResponseBuilder> arrayList = new ArrayList<ResponseBuilder>();
        block10: for (ParameterImpl parameterImpl : list) {
            switch (parameterImpl.getOutBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            arrayList.add(new ResponseBuilder.RpcLit((WrapperParameter)parameterImpl, valueSetterFactory));
                            continue block10;
                        }
                        arrayList.add(new ResponseBuilder.DocLit((WrapperParameter)parameterImpl, valueSetterFactory));
                        continue block10;
                    }
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.Body(parameterImpl.getXMLBridge(), valueSetter));
                    continue block10;
                }
                case HEADER: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.Header(this.soapVersion, parameterImpl, valueSetter));
                    continue block10;
                }
                case ATTACHMENT: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(ResponseBuilder.AttachmentBuilder.createAttachmentBuilder(parameterImpl, valueSetter));
                    continue block10;
                }
                case UNBOUND: {
                    ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                    arrayList.add(new ResponseBuilder.NullSetter(valueSetter, ResponseBuilder.getVMUninitializedValue(parameterImpl.getTypeInfo().type)));
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        switch (arrayList.size()) {
            case 0: {
                object = ResponseBuilder.NONE;
                break;
            }
            case 1: {
                object = (ResponseBuilder)arrayList.get(0);
                break;
            }
            default: {
                object = new ResponseBuilder.Composite(arrayList);
            }
        }
        return object;
    }

    @Override
    public Packet createRequestPacket(JavaCallInfo javaCallInfo) {
        Message message = this.bodyBuilder.createMessage(javaCallInfo.getParameters());
        for (MessageFiller messageFiller : this.inFillers) {
            messageFiller.fillIn(javaCallInfo.getParameters(), message);
        }
        Packet packet = (Packet)this.packetFactory.createContext(message);
        packet.setState(Packet.State.ClientRequest);
        packet.soapAction = this.soapAction;
        packet.expectReply = !this.isOneWay;
        packet.getMessage().assertOneWay(this.isOneWay);
        packet.setWSDLOperation(this.getOperationName());
        return packet;
    }

    ValueGetterFactory getValueGetterFactory() {
        return ValueGetterFactory.SYNC;
    }

    @Override
    public JavaCallInfo readResponse(Packet packet, JavaCallInfo javaCallInfo) throws Throwable {
        Message message = packet.getMessage();
        if (message.isFault()) {
            SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
            Throwable throwable = sOAPFaultBuilder.createException(this.checkedExceptions);
            javaCallInfo.setException(throwable);
            throw throwable;
        }
        this.initArgs(javaCallInfo.getParameters());
        Object object = this.responseBuilder.readResponse(message, javaCallInfo.getParameters());
        javaCallInfo.setReturnValue(object);
        return javaCallInfo;
    }

    public QName getOperationName() {
        return this.javaMethod.getOperationQName();
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    protected void initArgs(Object[] objectArray) throws Exception {
    }

    @Override
    public Method getMethod() {
        return this.javaMethod.getMethod();
    }

    @Override
    public JavaMethod getOperationModel() {
        return this.javaMethod;
    }
}

