/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.kcms;

import java.awt.color.CMMException;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.Profile;
import sun.java2d.cmm.kcms.CMMImageLayout;
import sun.java2d.cmm.kcms.ICC_Transform;

public class CMM
implements PCMM {
    private static long ID = 0L;
    static final int cmmStatSuccess = 0;
    static final int cmmStatBadProfile = 503;
    static final int cmmStatBadTagData = 504;
    static final int cmmStatBadTagType = 505;
    static final int cmmStatBadTagId = 506;
    static final int cmmStatBadXform = 507;
    static final int cmmStatXformNotActive = 508;
    static final int cmmStatOutOfRange = 518;
    static final int cmmStatTagNotFound = 519;
    private static CMM theKcms = null;

    static native int cmmLoadProfile(byte[] var0, long[] var1);

    static native int cmmFreeProfile(long var0);

    static native int cmmGetProfileSize(long var0, int[] var2);

    static native int cmmGetProfileData(long var0, byte[] var2);

    static native int cmmGetTagSize(long var0, int var2, int[] var3);

    static native int cmmGetTagData(long var0, int var2, byte[] var3);

    static native int cmmSetTagData(long var0, int var2, byte[] var3);

    static native int cmmGetTransform(ICC_Profile var0, int var1, int var2, ICC_Transform var3);

    static native int cmmCombineTransforms(ICC_Transform[] var0, ICC_Transform var1);

    static native int cmmFreeTransform(long var0);

    static native int cmmGetNumComponents(long var0, int[] var2);

    static native int cmmColorConvert(long var0, CMMImageLayout var2, CMMImageLayout var3);

    private CMM() {
    }

    private long getKcmsPtr(Profile profile) {
        if (profile instanceof KcmsProfile) {
            return ((KcmsProfile)profile).getKcmsPtr();
        }
        throw new CMMException("Invalid profile");
    }

    @Override
    public Profile loadProfile(byte[] byArray) {
        long[] lArray = new long[1];
        CMM.checkStatus(CMM.cmmLoadProfile(byArray, lArray));
        if (lArray[0] != 0L) {
            return new KcmsProfile(lArray[0]);
        }
        return null;
    }

    @Override
    public void freeProfile(Profile profile) {
        CMM.checkStatus(CMM.cmmFreeProfile(this.getKcmsPtr(profile)));
    }

    @Override
    public int getProfileSize(Profile profile) {
        int[] nArray = new int[1];
        CMM.checkStatus(CMM.cmmGetProfileSize(this.getKcmsPtr(profile), nArray));
        return nArray[0];
    }

    @Override
    public void getProfileData(Profile profile, byte[] byArray) {
        CMM.checkStatus(CMM.cmmGetProfileData(this.getKcmsPtr(profile), byArray));
    }

    @Override
    public int getTagSize(Profile profile, int n) {
        int[] nArray = new int[1];
        CMM.checkStatus(CMM.cmmGetTagSize(this.getKcmsPtr(profile), n, nArray));
        return nArray[0];
    }

    @Override
    public void getTagData(Profile profile, int n, byte[] byArray) {
        CMM.checkStatus(CMM.cmmGetTagData(this.getKcmsPtr(profile), n, byArray));
    }

    @Override
    public void setTagData(Profile profile, int n, byte[] byArray) {
        int n2 = CMM.cmmSetTagData(this.getKcmsPtr(profile), n, byArray);
        switch (n2) {
            case 504: 
            case 505: 
            case 519: {
                throw new IllegalArgumentException("Can not write tag data.");
            }
        }
        CMM.checkStatus(n2);
    }

    @Override
    public ColorTransform createTransform(ICC_Profile iCC_Profile, int n, int n2) {
        ICC_Transform iCC_Transform = new ICC_Transform();
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n, n2, iCC_Transform));
        return iCC_Transform;
    }

    @Override
    public ColorTransform createTransform(ColorTransform[] colorTransformArray) {
        int n;
        ICC_Transform iCC_Transform = new ICC_Transform();
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[colorTransformArray.length];
        for (n = 0; n < colorTransformArray.length; ++n) {
            iCC_TransformArray[n] = (ICC_Transform)colorTransformArray[n];
        }
        n = CMM.cmmCombineTransforms(iCC_TransformArray, iCC_Transform);
        if (n != 0 || iCC_Transform.getID() == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
        return iCC_Transform;
    }

    static native int cmmInit();

    static native int cmmTerminate();

    static synchronized PCMM getModule() {
        if (theKcms != null) {
            return theKcms;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("kcms");
                return null;
            }
        });
        int n = CMM.cmmInit();
        CMM.checkStatus(n);
        theKcms = new CMM();
        return theKcms;
    }

    protected void finalize() {
        CMM.checkStatus(CMM.cmmTerminate());
    }

    public static void checkStatus(int n) {
        if (n != 0) {
            throw new CMMException(CMM.errorString(n));
        }
    }

    static String errorString(int n) {
        switch (n) {
            case 0: {
                return "Success";
            }
            case 519: {
                return "No such tag";
            }
            case 503: {
                return "Invalid profile data";
            }
            case 504: {
                return "Invalid tag data";
            }
            case 505: {
                return "Invalid tag type";
            }
            case 506: {
                return "Invalid tag signature";
            }
            case 507: {
                return "Invlaid transform";
            }
            case 508: {
                return "Transform is not active";
            }
            case 518: {
                return "Invalid image format";
            }
        }
        return "General CMM error" + n;
    }

    final class KcmsProfile
    extends Profile {
        KcmsProfile(long l) {
            super(l);
        }

        long getKcmsPtr() {
            return this.getNativePtr();
        }
    }
}

