/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.Future;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.Groupable;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

public class WindowsAsynchronousFileChannelImpl
extends AsynchronousFileChannelImpl
implements Iocp.OverlappedChannel,
Groupable {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final int ERROR_HANDLE_EOF = 38;
    private static final FileDispatcher nd = new FileDispatcherImpl();
    private final long handle;
    private final int completionKey;
    private final Iocp iocp;
    private final boolean isDefaultIocp;
    private final PendingIoCache ioCache;
    static final int NO_LOCK = -1;
    static final int LOCKED = 0;

    private WindowsAsynchronousFileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Iocp iocp, boolean bl3) throws IOException {
        super(fileDescriptor, bl, bl2, iocp.executor());
        this.handle = fdAccess.getHandle(fileDescriptor);
        this.iocp = iocp;
        this.isDefaultIocp = bl3;
        this.ioCache = new PendingIoCache();
        this.completionKey = iocp.associate(this, this.handle);
    }

    public static AsynchronousFileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ThreadPool threadPool) throws IOException {
        boolean bl3;
        Iocp iocp;
        if (threadPool == null) {
            iocp = DefaultIocpHolder.defaultIocp;
            bl3 = true;
        } else {
            iocp = new Iocp(null, threadPool).start();
            bl3 = false;
        }
        try {
            return new WindowsAsynchronousFileChannelImpl(fileDescriptor, bl, bl2, iocp, bl3);
        }
        catch (IOException iOException) {
            if (!bl3) {
                iocp.implClose();
            }
            throw iOException;
        }
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long l) {
        return this.ioCache.remove(l);
    }

    @Override
    public void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.invalidateAllLocks();
        WindowsAsynchronousFileChannelImpl.close0(this.handle);
        this.ioCache.close();
        this.iocp.disassociate(this.completionKey);
        if (!this.isDefaultIocp) {
            this.iocp.detachFromThreadPool();
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    private static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            if (throwable instanceof ClosedChannelException) {
                throwable = new AsynchronousCloseException();
            }
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    @Override
    public long size() throws IOException {
        try {
            this.begin();
            long l = nd.size(this.fdObj);
            return l;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        try {
            this.begin();
            if (l > nd.size(this.fdObj)) {
                WindowsAsynchronousFileChannelImpl windowsAsynchronousFileChannelImpl = this;
                return windowsAsynchronousFileChannelImpl;
            }
            nd.truncate(this.fdObj, l);
        }
        finally {
            this.end();
        }
        return this;
    }

    @Override
    public void force(boolean bl) throws IOException {
        try {
            this.begin();
            nd.force(this.fdObj, bl);
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<FileLock> implLock(long l, long l2, boolean bl, A a, CompletionHandler<FileLock, ? super A> completionHandler) {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invoke(this, completionHandler, a, null, closedChannelException);
            return null;
        }
        PendingFuture<FileLock, A> pendingFuture = new PendingFuture<FileLock, A>(this, completionHandler, a);
        LockTask<A> lockTask = new LockTask<A>(l, fileLockImpl, pendingFuture);
        pendingFuture.setContext(lockTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            lockTask.run();
        } else {
            boolean bl2 = false;
            try {
                Invoker.invokeOnThreadInThreadPool(this, lockTask);
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    this.removeFromFileLockTable(fileLockImpl);
                }
            }
        }
        return pendingFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            throw new ClosedChannelException();
        }
        boolean bl2 = false;
        try {
            this.begin();
            int n = nd.lock(this.fdObj, false, l, l2, bl);
            if (n == -1) {
                FileLock fileLock = null;
                return fileLock;
            }
            bl2 = true;
            FileLockImpl fileLockImpl2 = fileLockImpl;
            return fileLockImpl2;
        }
        finally {
            if (!bl2) {
                this.removeFromFileLockTable(fileLockImpl);
            }
            this.end();
        }
    }

    @Override
    protected void implRelease(FileLockImpl fileLockImpl) throws IOException {
        nd.release(this.fdObj, fileLockImpl.position(), fileLockImpl.size());
    }

    @Override
    <A> Future<Integer> implRead(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        int n;
        if (!this.reading) {
            throw new NonReadableChannelException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (!this.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invoke(this, completionHandler, a, null, closedChannelException);
            return null;
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            if (completionHandler == null) {
                return CompletedFuture.withResult(0);
            }
            Invoker.invoke(this, completionHandler, a, 0, null);
            return null;
        }
        PendingFuture<Integer, A> pendingFuture = new PendingFuture<Integer, A>(this, completionHandler, a);
        ReadTask<A> readTask = new ReadTask<A>(byteBuffer, n2, n, l, pendingFuture);
        pendingFuture.setContext(readTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            readTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, readTask);
        }
        return pendingFuture;
    }

    @Override
    <A> Future<Integer> implWrite(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        int n;
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invoke(this, completionHandler, a, null, closedChannelException);
            return null;
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            if (completionHandler == null) {
                return CompletedFuture.withResult(0);
            }
            Invoker.invoke(this, completionHandler, a, 0, null);
            return null;
        }
        PendingFuture<Integer, A> pendingFuture = new PendingFuture<Integer, A>(this, completionHandler, a);
        WriteTask<A> writeTask = new WriteTask<A>(byteBuffer, n2, n, l, pendingFuture);
        pendingFuture.setContext(writeTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            writeTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, writeTask);
        }
        return pendingFuture;
    }

    private static native int readFile(long var0, long var2, int var4, long var5, long var7) throws IOException;

    private static native int writeFile(long var0, long var2, int var4, long var5, long var7) throws IOException;

    private static native int lockFile(long var0, long var2, long var4, boolean var6, long var7) throws IOException;

    private static native void close0(long var0);

    static {
        IOUtil.load();
    }

    private static class DefaultIocpHolder {
        static final Iocp defaultIocp = DefaultIocpHolder.defaultIocp();

        private DefaultIocpHolder() {
        }

        private static Iocp defaultIocp() {
            try {
                return new Iocp(null, ThreadPool.createDefault()).start();
            }
            catch (IOException iOException) {
                throw new InternalError(iOException);
            }
        }
    }

    private class LockTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final long position;
        private final FileLockImpl fli;
        private final PendingFuture<FileLock, A> result;

        LockTask(long l, FileLockImpl fileLockImpl, PendingFuture<FileLock, A> pendingFuture) {
            this.position = l;
            this.fli = fileLockImpl;
            this.result = pendingFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            boolean bl = false;
            try {
                WindowsAsynchronousFileChannelImpl.this.begin();
                l = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                PendingFuture<FileLock, A> pendingFuture = this.result;
                synchronized (pendingFuture) {
                    block11: {
                        int n = WindowsAsynchronousFileChannelImpl.lockFile(WindowsAsynchronousFileChannelImpl.this.handle, this.position, this.fli.size(), this.fli.isShared(), l);
                        if (n != -2) break block11;
                        bl = true;
                        return;
                    }
                    this.result.setResult(this.fli);
                }
            }
            catch (Throwable throwable) {
                WindowsAsynchronousFileChannelImpl.this.removeFromFileLockTable(this.fli);
                this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(throwable));
            }
            finally {
                if (!bl && l != 0L) {
                    WindowsAsynchronousFileChannelImpl.this.ioCache.remove(l);
                }
                WindowsAsynchronousFileChannelImpl.this.end();
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int n, boolean bl) {
            this.result.setResult(this.fli);
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int n, IOException iOException) {
            WindowsAsynchronousFileChannelImpl.this.removeFromFileLockTable(this.fli);
            if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                this.result.setFailure(iOException);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class ReadTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer dst;
        private final int pos;
        private final int rem;
        private final long position;
        private final PendingFuture<Integer, A> result;
        private volatile ByteBuffer buf;

        ReadTask(ByteBuffer byteBuffer, int n, int n2, long l, PendingFuture<Integer, A> pendingFuture) {
            this.dst = byteBuffer;
            this.pos = n;
            this.rem = n2;
            this.position = l;
            this.result = pendingFuture;
        }

        void releaseBufferIfSubstituted() {
            if (this.buf != this.dst) {
                Util.releaseTemporaryDirectBuffer(this.buf);
            }
        }

        void updatePosition(int n) {
            if (n > 0) {
                if (this.buf == this.dst) {
                    try {
                        this.dst.position(this.pos + n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    this.buf.position(n).flip();
                    try {
                        this.dst.put(this.buf);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                long l;
                int n = -1;
                long l2 = 0L;
                if (this.dst instanceof DirectBuffer) {
                    this.buf = this.dst;
                    l = ((DirectBuffer)((Object)this.dst)).address() + (long)this.pos;
                } else {
                    this.buf = Util.getTemporaryDirectBuffer(this.rem);
                    l = ((DirectBuffer)((Object)this.buf)).address();
                }
                boolean bl = false;
                try {
                    WindowsAsynchronousFileChannelImpl.this.begin();
                    l2 = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                    n = WindowsAsynchronousFileChannelImpl.readFile(WindowsAsynchronousFileChannelImpl.this.handle, l, this.rem, this.position, l2);
                    if (n == -2) {
                        bl = true;
                        return;
                    }
                    if (n == -1) {
                        this.result.setResult(n);
                        break block12;
                    }
                    throw new InternalError("Unexpected result: " + n);
                }
                catch (Throwable throwable) {
                    this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(throwable));
                }
                finally {
                    if (!bl) {
                        if (l2 != 0L) {
                            WindowsAsynchronousFileChannelImpl.this.ioCache.remove(l2);
                        }
                        this.releaseBufferIfSubstituted();
                    }
                    WindowsAsynchronousFileChannelImpl.this.end();
                }
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int n, boolean bl) {
            this.updatePosition(n);
            this.releaseBufferIfSubstituted();
            this.result.setResult(n);
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int n, IOException iOException) {
            if (n == 38) {
                this.completed(-1, false);
            } else {
                this.releaseBufferIfSubstituted();
                if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                    this.result.setFailure(iOException);
                } else {
                    this.result.setFailure(new AsynchronousCloseException());
                }
                Invoker.invoke(this.result);
            }
        }
    }

    private class WriteTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer src;
        private final int pos;
        private final int rem;
        private final long position;
        private final PendingFuture<Integer, A> result;
        private volatile ByteBuffer buf;

        WriteTask(ByteBuffer byteBuffer, int n, int n2, long l, PendingFuture<Integer, A> pendingFuture) {
            this.src = byteBuffer;
            this.pos = n;
            this.rem = n2;
            this.position = l;
            this.result = pendingFuture;
        }

        void releaseBufferIfSubstituted() {
            if (this.buf != this.src) {
                Util.releaseTemporaryDirectBuffer(this.buf);
            }
        }

        void updatePosition(int n) {
            if (n > 0) {
                try {
                    this.src.position(this.pos + n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l;
            int n;
            block8: {
                long l2;
                n = -1;
                l = 0L;
                if (this.src instanceof DirectBuffer) {
                    this.buf = this.src;
                    l2 = ((DirectBuffer)((Object)this.src)).address() + (long)this.pos;
                } else {
                    this.buf = Util.getTemporaryDirectBuffer(this.rem);
                    this.buf.put(this.src);
                    this.buf.flip();
                    this.src.position(this.pos);
                    l2 = ((DirectBuffer)((Object)this.buf)).address();
                }
                WindowsAsynchronousFileChannelImpl.this.begin();
                l = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                n = WindowsAsynchronousFileChannelImpl.writeFile(WindowsAsynchronousFileChannelImpl.this.handle, l2, this.rem, this.position, l);
                if (n != -2) break block8;
                WindowsAsynchronousFileChannelImpl.this.end();
                return;
            }
            try {
                try {
                    throw new InternalError("Unexpected result: " + n);
                }
                catch (Throwable throwable) {
                    this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(throwable));
                    if (l != 0L) {
                        WindowsAsynchronousFileChannelImpl.this.ioCache.remove(l);
                    }
                    this.releaseBufferIfSubstituted();
                    WindowsAsynchronousFileChannelImpl.this.end();
                }
            }
            catch (Throwable throwable) {
                WindowsAsynchronousFileChannelImpl.this.end();
                throw throwable;
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int n, boolean bl) {
            this.updatePosition(n);
            this.releaseBufferIfSubstituted();
            this.result.setResult(n);
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int n, IOException iOException) {
            this.releaseBufferIfSubstituted();
            if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                this.result.setFailure(iOException);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }
}

