@echo off

echo ************************************************
echo *                                              *
echo *         Installationsscript v0.0.1           *
echo *                                              *
echo ************************************************
echo. 


set INSTALL_FOLDER=%~dp0
set POS_FOLDER=c:\timeglobe\pos
set JRE_FOLDER=%POS_FOLDER%\jre-win32
set SERVICE_NAME=possat-8080
set SERVICE_DIR=%POS_FOLDER%\%SERVICE_NAME%
set planetPw=jo

goto check_Permissions

:check_Permissions
    echo suche administrator rechte...
    net session >nul 2>&1
    if %errorLevel% == 0 (
        echo [92mAdminstratorprivilege gefunden.[0m
        goto print_informations
    ) else (
        echo [91mKeine Adminstratorprivilege! Bitte mit Adminstratorprivilege neustarten..[0m
        goto exit_script
    )

:print_informations
    goto get_variables

:get_variables
    set /P isNew=Ist es eine Neuinstallation?(yes/no) 

    if NOT "%isNew%" == "yes" (
        if NOT "%isNew%" == "no" (
            goto get_variables
        )
    )

    set /P tenantNo=Instanznummer :
    set /P companyNo=Firmennummer :
    set /P departmentNo=Bereichsnummer :
    set /P businessunitNo=BU-Nummer :
    set /P posCd=Kassencode :
    set /P posCdSmall=Kassencode_klein :
    echo.
    echo. 
    echo [93mHIER ALLE DATEN OHNE UMLAUTE UND KLEINGESCHRIEBEN[0m 
    echo.

    set esafeuid="nope"
    set esafecity="city"
    set esafeposcd=%posCd%
    if "%isNew%" == "yes" (
        set /P esafeuid=ESAFE UID :
        set /P esafecity=Stadt des Saloons :
    )
    goto get_countryCode


:get_planet_info
    cls
    if "%isNew%" == "no" goto show_inputs

    set /P isPlanet=Ist der Kunde ein Planet Kunde? (true/false):
    if NOT %isPlanet% == true (
        if NOT %isPlanet% == false (
            goto get_planet_info
        )
    )

    if %isPlanet% == true (
        goto get_planet_pw
    )

    
    goto show_inputs


:get_planet_pw
    cls
    echo Bitte oeffne den planet admin und oeffne die Tabelle "pos_planet_replication_logins"
    set /P planetPw=Welches Passwort steht da? (kopieren): 
    goto show_inputs

:get_countryCode
    cls
    set countryNo=""
    echo.
    echo Bitte waehle das Land.
    echo Gib die Wahl als Nummer und Enter ein.
    echo (1) AT
    echo (2) CH
    echo (3) DE
    set /P countryNo=Eingabe:

    if NOT %countryNo% == 1 (
         if NOT %countryNo%  == 2 (
             if NOT %countryNo%  == 3 (
                echo.
                echo [91mFalsche eingabe...[0m
                echo. 
                goto get_countryCode
             )
         )
    )

    goto get_planet_info


:show_inputs
    cls
    echo ************** Eingaben Korrekt?... ***************
    echo.
    echo Instanznummer: %tenantNo%
    echo Firmennummer: %companyNo%
    echo Bereichsnummer: %departmentNo%
    echo BU-Nummer:%businessunitNo%
    echo Kassencode:%posCd%
    echo Kassencode_klein :%posCdSmall%
    echo esafeuid: %esafeuid%
    echo esafecity: %esafecity%
    echo esafeposcd: %esafeposcd%
    echo PlanetKunde: %isPlanet%
    echo PlanetPW: %planetPw%

    if %countryNo% == 1 echo Land: AT
    if %countryNo% == 2 echo Land: CH
    if %countryNo% == 3 echo Land: DE
    echo.
    echo.
    set /P k=Eingaben korrekt? (yes/no):
    if NOT %k% == yes goto get_variables

    cls
    if "%isNew%" == "no" goto check_configs
    goto check_backup


:check_configs
    set HAS_CONFIG="false" 
    echo suche config files
    if NOT EXIST "%INSTALL_FOLDER%\*.xml" (
        echo [91mkeine configs gefunden..[0m
        goto exit_script 
    )
    set HAS_CONFIG="true"
    echo [92mconfigs gefunden..[0m
    goto check_backup 


:check_backup
    echo checke backup

    IF NOT EXIST "%INSTALL_FOLDER%\backup.jar" (
        echo [91mKeine Backupdatei gefunden! Bitte backup Datei ablegen.[0m
        goto exit_script
    )
    echo [92mbackup gefunden..[0m
    goto create_folder 

:create_folder

    echo erzeuge ordner..

    mkdir C:\timeglobe\ 2>nul
    xcopy "%INSTALL_FOLDER%\pos\jre" "%JRE_FOLDER%\" /S /E /Y >NUL
    xcopy "%INSTALL_FOLDER%\pos\tomcat\*" "%SERVICE_DIR%\" /S /E /Y >NUL

    rmdir %SERVICE_DIR%\webapps /S /Q 2>nul
    mkdir %SERVICE_DIR%\webapps\ROOT 2>nul
    mkdir %SERVICE_DIR%\webapps\ROOT\%tenantNo%%posCdSmall% 2>nul
    mkdir c:\tseDateien 2>nul
    

    xcopy "%INSTALL_FOLDER%\pos\libs" %SERVICE_DIR%\lib /S /E /Y >NUL

    mkdir %POS_FOLDER%\apps 2>nul
    mkdir %POS_FOLDER%\backup 2>nul
    mkdir %SERVICE_DIR%\conf\Catalina\localhost 2>nul

    setlocal
    cd %SERVICE_DIR%\bin 2>nul
    ren tomcat8.exe %SERVICE_NAME%.exe 2>nul
    ren tomcat8w.exe %SERVICE_NAME%w.exe 2>nul
    endlocal

    echo [92mOrdner erfolgreich erstellt..[0m 


    goto install_tomcat


:install_tomcat
    echo install tomcat...
    @set PARAM=--DisplayName=%SERVICE_NAME% 
    @set PARAM=%PARAM% --Install=%SERVICE_DIR%\bin\%SERVICE_NAME%.exe
    @set PARAM=%PARAM% --StartMode=jvm
    @set PARAM=%PARAM% --StopMode=jvm
    @set PARAM=%PARAM% --StartClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StartParams=start
    @set PARAM=%PARAM% --StartPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --StopClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StopParams=stop --StopPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --Startup=auto
    @set PARAM=%PARAM% --Jvm=%JRE_FOLDER%\bin\server\jvm.dll
    @set PARAM=%PARAM% --Classpath=%SERVICE_DIR%\bin\bootstrap.jar;%SERVICE_DIR%\bin\tomcat-juli.jar
    @set PARAM=%PARAM% --JvmOptions=-Dcatalina.home=%SERVICE_DIR%;-Dcatalina.base=%SERVICE_DIR%;-Djava.endorsed.dirs=%SERVICE_DIR%\common\endorsed;-Djava.io.tmpdir=%SERVICE_DIR%\temp;-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager;-Djava.util.logging.config.file=%SERVICE_DIR%\conf\logging.properties;-Djava.awt.headless=true;
    @set PARAM=%PARAM% --LogPath="%SERVICE_DIR%\logs"
    @set PARAM=%PARAM% --JvmMs=512
    @set PARAM=%PARAM% --JvmMx=1024
    @set PARAM=%PARAM% --StdOutput=auto
    @set PARAM=%PARAM% --StdError=auto

    %SERVICE_DIR%\bin\%SERVICE_NAME% //IS//%SERVICE_NAME% %PARAM% 2>nul

    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim installieren des tomcats! Das Programm wird beendet..[0m
        goto exit_script 
    )
    echo [92mTomcat erfolgreich installiert..[0m 
    goto set_firewall  



:set_firewall

    echo create firewall rules

    netsh advfirewall firewall add rule name="TG SATELLITE 8080" dir=in action=allow protocol=TCP localport=8080 >nul
    netsh advfirewall firewall add rule name="TG SATELLITE 9980" dir=in action=allow protocol=TCP localport=9980 >nul

    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim einrichten der Firewall![0m
        goto exit_script 
    ) else (
        echo [92mFirewall eingerichtet..[0m 
    )

    goto download_files

:download_files
    echo download latest updates..


    "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\helper.jar" downloadupdate
    
    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim runterladen der Daten.[0m
        goto exit_script 
    )
    echo [92mDownload complete..[0m 

    echo copy files

    IF EXIST "%INSTALL_FOLDER%\temp\libs" (
        xcopy /Y /E /I "%INSTALL_FOLDER%\temp\libs\*" %SERVICE_DIR%\lib
    )


    xcopy /Y /E /I "%INSTALL_FOLDER%\temp\Berichte\*" %SERVICE_DIR%\webapps\ROOT\%tenantNo%%posCdSmall% >NUL
    xcopy /Y /E /I "%INSTALL_FOLDER%\temp\*.war" %POS_FOLDER%\apps\ >NUL

    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim kopieren der Daten.[0m
        goto exit_script 
    )
    echo [92mCopy complete..[0m 
    goto create_xml  



:create_xml
    if "%isNew%" == "yes" (
        echo create config files
        "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\helper.jar" createxml %countryNo% %tenantNo% %companyNo% %departmentNo% %businessunitNo% %posCd% %posCdSmall% %esafeuid% %esafecity% "passwort" %esafeposcd% %isPlanet% %planetPw%
        if NOT %ERRORLEVEL% == 0 (
            echo [91mFehler beim erstellen.[0m
            goto exit_script
        )
        echo [92mcreate complete[0m
        goto create_database  
    )

    xcopy /Y "%INSTALL_FOLDER%*.xml" c:\timeglobe\pos\possat-8080\conf\Catalina\localhost\ >nul
    goto create_database  


:create_database

    echo create database
    "%INSTALL_FOLDER%pos\jre\bin\java" -jar "%INSTALL_FOLDER%db-tool.jar" restore jarfile:="%INSTALL_FOLDER%backup.jar" target-db:=c:/timeglobe/pos/database/db_pos_s%tenantNo%%posCdSmall% database-type:=derby create-db:=true catalog-file:="%INSTALL_FOLDER%temp\pos.xml" >nul
    echo [92mcreate database complete[0m 

    goto clean_database

:clean_database
    if "%isNew%" == "yes" (
        echo clean database
        "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\helper.jar" cleandatabase c:/timeglobe/pos/database/db_pos_s%tenantNo%%posCdSmall%
        if NOT %ERRORLEVEL% == 0 (
            echo [91mFehler beim saeubern.[0m
            goto exit_script 
        )
    )
    echo [92mcleaning complete[0m 
    goto install_launcher 


:install_launcher

    echo install launcher...

    xcopy /Y /E /I "%INSTALL_FOLDER%\launch\jre8-win32" c:\timeglobe\launch\jre8-win32 >nul
    xcopy /Y /E /I "%INSTALL_FOLDER%\launch\launch-9980" c:\timeglobe\launch\launch-9980 >nul
    mkdir c:\timeglobe\launch\install 2>nul
    xcopy /Y /E /I "%INSTALL_FOLDER%\launch\install" c:\timeglobe\launch\install >nul
    @setlocal
    @set PORT=9980
    @set BASE_DIR=c:\timeglobe\launch
    @set SERVICE_NAME=launch-%PORT%
    @set JRE_DIR=%BASE_DIR%\jre8-win32
    @set SERVICE_DIR=%BASE_DIR%\%SERVICE_NAME%
    @set PARAM=--DisplayName=%SERVICE_NAME% 
    @set PARAM=%PARAM% --Install=%SERVICE_DIR%\bin\%SERVICE_NAME%.exe
    @set PARAM=%PARAM% --StartMode=jvm
    @set PARAM=%PARAM% --StopMode=jvm
    @set PARAM=%PARAM% --StartClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StartParams=start
    @set PARAM=%PARAM% --StartPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --StopClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StopParams=stop --StopPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --Startup=auto
    @set PARAM=%PARAM% --Jvm=%JRE_DIR%\bin\client\jvm.dll
    @set PARAM=%PARAM% --Classpath=%SERVICE_DIR%\bin\bootstrap.jar;%SERVICE_DIR%\bin\tomcat-juli.jar
    @set PARAM=%PARAM% --JvmOptions=-Dcatalina.home=%SERVICE_DIR%;-Dcatalina.base=%SERVICE_DIR%;-Djava.endorsed.dirs=%SERVICE_DIR%\common\endorsed;-Djava.io.tmpdir=%SERVICE_DIR%\temp;-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager;-Djava.util.logging.config.file=%SERVICE_DIR%\conf\logging.properties;-Djava.awt.headless=true;
    @set PARAM=%PARAM% --LogPath="%SERVICE_DIR%\logs"
    @set PARAM=%PARAM% --JvmMs=256
    @set PARAM=%PARAM% --JvmMx=512
    @set PARAM=%PARAM% --StdOutput=auto
    @set PARAM=%PARAM% --StdError=auto
    %SERVICE_DIR%\bin\%SERVICE_NAME% //IS//%SERVICE_NAME% %PARAM% >nul


    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim installieren des launchers! Das Programm wird beendet..[0m
        goto exit_script 
    ) else (
        c:\timeglobe\launch\jre8-win32\bin\java -cp c:\timeglobe\launch\install\esafe-to-launcher.jar util.GetConfig  >nul
        rmdir /s /q c:\timeglobe\launch\install\ >nul
        "%INSTALL_FOLDER%launch\install\LauncherSetup.msi" 
    )

    echo [92mlauncher installiert..[0m
    goto :install_tse



:install_tse
    echo install tse...

    xcopy /Y /E /I "%INSTALL_FOLDER%\tse\runtime\jdk-14.0.2-win" c:\timeglobe\tse\runtime\jdk-14.0.2-win >nul
    xcopy /Y /E /I "%INSTALL_FOLDER%\tse\tsesat-8280" c:\timeglobe\tse\tsesat-8280 >nul
    @setlocal
    @set PORT=8280
    @set BASE_DIR=c:\timeglobe\tse
    @set SERVICE_NAME=tsesat-%PORT%
    @set JAVA_DIR=%BASE_DIR%\runtime\jdk-14.0.2-win
    @set SERVICE_DIR=%BASE_DIR%\%SERVICE_NAME%
    @set PARAM=--DisplayName=%SERVICE_NAME% 
    @set PARAM=%PARAM% --Install=%SERVICE_DIR%\bin\%SERVICE_NAME%.exe
    @set PARAM=%PARAM% --StartMode=jvm
    @set PARAM=%PARAM% --StopMode=jvm
    @set PARAM=%PARAM% --StartClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StartParams=start
    @set PARAM=%PARAM% --StartPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --StopClass=org.apache.catalina.startup.Bootstrap
    @set PARAM=%PARAM% --StopParams=stop --StopPath=%SERVICE_DIR%
    @set PARAM=%PARAM% --Startup=auto
    @set PARAM=%PARAM% --Jvm=%JAVA_DIR%\bin\server\jvm.dll
    @set PARAM=%PARAM% --Classpath=%SERVICE_DIR%\bin\bootstrap.jar;%SERVICE_DIR%\bin\tomcat-juli.jar
    @set PARAM=%PARAM% --JvmOptions=-Dcatalina.home=%SERVICE_DIR%;-Dcatalina.base=%SERVICE_DIR%;-Djava.io.tmpdir=%SERVICE_DIR%\temp;-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager;-Djava.util.logging.config.file=%SERVICE_DIR%\conf\logging.properties;-Djava.awt.headless=true;
    @set PARAM=%PARAM% --LogPath="%SERVICE_DIR%\logs"
    @set PARAM=%PARAM% --JvmMs=256
    @set PARAM=%PARAM% --JvmMx=512
    @set PARAM=%PARAM% --StdOutput=auto
    @set PARAM=%PARAM% --StdError=auto
    %SERVICE_DIR%\bin\%SERVICE_NAME% //IS//%SERVICE_NAME% %PARAM%
    
    if NOT %ERRORLEVEL% == 0 (
        echo [91mFehler beim installieren des launchers! Das Programm wird beendet..[0m
        goto exit_script 
    )
    echo [92mtse installiert..[0m
    goto :start_services

:start_services
    echo start services..

    sc start possat-8080 >nul
    sc start launch-9980 >nul
    sc start tsesat-8280 >nul

    echo [92mservices gestartet..[0m

    echo.
    echo. Druecke Enter um fortzufahren.
    pause >nul
    if %countryNo% == 1 (
        if "%isNew%" == "yes" (
            goto get_rksv_data
        )
    )
    goto show_summary


:get_rksv_data
    echo generate rksv data...
    echo.
    echo.
    echo Bitte warte und teste bis die Kasse online ist und druecke danach auf Enter.
    start "" http://localhost:8080/s%tenantNo%%posCdSmall%
    pause >nul
    cls
    "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\helper.jar" generaterksv %tenantNo% %posCdSmall%
    if %ERRORLEVEL% == 1 (
        echo.
        echo [91mDer RKSV Service ist nicht erreichbar..[0m
        echo.
        goto get_rksv_data 
    )

    if %ERRORLEVEL% == 2 (
        echo.
        echo [91mKein Gültiges Zertifikat gefunden. Iste eine Sicherheitskarte angeschlossen?..[0m
        echo.
        goto get_rksv_data 
    )
    if %ERRORLEVEL% == 3 (
        echo.
        echo [91mFehler..[0m
        echo.
        goto exit_script 
    )

    echo [92mdaten erstellt..[0m

    net stop possat-8080 >nul && net start possat-8080 >nul

    echo Kasse wird neugestartet...
    echo.
    echo 1. Logge dich ein und erzeuge einen Nullbon.
    echo 2. Gehe unter exporte auf "DEP EXPORT..."
    echo 3. Gehe in den timeglobe/pos/backups/jws Ordner und kopiere die neuste datei nach %INSTALL_FOLDER%\dep.json...
    echo.
    echo Druecke Enter um fortzufahren...
    pause >nul
    cls

    goto test_rksv

:test_rksv
    echo test rksv data...
    "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\regkassen-verification-depformat-1.0.0.jar" -v -f -i "%INSTALL_FOLDER%\dep.json" -c "%INSTALL_FOLDER%\params.json" -o "%INSTALL_FOLDER%\results" >nul
    "%INSTALL_FOLDER%\pos\jre\bin\java" -jar "%INSTALL_FOLDER%\helper.jar" testrksv >nul

    if %ERRORLEVEL% == 1 (
        echo.
        echo [91mFehler des Nullbons..[0m
        echo.
        goto exit_script 
    )

    echo [92mNullbon erfolgreich getestet falls es ein Planet Kunde ist wrird die Kasse neugestartet..[0m

    net stop possat-8080 >nul && net start possat-8080 >nul

    echo Druecke Enter um fortzufahren...
    pause >nul
    cls
    goto rskv_rep

:rskv_rep
    if EXIST "c:\timeglobe\pos\possat-8080\conf\Catalina\*.xml" (
        xcopy /Y c:\timeglobe\pos\possat-8080\conf\Catalina\*.xml c:\timeglobe\pos\possat-8080\conf\Catalina\localhost\ >nul
        del c:\timeglobe\pos\possat-8080\conf\Catalina\*.xml
    )
    goto show_summary



:show_summary
    cls
    echo Bitte fuer alle nachfolgenden Schritte noch aus. Wenn du alle Schritte gemacht hast druecke Enter.
    echo.
    echo 1. Komplementiere die Launcher installation
    if "%isNew%" == "yes" (
        echo 2. Erzeuge ein Einrichtungsprotokoll "Kasse Exporte Einrichtungsprotokoll"
        echo 3. speichere dieses beim Kunden und in unserem Kundenordner
    )
    echo 4. Installiere die gewuenschten Drucker und stelle diese ein Einstellungen Konfiguration Drucker
    echo 5. Hintelege die richtigen Formulare fuer die Bons
    echo 6. Hinterlege das Logo
    echo 7. TSE Einrichtung?
    echo Druecke Enter um fortzufahren
    pause >nul
    cls
    echo [92m************************************************
    echo *                                              *
    echo *         Installation Komplett.               *
    echo *                                              *
    echo ************************************************[0m
    echo.
    echo.

    if "%isNew%" == "yes" (
        echo 1. Daten fuer zoho
        echo stationPath: %esafeuid%/%esafecity%/%esafeposcd%
        echo.
        echo.
        if %countryNo% == 1 (
            echo 2. Bitte die RKSV Daten %INSTALL_FOLDER%rksv.temp an den Kundenschicken.
        )
    )
    goto exit_script

:exit_script
    echo Druecke Enter um das Programm zu beenden
    pause >nul