<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">

	
	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." />


<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="content-separator">
		<xsl:attribute name="border-bottom">0.5mm solid</xsl:attribute>
		<xsl:attribute name="margin-top">2mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">2mm</xsl:attribute>
	</xsl:attribute-set>


	<xsl:template name="tokenize">
		<xsl:param name="input"/>
		<xsl:param name="length" select="30"/>
		<token><text><xsl:value-of select="substring($input,1,$length)"/></text></token>
		<xsl:if test="substring($input,$length+1)">
		<xsl:call-template name="tokenize">
		<xsl:with-param name="input" select="substring($input,$length+1)"/>
		</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="receiptdata">
		<xsl:param name="SalesInv" />
		<!-- Body Variables -->
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="$SalesInv/departmentCurrencySymbol"></xsl:value-of>
					</xsl:variable>
					

					<!-- LOGO -->
					<fo:block-container width="100%" text-align="center" >
						<fo:block>
							<fo:external-graphic content-width="scale-to-fit" content-height="100%" width="100%" scaling="uniform">
								<xsl:attribute name="src"><xsl:value-of select="$SalesInv/buLogoUrl" /></xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:block-container>

					<!-- BU DATA -->
					<fo:block-container width="100%">
						<!-- CompanyName shows only if differently from SalonName -->
						<!-- <xsl:if test="$SalesInv/businessunitAdr0 != $SalesInv/buNm1"> -->
							<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
								<xsl:value-of select="'Senzera AT GmbH'" />
							</fo:block>
					<!-- 	</xsl:if>-->

						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$SalesInv/buNm1" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$SalesInv/buNm2" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$SalesInv/businessunitAdr2" />&#160;<xsl:value-of select="$SalesInv/businessunitAdr3" />
						</fo:block>

						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							eMail:&#160;<xsl:value-of select="$SalesInv/buEmail" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Telefon:&#160;<xsl:value-of select="$SalesInv/buPhone" />
						</fo:block>

					</fo:block-container>



					<fo:block-container width="100%" margin-top="5mm">

						<xsl:choose>
							<!-- GUTSCHRIFT -->
							<xsl:when test='$SalesInv/SalesInvType=2'>
								<fo:block xsl:use-attribute-sets="title-style" text-align="center">
									Gutschrift
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									Beleg-Nr.:<xsl:value-of select="$SalesInv/SalesInvCd" />&#160;
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									<xsl:value-of select="$SalesInv/SalesInvTsD" />&#160;<xsl:value-of select="$SalesInv/SalesInvTsT" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-small" text-align="center">
									(Rechnungskorrektur für Beleg-Nr.
									<xsl:value-of select="$SalesInv/cancelForSalesInvCd" />
									vom
									<xsl:value-of select="$SalesInv/cancelForSalesInvTsD" />
									&#160;
									<xsl:value-of select="$SalesInv/cancelForSalesInvTsT" />
									)
								</fo:block>
							</xsl:when>
							<!-- BON -->
							<xsl:otherwise>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									Beleg-Nr.:<xsl:value-of select="$SalesInv/salesInvCd" />&#160;
									<xsl:value-of select="$SalesInv/salesInvTsD" />&#160;<xsl:value-of select="$SalesInv/salesInvTsT" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									<xsl:value-of select="$SalesInv/SalesInvTsD" />&#160;<xsl:value-of select="$SalesInv/SalesInvTsT" />
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
					</fo:block-container>



					<!-- BARCODE -->
					<fo:block-container width="100%">
						<fo:block text-align="center">
							<xsl:variable name="sId">
								<xsl:value-of select="$SalesInv/salesInvCd" />
							</xsl:variable>

							<fo:instream-foreign-object>
								<xsl:variable name="barcode-cfg">
									<barcode>
										<code128>
											<human-readable>none</human-readable>
											<height>16mm</height>
											<module-width>0.20mm</module-width>
											<quiet-zone enabled="false" />
										</code128>
									</barcode>
								</xsl:variable>
								<xsl:copy-of select="barcode:generate($barcode-cfg, $sId)" />
							</fo:instream-foreign-object>
						</fo:block>
						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					</fo:block-container>

					<!-- Kassierer -->
					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Kunde/in:<xsl:value-of select="$SalesInv/customerAdr1" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Kassierer/in:<xsl:value-of select="$SalesInv/employeeNm" />
						</fo:block>
					</fo:block-container>

					<!-- Kunde
					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Kunde:<xsl:value-of select="$SalesInv/customerAdr1" />
						</fo:block>
					</fo:block-container> -->


					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>

					
					<!-- Positions Tabelle -->
					<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">

						<fo:table-column column-width="7.15%"></fo:table-column>
						<fo:table-column column-width="63.4%"></fo:table-column>
						<fo:table-column column-width="15.15%"></fo:table-column>
						<fo:table-column column-width="14.3%"></fo:table-column>
						<fo:table-body>
						
							<!-- EMPTY ROW -->
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="cell-default" text-align="left"></fo:block> 
								</fo:table-cell>
							</fo:table-row>
							<!-- Positionen -->
							<xsl:for-each select="$SalesInv/SalesInvPosition">

								<xsl:variable name="margin">
									<xsl:choose>
										<xsl:when test='position() = last()'>
											0mm
										</xsl:when>
										<xsl:otherwise>
											2mm
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								

								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
											<xsl:value-of select='format-number(amount, "###.##0", "amount")' />*
										</fo:block>
									</fo:table-cell>
									<!-- ItemTable (Name,Rabatta,Employee -->
									<fo:table-cell>

										<fo:block-container  margin-bottom="{$margin}">
											<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
												<fo:table-column column-width="77.7%"></fo:table-column>
												<fo:table-column column-width="22.3%"></fo:table-column>
												<fo:table-body>
													<!-- Item, Preiß -->
													<fo:table-row>
														<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="left">
															<fo:block>
																<xsl:value-of select="itemNm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="right">
															<fo:block>
																<xsl:value-of select='format-number(itemPrice, "###.##0,00", "money")' />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<!-- Kartennummer, wenn auf Position vorhanden -->
													<xsl:if test='ccConditionCardNo != "" or ccConditionCardNm != "" '>
														<fo:table-row>
															<fo:table-cell xsl:use-attribute-sets="cell-default"  text-align="left" number-columns-spanned="2">
																<fo:block>
																	<xsl:choose>
																		<xsl:when test="ccConditionCardNo != ''">
																			<xsl:value-of select="ccConditionCardNo" />
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="ccConditionCardNm" />
																		</xsl:otherwise>
																	</xsl:choose>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:if>
													<!-- Mitarbeiter -->
													<fo:table-row>
														<fo:table-cell xsl:use-attribute-sets="cell-default"  text-align="left" number-columns-spanned="2">
															<fo:block>
																<xsl:value-of select="Employees" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<!-- Rabatt auf Position -->
													<xsl:if test='appliedPosRebatePrice!=0'>
														<fo:table-row>
															<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="left" >
																<fo:block>
																	<xsl:choose>
																		<!-- Prozent -->
																		<xsl:when test='posRebateRatePercent>0'>
																			<xsl:value-of select='format-number(posRebateRatePercent, "#0,00", "percent")' />
																			% von
																			<xsl:value-of select='format-number(posRebateBasePrice,"###.##0,00", "money")' />
																		</xsl:when>
																		<!-- Preis -->
																		<xsl:otherwise>
																			Rabatt
																		</xsl:otherwise>
																	</xsl:choose>
																</fo:block>
															</fo:table-cell>
															<!-- Wert -->
															<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="right" >
																<fo:block>
																	<xsl:value-of select='format-number(-appliedPosRebatePrice,"###.##0,00", "money")' />
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:if>
													<!-- Belegrabatt -->
													<xsl:if test='appliedInvRebatePrice!=0'>
														<fo:table-row>
															<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="left" >
																<fo:block>
																	<xsl:value-of select='format-number(invRebateRatePercent, "#0,00", "percent")' />
																	% von
																	<xsl:value-of select='format-number(invRebateBasePrice,"###.##0,00", "money")' />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="right">
																<fo:block>
																	<xsl:value-of select='format-number(-appliedInvRebatePrice,"###.##0,00", "money")' />
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:if>

												</fo:table-body>
											</fo:table>
										</fo:block-container>
									</fo:table-cell>

									<!-- Gesamt Positionspreiß -->
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="center" >
											<xsl:value-of select='taxCd' />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
											<xsl:value-of select='format-number(positionGrossPrice, "###.##0,00", "money")' />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</xsl:for-each>


							<xsl:if test="$SalesInv/PosPayment">
									<xsl:for-each select="$SalesInv/PosPayment">

										<xsl:if test="not(paymentHint='generated')">
											<xsl:if test="paymentType=11 or paymentType=12 or paymentType=13">
												<xsl:if test="paymentDirection!=1">
													<fo:table-row>
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																1*
															</fo:block>
														</fo:table-cell>
														<fo:table-cell>
															<fo:block-container  margin-top="2mm">
																<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
																	<fo:table-column column-width="77.7%"></fo:table-column>
																	<fo:table-column column-width="22.3%"></fo:table-column>
																	<fo:table-body>
																		<!-- Item, Preiß -->
																		<fo:table-row>
																			<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="left">
																				<fo:block>
																					<xsl:if test="paymentType=11">
																						Gutschein&#160;<xsl:value-of select="paymentRef" />
																					</xsl:if>
																					<xsl:if test="paymentType=12">
																						Punktegutschein&#160;<xsl:value-of select="paymentRef" />
																					</xsl:if>
																					<xsl:if test="paymentType=13">
																						Gutscheinkarte&#160;<xsl:value-of select="paymentRef" />
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="right">
																				<fo:block>
																					<xsl:if test="paymentType=12">
																						<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>


																		<!-- Rabatt -->
																		<xsl:if test="paymentType=12">
																			<fo:table-row>
																				<fo:table-cell>
																					<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																						Punkterabatt(<xsl:value-of select='salesCreditPoints' />)&#160;<xsl:value-of select="paymentRef" />
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell>
																					<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
																						<xsl:choose>
																							<xsl:when test="paymentDirection = 1">
																								+<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																							</xsl:when>
																							<xsl:when test="paymentDirection = 2">
																								-<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																							</xsl:when>
																							<xsl:otherwise>
																							</xsl:otherwise>
																						</xsl:choose>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</xsl:if>		
																	


																	</fo:table-body>
																</fo:table>
															</fo:block-container>
														</fo:table-cell>
														<!-- Gesamt Positionspreiß -->
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="right" margin-top="2mm">
																<xsl:choose>
																	<xsl:when test="paymentType=12">
																		0,00
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
											</xsl:if>
											<xsl:if test="paymentType=2">
												<xsl:if test="paymentDirection!=1 and cancelForPosPaymentId = ''">
													<fo:table-row>
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																1*
															</fo:block>
														</fo:table-cell>
														<fo:table-cell>
															<fo:block-container  margin-top="2mm">
																<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
																	<fo:table-column column-width="77.7%"></fo:table-column>
																	<fo:table-column column-width="22.3%"></fo:table-column>
																	<fo:table-body>
																		<!-- Item, Preiß -->
																		<fo:table-row>
																			<fo:table-cell xsl:use-attribute-sets="cell-default" text-align="left" number-columns-spanned="2">
																				<fo:block >
																					Gutschein&#160;<xsl:value-of select="paymentRef" />
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block-container>
														</fo:table-cell>
														<!-- Gesamt Positionspreiß -->
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell>
															<fo:block xsl:use-attribute-sets="cell-default" text-align="right" margin-top="2mm">
																<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													
													
													
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
							</xsl:if>
						</fo:table-body>
					</fo:table>


					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>


					<!-- Zwischensumme, Rabatte -->

					<xsl:if test="not($SalesInv/SalesInvAdditionalTotals/SalesInvTotalPrice = $SalesInv/SalesInvAdditionalTotals/SalesInvTotalPriceToPay)">

						<fo:block-container width="100%">
							<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
								<fo:table-column column-width="82.7%"></fo:table-column>
								<fo:table-column column-width="17.3%"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-bottom="0mm">
												Zwischensumme
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="right" margin-bottom="0mm">
												<xsl:value-of select='format-number($SalesInv/SalesInvAdditionalTotals/SalesInvTotalPrice, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<xsl:if test="$SalesInv/PosPayment">
										<xsl:for-each select="$SalesInv/PosPayment">
											<xsl:if test="paymentType=2 or paymentType=6 or paymentType = 10 or paymentType = 12">
													<xsl:choose>
														<xsl:when test="paymentType=6">
															<fo:table-row>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="left"  margin-top="2mm">
																		Rabatt nach Total
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="right"  margin-top="2mm">
																		<xsl:choose>
																			<xsl:when test="paymentDirection = 1">
																				+<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:when test="paymentDirection = 2">
																				-<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:otherwise>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:when>
														<xsl:when test="paymentType=10">
															<fo:table-row>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																		Punkterabatt(<xsl:value-of select='salesCreditPoints' />)
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="right" margin-top="2mm">
																		<xsl:choose>
																			<xsl:when test="paymentDirection = 1">
																				+<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:when test="paymentDirection = 2">
																				-<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:otherwise>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:when>
														<xsl:when test="paymentType=2">
															<xsl:if test="not(salesVoucherValueRebate = '') and cancelForPosPaymentId = '' and paymentDirection = 2">
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																			Rabatt&#160;<xsl:value-of select="paymentRef" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell>
																		<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
																			<xsl:choose>
																				<xsl:when test="paymentDirection = 2">
																					-<xsl:value-of select='format-number(salesVoucherValueRebate, "###.##0,00", "money")' />
																				</xsl:when>
																				<xsl:otherwise>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:if>
															<xsl:if test="not(salesVoucherValueRebate = '') and not(cancelForPosPaymentId = '') and paymentDirection = 1">
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																			Rabatt&#160;<xsl:value-of select="paymentRef" />
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell>
																		<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
																			<xsl:choose>
																				<xsl:when test="paymentDirection = 1">
																					+<xsl:value-of select='format-number(salesVoucherValueRebate, "###.##0,00", "money")' />
																				</xsl:when>
																				<xsl:otherwise>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:if>				
														</xsl:when>
														
														<xsl:otherwise>
															<!-- <fo:table-row>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="left" margin-top="2mm">
																		Punkterabatt(<xsl:value-of select='salesCreditPoints' />)&#160;<xsl:value-of select="paymentRef" />
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell>
																	<fo:block xsl:use-attribute-sets="cell-default" text-align="right" margin-top="2mm">
																		<xsl:choose>
																			<xsl:when test="paymentDirection = 1">
																				+<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:when test="paymentDirection = 2">
																				-<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																			</xsl:when>
																			<xsl:otherwise>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row> -->
														</xsl:otherwise>
													</xsl:choose>
											</xsl:if>
										</xsl:for-each>
									</xsl:if>
								</fo:table-body>
							</fo:table>
						</fo:block-container>

						<fo:block-container width="100%">
							<fo:block xsl:use-attribute-sets="content-separator">
							</fo:block>
						</fo:block-container>
					</xsl:if>

					
					<fo:block-container width="100%">
						<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
							<fo:table-column column-width="78.6%"></fo:table-column>
							<fo:table-column column-width="21.4%"></fo:table-column>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-big" text-align="left" >
											Summe
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-big" text-align="right" >
											<xsl:value-of select='format-number($SalesInv/SalesInvAdditionalTotals/SalesInvTotalPriceToPay, "###.##0,00", "money")' />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block-container>

					<xsl:if test="$SalesInv/PosPayment">
						<fo:block-container width="100%">
							<fo:block xsl:use-attribute-sets="content-separator">
							</fo:block>
						</fo:block-container>

						<fo:block-container width="100%">
							<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
								<fo:table-column column-width="82.7%"></fo:table-column>
								<fo:table-column column-width="17.3%"></fo:table-column>
								<fo:table-body>

									<!-- Trinkgeld -->
									<xsl:if test="$SalesInv/totalTipValue">
										<fo:table-row>
											<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-default">
												<fo:block>
													Trinkgeld
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-default">
												<fo:block>
													<xsl:value-of select='format-number($SalesInv/totalTipValue, "###.##0,00", "money")' />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:if>


									<xsl:for-each select="$SalesInv/PosPayment">
										<fo:table-row>
											<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-default">
												<fo:block>
													<xsl:choose>
														<xsl:when test="paymentType=1">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Gegeben Bar
																</xsl:when>
																<xsl:otherwise>
																	Ausgezahlt Bar
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=2">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Gutscheineinreichung&#160;<xsl:value-of select="paymentRef" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:if test="paymentHint='generated'">
																		Restwertgutschein&#160;<xsl:value-of select="paymentRef" />
																	</xsl:if>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=3">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Einzahlung
																</xsl:when>
																<xsl:otherwise>
																	Rückgeld Bar
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=4">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	EC-Zahlung
																</xsl:when>
																<xsl:otherwise>
																	EC-Zahlung
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=5">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Kreditkarte
																</xsl:when>
																<xsl:otherwise>
																	Kreditkarte
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=7">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Anrechnung Rechnungskorrektur
																</xsl:when>
																<xsl:otherwise>
																	Guthaben Rechnungskorrektur
																</xsl:otherwise>
															</xsl:choose>
															&#160;Beleg Nr.
															<xsl:value-of select="paymentRef" />
														</xsl:when>
														<xsl:when test="paymentType=8">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Überweisung
																</xsl:when>
																<xsl:otherwise>
																	Überweisung
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=11">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Gutschein
																	&#160;
																	<xsl:value-of select="paymentRef" />
																</xsl:when>
																<xsl:otherwise>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=12">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Punkte-Gutschein&#160;<xsl:value-of select="paymentRef" />
																	<xsl:if test="salesCreditPoints != ''">
																		&#160;<xsl:value-of select="salesCreditPoints" />&#160;Punkte
																	</xsl:if>
																</xsl:when>
																<xsl:otherwise>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=13">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Gutscheinkarte
																	&#160;
																	<xsl:value-of select="paymentRef" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:if test="paymentHint='generated'">
																		Rest Gutscheinkarte&#160;<xsl:value-of select="paymentRef" />
																	</xsl:if>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:when test="paymentType=14">
															<xsl:choose>
																<xsl:when test="paymentDirection=1">
																	Onlinezahlung&#160;<xsl:value-of select="paymentRef" />
																</xsl:when>
																<xsl:otherwise>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise>
														</xsl:otherwise>
													</xsl:choose>
												</fo:block>
											</fo:table-cell>
											
											<xsl:if test="(paymentDirection=1 and paymentType != 6 and paymentType != 10) or (paymentType = 2 and paymentHint='generated') or (paymentType != 2 and paymentType != 10 and paymentType != 6 and paymentType != 11 and paymentType != 12)">
												<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-default">
													<fo:block>
														<xsl:choose>
															<xsl:when test="paymentDirection = 1">
																<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
															</xsl:when>
															<xsl:otherwise>
																-<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
															</xsl:otherwise>
														</xsl:choose>
													</fo:block>
												</fo:table-cell>
											</xsl:if>		
										</fo:table-row>

									</xsl:for-each>
									<fo:table-row>
										<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-default">
											<fo:block>
												Rückgeld Bar
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-default">
											<fo:block>
												<xsl:value-of select='format-number($SalesInv/SalesInvAdditionalTotals/SalesInvChange, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block-container>
					</xsl:if>
			
					<xsl:if test="not ($SalesInv/SalesInvAdditionalTotals/OpenValues = 0)">
						<fo:block-container width="100%">
							<fo:block xsl:use-attribute-sets="content-separator">
							</fo:block>
						</fo:block-container>
						
						<fo:block-container width="100%">
							<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
								<fo:table-column column-width="78.6%"></fo:table-column>
								<fo:table-column column-width="21.4%"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-big" text-align="left" >
												noch zuzahlen
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-big" text-align="right" >
												<xsl:value-of select='format-number($SalesInv/SalesInvAdditionalTotals/OpenValues, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block-container>
					</xsl:if>

					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>


					<fo:block-container width="100%">
						<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
							<fo:table-column column-width="25%"></fo:table-column>
							<fo:table-column column-width="25%"></fo:table-column>
							<fo:table-column column-width="25%"></fo:table-column>
							<fo:table-column column-width="25%"></fo:table-column>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="2mm">
											MwSt. %
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="2mm">
											Brutto
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="2mm">
											Netto
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="2mm">
											MwSt.
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<xsl:for-each select="$SalesInv/SalesInvTaxTotal">
									
									<xsl:variable name="margin">
										<xsl:choose>
											<xsl:when test='position() = last()'>
												0mm
											</xsl:when>
											<xsl:otherwise>
												2mm
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<fo:table-row>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="{$margin}">
												<xsl:value-of select='taxCd'/>=&#160;<xsl:value-of select='format-number(taxRatePercent, "#0,##", "percent")' />%
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="{$margin}">
												<xsl:value-of select='format-number(totalGrossPrice, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="{$margin}">
												<xsl:value-of select='format-number(totalNetPrice, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="cell-default" text-align="center" margin-bottom="{$margin}">
												<xsl:value-of select='format-number(totalTaxPrice, "###.##0,00", "money")' />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
								
							</fo:table-body>
						</fo:table>
					</fo:block-container>

					<xsl:if test="$SalesInv/alternateTaxHint='nato'">
						<fo:block-container width="70mm" margin-top="2mm">
							<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
								Die angegebenen Beträge sind Netto-Beträge.
								
							</fo:block>
							<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
								Umsatzsteuerbefreit nach Art. 67 Abs. 3 NATO-ZAbk
								
							</fo:block>
						</fo:block-container>
					</xsl:if>


					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>


					<xsl:if test="$SalesInv/currentSalesCreditPoints">
						<fo:block-container width="100%"  margin-top="5mm">
							<fo:block xsl:use-attribute-sets="cell-big" text-align="center" font-weight="bold">
								Ihr neuer Punktestand:&#160;<xsl:value-of select="$SalesInv/currentSalesCreditPoints" />
							</fo:block>
						</fo:block-container>
					</xsl:if>
	



					<fo:block-container width="100%">



						<xsl:choose>
							<!-- TSE INSTALLIERT -->
							<xsl:when test="$SalesInv/TseData/tseCode != '' and $SalesInv/TseData/tseCode != '-1'">
								<xsl:choose>
									<!-- TSE OK -->
									<xsl:when test="$SalesInv/TseData/tseCode = '0'">
										<fo:block xsl:use-attribute-sets="content-separator" margin-top="4mm"></fo:block>
										<fo:table border-collapse="separate" table-layout="fixed" border="1" width="100%">
											<fo:table-column column-width="40%"></fo:table-column>
											<fo:table-column column-width="60%"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Transaktion:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:variable name="tokens">
																<xsl:call-template name="tokenize">
																<xsl:with-param name="input" select="$SalesInv/TseData/tseTransaction" />
															</xsl:call-template>
														</xsl:variable>
														<xsl:for-each select="exsl:node-set($tokens)/token">
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																<xsl:value-of select="text" />
															</fo:block>
														</xsl:for-each>
													</fo:table-cell>
												</fo:table-row>
												<!-- <fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Erstbestellung:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/TseFirstOrderTs" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row> -->
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Start:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/TseData/TseStartTs" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Stop:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/TseData/TseStopTs" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Seriennummer:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:variable name="tokens">
															<xsl:call-template name="tokenize">
																<xsl:with-param name="input" select="$SalesInv/TseData/tseSerial" />
															</xsl:call-template>
														</xsl:variable>
														<xsl:for-each select="exsl:node-set($tokens)/token">
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																<xsl:value-of select="text" />
															</fo:block>
														</xsl:for-each>
													</fo:table-cell>
												</fo:table-row>
												<!-- <fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Signatur:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:variable name="tokens">
															<xsl:call-template name="tokenize">
																<xsl:with-param name="input" select="$SalesInv/tseSignature" />
															</xsl:call-template>
														</xsl:variable>
														<xsl:for-each select="exsl:node-set($tokens)/token">
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																<xsl:value-of select="text" />
															</fo:block>
														</xsl:for-each>
													</fo:table-cell>
													
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Zeitformat:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/tseTimeFormat" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-Hashalgorhythmus:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/tseHashAlg" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															TSE-PublicKey:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:variable name="tokens">
															<xsl:call-template name="tokenize">
																<xsl:with-param name="input" select="$SalesInv/tsePublicKey" />
															</xsl:call-template>
														</xsl:variable>
														<xsl:for-each select="exsl:node-set($tokens)/token">
															<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
																<xsl:value-of select="text" />
															</fo:block>
														</xsl:for-each>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="left">
															Kassen-ID:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block xsl:use-attribute-sets="cell-default" text-align="right">
															<xsl:value-of select="$SalesInv/tsePosId" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row> -->
											</fo:table-body>
										</fo:table>
									</xsl:when>
									<!-- TSE Nicht in Betrieb -->
									<xsl:when test="$SalesInv/TseData/tseCode = '-2'">
										<fo:block xsl:use-attribute-sets="content-separator" margin-top="4mm"></fo:block>
										<fo:block text-align="center" display-align="center" width="70mm" font-size="20" margin-top="10mm" margin-bottom="mm">
											Sicherheitseinrichtung ausgefallen!
										</fo:block>
									</xsl:when>
									<!-- TSE Ausgefallen -->
									<xsl:when test="$SalesInv/TseData/tseCode = '-3'">
										<fo:block xsl:use-attribute-sets="content-separator" margin-top="4mm"></fo:block>
										<fo:block text-align="center" display-align="center" width="70mm" font-size="20" margin-top="10mm" margin-bottom="mm">
											Sicherheitseinrichtung ausgefallen!
										</fo:block>
									</xsl:when>
									<!-- TSE Ausgefallen -->
									<xsl:when test="$SalesInv/TseData/tseCode = '-4'">
										<fo:block xsl:use-attribute-sets="content-separator" margin-top="4mm"></fo:block>
										<fo:block text-align="center" display-align="center" width="70mm" font-size="20" margin-top="10mm" margin-bottom="mm">
											Sicherheitseinrichtung ausgefallen!
										</fo:block>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<!-- RKSV AUSGEFALLEN -->
							<xsl:when test="$SalesInv/isSignatureValid = 'false'">
								<fo:block xsl:use-attribute-sets="content-separator" margin-top="4mm"></fo:block>
								<fo:block text-align="center" display-align="center" width="70mm" font-size="20" margin-top="10mm" margin-bottom="mm">
									Sicherheitseinrichtung ausgefallen!
								</fo:block>
							</xsl:when>
							<!-- WENN EINE QR URL EXISTIERT DANN DRUCKEN -->
							<xsl:otherwise>
								<fo:block text-align="center">
									<fo:external-graphic content-width="40mm" content-height="100%" width="40mm" scaling="uniform">
										<xsl:attribute name="src"><xsl:value-of select="$SalesInv/qrUrl" /></xsl:attribute>
									</fo:external-graphic>
								</fo:block>
							</xsl:otherwise>
						</xsl:choose>
					</fo:block-container>


					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="content-separator">
						</fo:block>
					</fo:block-container>
											



					<fo:block-container width="100%">
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$SalesInv/buNoteTxt" />
						</fo:block>
					</fo:block-container>


					<fo:block-container width="100%" margin-top="5mm">
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							<xsl:value-of select="$SalesInv/buWeb" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							USt.-IdNr:<xsl:value-of select="$SalesInv/buEuTaxId" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
							Steuernummer:<xsl:value-of select="$SalesInv/buTaxId" />
						</fo:block>

						<xsl:if test="$SalesInv/buBankNm != ''">
							<fo:block-container width="100%"  margin-top="0mm">
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									Bankname:<xsl:value-of select="$SalesInv/buBankNm" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									IBAN:<xsl:value-of select="$SalesInv/buIban" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
									BIC:<xsl:value-of select="$SalesInv/buBic" />
								</fo:block>
							</fo:block-container>
						</xsl:if>

					</fo:block-container>





					<!-- KUNDENBELEG -->
					<xsl:if test="$SalesInv/EcashNote/EcashNoteLine">
						<fo:block-container width="100%">
							<fo:block xsl:use-attribute-sets="content-separator">
							</fo:block>
						</fo:block-container>
						<fo:block-container width="100%">
							<fo:block width="100%">
								<xsl:for-each select="$SalesInv/EcashNote/EcashNoteLine">
									<xsl:choose>
										<xsl:when test="lineDecoration = 'L'">
											<!-- linksbündig -->
											<fo:block width="100%" xsl:use-attribute-sets="cell-default" text-align="center" border="1px solid">
												<xsl:value-of select="lineTxt"/>
											</fo:block>

										</xsl:when>

										<xsl:when test="lineDecoration = 'R'">
											<!-- rechtsbündig -->
											<fo:block xsl:use-attribute-sets="cell-default" text-align="center">
												<xsl:value-of select="lineTxt" />
											</fo:block>

										</xsl:when>

										<xsl:when test="lineDecoration = 'Z'">
											<!-- zentriert -->
											<fo:block xsl:use-attribute-sets="cell-default"
												text-align="center">
												<xsl:value-of select="lineTxt" />
											</fo:block>

										</xsl:when>

										<xsl:when test="lineDecoration = 'ZF'">
											<!-- zentriert -->
											<fo:block xsl:use-attribute-sets="text-bold"
												text-align="center">
												<xsl:value-of select="lineTxt" />
											</fo:block>

										</xsl:when>

										<xsl:when test="lineDecoration = 'F'">
											<!-- bold -->
											<fo:block xsl:use-attribute-sets="text-bold"
												text-align="center">
												<xsl:value-of select="lineTxt" />
											</fo:block>

										</xsl:when>


										<xsl:otherwise>

											<fo:block xsl:use-attribute-sets="cell-default"
												text-align="center">
												<xsl:choose>
													<xsl:when test="lineTxt">
														<xsl:value-of select="lineTxt" />
													</xsl:when>
													<xsl:otherwise>
														&#160;
													</xsl:otherwise>
												</xsl:choose>
											</fo:block>

										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</fo:block>
						</fo:block-container>
					</xsl:if>
					<fo:block-container border="1px solid #edeff2">
						<fo:block margin-top="5mm"/>
					</fo:block-container>
						
					<fo:block id="LastPage" margin-top="5mm"/>
	</xsl:template>

</xsl:stylesheet>