<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell2-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


<xsl:template name="sumpurchaseprice">
  <!-- Knoten auf eine leere Knotenmenge initialisieren -->
  <xsl:param name="stocknotepositions" select="/"/>
 
  <xsl:param name="itemSupplierList" select="/"/>
  <xsl:param name="inList" select="0"/>
   
  <xsl:param name="result" select="0"/>
  <xsl:choose>
    <xsl:when test="not($stocknotepositions)">
      <xsl:value-of select="$result"/>
    </xsl:when>
     
    <xsl:otherwise>
      <!-- Template aufrufen oder anwenden, das den Wert des Knotens ermittelt, es sei denn,der Knoten ist der tatsächliche Wert, der summiert werden soll -->
    
    <xsl:variable name="itemCd" select="$stocknotepositions[1]/articleNo"/>
      <xsl:variable name="value">
       <xsl:choose>
         <xsl:when test="$inList=1">
            <xsl:choose>
               <xsl:when test="$itemSupplierList[item_cd=$itemCd]">
                 <xsl:value-of select="$stocknotepositions[1]/itemPurchaseTotalPrice" />
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="0" />
               </xsl:otherwise>
            </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
         <xsl:choose>
               <xsl:when test="not($itemSupplierList[item_cd=$itemCd])">
                 <xsl:value-of select="$stocknotepositions[1]/itemPurchaseTotalPrice" />
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="0" />
               </xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
       </xsl:choose>
       
       
      </xsl:variable>
      <!-- Rekursion, um den Rest zu summieren -->
      <xsl:call-template name="sumpurchaseprice">
        <xsl:with-param name="stocknotepositions" select="$stocknotepositions[position( ) != 1]"/>
        <xsl:with-param name="itemSupplierList" select="$itemSupplierList"/>
          <xsl:with-param name="inList" select="$inList"/>
        
        <xsl:with-param name="result" select="$result + $value"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="sumpurchasepriceBatcher">
  <xsl:param name="stocknotepositions" select="/"/>
 
  <xsl:param name="itemSupplierList" select="/"/>
  <xsl:param name="inList" select="0"/>
   
  <xsl:param name="result" select="0"/>
  <xsl:param name="batch-size" select="500"/>
  <xsl:choose>
    <xsl:when test="not($stocknotepositions)">
      <xsl:value-of select="$result"/>
    </xsl:when>
     
    <xsl:otherwise>
      <xsl:variable name="batchSum">
        <xsl:call-template name="sumpurchaseprice">
        <xsl:with-param name="stocknotepositions" select="$stocknotepositions[position( ) &lt; $batch-size]"/>
        <xsl:with-param name="itemSupplierList" select="$itemSupplierList"/>
          <xsl:with-param name="inList" select="$inList"/>
         <xsl:with-param name="result" select="0"/>
 
        </xsl:call-template>
      </xsl:variable>
      <xsl:call-template name="sumpurchasepriceBatcher">
        <xsl:with-param name="stocknotepositions" select="$stocknotepositions[position( ) &gt;= $batch-size]"/>
        <xsl:with-param name="itemSupplierList" select="$itemSupplierList"/>
         <xsl:with-param name="inList" select="$inList"/>
        <xsl:with-param name="result" select="$result + $batchSum"/>
        <xsl:with-param name="batch-size" select="$batch-size"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="currency">
		<xsl:param name="code" />

		<xsl:choose>
			<xsl:when test="$code = 'EUR'">
				€
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>





	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title">
						
						<xsl:value-of select="report/stock_note_detail/stockNote/name" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_nm_2" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_street" />
						,
						<xsl:value-of select="report/businessunits/row/bu_postal_cd" />
						&#160;
						<xsl:value-of select="report/businessunits/row/bu_city" />
						,
						<xsl:value-of select="report/businessunits/row/bu_country_cd" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/businessunit_nm" />
						, Kostenstelle
						<xsl:value-of select="report/businessunits/row/bu_nm_1" />
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											
						<xsl:value-of select="report/stock_note_detail/stockNote/name" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">


					<fo:table table-layout="fixed" width="170mm">
						<fo:table-column column-width="32mm" />
						<fo:table-column column-width="3mm" />
						<fo:table-column column-width="135mm" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
									<xsl:value-of select="report/stock_note_detail/stockNote/date" />
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Lager
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/stockNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Belegnummer
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/noteId" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							

							<xsl:if
								test="report/stock_note_detail/stockNote/dlnType = 2">
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Ext. Belegnummer
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/purchaseNoteId" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Lieferant
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/supplierNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
							<xsl:if
								test="report/stock_note_detail/stockNote/dlnType = 1">
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Kunde
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/custNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
							<xsl:if
								test="report/stock_note_detail/stockNote/dlnType = 3">
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Mitarbeiter
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/employeeNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Korrekturart
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
									<xsl:variable name="selCorrectionType"
											select="report/stock_note_detail/stockNote/stockRevisionTypeNo"/>
									
											<xsl:if test="$selCorrectionType != ''">
												
													<xsl:value-of select="report/stockRevisionTypes/row[id=$selCorrectionType]/stock_revision_type_nm" />
													
											</xsl:if>
						
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
							<xsl:if
								test="report/stock_note_detail/stockNote/dlnType = 5">
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Ziellager
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/sinkStockNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Kommentar
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/comment" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Verwendungszweck
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/usage" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
								<xsl:if
								test="report/stock_note_detail/stockNote/dlnType = 6">
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Inventurbezeichnung
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/inventoryName" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Mitarbeiter
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/employeeNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Status
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:value-of select="report/stock_note_detail/stockNote/inventoryProcessStateNm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							</xsl:if>
							
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2-bold">
									<fo:block>
										Positionen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										&#160;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>
					
	
	<xsl:for-each select="report/suppliers/row">		
	     		<xsl:variable name="supplierNo"  select="contact_no"/>
                <fo:block>
										<xsl:value-of select="contact_nm"></xsl:value-of>
									</fo:block>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%" />
						<fo:table-column column-width="30%" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
  
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
										<fo:table-column column-width="30%" />
											<fo:table-column column-width="15%" />
											
											
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="10%" />
											</xsl:when>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2 and report/stock_note_detail/stockNote/inventoryProcessState != 4">
											
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
												<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-column column-width="55%" />
														</xsl:otherwise>
											</xsl:choose>
											
											
											</xsl:when>
											<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 3">
													<fo:table-column column-width="19%" />
													<fo:table-column column-width="18%" />
													<fo:table-column column-width="18%" />
												</xsl:when>
												<xsl:otherwise>
													<fo:table-column column-width="55%" />
												</xsl:otherwise>
											</xsl:choose>
											<!-- <fo:table-column column-width="15mm" />
											<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
											<fo:table-column column-width="15mm" />
											<fo:table-column column-width="15mm" />
											</xsl:if> -->
											
											<!-- <fo:table-column column-width="20mm" />
											--></xsl:otherwise>
											</xsl:choose>
											

											<fo:table-header>
												<fo:table-row>
													
													

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Artikelname</fo:block>
													</fo:table-cell>
													
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Art.-Nr.</fo:block>
													</fo:table-cell>

<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
									<!-- 	<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EAN</fo:block>
													</fo:table-cell>-->
										<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
											
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Soll-Bestand</fo:block>
													</fo:table-cell>
													
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK</fo:block>
													</fo:table-cell>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK-Wert</fo:block>
													</fo:table-cell>
													
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Gezählt</fo:block>
													</fo:table-cell>
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Differenz</fo:block>
													</fo:table-cell>
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Gezählt</fo:block>
													</fo:table-cell>
														</xsl:otherwise>
											</xsl:choose>
										
										
											
											</xsl:when>
											
											<xsl:otherwise>
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Anzahl</fo:block>
													</fo:table-cell>
										<!-- 	<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Betrag</fo:block>
													</fo:table-cell> -->
													
													<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
												<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK</fo:block>
													</fo:table-cell>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK-Wert</fo:block>
													</fo:table-cell>
											</xsl:if>
													
													</xsl:otherwise>
													
													
											
											
											
											</xsl:choose>
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
											
											<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Grund für Differenz</fo:block>
													</fo:table-cell>
													
													</xsl:if>

													
												</fo:table-row>
											</fo:table-header>
											
											<fo:table-body>
											<xsl:choose>
													<xsl:when test="/report/stock_note_detail/stockNote/poscount != 0">
												<xsl:variable name="itemCd" select="articleNo"/>

												<xsl:for-each
													select="/report/stock_note_detail/stockNote/positions/row">
													
													<xsl:variable name="itemCd" select="articleNo"/>
													
													<xsl:if test="/report/itemSuppliers/row[supplier_no=$supplierNo][item_cd=$itemCd]" >
												 
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row >
														

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of disable-output-escaping="yes" select="articleNm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="articleNo" />
															</fo:block>
														</fo:table-cell>
														
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
										<!--<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="articlEan" />
															</fo:block>
														</fo:table-cell>-->
										<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
											
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="currentCalcAmount" />
																
															</fo:block>
														</fo:table-cell>
														
															
													
													<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchasePrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchaseTotalPrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
													
													
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="inventoryProcessAmount" />
																
															</fo:block>
														</fo:table-cell>
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="amount" />
																
															</fo:block>
														</fo:table-cell>
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="inventoryProcessAmount" />
																
															</fo:block>
														</fo:table-cell>
														</xsl:otherwise>
											</xsl:choose>
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
											
											<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
														<xsl:variable name="selCorrectionType"
											                                     select="stockRevisionTypeNo"/>
									
										            	<xsl:if test="$selCorrectionType != ''">
												
													           <xsl:value-of select="/report/stockRevisionTypes/row[id=$selCorrectionType]/stock_revision_type_nm" />
													
											           </xsl:if>
													</fo:block>
													</fo:table-cell>
													
												
													
													</xsl:if>
											
											</xsl:when>
											<xsl:otherwise>
										<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="amount" />
																
															</fo:block>
														</fo:table-cell>
                                                 <xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
													<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchasePrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchaseTotalPrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
											</xsl:if>

													<!-- 	<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="price" />
																
															</fo:block>
														</fo:table-cell>--></xsl:otherwise>
											</xsl:choose>
													
														
														
														

														
													</fo:table-row>
													
													</xsl:if>
												</xsl:for-each>
												
												

							   <xsl:variable name="sumValue">					
												<xsl:call-template name="sumpurchasepriceBatcher">
        <xsl:with-param name="stocknotepositions" select="/report/stock_note_detail/stockNote/positions/row"/>
        <xsl:with-param name="itemSupplierList" select="/report/itemSuppliers/row[supplier_no=$supplierNo]"/>
          <xsl:with-param name="inList" select="1"/>
        <xsl:with-param name="result" select="0"/>
        
      </xsl:call-template>
      </xsl:variable>
												
													<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 6">
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
													<fo:table-row>
														
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
													
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>Summe
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																	<xsl:value-of select='format-number($sumValue, "###.##0,00", "money")' />
																	
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																	
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															
															</fo:block>
														</fo:table-cell>
														</xsl:if>
															</fo:table-row>
													</xsl:if>
													</xsl:if>
														<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
													
													<fo:table-row>
														
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
													
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>Summe
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																<xsl:value-of select='format-number($sumValue, "###.##0,00", "money")' />
															</fo:block>
														</fo:table-cell>
											
														
														</fo:table-row>
													
													 </xsl:if>
												</xsl:when>
													<xsl:otherwise>
													<fo:table-row>
														<fo:table-cell number-columns-spanned="3" text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																&#160;
															</fo:block>
														</fo:table-cell>
														</fo:table-row>
													</xsl:otherwise>
												</xsl:choose>
												
												

											</fo:table-body>
											
										</fo:table>
										
									
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							

						</fo:table-body>
				    	</fo:table>
	               </xsl:for-each>
               <fo:block>
										Ohne Lieferant
									</fo:block>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%" />
						<fo:table-column column-width="30%" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
  
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
										<fo:table-column column-width="30%" />
											<fo:table-column column-width="15%" />
											
											
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="9%" />
												<fo:table-column column-width="10%" />
											</xsl:when>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2 and report/stock_note_detail/stockNote/inventoryProcessState != 4">
											
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
												<fo:table-column column-width="11%" />
											<fo:table-column column-width="11%" />
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-column column-width="55%" />
														</xsl:otherwise>
											</xsl:choose>
											
											
											</xsl:when>
											<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 3">
													<fo:table-column column-width="19%" />
													<fo:table-column column-width="18%" />
													<fo:table-column column-width="18%" />
												</xsl:when>
												<xsl:otherwise>
													<fo:table-column column-width="55%" />
												</xsl:otherwise>
											</xsl:choose>
											<!-- <fo:table-column column-width="15mm" />
											<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
											<fo:table-column column-width="15mm" />
											<fo:table-column column-width="15mm" />
											</xsl:if> -->
											
											<!-- <fo:table-column column-width="20mm" />
											--></xsl:otherwise>
											</xsl:choose>
											

											<fo:table-header>
												<fo:table-row>
													
													

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Artikelname</fo:block>
													</fo:table-cell>
													
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Art.-Nr.</fo:block>
													</fo:table-cell>

<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
									<!-- 	<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EAN</fo:block>
													</fo:table-cell>-->
										<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
											
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Soll-Bestand</fo:block>
													</fo:table-cell>
													
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK</fo:block>
													</fo:table-cell>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK-Wert</fo:block>
													</fo:table-cell>
													
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Gezählt</fo:block>
													</fo:table-cell>
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Differenz</fo:block>
													</fo:table-cell>
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Gezählt</fo:block>
													</fo:table-cell>
														</xsl:otherwise>
											</xsl:choose>
										
										
											
											</xsl:when>
											
											<xsl:otherwise>
											<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Anzahl</fo:block>
													</fo:table-cell>
										<!-- 	<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Betrag</fo:block>
													</fo:table-cell> -->
													
													<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
												<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK</fo:block>
													</fo:table-cell>
														<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK-Wert</fo:block>
													</fo:table-cell>
											</xsl:if>
													
													</xsl:otherwise>
													
													
											
											
											
											</xsl:choose>
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
											
											<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Grund für Differenz</fo:block>
													</fo:table-cell>
													
													</xsl:if>

													
												</fo:table-row>
											</fo:table-header>
											
											<fo:table-body>
											<xsl:choose>
													<xsl:when test="/report/stock_note_detail/stockNote/poscount != 0">
													

												<xsl:for-each
													select="/report/stock_note_detail/stockNote/positions/row">
													
													<xsl:variable name="itemCd" select="articleNo"/>
													
													<xsl:if test="not(/report/itemSuppliers/row[item_cd=$itemCd])" >
												 
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row >
														

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of disable-output-escaping="yes" select="articleNm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="articleNo" />
															</fo:block>
														</fo:table-cell>
														
											<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/dlnType = 6">
										<!--<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="articlEan" />
															</fo:block>
														</fo:table-cell>-->
										<xsl:choose>
											<xsl:when test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
											
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="currentCalcAmount" />
																
															</fo:block>
														</fo:table-cell>
														
															
													
													<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchasePrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchaseTotalPrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
													
													
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="inventoryProcessAmount" />
																
															</fo:block>
														</fo:table-cell>
											<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="amount" />
																
															</fo:block>
														</fo:table-cell>
														
														</xsl:when>
														<xsl:otherwise>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="inventoryProcessAmount" />
																
															</fo:block>
														</fo:table-cell>
														</xsl:otherwise>
											</xsl:choose>
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
											
											<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
														<xsl:variable name="selCorrectionType"
											                                     select="stockRevisionTypeNo"/>
									
										            	<xsl:if test="$selCorrectionType != ''">
												
													           <xsl:value-of select="/report/stockRevisionTypes/row[id=$selCorrectionType]/stock_revision_type_nm" />
													
											           </xsl:if>
													</fo:block>
													</fo:table-cell>
													
												
													
													</xsl:if>
											
											</xsl:when>
											<xsl:otherwise>
										<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="amount" />
																
															</fo:block>
														</fo:table-cell>
                                                 <xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
													<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchasePrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select='format-number(itemPurchaseTotalPrice , "###.##0,00", "money")' />
																
															</fo:block>
														</fo:table-cell>
											</xsl:if>

													<!-- 	<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>

																	<xsl:value-of select="price" />
																
															</fo:block>
														</fo:table-cell>--></xsl:otherwise>
											</xsl:choose>
													
														
														
														

														
													</fo:table-row>
													
													</xsl:if>
												</xsl:for-each>
												
												

							   <xsl:variable name="sumValue">					
												<xsl:call-template name="sumpurchasepriceBatcher">
        <xsl:with-param name="stocknotepositions" select="/report/stock_note_detail/stockNote/positions/row"/>
        <xsl:with-param name="itemSupplierList" select="/report/itemSuppliers/row"/>
          <xsl:with-param name="inList" select="0"/>
        <xsl:with-param name="result" select="0"/>
      </xsl:call-template>
      </xsl:variable>
												
													<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 6">
													<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState > 2">
													<fo:table-row>
														
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
													
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>Summe
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																	<xsl:value-of select='format-number($sumValue, "###.##0,00", "money")' />
																	
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																	
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<xsl:if test="/report/stock_note_detail/stockNote/inventoryProcessState = 4">
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															
															</fo:block>
														</fo:table-cell>
														</xsl:if>
															</fo:table-row>
													</xsl:if>
													</xsl:if>
														<xsl:if test="/report/stock_note_detail/stockNote/dlnType = 3">
													
													<fo:table-row>
														
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
													
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>Summe
															</fo:block>
														</fo:table-cell>
															<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-bold">
															<fo:block>
																<xsl:value-of select='format-number($sumValue, "###.##0,00", "money")' />
															</fo:block>
														</fo:table-cell>
											
														
														</fo:table-row>
													
													 </xsl:if>
													 
												</xsl:when>
													<xsl:otherwise>
													<fo:table-row>
														<fo:table-cell number-columns-spanned="3" text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																&#160;
															</fo:block>
														</fo:table-cell>
														</fo:table-row>
													</xsl:otherwise>
												</xsl:choose>
												
												

											</fo:table-body>
											
										</fo:table>
										
									
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						

						</fo:table-body>
				    	</fo:table>
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>