<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	 xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />



	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


<xsl:template name="printemployeedata">
<xsl:param name="employeeNo" />
<xsl:param name="employeeNm" />
<xsl:param name="employeeContractBeginTs" />
<xsl:param name="buName" />
<xsl:param name="paramData" />
<xsl:param name="itemGroupData" />
<xsl:param name="itemCategoryData" />
<xsl:param name="itemTotalData" /> 
<xsl:param name="newCustomerList" />
<xsl:param name="crsWorkStatistics" /> 



	<!-- Loop through the columns in order -->
				
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				
				<xsl:choose>
				
				  <xsl:when test="$column='saloon_no'"><xsl:value-of select="$buName" /></xsl:when>
				
					<xsl:when test="$column='r_dt'">
				    	<xsl:call-template name="formatdate"><xsl:with-param name="datestr"	select="$paramData/DATE" /></xsl:call-template></xsl:when>
				    <xsl:when test="$column='r_employee_no'"><xsl:value-of select="$employeeNo" /></xsl:when>
					
					<xsl:when test="$column='r_employee_nm'"><xsl:text>"</xsl:text><xsl:value-of select="$employeeNm" /><xsl:text>"</xsl:text></xsl:when>
					
					
					<xsl:when test="starts-with($column,'emRepGroup_')">
					
					    <xsl:variable name="itemCategoryGroupCd">
					        <xsl:value-of select="substring-after($column,'emRepGroup_')" />
					    </xsl:variable>
					
			    		<xsl:variable name="itemCategoryCd">
				        	<xsl:value-of select="substring-before($itemCategoryGroupCd,'_')" />
					    </xsl:variable>
					    
					    <xsl:variable name="itemGroupCd">
					       <xsl:value-of select="substring-after($itemCategoryGroupCd,'_')" />
					    </xsl:variable>	 
			           
			            <xsl:value-of select="format-number($itemGroupData/row[r_employee_no=$employeeNo][item_report_category_cd=$itemCategoryCd][item_report_group_cd=$itemGroupCd]/amountitemsperreportgroup_service, '0,00', 'money')" />
					</xsl:when>
					
					 
					<xsl:when test="starts-with($column,'emRepCategory_ges')">
					
					   <xsl:variable name="itemCategoryCd">
					       <xsl:value-of select="substring-after($column,'emRepCategory_ges_')" />
					   </xsl:variable>
									
			            <xsl:value-of select="format-number($itemCategoryData/row[r_employee_no=$employeeNo][item_report_category_cd=$itemCategoryCd]/r_total_services, '0,00', 'money')" />
					</xsl:when>
					
									
									
					<xsl:when test="$column='d_vk'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/r_vk_g1, '0,00', 'money')" />
					</xsl:when>
					
					<xsl:when test="$column='h_vk'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/r_vk_g2, '0,00', 'money')" />
					</xsl:when>
				
					<xsl:when test="$column='k_vk'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/r_vk_g3, '0,00', 'money')" />
					</xsl:when>
					
					<xsl:when test="$column='total_vk_stk'">
				        <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/amount_products, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='d_customer'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/d_customer_amount, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='h_customer'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/h_customer_amount, '0,00', 'amount')" />
					</xsl:when>
				
					<xsl:when test="$column='k_customer'">
					    <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/k_customer_amount, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='d_new_customer'">
					    <xsl:value-of select="format-number($newCustomerList/row[r_employee_no=$employeeNo]/d_new_customer, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='h_new_customer'">
					    <xsl:value-of select="format-number($newCustomerList/row[r_employee_no=$employeeNo]/h_new_customer, '0,00', 'amount')" />
					</xsl:when>
				
					<xsl:when test="$column='k_new_customer'">
					    <xsl:value-of select="format-number($newCustomerList/row[r_employee_no=$employeeNo]/k_new_customer, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='total_vk_stk'">
				        <xsl:value-of select="format-number($itemTotalData/row[r_employee_no=$employeeNo]/amount_products, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='r_available'">
					    <xsl:value-of select="format-number($crsWorkStatistics/employee-statistic[@employee-no=$employeeNo]/@worktime-in-hour, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='r_ill'">
					    <xsl:value-of select="format-number($crsWorkStatistics/employee-statistic[@employee-no=$employeeNo]/@illtime-in-hour, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='r_holiday'">
					    <xsl:value-of select="format-number($crsWorkStatistics/employee-statistic[@employee-no=$employeeNo]/@holidaytime-in-hour, '0,00', 'amount')" />
					</xsl:when>
				
					<xsl:when test="$column='r_other'">
					    <xsl:value-of select="format-number($crsWorkStatistics/employee-statistic[@employee-no=$employeeNo]/@othertime-in-hour, '0,00', 'amount')" />
					</xsl:when>
					
					<xsl:when test="$column='r_seminar'">
					    <xsl:value-of select="format-number(0, '0,00', 'amount')" />
					</xsl:when>
					<xsl:when test="$column='r_employee_contract_begin'">
				    	<xsl:call-template name="formatdate"><xsl:with-param name="datestr"	select="$employeeContractBeginTs" /></xsl:call-template>
				    	</xsl:when>
				 
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>


</xsl:template>


	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
	    <column>saloon_no<desc>Salon-Nr</desc></column>
        <column>r_employee_no<desc>Personalnummer</desc></column>
		<column>r_dt<desc>Monat</desc></column>
		<column>r_available<desc>Anwesend</desc></column>
		<column>r_ill<desc>KK</desc></column>
		<column>r_holiday<desc>Urlaub</desc></column>
		<column>r_other<desc>Sonderurlaub</desc></column>
		<column>r_seminar<desc>Seminar</desc></column>
		<column>d_customer<desc>Dkunden</desc></column>
		<column>d_new_customer<desc>Dneukunden</desc></column>
		<column>emRepGroup_damen_waschenlegen<desc>Dwaschenlegen</desc></column>
		<column>emRepGroup_damen_waschenfoenen<desc>Dwaschenfoenen</desc></column>
		<column>emRepGroup_damen_dauerwelle<desc>Ddauerwelle</desc></column>
		<column>emRepGroup_damen_faerben<desc>Dfaerben</desc></column>
		<column>emRepGroup_damen_straehnen<desc>Dstraehnen</desc></column>
		<column>emRepGroup_damen_toenen<desc>Dtoenen</desc></column>
		<column>emRepGroup_damen_haarschnitt<desc>Dhaarschnitt</desc></column>
		<column>emRepGroup_damen_haarpflege<desc>Dhaarpflege</desc></column>
		<column>emRepGroup_damen_kopfhaut<desc>Dkopfhaut</desc></column>
		
		<column>emRepGroup_kosmetik_augen<desc>Kaugen</desc></column>
		<column>emRepGroup_kosmetik_hand<desc>Khand</desc></column>
		<column>emRepGroup_kosmetik_makeup<desc>Kmakeup</desc></column>
		
		<column>h_customer<desc>Hkunden</desc></column>
		<column>h_new_customer<desc>Hneukunden</desc></column>
		<column>emRepGroup_herren_waschenfoenen<desc>Hwaschenfoenen</desc></column>
		<column>emRepGroup_herren_dauerwelle<desc>Hdauerwelle</desc></column>
		<column>emRepGroup_herren_faerben<desc>Hfaerben</desc></column>
		<column>emRepGroup_herren_haarschnitt1<desc>Hhaarschnitt1</desc></column>
		<column>emRepGroup_herren_haarpflege<desc>Hhaarpflege</desc></column>
		<column>emRepGroup_herren_kopfhaut<desc>Hkopfhaut</desc></column>
		
		<column>k_customer<desc>Kkunden</desc></column>
		<column>k_new_customer<desc>Kneukunden</desc></column>
		<column>emRepGroup_kinder_waschenfoenen<desc>Kwaschenfoenen</desc></column>
		<column>emRepGroup_kinder_dauerwelle<desc>Kdauerwelle</desc></column>
		<column>emRepGroup_kinder_faerben<desc>Kfaerben</desc></column>
		<column>emRepGroup_kinder_haarschnitt1<desc>Khaarschnitt1</desc></column>
		<column>emRepGroup_kinder_haarpflege<desc>Khaarpflege</desc></column>
		<column>emRepGroup_kinder_kopfhaut<desc>Kkopfhaut</desc></column>
		
		<column>emRepCategory_ges_damen<desc>Udamen</desc></column>
		<column>emRepCategory_ges_herren<desc>Uherren</desc></column>
		<column>emRepCategory_ges_kinder<desc>Ukinder</desc></column>
		<column>emRepCategory_ges_kosmetik<desc>Ukosmetik</desc></column>
		<column>emRepCategory_ges_laser<desc>Ulaser</desc></column>
		
		<column>d_vk<desc>Uvkdamen</desc></column>
		<column>h_vk<desc>Uvkherren</desc></column>
		<column>k_vk<desc>Uvkkinder</desc></column>
		
		<column>r_employee_nm<desc>FamName</desc></column>
		<column>r_employee_first_nm<desc>Vorname</desc></column>
		<column>r_crinis_no<desc>CrinisNr</desc></column>
		<column>r_employee_contract_begin<desc>Eintritt</desc></column>
		
		<column>total_vk_stk<desc>VkStueck</desc></column>
		
		<column>currency<desc>WaehrungKz</desc></column>
		
	</csv:columns>

	<xsl:template match="/">

		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>

<xsl:variable name="buName" select="/report/businessunits/row/businessunit_nm" />

			<xsl:for-each select="/report/employees/row">
			
			<xsl:variable name="employeeNo" select="employee_no" />
			<xsl:variable name="employeeNm" select="employee_nm" />
			<xsl:variable name="employeeContractBeginTs" select="valid_from" />


			<xsl:call-template name="printemployeedata">
			<xsl:with-param name="employeeNo" select="$employeeNo"></xsl:with-param>
			<xsl:with-param name="employeeNm" select="$employeeNm"></xsl:with-param>
			<xsl:with-param name="employeeContractBeginTs" select="$employeeContractBeginTs"></xsl:with-param>
			<xsl:with-param name="buName" select="$buName"></xsl:with-param>
			<xsl:with-param name="paramData" select="/report/report-params"></xsl:with-param>
			<xsl:with-param name="itemGroupData" select="/report/employeeDlCntPerReportGroup"></xsl:with-param>
			<xsl:with-param name="itemCategoryData" select="/report/employeeDlCntPerCategory"></xsl:with-param>
			<xsl:with-param name="itemTotalData" select="/report/employeeDlCntTotal"></xsl:with-param>
			<xsl:with-param name="newCustomerList" select="/report/newCustomerList"></xsl:with-param>
			<xsl:with-param name="crsWorkStatistics" select="/report/crs_work_statistics/crs-work-statistics"></xsl:with-param>
			
			</xsl:call-template>
		
		</xsl:for-each>
	</xsl:template>

	

</xsl:stylesheet>