<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:csv="csv:csv">


	
<csv:columns>
	<column>i1<desc>satzart</desc>
		</column>
		<column>direction<desc>buchcode</desc>
		</column>
		<column>percent<desc>prozent</desc>
		</column>
		<column>tax_hint<desc>steuercode</desc>
		</column>
		<column>pValue<desc>betrag</desc>
		</column>
		<column>tax_value<desc>steuer</desc>
		</column>
		<column>acct_cd<desc>konto</desc>
		</column>
		<column>contra_acct<desc>gkonto</desc>
		</column>
		
		<column>day_dt<desc>belegdatum</desc>
		</column>
		<column>i3<desc>buchsymbol</desc>
		</column>
		<column>i4<desc>kost</desc>
		</column>
		<column>i5<desc>belegnr</desc>
		</column>
		



	</csv:columns>
	<xsl:template name="printheader2">

	<xsl:for-each select="document('./csvRowCashJournalType2.xsl')/*/csv:columns/*">
		<xsl:value-of select="./desc" />
		<xsl:if test="position() != last()">
			<xsl:value-of select="$delimiter" />
		</xsl:if>
	</xsl:for-each>

</xsl:template>

	<xsl:template name="printbusinessunitdata2">
		<xsl:param name="posCd" />
		<xsl:param name="buNm1" />
		<xsl:param name="property" />
		<xsl:param name="counter" />

		<xsl:variable name="direction" select="$property/direction" />
		<xsl:variable name="netValue" select="$property/net_value" />
		<xsl:variable name="grossValue" select="$property/gross_value" />
		<xsl:variable name="taxHint" select="$property/tax_hint" />


		<!-- Loop through the columns in order -->
		<xsl:for-each select="document('./csvRowCashJournalType2.xsl')/*/csv:columns/*">
			<!-- Extract the column name and value -->
			<xsl:variable name="column" select="./text()" />
			<xsl:variable name="value" select="$property/*[name() = $column]" />
			<xsl:choose>


				<xsl:when test="$column='contra_acct'">
					

                   <xsl:text>"</xsl:text>
                     <xsl:call-template name="findeGegenkonto">
			             	<xsl:with-param name="posCd" select="$posCd"></xsl:with-param>
			       </xsl:call-template>
				   <xsl:text>"</xsl:text>

				</xsl:when>

				<xsl:when test="$column='i4'">
				  <xsl:text>"</xsl:text>
                     <xsl:call-template name="findeKostenstelle">
			             	<xsl:with-param name="posCd" select="$posCd"></xsl:with-param>
			             	<xsl:with-param name="buNm" select="$buNm1"></xsl:with-param>
			       </xsl:call-template>
				   <xsl:text>"</xsl:text>
				
				
					
				</xsl:when>
				<xsl:when test="$column='pValue'">

					<xsl:choose>
						<xsl:when test="$netValue and $taxHint = '1'">
							<xsl:if test="$direction = '1'">
								<xsl:text>"-"</xsl:text>
							</xsl:if>
							<xsl:value-of select="format-number($netValue, '0,00', 'money')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="$direction = '1'">
								<xsl:text>"-"</xsl:text>
							</xsl:if>
							<xsl:value-of select="format-number($grossValue, '0,00', 'money')" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="$column='tax_value'">

					<xsl:choose>
						<xsl:when test="$netValue and $taxHint = '1'">
							<xsl:if test="$direction = '1'">
								<xsl:text>"-"</xsl:text>
							</xsl:if>
							<xsl:value-of select="format-number($value, '0,00', 'money')" />
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>


				</xsl:when>

				<xsl:when test="$column='direction'">
					<xsl:if test="$direction = '1'">
						<xsl:text>"2"</xsl:text>
					</xsl:if>
					<xsl:if test="$direction = '2'">
						<xsl:text>"1"</xsl:text>
					</xsl:if>

				</xsl:when>

				<xsl:when test="$column='i1'">
					<xsl:text>"0"</xsl:text>

				</xsl:when>
				<xsl:when test="$column='i3'">
					<xsl:text>"KA"</xsl:text>

				</xsl:when>
				<xsl:when test="$column='i5'">
					<xsl:value-of select="$counter" />

				</xsl:when>
				<xsl:when test="$column='day_dt'">
					<xsl:value-of select="$value" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$value" />
				</xsl:otherwise>
			</xsl:choose>


			<!-- Add the delimiter unless we are the last expression -->
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>


	</xsl:template>

</xsl:stylesheet>