<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">

	<xsl:attribute-set name="report-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	
	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>

		<xsl:value-of select="$dd" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$mm" />
		<xsl:value-of select="'.'" />
		<xsl:value-of select="$yyyy" />
		<xsl:text> </xsl:text>
		<xsl:value-of select="$time" />
	</xsl:template>

	<xsl:template name="header">
		<xsl:param name="title" />
		<xsl:param name="businessunit" />
		<xsl:param name="filterRow" />
		<xsl:param name="date" />
		<xsl:param name="period1" />
		<xsl:param name="period2" />
		<xsl:param name="periods1" />
		<xsl:param name="periods2" />
		<xsl:param name="periods3" />
		<xsl:param name="periods4" />
		<xsl:param name="creation" />
		<xsl:param name="viewMode" />
		<xsl:param name="filterRows" />
		



		<fo:table width="100%">
			<fo:table-column column-width="50%"></fo:table-column>
			<fo:table-column column-width="50%"></fo:table-column>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block text-align="left" xsl:use-attribute-sets="report-title2">
							<xsl:value-of select="$title" />
							<xsl:if test="$businessunit != ''">
								:&#160;<xsl:value-of select="$businessunit/bu_nm_1" />
							</xsl:if>
							
						</fo:block>
					</fo:table-cell>

					<fo:table-cell>
						<fo:block text-align="right" font-size="8pt">
							<xsl:if test="$businessunit != ''">
								<xsl:value-of select="$businessunit/bu_street" />,
								<xsl:value-of select="$businessunit/bu_postal_cd" />&#160;
								<xsl:value-of select="$businessunit/bu_city" />,
								<xsl:value-of select="$businessunit/bu_country_cd" />
							</xsl:if>
						</fo:block>
					</fo:table-cell>


				</fo:table-row>
				<!-- Creation -->
				<xsl:if test="$creation != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								Erstellt am:&#160;
								<xsl:call-template name="formatdatetime">
									<xsl:with-param name="datetimestr" select="$creation" />
								</xsl:call-template>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<!-- Datum -->
				<xsl:if test="$date != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								Datum:&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$date" />
								</xsl:call-template>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<!-- Zeitraum -->
				<xsl:if test="$period1 != '' and $period2 != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								Zeitraum:&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$period1" />
								</xsl:call-template>
								&#160;-&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$period2" />
								</xsl:call-template>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<!-- Zeiträume -->
				<xsl:if test="$periods1 != '' and $periods2 != '' and $periods3 != '' and $periods4 != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								Zeiträume:&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$periods1" />
								</xsl:call-template>
								&#160;-&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$periods2" />
								</xsl:call-template>
								&#160;und&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$periods3" />
								</xsl:call-template>
								&#160;-&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="$periods4" />
								</xsl:call-template>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>

				<!-- filterRow -->
				<xsl:if test="$viewMode != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								<xsl:value-of select="$viewMode" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>

				<!-- filterRow -->
				<xsl:if test="$filterRow != ''">
					<fo:table-row>
						<fo:table-cell>
							<fo:block text-align="left" font-size="8pt">
								<xsl:value-of select="$filterRow" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>

				<xsl:if test="count(exsl:node-set($filterRows)/filterRow) != 0">
					<xsl:for-each select="exsl:node-set($filterRows)/filterRow">
						<fo:table-row>
							<fo:table-cell>
								<fo:block text-align="left" font-size="8pt">
									<xsl:value-of select="content" />
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:for-each>
				</xsl:if>




			</fo:table-body>
		</fo:table>
	
	</xsl:template>

</xsl:stylesheet>