<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">
					<fo:block-container xsl:use-attribute-sets="title-style">
						<fo:block>Umsätze nach ausführendem Mitarbeiter</fo:block>


						<fo:block>
							Für den Zeitraum
							<xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/DATE" />
							</xsl:call-template>
							-
							<xsl:call-template name="formatdate">
								<xsl:with-param name="datestr"
									select="report/report-params/TODATE" />
							</xsl:call-template>
						</fo:block>


					</fo:block-container>
					<fo:block-container xsl:use-attribute-sets="report-title">


						<fo:block>&#160;&#160;&#160;</fo:block>
						<fo:block>
							Für
							<xsl:value-of select="report/businessunits/row/businessunit_nm" />
							,
							<xsl:value-of select="report/businessunits/row/bu_city" />
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Umsätze nach ausführendem Mitarbeiter
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
											&#160;&#160;&#160;
											<xsl:value-of select="report/businessunits/row/businessunit_nm" />
											,
											<xsl:value-of select="report/businessunits/row/bu_city" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
						<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

					<xsl:variable name="totalProducts"
						select="sum(report/employeeRevenue/row/r_total_products)" />
					<xsl:variable name="totalServices"
						select="sum(report/employeeRevenue/row/r_total_services)" />
					<xsl:variable name="totalCustomers"
						select="sum(report/employeeRevenue/row/r_amountcustomer)" />
					<xsl:variable name="totalRevenue"
						select="sum(report/employeeRevenue/row/r_total)" />
					<xsl:variable name="cntEmployees"
						select="count(report/employeeRevenue/row/r_employee_no)" />
					<fo:table table-layout="fixed" border-collapse="collapse"
						break-after="page" width="100%" margin-top="0cm">
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>

						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						
						<fo:table-header >
							<fo:table-row>
							
							  <fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
										<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Tage</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Profession</fo:block>
								</fo:table-cell> 
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Dienstl.- Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Dienstl.- Gesamt</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Verkauf</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gesamt Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderOuterSum">
									<fo:block>Gesamt-</fo:block>
									<fo:block>Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz pro Tag</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Verkaufs-anteil</fo:block>
								</fo:table-cell>
								
								<!-- <fo:table-cell>
									 <fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Mitarbeiter</fo:block>
									</fo:block-container>
									
								</fo:table-cell>
								
								<fo:table-cell>
									<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)" >
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)" >
										<fo:block xsl:use-attribute-sets="th1Rotated" >Tag</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >DL Dame</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >DL Herren</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >DL Kind</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >DL Gesamt</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Verkauf</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Gesamtumsatz</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Ø pro Tag</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >% Verkaufsanteil</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Gesamt Dame</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Gesamt Herr</fo:block>
									</fo:block-container>
								</fo:table-cell>
									<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Gesamt Kind</fo:block>
									</fo:block-container>
								</fo:table-cell>
								<fo:table-cell>
								<fo:block-container xsl:use-attribute-sets="containerHeader" fox:transform="rotate(-60)">
										<fo:block  xsl:use-attribute-sets="borderRotated"></fo:block>
									</fo:block-container>
									 <fo:block-container xsl:use-attribute-sets="containerHeaderLabel" fox:transform="rotate(-60)">
										<fo:block xsl:use-attribute-sets="th1Rotated" >Profession</fo:block>
									</fo:block-container>
								</fo:table-cell>  -->
								
							
							</fo:table-row>
							</fo:table-header>
							<fo:table-body>
							<xsl:for-each select="report/employeeRevenue/row">
								<fo:table-row >

									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="r_employee_nm" />
										</fo:block>
									</fo:table-cell>
									
									<!-- Arbeitstage -->
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_cnt_dt" />
										</fo:block>
									</fo:table-cell>
									<!-- Profession -->
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_profession_nm" />
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Dame // DL D -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Herr // DL H -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Kind // DL K -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dienstleistung Gesamt / Umsatz DL  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_services, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Verkauf / Umsatz V  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_products, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Dame Gesamt / Umsatz D  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g1, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Herr Gesamt / Umsatz H  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g2, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Umsatz Kinde Gesamt / Umsatz K  -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_g3, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>

									
									
									<!-- Umsatz Gesamt -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
											<xsl:value-of select="format-number(r_total, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									<!-- Ø pro Tag /  Ums. G/Tag -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_day, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									
									
									<!-- %Verkaufsanteil /  Ums.V. / Ums. G % -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>


											<xsl:choose>
												<xsl:when test="r_total!=0">
													<xsl:value-of
														select="format-number((r_total_products div r_total) * 100, '###.##0,00', 'money')" />
													&#160;%

												</xsl:when>
												<xsl:otherwise>
													0,00&#160;%
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									

								</fo:table-row>

							</xsl:for-each>

							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>Summe</fo:block>
								</fo:table-cell>
								<!-- Tag -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="sum(report/employeeRevenue/row/r_cnt_dt)" />
									</fo:block>
								</fo:table-cell>
								<!-- Profession -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g1_services, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g2_services, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g3_services, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen / Umsatz DL -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_services, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf / Umsatz V -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_products, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- Umsatz Dame Gesamt / Umsatz D -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g1, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Herr Gesamt / Umsatz H -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g2, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Kind Gesamt / Umsatz K -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_g3, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								
								</fo:table-cell>
									<!-- Umsatz Gesamt / Umsatz G -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Ø pro Tag/  Ums. G / Tag-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_day, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- % Verkaufsanteil / Ums. V / Ums. G %-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/sumRevenue/row/r_total!=0">

												<xsl:value-of
													select="format-number((report/sumRevenue/row/r_total_products div report/sumRevenue/row/r_total) * 100, '###.##0,00', 'money')" />
												&#160;%
											</xsl:when>
											<xsl:otherwise>
												0&#160;%
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								
								
							
								
								

							</fo:table-row>

							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>&#216;&#160;Mitarbeiter</fo:block>
								</fo:table-cell>
								
								<!-- Tag-->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_cnt_dt) div $cntEmployees, '###.##0,#', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Profession -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g1_services) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g2_services) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistung Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g3_services) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen / Umsatz DL -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_services) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf / Umsatz V -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_products) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Gesamt Damen / Umsatz D -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g1) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Herr Gesamt / Umsatz H -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g2) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Kind Gesamt / Umsatz K -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_g3) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- Umsatz Gesamt / Umsatz G -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								
								<!-- Ø pro Tag/  Ums. G / Tag-->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:variable name="sTotalPerDay">

													<xsl:for-each select="report/employeeRevenue/row">

														<number>
															<xsl:value-of
																select="(round(100*(r_total div r_cnt_dt)) div 100) " />
														</number>
													</xsl:for-each>
												</xsl:variable>

												<xsl:value-of
													select="format-number(round(100*(sum(exsl:node-set($sTotalPerDay)/number) div $cntEmployees)) div 100, '###.##0,00', 'money')" />


												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>


									</fo:block>
								</fo:table-cell>
								
								<!-- % Verkaufsanteil / Ums. V / Ums. G %--> 
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:variable name="sTotalProductPerTotal">

													<xsl:for-each select="report/employeeRevenue/row">

														<xsl:if test="r_total!=0">

															<number>
																<xsl:value-of
																	select="(round(100*(r_total_products div r_total)) div 100) *100" />
															</number>
														</xsl:if>
													</xsl:for-each>
												</xsl:variable>

												<xsl:value-of
													select="format-number(round(100*(sum(exsl:node-set($sTotalProductPerTotal)/number) 
													div $cntEmployees)) div 100, '###.##0,00', 'money')" />
												&#160;%
											</xsl:when>
											<xsl:otherwise>
												0&#160;%
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							
							</fo:table-row>

						</fo:table-body>
					</fo:table>

					<!-- 
					** Zweite Tabelle 

					-->
					
					<fo:table table-layout="fixed" border-collapse="collapse"
						width="100%">
						<fo:table-column column-width="2.50cm"></fo:table-column>
						<fo:table-column column-width="0.70cm"></fo:table-column>
						<fo:table-column column-width="1.60cm"></fo:table-column>

						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>

						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-column ></fo:table-column>
						<fo:table-header>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold-left">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Tage</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Prof.</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Damen</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Herren</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Anzahl Kinder</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Anzahl Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Anzahl pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø DL Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block>Ø DL Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderInnerSum">
									<fo:block># DL Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Dame</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Herr</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz Kind</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="tableHeaderOuterSum">
									<fo:block>Ø Umsatz Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz DL Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ø Umsatz VK Besuche</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							<xsl:for-each select="report/employeeRevenue/row">
								<fo:table-row>
									<!--Mitarbeiter -->
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell-style0">
										<fo:block>
											<xsl:value-of select="r_employee_nm" />
										</fo:block>
									</fo:table-cell>
									<!-- Tage --> 
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_cnt_dt" />
										</fo:block>
									</fo:table-cell>
									<!-- Profession -->
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_profession_nm" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Damen -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup1" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Herren -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup2" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kinder -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="r_amountgoup3" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kunden -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="r_amountcustomer" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Kunden pro Tag -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_cnt_dt!=0">
													<xsl:value-of
														select="format-number( r_amountcustomer div r_cnt_dt, '###.##0,00', 'money')" />

												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g1,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g2,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_g3,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services/Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="format-number( r_services_per_cus,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									<!-- Anzahl Services -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableInnerSum">
										<fo:block>
											<xsl:value-of select="format-number(r_count_services,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Dame -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g1, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Herr -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g2, '###.##0,00', 'money')" />
					
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Kind -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of
												select="format-number(r_total_per_g3, '###.##0,00', 'money')" />
											<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
										</fo:block>
									</fo:table-cell>
									<!-- Umsatz pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="tableOuterSum">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_amountcustomer!=0">
													<xsl:value-of
														select="format-number(r_total div r_amountcustomer , '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</xsl:when>
												<xsl:otherwise>
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Dienstleistungen pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>

											<xsl:choose>
												<xsl:when test="r_amountcustomer!=0">
													<xsl:value-of
														select="format-number(r_total_services div  r_amountcustomer , '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

												</xsl:when>
												<xsl:otherwise>
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
									<!-- Umsatz Verkauf pro Kunde -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:choose>
												<xsl:when test="r_amountcustomer!=0">
													<xsl:value-of
														select="format-number(r_total_products div  r_amountcustomer, '###.##0,00', 'money')" />
													<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</xsl:when>
												<xsl:otherwise>
													0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
												</xsl:otherwise>
											</xsl:choose>

										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:for-each>
							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>Summe</fo:block>
								</fo:table-cell>
								<!-- Tage --> 
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="sum(report/employeeRevenue/row/r_cnt_dt)" />
									</fo:block>
								</fo:table-cell>
								<!-- Profession -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Damen -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/sumRevenue/row/r_amountgoup1" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Herren -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/sumRevenue/row/r_amountgoup2" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kinder -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/sumRevenue/row/r_amountgoup3" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="report/sumRevenue/row/r_amountcustomer" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden pro Tag -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="round(100*(report/sumRevenue/row/r_amountcustomer div report/sumRevenue/row/r_cnt_dt)) div 100" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g1,'###0,0', 'money')"/>
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g2,'###0,0', 'money')"/>
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of select="format-number(report/sumRevenue/row/r_services_per_g3,'###0,0', 'money')"/>
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of  select="format-number(report/sumRevenue/row/r_services_per_cus,'###0,0', 'money')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services -->
								<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(report/sumRevenue/row/r_count_services,'###0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
								<!-- Umsatz pro Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g1, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								<!-- Umsatz pro Herr -->
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g2, '###.##0,00', 'money')" />
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/sumRevenue/row/r_total_per_g3, '###.##0,00', 'money')" />
									</fo:block>
								</fo:table-cell>
									<!-- Umsatz pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/sumRevenue/row/r_amountcustomer!=0">
												<xsl:value-of
													select="format-number(report/sumRevenue/row/r_total div report/sumRevenue/row/r_amountcustomer, '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Dienstleistungen pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$totalCustomers!=0">
												<xsl:value-of
													select="format-number($totalServices div $totalCustomers , '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$totalCustomers!=0">
												<xsl:value-of
													select="format-number($totalProducts div $totalCustomers , '###.##0,00', 'money')" />
												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>

								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th3bold">
									<fo:block>&#216;&#160;Mitarbeiter</fo:block>
								</fo:table-cell>
								<!-- Tage --> 
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_cnt_dt) div $cntEmployees, '###.##0,#', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Profession -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Damen -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_amountgoup1) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Herren -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_amountgoup2) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kinder -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_amountgoup3) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_amountcustomer) div $cntEmployees, '###.##0,##', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Kunden pro Tag -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:variable name="sCustPerDay">

											<xsl:for-each select="report/employeeRevenue/row">

												<number>
													<xsl:value-of
														select="round(100*(r_amountcustomer div r_cnt_dt)) div 100" />
												</number>
											</xsl:for-each>
										</xsl:variable>

										<xsl:value-of
											select="round(100*(sum(exsl:node-set($sCustPerDay)/number) div $cntEmployees)) div 100" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_services_per_g1) div $cntEmployees, '###.##0,0', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_services_per_g2) div $cntEmployees, '###.##0,0', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_services_per_g3) div $cntEmployees, '###.##0,0', 'amount')" />
									</fo:block>
								</fo:table-cell>
								<!-- Anzahl Services/Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:value-of
													select="format-number(sum(report/employeeRevenue/row/r_services_per_cus) div $cntEmployees, '###.##0,0', 'amount')" />


											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>

								</fo:table-cell>
								<!-- Anzahl Services -->
								<fo:table-cell text-align="right"
										xsl:use-attribute-sets="th3bold">
										<fo:block>
											<xsl:value-of select="format-number(sum(report/employeeRevenue/row/r_count_services) div $cntEmployees, '###.##0,0', 'money')" />
										</fo:block>
									</fo:table-cell>
								<!-- Umsatz pro Dame -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_per_g1) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Herr -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_per_g2) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kind -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:value-of
											select="format-number(sum(report/employeeRevenue/row/r_total_per_g3) div $cntEmployees, '###.##0,00', 'money')" />
										<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
									</fo:block>
								</fo:table-cell>
								<!-- Umsatz pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:variable name="sTotalPerCust">
													<xsl:for-each select="report/employeeRevenue/row">
												 	    <number>
															<xsl:value-of
																select="round(100*(r_total div r_amountcustomer)) div 100" />
														</number>
													</xsl:for-each>
												</xsl:variable>

												<xsl:value-of
													select="format-number(round(100*(sum(exsl:node-set($sTotalPerCust)/number) div $cntEmployees)) div 100, '###.##0,00', 'money')" />


												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>

								<!-- Umsatz Dienstleistungen pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>

										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:variable name="sTotalServicePerCust">

													<xsl:for-each select="report/employeeRevenue/row">

														<number>
															<xsl:value-of
																select="round(100*(r_total_services div r_amountcustomer)) div 100" />
														</number>
													</xsl:for-each>
												</xsl:variable>

												<xsl:value-of
													select="format-number(round(100*(sum(exsl:node-set($sTotalServicePerCust)/number) div $cntEmployees)) div 100, '###.##0,00', 'money')" />


												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
								<!-- Umsatz Verkauf pro Kunde -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th3bold">
									<fo:block>
										<xsl:choose>
											<xsl:when test="$cntEmployees!=0">
												<xsl:variable name="sTotalProductPerCust">

													<xsl:for-each select="report/employeeRevenue/row">

														<number>
															<xsl:value-of
																select="round(100*(r_total_products div r_amountcustomer)) div 100" />
														</number>
													</xsl:for-each>
												</xsl:variable>

												<xsl:value-of
													select="format-number(round(100*(sum(exsl:node-set($sTotalProductPerCust)/number) div $cntEmployees)) div 100, '###.##0,00', 'money')" />


												<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:when>
											<xsl:otherwise>
												0,00<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>
