<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="row_underline">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom">0.5pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="valueCell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellTitle">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom">2pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableLastRow">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-top">1.5pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellValue">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>

			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdate2">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdate3">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm" select="'01'">
			
		</xsl:variable>

		<xsl:variable name="dd" select="'01'">
			
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdatedmm">
		<xsl:param name="datestr" />

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,4,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,1,2)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="substring($dd,1,1) = 0">
						<xsl:value-of select="substring($dd,2,1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$mm" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


 <xsl:template name="numberEFormat" >
  <xsl:param name="value" />
 
	<xsl:choose>
		<xsl:when test="not(contains($value,'E'))">
			<xsl:value-of select="$value"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="vExponent" select="substring-after($value,'E')"/>
			<xsl:variable name="vMantissa" select="substring-before($value,'E')"/>
			
			<xsl:variable name="vFactor">
				<xsl:choose>
					<xsl:when test="starts-with($vExponent,'-')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>		
					<xsl:when test="starts-with($vExponent,'+')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>							
					<xsl:otherwise>
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,1) + 1)" />
					</xsl:otherwise>
				</xsl:choose>				   
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($vExponent,'-')">
					<xsl:value-of select="$vMantissa div $vFactor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$vMantissa * $vFactor"/>
				</xsl:otherwise>
			</xsl:choose>
		
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>


	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	
	<csv:columns>
		<column>payment_orig_unformated<desc>Umsatz (ohne Soll/Haben-Kz)</desc>
		</column>
		<column>direction<desc>Soll/Haben-Kennzeichen</desc>
		</column>
		<column>i1<desc>WKZ Umsatz</desc>
		</column>
		<column>i3<desc>Kurs</desc>
		</column><column>i4<desc>Basis-Umsatz</desc>
		</column>
		<column>i5<desc>WKZ Basis-Umsatz</desc>
		</column>
		<column>acct_cd<desc>Konto</desc>
		</column>
		<column>contra_acct<desc>Gegenkonto (ohne BU-Schlüssel)</desc>
		</column>
		<column>tax_hint<desc>BU-Schlüssel</desc>
		</column>
		<column>day_dt<desc>Belegdatum</desc>
		</column>
		<column>i9<desc>Belegfeld 1</desc>
		</column>
		<column>i10<desc>Belegfeld 2</desc>
		</column>
		<column>i11<desc>Skonto</desc>
		</column>
		<column>simple_acct_nm<desc>Buchungstext</desc>
		</column>
		<column>
			i13
			<desc>Postensperre</desc>
		</column>
		<column>
			i14
			<desc>Diverse Adressnummer</desc>
		</column>
		<column>
			i15
			<desc>Geschäftspartnerbank</desc>
		</column>
		<column>
			i16
			<desc>Sachverhalt</desc>
		</column>
		<column>
			i17
			<desc>Zinssperre</desc>
		</column>
		<column>
			i18
			<desc>Beleglink</desc>
		</column>
		<column>
			i19
			<desc>Beleginfo - Art 1</desc>
		</column>
		<column>
			i20
			<desc>Beleginfo - Inhalt 1</desc>
		</column>
		<column>
			i21
			<desc>Beleginfo - Art 2</desc>
		</column>
		<column>
			i22
			<desc>Beleginfo - Inhalt 2</desc>
		</column>
		<column>
			i23
			<desc>Beleginfo - Art 3</desc>
		</column>
		<column>
			i24
			<desc>Beleginfo - Inhalt 3</desc>
		</column>
		<column>
			i25
			<desc>Beleginfo - Art 4</desc>
		</column>
		<column>
			i26
			<desc>Beleginfo - Inhalt 4</desc>
		</column>
		<column>
			i27
			<desc>Beleginfo - Art 5</desc>
		</column>
		<column>
			i28
			<desc>Beleginfo - Inhalt 5</desc>
		</column>
		<column>
			i29
			<desc>Beleginfo - Art 6</desc>
		</column>
		<column>
			i30
			<desc>Beleginfo - Inhalt 6</desc>
		</column>
		<column>
			i31
			<desc>Beleginfo - Art 7</desc>
		</column>
		<column>
			i32
			<desc>Beleginfo - Inhalt 7</desc>
		</column>
		<column>
			i33
			<desc>Beleginfo - Art 8</desc>
		</column>
		<column>
			i34
			<desc>Beleginfo - Inhalt 8</desc>
		</column>
		<column>
			i35
			<desc>KOST1 - Kostenstelle</desc>
		</column>
		<column>
			i36
			<desc>KOST2 - Kostenstelle</desc>
		</column>
		<column>
			i37
			<desc>Kost-Menge</desc>
		</column>
		<column>
			i38
			<desc>EU-Land u. UStID</desc>
		</column>
		<column>
			i39
			<desc>EU-Steuersatz</desc>
		</column>
		<column>
			i40
			<desc>Abw. Versteuerungsart</desc>
		</column>
		<column>
			i41
			<desc>Sachverhalt L+L</desc>
		</column>
		<column>
			i42
			<desc>Funktionsergänzung L+L</desc>
		</column>
		<column>
			i43
			<desc>BU 49 Hauptfunktionstyp</desc>
		</column>
		<column>
			i44
			<desc>BU 49 Hauptfunktionsnummer</desc>
		</column>
		<column>
			i45
			<desc>BU 49 Funktionsergänzung</desc>
		</column>
		<column>
			i46
			<desc>Zusatzinformation - Art 1</desc>
		</column>
		<column>
			i47
			<desc>Zusatzinformation- Inhalt 1</desc>
		</column>
		<column>
			i48
			<desc>Zusatzinformation - Art 2</desc>
		</column>
		<column>
			i49
			<desc>Zusatzinformation- Inhalt 2</desc>
		</column>
		<column>
			i50
			<desc>Zusatzinformation - Art 3</desc>
		</column>
		<column>
			i51
			<desc>Zusatzinformation- Inhalt 3</desc>
		</column>
		<column>
			i52
			<desc>Zusatzinformation - Art 4</desc>
		</column>
		<column>
			i53
			<desc>Zusatzinformation- Inhalt 4</desc>
		</column>
		<column>
			i54
			<desc>Zusatzinformation - Art 5</desc>
		</column>
		<column>
			i55
			<desc>Zusatzinformation- Inhalt 5</desc>
		</column>
		<column>
			i56
			<desc>Zusatzinformation - Art 6</desc>
		</column>
		<column>
			i57
			<desc>Zusatzinformation- Inhalt 6</desc>
		</column>
		<column>
			i58
			<desc>Zusatzinformation - Art 7</desc>
		</column>
		<column>
			i59
			<desc>Zusatzinformation- Inhalt 7</desc>
		</column>
		<column>
			i60
			<desc>Zusatzinformation - Art 8</desc>
		</column>
		<column>
			i61
			<desc>Zusatzinformation- Inhalt 8</desc>
		</column>
		<column>
			i62
			<desc>Zusatzinformation - Art 9</desc>
		</column>
		<column>
			i63
			<desc>Zusatzinformation- Inhalt 9</desc>
		</column>
		<column>
			i64
			<desc>Zusatzinformation - Art 10</desc>
		</column>
		<column>
			i65
			<desc>Zusatzinformation- Inhalt 10</desc>
		</column>
		<column>
			i66
			<desc>Zusatzinformation - Art 11</desc>
		</column>
		<column>
			i67
			<desc>Zusatzinformation- Inhalt 11</desc>
		</column>
		<column>
			i68
			<desc>Zusatzinformation - Art 12</desc>
		</column>
		<column>
			i69
			<desc>Zusatzinformation- Inhalt 12</desc>
		</column>
		<column>
			i70
			<desc>Zusatzinformation - Art 13</desc>
		</column>
		<column>
			i71
			<desc>Zusatzinformation- Inhalt 13</desc>
		</column>
		<column>
			i72
			<desc>Zusatzinformation - Art 14</desc>
		</column>
		<column>
			i73
			<desc>Zusatzinformation- Inhalt 14</desc>
		</column>
		<column>
			i74
			<desc>Zusatzinformation - Art 15</desc>
		</column>
		<column>
			i75
			<desc>Zusatzinformation- Inhalt 15</desc>
		</column>
		<column>
			i76
			<desc>Zusatzinformation - Art 16</desc>
		</column>
		<column>
			i77
			<desc>Zusatzinformation- Inhalt 16</desc>
		</column>
		<column>
			i78
			<desc>Zusatzinformation - Art 17</desc>
		</column>
		<column>
			i79
			<desc>Zusatzinformation- Inhalt 17</desc>
		</column>
		<column>
			i80
			<desc>Zusatzinformation - Art 18</desc>
		</column>
		<column>
			i81
			<desc>Zusatzinformation- Inhalt 18</desc>
		</column>
		<column>
			i82
			<desc>Zusatzinformation - Art 19</desc>
		</column>
		<column>
			i83
			<desc>Zusatzinformation- Inhalt 19</desc>
		</column>
		<column>
			i84
			<desc>Zusatzinformation - Art 20</desc>
		</column>
		<column>
			i85
			<desc>Zusatzinformation- Inhalt 20</desc>
		</column>

		<column>
			i86
			<desc>Stück</desc>
		</column>
		<column>
			i87
			<desc>Gewicht</desc>
		</column>
		<column>
			i88
			<desc>Zahlweise</desc>
		</column>
		<column>
			i89
			<desc>Forderungsart</desc>
		</column>
		<column>
			i90
			<desc>Veranlagungsjahr</desc>
		</column>
		<column>
			i91
			<desc>Zugeordnete Fälligkeit</desc>
		</column>
		<column>
			i92
			<desc>Skontotyp</desc>
		</column>
		<column>
			i93
			<desc>Auftragsnummer</desc>
		</column>
		<column>
			i94
			<desc>Buchungstyp</desc>
		</column>
		<column>
			i95
			<desc>USt-Schlüssel (Anzahlungen)</desc>
		</column>
		<column>
			i96
			<desc>EU-Land (Anzahlungen)</desc>
		</column>
		<column>
			i97
			<desc>Sachverhalt L+L (Anzahlungen)</desc>
		</column>
		<column>
			i98
			<desc>EU-Steuersatz (Anzahlungen)</desc>
		</column>
		<column>
			i99
			<desc>Erlöskonto (Anzahlungen)</desc>
		</column>
		<column>
			i100
			<desc>Herkunft-Kz</desc>
		</column>

		<column>
			i101
			<desc>Buchungs GUID/Leerfeld</desc>
		</column>
		<column>
			i102
			<desc>KOST-Datum</desc>
		</column>
		<column>
			i103
			<desc>SEPA-Mandatsreferenz</desc>
		</column>
		<column>
			i104
			<desc>Skontosperre</desc>
		</column>
		<column>
			i105
			<desc>Gesellschaftername</desc>
		</column>
		<column>
			i106
			<desc>Beteiligtennummer</desc>
		</column>
		<column>
			i107
			<desc>Identifikationsnummer</desc>
		</column>
		<column>
			i108
			<desc>Zeichnernummer</desc>
		</column>
		<column>
			i109
			<desc>Postensperre bis</desc>
		</column>
		<column>
			i110
			<desc>Bezeichnung SoBil-Sachverhalt</desc>
		</column>
		<column>
			i111
			<desc>Kennzeichen SoBil-Buchung</desc>
		</column>
		<column>
			i112
			<desc>Festschreibung</desc>
		</column>
		<column>
			i113
			<desc>Leistungsdatum</desc>
		</column>
		<column>
			i114
			<desc>Datum Zuord. Steuerperiode</desc>
		</column>



	</csv:columns>

	<xsl:template match="/">
	
	<xsl:variable name="currencyCd">
					<xsl:value-of select="report/departmentCurrency/row/currency_cd"></xsl:value-of>
					</xsl:variable>
		<!-- Output the DATEV header -->
		<xsl:text>"EXTF"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="510" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="21" /><!-- Buchungsstapel -->
		<xsl:value-of select="$delimiter" />
		<xsl:text>"Buchungsstapel"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="7" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:text>"RE"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="00000" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="10000" />
		<xsl:value-of select="$delimiter" />
		<xsl:call-template name="formatdate3">
			<xsl:with-param name="datestr" select="report/report-params/DATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="4" />
		<xsl:value-of select="$delimiter" />
		<xsl:call-template name="formatdate2">
			<xsl:with-param name="datestr" select="report/report-params/DATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />
		<xsl:call-template name="formatdate2">
			<xsl:with-param name="datestr" select="report/report-params/TODATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="0" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="1" />
		<xsl:value-of select="$delimiter" />
		<xsl:text>"</xsl:text><xsl:value-of select="$currencyCd"></xsl:value-of><xsl:text>"</xsl:text>
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:value-of select="$delimiter" />
		<xsl:text>
</xsl:text>




		<!-- Output the CSV column header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>

		<xsl:variable name="posCd" select="/report/report-params/POS_CD" />
		<xsl:variable name="buNm1" select="/report/businessunits/row/buNm1" />
		<xsl:for-each select="/report/cash_journal/pos_cash_journal/row">
			<xsl:variable name="property" select="." />
			<xsl:variable name="property" select="." />
				
			<xsl:variable name="contraAcctCd" select="contra_acct_cd" />
			<xsl:variable name="contraAcctNm" select="contra_simple_acct_nm" />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					<xsl:when test="$column='contra_acct'">
						<xsl:choose>
						 	<xsl:when test="$posCd='P1'"><xsl:text>"1600"</xsl:text></xsl:when>
						 	<xsl:when test="$posCd='P2'"><xsl:text>"1602"</xsl:text></xsl:when>
						 	<xsl:when test="$posCd='P3'"><xsl:text>"1601"</xsl:text></xsl:when>
					   		<xsl:otherwise><xsl:value-of select="1600" /></xsl:otherwise>
						</xsl:choose>
						
						
					</xsl:when>
					<xsl:when test="$column='acct_cd'">
						<xsl:choose>
						 	<xsl:when test="$value='1461'">
								<xsl:choose>
								 	
								 	<xsl:when test="$posCd='P2'"><xsl:text>1467</xsl:text></xsl:when>
								 	<xsl:when test="$posCd='P3'"><xsl:text>1464</xsl:text></xsl:when>
							   		<xsl:otherwise><xsl:value-of select="$value" /></xsl:otherwise>
								</xsl:choose>
						 	
						 	</xsl:when>
						 	<xsl:when test="$value='1462'">
								<xsl:choose>
								 	
								 	<xsl:when test="$posCd='P2'"><xsl:text>1468</xsl:text></xsl:when>
								 	<xsl:when test="$posCd='P3'"><xsl:text>1465</xsl:text></xsl:when>
							   		<xsl:otherwise><xsl:value-of select="$value" /></xsl:otherwise>
								</xsl:choose>
						 	
						 	</xsl:when>
						 	<xsl:when test="$value='1463'">
								<xsl:choose>
								 	
								 	<xsl:when test="$posCd='P2'"><xsl:text>1469</xsl:text></xsl:when>
								 	<xsl:when test="$posCd='P3'"><xsl:text>1466</xsl:text></xsl:when>
							   		<xsl:otherwise><xsl:value-of select="$value" /></xsl:otherwise>
								</xsl:choose>
						 	
						 	</xsl:when>
					   		<xsl:otherwise><xsl:value-of select="$value" /></xsl:otherwise>
						</xsl:choose>
						
						
					</xsl:when>
					<xsl:when test="$column='simple_acct_nm'">
						<xsl:choose>
							<xsl:when test="$contraAcctNm">
								<xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>-</xsl:text><xsl:value-of select="$contraAcctNm" /><xsl:text>"</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text>
							</xsl:otherwise>	
						</xsl:choose>
					</xsl:when>
					
					<xsl:when test="$column='payment_orig_unformated'">
						<xsl:variable name="priceValue">
													<xsl:call-template name="numberEFormat">
														<xsl:with-param name="value" select="$value" />
		
													</xsl:call-template>
							</xsl:variable>
					<xsl:value-of select="format-number($priceValue, '0,00', 'money')" />
					</xsl:when>
					
					<xsl:when test="$column='i35'">
						<xsl:choose>
						 	<xsl:when test="$posCd='P1'"><xsl:text>"1"</xsl:text></xsl:when>
						 	<xsl:when test="$posCd='P2'"><xsl:text>"3"</xsl:text></xsl:when>
						 	<xsl:when test="$posCd='P3'"><xsl:text>"2"</xsl:text></xsl:when>
					   		<xsl:otherwise><xsl:text>"</xsl:text><xsl:value-of select="$buNm1" /><xsl:text>"</xsl:text></xsl:otherwise>
						</xsl:choose>
						
					</xsl:when>
					
					<xsl:when test="$column='direction'">
						<xsl:if test="$value = 1">
							<xsl:text>"H"</xsl:text>
						</xsl:if>
						<xsl:if test="$value = 2">
							<xsl:text>"S"</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$column='day_dt'">
						<xsl:call-template name="formatdatedmm">
							<xsl:with-param name="datestr"
								select="$value" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>



	</xsl:template>
</xsl:stylesheet>