<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
	    <column>customer_group_nm<desc>Kundengruppe</desc></column>
      	<column>contact_nm<desc>Nachname</desc></column>
      	<column>first_nm<desc>Vorname</desc></column>
      	<column>email<desc>Mail</desc></column>
      	<column>street<desc>Straße</desc></column>
      	<column>postal_cd<desc>PLZ</desc></column>
      	<column>city<desc>Stadt</desc></column>
      	<column>phone<desc>Telefonnummer</desc></column>
      	<column>r_dt_birthday<desc>Geburtstag</desc></column>
	<!-- 	<column>comment<desc>Kommentar</desc></column> -->
		<column>r_visit_z1<desc>Besuch in Zeitraum</desc></column>
		<column>r_total_t1<desc>Umsatz Zeitraum</desc></column>
		<column>neukunde<desc>Neukunde Zeitraum</desc></column>
		<column>r_visit_z2<desc>Besuch in Vergleichszeitraum</desc></column>
		<column>r_total_t2<desc>Umsatz Vergleichszeitraum</desc></column>
		
      	
	</csv:columns>

	<xsl:template match="/" >
	Auswertung Kundenbesuche im Zeitraum <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="report/report-params/DATE" /></xsl:call-template> bis <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="report/report-params/TODATE" /></xsl:call-template>
	<xsl:text>
		</xsl:text>
		Vergleichszeitraum <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="report/report-params/DATE_COMPARE" /></xsl:call-template> bis <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="report/report-params/TODATE_COMPARE" /></xsl:call-template>
		<xsl:text>
		</xsl:text>
		<xsl:text>
		</xsl:text>
		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="report/visitorList/row">
				
				<xsl:variable name="customerNo" select="customer_no" />
				<xsl:variable name="customerRevRow" select="/report/returningCustomerRevenue/row[r_customer_no=$customerNo]" />
			
				<xsl:variable name="property" select="." />
				<!-- Loop through the columns in order -->
				<xsl:for-each select="document('')/*/csv:columns/*">
					<!-- Extract the column name and value -->
					<xsl:variable name="column" select="./text()" />
					<xsl:variable name="value" select="$property/*[name() = $column]" />
					<xsl:choose>
						<xsl:when test="$column ='r_total_t1'"><xsl:value-of select="format-number($customerRevRow/r_total_t1, '###.##0,00', 'money')" /></xsl:when>
						<xsl:when test="$column ='r_total_t2'"><xsl:value-of select="format-number($customerRevRow/r_total_t2, '###.##0,00', 'money')" /></xsl:when>
						<xsl:when test="starts-with($column,'r_dt') and $value != ''">
						 <xsl:call-template name="formatdate"><xsl:with-param name="datestr" select="$value"/></xsl:call-template>
						 </xsl:when> 
						<xsl:when test="starts-with($column,'phone')">#<xsl:value-of select="$value" /></xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$value" />
						</xsl:otherwise>
					</xsl:choose>
	
					<!-- Add the delimiter unless we are the last expression -->
					<xsl:if test="position() != last()">
						<xsl:value-of select="$delimiter" />
					</xsl:if>
				
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
			</xsl:text>
		
		</xsl:for-each>
		
	
	</xsl:template>


</xsl:stylesheet>
