<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
  <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="footer-text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="report-table">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>		
		<xsl:attribute name="border-width">1pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="report-cell">
		<xsl:attribute name="border-style">solid</xsl:attribute>		
		<xsl:attribute name="border-width">1pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-header"  use-attribute-sets="report-cell">		
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="report-cell-bold"  use-attribute-sets="report-cell">		
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-main-topic"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
		<xsl:attribute name="background-color">#999999</xsl:attribute>
		
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-main-topic-no-bg"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>	
	</xsl:attribute-set>

	<xsl:attribute-set name="report-cell-sub-topic"  use-attribute-sets="report-cell-bold">		
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		
	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="tgDivision-format">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="format" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="format-number($divident div  ($negativCorrection * $divisor ), $format, 'money')" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					0,00
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="format-number($divident div  $divisor , $format, 'money')" />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	<xsl:template name="tgDivision">
		<xsl:param name="divident" />
		<xsl:param name="divisor" />
		<xsl:param name="negativCorrection" />
			<xsl:choose>
				<xsl:when test="$divisor &lt; 0 and $divident &lt; 0">
					<xsl:value-of select="$divident div  ($negativCorrection * $divisor )" />
				</xsl:when>
				<xsl:when test="$divisor=0">
					<xsl:value-of	select="$divisor" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of	select="$divident div  $divisor " />
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>


	<xsl:template name="table-customer">
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataLMA" />
                          
				<!--		 <xsl:call-template name="table-title-row">
							<xsl:with-param name="title" select="'Neukunden'" />
						</xsl:call-template>
-->
						<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       Neukunden
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number($customerVisitData/neukunden_cg1  +$customerVisitData/neukunden_cg2 +$customerVisitData/neukunden_cg3  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/neukunden_cg1 + $customerVisitDataLMA/neukunden_cg2 + $customerVisitDataLMA/neukunden_cg3  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
						  
						  
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Damen
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/neukunden_cg1  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/neukunden_cg1  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Herren
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/neukunden_cg2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/neukunden_cg2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Kinder
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/neukunden_cg3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/neukunden_cg3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
                            
						
							
							 <!--<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Kunden'" />
							</xsl:call-template>-->
								<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       Kunden
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic" > 
                                    <fo:block>
                                       <xsl:value-of select="format-number($customerVisitData/bestandskunden_cg1  +$customerVisitData/bestandskunden_cg2 +$customerVisitData/bestandskunden_cg3  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic" > 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/bestandskunden_cg1 + $customerVisitDataLMA/bestandskunden_cg2+ $customerVisitDataLMA/bestandskunden_cg3  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Damen
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell" > 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/bestandskunden_cg1  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell" > 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/bestandskunden_cg1  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Herren
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/bestandskunden_cg2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center"  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/bestandskunden_cg2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Kinder
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/bestandskunden_cg3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/bestandskunden_cg3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>

	</xsl:template>

	<xsl:template name="table-visits">
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataLMA" />
                          
						<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       Besuche
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number($customerVisitData/amount_customer  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/amount_customer  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell-main-topic"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
						  
						  
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Damen
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/r_amount_group1  , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/r_amount_group1 , '#', 'amount')" />
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell  number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Herren
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/r_amount_group2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/r_amount_group2  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
							<fo:table-row> 
                                <fo:table-cell  xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       Kinder
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitData/r_amount_group3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       <xsl:value-of select="format-number( $customerVisitDataLMA/r_amount_group3  , '#', 'amount')"/>
                                    </fo:block>
                                </fo:table-cell> 
								<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>
                                       
                                    </fo:block>
                                </fo:table-cell> 
                            </fo:table-row>
                            
	</xsl:template>


	<xsl:template name="table-title-row">
		<xsl:param name="title" />
		<fo:table-row> 
					<fo:table-cell number-columns-spanned="9" xsl:use-attribute-sets="report-cell-main-topic"> 
						<fo:block>
							<xsl:value-of select="$title" />
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>

	</xsl:template>


	<xsl:template name="table-sub-title-row">
		<xsl:param name="title" />
		<fo:table-row> 
			<fo:table-cell number-columns-spanned="9" xsl:use-attribute-sets="report-cell-sub-topic"> 
				<fo:block>
					<xsl:value-of select="$title" />
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	</xsl:template>

	<xsl:template name="table-structure-dl">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryReportGroupList" />
		<xsl:param name="reportGroupData" />
		<xsl:param name="categoryData" />
		<xsl:param name="reportGroupDataLMA" />
		<xsl:param name="categoryDataLMA" />
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataLMA" />

		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />
	<!--		<xsl:variable name="amountCustomerPerCategory" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
			<xsl:variable name="amountCustomerPerCategoryLMA" select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
		-->	

			
			<xsl:variable name="customerGroupId" select="customer_group_no" />
			<xsl:variable name="customerGroupColumnNm" select="concat('r_amount_group', $customerGroupId)" />
	
			<xsl:variable name="amountCustomerPerCategory" >
				<xsl:choose>
					<xsl:when test="$customerGroupId &gt; 0 and $customerGroupId &lt; 4">
						<xsl:value-of select="$customerVisitData/*[name() = $customerGroupColumnNm]" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:variable name="amountCustomerPerCategoryLMA" >
				<xsl:choose>
					<xsl:when test="$customerGroupId &gt; 0 and $customerGroupId &lt; 4">
						<xsl:value-of select="$customerVisitDataLMA/*[name() = $customerGroupColumnNm]" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>




			<xsl:call-template name="table-sub-title-row">
				<xsl:with-param name="title" select="item_report_category_nm" />
			</xsl:call-template>
		
			<xsl:for-each select="$categoryReportGroupList[item_report_category_cd=$itemReportCategoryCd]">
	
				<xsl:variable name="itemReportGroupCd" select="item_report_group_cd" />
			
					<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="item_report_group_nm" />
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number( $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl , '0', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
							<fo:block>

								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategory"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	


								<xsl:value-of  select="format-number($divValue * 100, '0,#', 'percent')"/>			
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number( $reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl, '0', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
							<fo:block>

							<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryLMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	


								<xsl:value-of  select="format-number($divValue * 100,  '0,#', 'percent')"/>			
							</fo:block>
						</fo:table-cell> 
					</fo:table-row>
				</xsl:for-each>
				

					<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="'Gesamt'" />
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number(sum( $reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl) , '0', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">

							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl)"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategory"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	


								<xsl:value-of  select="format-number($divValue * 100, '0,#', 'percent')"/>			-->
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number( sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl), '0', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">

							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl)"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryLMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	


								<xsl:value-of  select="format-number($divValue * 100,  '0,#', 'percent')"/>			-->
							</fo:block>
						</fo:table-cell> 
					</fo:table-row>

		</xsl:for-each>

    </xsl:template>   

	<xsl:template name="table-structure-withcustomergroups-dl">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryReportGroupList" />
		<xsl:param name="reportGroupData" />
		<xsl:param name="categoryData" />
		<xsl:param name="reportGroupDataLMA" />
		<xsl:param name="categoryDataLMA" />
		<xsl:param name="customerVisitData" />
		<xsl:param name="customerVisitDataLMA" />

		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />
		<!--	<xsl:variable name="amountCustomerPerCategory" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
			<xsl:variable name="amountCustomerPerCategoryLMA" select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/amount_customer" />
			-->
			<xsl:variable name="amountCustomerPerCategoryG1" select="$customerVisitData/r_amount_group1" />
			<xsl:variable name="amountCustomerPerCategoryG2G3" select="$customerVisitData/r_amount_group2 + $customerVisitData/r_amount_group3" />
			<xsl:variable name="amountCustomerPerCategoryG1LMA" select="$customerVisitDataLMA/r_amount_group1" />
			<xsl:variable name="amountCustomerPerCategoryG2G3LMA" select="$customerVisitDataLMA/r_amount_group2 + $customerVisitData/r_amount_group3" />
			
			
			<fo:table-row> 
				<fo:table-cell xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						<xsl:value-of select="item_report_category_nm" />
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						D
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						H
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						D
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"   xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						H
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						D
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						H
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"  xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						D
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell text-align="center"   xsl:use-attribute-sets="report-cell-sub-topic"> 
					<fo:block>
						H
					</fo:block>
				</fo:table-cell> 
			</fo:table-row>

			<xsl:for-each select="$categoryReportGroupList[item_report_category_cd=$itemReportCategoryCd]">
	
					<xsl:variable name="itemReportGroupCd" select="item_report_group_cd" />
			
					<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="item_report_group_nm" />
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number($reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1, '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number($reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3, '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryG1"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="($reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupData[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3) "/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryG2G3"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		
							</fo:block>
						</fo:table-cell> 
						
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1  , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:value-of select="format-number($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3  , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g1"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryG1LMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block>
								<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g2 + $reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd][item_report_group_cd=$itemReportGroupCd]/cnt_dl_g3) "/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryG2G3LMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>	
							</fo:block>
						</fo:table-cell> 

					</fo:table-row>
				</xsl:for-each>
			
				<fo:table-row> 
						<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="'Gesamt'" />
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number(sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1), '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number(sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3), '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1)"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategory"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		-->
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="(sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupData[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3)) "/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategory"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		-->
							</fo:block>
						</fo:table-cell> 
						
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number(sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1 ) , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
								<xsl:value-of select="format-number(sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3)  , '#', 'amount')"/>
							</fo:block>
						</fo:table-cell> 
						
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g1)"/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryLMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		-->
							</fo:block>
						</fo:table-cell> 
						<fo:table-cell  text-align="center" xsl:use-attribute-sets="report-cell"> 
							<fo:block font-weight="bold">
							<!--	<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="(sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g2) + sum($reportGroupDataLMA[item_report_category_cd=$itemReportCategoryCd]/cnt_dl_g3)) "/>
										<xsl:with-param name="divisor" select="$amountCustomerPerCategoryLMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue * 100, '0,#', 'percent')"/>		-->
							</fo:block>
						</fo:table-cell> 

					</fo:table-row>
			
		</xsl:for-each>

    </xsl:template>   


 	<xsl:template name="table-revenue">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="categoryDataLMA" />
		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
						
							<xsl:value-of select="format-number($categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services , '###.##0,00', 'money')"/>
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
						
							<xsl:value-of select="format-number($categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/r_total_services , '###.##0,00', 'money')"/>
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:value-of select="format-number($categoryData[item_report_category_cd='-']/r_total_products, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:value-of select="format-number($categoryDataLMA[item_report_category_cd='-']/r_total_products, '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
				
					<xsl:value-of select="format-number(sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
				
					<xsl:value-of select="format-number(sum($categoryDataLMA[item_report_category_cd !='-']/r_total_services) + $categoryDataLMA[item_report_category_cd='-']/r_total_products , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    	

 	<xsl:template name="table-revenue-per-value">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="value" />
		<xsl:param name="categoryDataLMA" />
		<xsl:param name="valueLMA" />
		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services "/>
										<xsl:with-param name="divisor" select="$value"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
							
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
									<xsl:call-template name="tgDivision">
										<xsl:with-param name="divident" select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/r_total_services "/>
										<xsl:with-param name="divisor" select="$valueLMA"/>
										<xsl:with-param name="negativCorrection" select="-1"/>
										
									</xsl:call-template>	
								</xsl:variable>	

								<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
							
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
		
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryDataLMA[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valueLMA"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue, '###.##0,00', 'money')"/>
		
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

	<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryDataLMA[item_report_category_cd !='-']/r_total_services) + $categoryDataLMA[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valueLMA"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    

 	<xsl:template name="table-work-days">
		<xsl:param name="workdays" />
			<xsl:param name="workdaysLMA" />
		
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							Arbeitstage
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="$workdays"/>
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="$workdaysLMA"/>
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
	
    </xsl:template>    


 	<xsl:template name="table-revenue-per-customer">
		<xsl:param name="categoryList" />
		<xsl:param name="categoryData" />
		<xsl:param name="value" />
		<xsl:param name="categoryDataLMA" />
		<xsl:param name="valueLMA" />
		<xsl:for-each select="$categoryList">	
			<xsl:variable name="itemReportCategoryCd" select="item_report_category_cd" />			
				<fo:table-row> 
					<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:value-of select="item_report_category_nm" />
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/r_total_services"/>
									<xsl:with-param name="divisor" select="$categoryData[item_report_category_cd=$itemReportCategoryCd]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

							
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
						<fo:block>
							<xsl:variable name="divValue">							
								<xsl:call-template name="tgDivision">
									<xsl:with-param name="divident" select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/r_total_services"/>
									<xsl:with-param name="divisor" select="$categoryDataLMA[item_report_category_cd=$itemReportCategoryCd]/amount_customer"/>
									<xsl:with-param name="negativCorrection" select="-1"/>
								</xsl:call-template>	
							</xsl:variable>	

							<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

							
						</fo:block>
					</fo:table-cell> 
					<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
						<fo:block>
								&#160;
						</fo:block>
					</fo:table-cell> 
				</fo:table-row>
		</xsl:for-each>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Verkauf
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$categoryDataLMA[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valueLMA"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
					
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryData[item_report_category_cd !='-']/r_total_services) + $categoryData[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$value"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="right" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="divValue">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="sum($categoryDataLMA[item_report_category_cd !='-']/r_total_services) + $categoryDataLMA[item_report_category_cd='-']/r_total_products"/>
							<xsl:with-param name="divisor" select="$valueLMA"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	

					<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
						&#160;
				</fo:block>
			</fo:table-cell> 
		</fo:table-row>

    </xsl:template>    


	<xsl:template name="table-treatment-factor">
		<xsl:param name="treatmentData" />
		<xsl:param name="treatmentDataLMA" />
						
			<fo:table-row> 
				<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						Damen
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
							
							<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentData/r_cnt_dl_cg1"/>
								<xsl:with-param name="divisor" select="$treatmentData/r_amount_group1"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						
						&#160;
						
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						
							<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentDataLMA/r_cnt_dl_cg1"/>
								<xsl:with-param name="divisor" select="$treatmentDataLMA/r_amount_group1"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
							&#160;
						
					</fo:block>
				</fo:table-cell> 
			</fo:table-row>
	
			<fo:table-row> 
				<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
					<fo:block>
						Herren
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>


							<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentData/r_cnt_dl_cg2"/>
								<xsl:with-param name="divisor" select="$treatmentData/r_amount_group2"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
													&#160;
						
					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
					<fo:block>

							<xsl:variable name="divValue">							
							<xsl:call-template name="tgDivision">
								<xsl:with-param name="divident" select="$treatmentDataLMA/r_cnt_dl_cg2"/>
								<xsl:with-param name="divisor" select="$treatmentDataLMA/r_amount_group2"/>
								<xsl:with-param name="negativCorrection" select="-1"/>
							</xsl:call-template>	
						</xsl:variable>	

						<xsl:value-of select="format-number($divValue , '###.##0,00', 'money')"/>

					</fo:block>
				</fo:table-cell> 
				<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
					<fo:block>
							&#160;
						
					</fo:block>
				</fo:table-cell> 
			</fo:table-row>

    </xsl:template>    


	<xsl:template name="table-lma-ama">
		<xsl:param name="amaData" />
		<xsl:param name="lmaData" />
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell  number-columns-spanned="4" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					AMA
				</fo:block>
			</fo:table-cell> 
		
			<fo:table-cell number-columns-spanned="4" text-align="center" xsl:use-attribute-sets="report-cell"> 
			<fo:block>
					LMA
				</fo:block>
			</fo:table-cell>			
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Damen
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2"  text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group1"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>		
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group1"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>			
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Herren
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group2"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>		
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group2"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>			
		</fo:table-row>

		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					Kinder
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_group3"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>		
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_group3"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>			
		</fo:table-row>
		<fo:table-row> 
			<fo:table-cell  xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					Gesamt
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center"   xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$amaData/r_amount_customer"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$amaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block font-weight="bold">
					<xsl:variable name="valuePerEmployee">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$lmaData/r_amount_customer"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_employee"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:variable name="valuePerDay">							
						<xsl:call-template name="tgDivision">
							<xsl:with-param name="divident" select="$valuePerEmployee"/>
							<xsl:with-param name="divisor" select="$lmaData/r_cnt_dt"/>
							<xsl:with-param name="negativCorrection" select="-1"/>
						</xsl:call-template>	
					</xsl:variable>	
					<xsl:value-of select="format-number($valuePerDay , '###.##0,00', 'money')"/>
				
				</fo:block>
			</fo:table-cell> 
			<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="report-cell"> 
				<fo:block>
					&#160;
				</fo:block>
			</fo:table-cell>
		</fo:table-row>

	</xsl:template>  



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="15mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="15mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">

					<xsl:variable name="filterRow">
						Mitarbeiter:&#160;
						<xsl:choose>
							<xsl:when test="not(report/report-params/EMPLOYEE_NO)">
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="report/employeeNm/row/employee_nm" /> 
							</xsl:otherwise>
						</xsl:choose> 
					</xsl:variable>
					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"BV kumuliert"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRow" select="$filterRow" />
					</xsl:call-template>

					</fo:static-content>

				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="footer-text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											BV kumuliert
											<xsl:choose>
												<xsl:when test="not(report/report-params/EMPLOYEE_NO)">
													<xsl:value-of select="report/businessunits/row/bu_nm_2" /> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="report/employeeNm/row/employee_nm" /> 
												</xsl:otherwise>
											</xsl:choose>   / <xsl:call-template name="formatdate">
													<xsl:with-param name="datestr"
														select="report/report-params/DATE" />
												</xsl:call-template> - <xsl:call-template name="formatdate">
													<xsl:with-param name="datestr"
														select="report/report-params/TODATE" />
												</xsl:call-template> 
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="footer-text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">


					<fo:table table-layout="fixed" width="100%"  xsl:use-attribute-sets="report-table">
						<fo:table-column column-width="20%"></fo:table-column>
						<!-- ama -->
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
                        <fo:table-column column-width="10%"></fo:table-column>
						
						<!-- lma -->
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
                        <fo:table-column column-width="10%"></fo:table-column>

						
						<fo:table-header>
							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell-header"> 
                                    <fo:block>
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                     AMA Anzahl / Wert
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                      AMA   Struktur in %
                                    </fo:block>  
                                </fo:table-cell> 
								 <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                     LMA Anzahl / Wert
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="report-cell-header" text-align="center"> 
                                    <fo:block>
                                       LMA  Struktur in %
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>
						</fo:table-header>

						<fo:table-body>



                            



							<xsl:call-template name="table-customer">
								<xsl:with-param name="customerVisitData" select="/report/bv/ama/customerVisits/row"/>
								<xsl:with-param name="customerVisitDataLMA" select="/report/bv/lma/customerVisits/row"/>
         					</xsl:call-template>     
							<xsl:call-template name="table-visits">
								<xsl:with-param name="customerVisitData" select="/report/bv/ama/globalData/row"/>
								<xsl:with-param name="customerVisitDataLMA" select="/report/bv/lma/globalData/row"/>
         					</xsl:call-template>     
					
			
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Arbeitstage'" />
							</xsl:call-template>
			 				<xsl:call-template name="table-work-days">
								<xsl:with-param name="workdays" select="/report/bv/ama/globalData/row/cnt_working_days"/>
								<xsl:with-param name="workdaysLMA" select="/report/bv/lma/globalData/row/cnt_working_days"/>
							</xsl:call-template>	
						
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Dienstleistungsstruktur'" />
							</xsl:call-template>
							
							<xsl:call-template name="table-structure-dl">
								<xsl:with-param name="categoryList" select="/report/categorylist/row[use_customer_group=0]"/>
								<xsl:with-param name="categoryReportGroupList" select="/report/itemCategoryReportGrouplist/row"/>
								<xsl:with-param name="reportGroupData" select="/report/bv/ama/serviceStructure_dl/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/ama/categoryData/row"/>
								<xsl:with-param name="reportGroupDataLMA" select="/report/bv/lma/serviceStructure_dl/row"/>
								<xsl:with-param name="categoryDataLMA" select="/report/bv/lma/categoryData/row"/>
								<xsl:with-param name="customerVisitData" select="/report/bv/ama/globalData/row"/>
								<xsl:with-param name="customerVisitDataLMA" select="/report/bv/lma/globalData/row"/>
         					</xsl:call-template>     
							
							<xsl:call-template name="table-structure-withcustomergroups-dl">
								<xsl:with-param name="categoryList" select="/report/categorylist/row[use_customer_group=1]"/>
								<xsl:with-param name="categoryReportGroupList" select="/report/itemCategoryReportGrouplist/row"/>
								<xsl:with-param name="reportGroupData" select="/report/bv/ama/serviceStructure_withcustomergroup_dl/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/ama/categoryData/row"/>
								<xsl:with-param name="reportGroupDataLMA" select="/report/bv/lma/serviceStructure_withcustomergroup_dl/row"/>
								<xsl:with-param name="categoryDataLMA" select="/report/bv/lma/categoryData/row"/>
								<xsl:with-param name="customerVisitData" select="/report/bv/ama/globalData/row"/>
								<xsl:with-param name="customerVisitDataLMA" select="/report/bv/lma/globalData/row"/>
         					</xsl:call-template>  

							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Umsatz'" />
							</xsl:call-template>

							<xsl:call-template name="table-revenue">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/ama/categoryData/row"/>
								<xsl:with-param name="categoryDataLMA" select="/report/bv/lma/categoryData/row"/>
         					</xsl:call-template>    	

						
							<xsl:call-template name="table-title-row">
								<xsl:with-param name="title" select="'Leistungskennzahlen'" />
							</xsl:call-template>

							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Auslastung pro MA pro Tag'" />
							</xsl:call-template>
							<xsl:call-template name="table-lma-ama">
								<xsl:with-param name="amaData" select="/report/bv/ama/ama-data/row"/>
								<xsl:with-param name="lmaData" select="/report/bv/lma/lma-data/row"/>
         					</xsl:call-template>    	


							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Behandlungsfaktor'" />
							</xsl:call-template>
							<xsl:call-template name="table-treatment-factor">
									<xsl:with-param name="treatmentData" select="/report/bv/ama/globalData/row"/>
									<xsl:with-param name="treatmentDataLMA" select="/report/bv/lma/globalData/row"/>
							</xsl:call-template>		


							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Umsatz pro Tag'" />
							</xsl:call-template>
							<xsl:call-template name="table-revenue-per-value">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/ama/categoryData/row"/>
								<xsl:with-param name="value" select="/report/bv/ama/globalData/row/cnt_working_days"/>
								<xsl:with-param name="categoryDataLMA" select="/report/bv/lma/categoryData/row"/>
								<xsl:with-param name="valueLMA" select="/report/bv/lma/globalData/row/cnt_working_days"/>
         					</xsl:call-template>    	
	
							<xsl:call-template name="table-sub-title-row">
								<xsl:with-param name="title" select="'Umsatz pro Besuch'" />
							</xsl:call-template>
							<xsl:call-template name="table-revenue-per-customer">
								<xsl:with-param name="categoryList" select="/report/categorylist/row"/>
								<xsl:with-param name="categoryData" select="/report/bv/ama/categoryData/row"/>
								<xsl:with-param name="value" select="/report/bv/ama/globalData/row/amount_customer"/>
								<xsl:with-param name="categoryDataLMA" select="/report/bv/lma/categoryData/row"/>
								<xsl:with-param name="valueLMA" select="/report/bv/lma/globalData/row/amount_customer"/>
         					</xsl:call-template>    	


			            </fo:table-body>

					</fo:table>

					<fo:table table-layout="fixed" width="100%"  xsl:use-attribute-sets="report-table" margin-top="10mm">
						<fo:table-column column-width="25%"></fo:table-column>
						<fo:table-column column-width="75%"></fo:table-column>
						
						

						<fo:table-body>

                          <fo:table-row> 
                               
                                 <fo:table-cell number-columns-spanned="2"  xsl:use-attribute-sets="report-cell" font-weight="bold" text-align="left"> 
                                    <fo:block>
										Legende
                                    </fo:block>  
                                </fo:table-cell> 
                                
                            </fo:table-row>

                            <fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Auslastung pro MA pro Tag:
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                      Anzahl Kundenbesuche pro Tag / Anzahl MA
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Behandlungsfaktor: 
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                      Anzahl Damen (Herren) DL Gesamt / Anzahl Damenbesuche (Herren) Gesamt
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Umsatz pro Besuch: 
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                     Durchschnittlicher Umsatz je Kundengruppe bzw. durchschnittlicher Verkaufsumsatz je Besuch
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Strukturwert in %:
                                    </fo:block>  
                                </fo:table-cell> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                       Anzahl Behandlungsart / Anzahl Besuche je Kundengruppe; Eine Behandlungsart ist eine Gruppe von Dienstleistungen zB Farbe
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>

							<fo:table-row> 
                                <fo:table-cell xsl:use-attribute-sets="report-cell"> 
                                    <fo:block>Dienstleistungsstruktur: 
                                    </fo:block>  
                                </fo:table-cell> 
                                 <fo:table-cell xsl:use-attribute-sets="report-cell" text-align="left"> 
                                    <fo:block>
                                    gibt die Anzahl der Dienstleistungen in einer DL Gruppe bzw. im Struktur das Verhältnis zu der Gesamtanzahl Besuche der jeweiligen Kundengruppe
                                    </fo:block>  
                                </fo:table-cell> 
                            </fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>