<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
   <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border">1px solid #000000</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-block-header">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell-block">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="block-header">
		<xsl:attribute name="font-size">11pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">10mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">7mm</xsl:attribute>

	</xsl:attribute-set>



	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">

					<xsl:variable name="doneTs">
						<xsl:choose>
							<xsl:when test="report/minSalesInvTs/row/minsalesinvts">
								<xsl:value-of select="report/minSalesInvTs/row/minsalesinvts" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="report/report-params/NOW" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

				    <xsl:call-template name="header">
						<xsl:with-param name="title" select='"Einrichtungsprotokoll"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="date" select="report/report-params/DATE" />
					</xsl:call-template>
					
				</fo:static-content>
				

				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											
											
											<xsl:value-of select="$doneTs"></xsl:value-of>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Einrichtungsprotokoll
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">


               <fo:block xsl:use-attribute-sets="block-header">
						Allgemeines
					</fo:block>
					<fo:table table-layout="fixed" width="100%" >
						<fo:table-column column-width="30%"></fo:table-column>
						<fo:table-column column-width="70%"></fo:table-column>
						

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block-header">
										Stand am:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="$doneTs"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block-header">
										Bon-Code-Schema:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block">
										I.<xsl:value-of select="report/pointOfSale/row/pos_cd"></xsl:value-of>.&lt;fortlaufende Bonnummer&gt;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block-header">
										Gutschein-Code-Schema:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									
									<fo:block xsl:use-attribute-sets="cell-block">
										V<xsl:value-of select="report/pointOfSale/row/tenant_no"></xsl:value-of>.<xsl:value-of select="report/pointOfSale/row/pos_cd"></xsl:value-of>.&lt;fortlaufende Gutscheinnummer&gt;
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
					</fo:table-body>
								</fo:table>


					<fo:block xsl:use-attribute-sets="block-header">
						Geschäftsstelle
					</fo:block>
					<fo:table table-layout="fixed" width="100%" >
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
										<fo:block xsl:use-attribute-sets="cell-block-header">Name</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/businessunit_nm"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Kostenstelle Name 1</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_nm_1"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Kostenstelle Name 2</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_nm_2"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Straße</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_street"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">PLZ/Ort</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_postal_cd"></xsl:value-of>
										/
										<xsl:value-of select="report/businessunits/row/bu_city"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">E-Mail</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_email"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Telefon</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_phone"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">WEB</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_web"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Steuernummer
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_tax_id"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Umsatz-Steuernummer</fo:block>
										<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_eu_tax_id"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">IBAN</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_iban"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Kontoinhaber
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_bank_acct_holder"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Bank</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_bank_nm"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">BIC</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_bic"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Logo-Url</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_logo_url"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Beleg-Url
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_note_form_url"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Beleg Text</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_note_txt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Gutschein-Url
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/bu_voucher_form_url"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Alternative Steuer </fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/alternate_tax_hint"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Alternativer Steuer Cd
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/alternate_tax_cd"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Portfolio</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/portfolio_cd"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Pos Cd </fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/pos_cd_hint"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>


					<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Lager-Nr.
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/stock_no"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								
									<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Lager </fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/stock_nm"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Preislisten-Nr.
										
									</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/sales_pricelist_id"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Markt-Nr.</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/businessunits/row/market_no"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

							

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
										<fo:block xsl:use-attribute-sets="cell-block-header">Währung</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block"><xsl:value-of select="report/departmentCurrency/row/currency_nm"></xsl:value-of></fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>


						<fo:block xsl:use-attribute-sets="block-header">
						Daten Belege
					</fo:block>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
										<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Bons</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/salesInvsAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Ausgaben</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/purchaseInvsAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Lager-Buchungen</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/stockDlnAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Zahlungen</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/paymentAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Gutscheine</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/voucherAmount/row/cnt"></xsl:value-of>
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Konten</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/simpleAccountsAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>


					<fo:block xsl:use-attribute-sets="block-header">

						Daten Dienstleistungen
					</fo:block>
					<fo:table table-layout="fixed" width="100%" >
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>
						<fo:table-column column-width="20%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Dienstleistungen</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/itemsServiceAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">Anzahl Produkte</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										<xsl:value-of select="report/itemsProductAmount/row/cnt"></xsl:value-of>
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
									&#160;
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
									</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell">
									<fo:block xsl:use-attribute-sets="cell-block-header">&#160;</fo:block>
									<fo:block xsl:use-attribute-sets="cell-block">
										&#160;
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>





					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>