<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">
  <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">2mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>


	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>




	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#000000</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style-no-border">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">2mm</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="right-cell-style">
	
		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

<xsl:template name="prozentAbw">
	<xsl:param name="data"/>
	<xsl:param name="dataCompare"/>

	<xsl:choose>
					<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($dataCompare)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($data)) = 'NaN'">
						<xsl:value-of select="format-number(0 ,'###.##0,##' , 'percent')"/>%
					</xsl:when>
					<xsl:when test="$dataCompare = 0">
						<xsl:value-of select="'-'" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((($data div $dataCompare ) -1) * 100 ,'###.##0,##' , 'percent')"/>%
					</xsl:otherwise>
				</xsl:choose>

</xsl:template>

<xsl:template name="differenzCell">
	<xsl:param name="data"/>
	<xsl:param name="dataCompare"/>
	<xsl:param name="format" select="'money'"/>
	<xsl:param name="pattern" select="'###.##0,00'"/>

	<xsl:variable name="value">
		<xsl:choose>
			<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
				<xsl:value-of select="0"/>
			</xsl:when>
			<xsl:when test="string(number($dataCompare)) = 'NaN'">
				<xsl:value-of select="$data"/>
			</xsl:when>
			<xsl:when test="string(number($data)) = 'NaN'">
				<xsl:value-of select="$dataCompare"/>
			</xsl:when>

			<xsl:otherwise>
				<xsl:value-of select="$data - $dataCompare"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>


	<xsl:choose>
		<xsl:when test="$value &lt; 0">
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block color="#cd0000">
						<xsl:value-of select="format-number($value ,$pattern ,$format)"/>
				</fo:block>
			</fo:table-cell>
		</xsl:when>
		<xsl:when test="$value &gt; 0">
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block color="#228b22">
						<xsl:value-of select="format-number($value ,$pattern ,$format)"/>
				</fo:block>
			</fo:table-cell>
		</xsl:when>
		<xsl:otherwise>
			<fo:table-cell text-align="center"  
					xsl:use-attribute-sets="cell-style">
				<fo:block >
						<xsl:value-of select="format-number($value ,$pattern ,$format)"/>
				</fo:block>
			</fo:table-cell>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>


	<xsl:template name="displayDepartment">
		<xsl:param name="departmentNm" />
		<xsl:param name="businessunits" />
		<xsl:param name="data" />
		<xsl:param name="dataCompare" />
		<xsl:param name="rebate" />
		<xsl:param name="rebateCompare" />

		<!-- department name-->
		<fo:table-row>
			<fo:table-cell text-align="left" number-columns-spanned="17" 
				xsl:use-attribute-sets="cell-style text-bold">
				<fo:block>
					<xsl:value-of select="$departmentNm" />	
				</fo:block>
			</fo:table-cell>
		
		</fo:table-row>

		<xsl:for-each select="$businessunits">
			<xsl:variable name="posCd" select="pos_cd_hint"/>

				<fo:table-row>
					<fo:table-cell text-align="left" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="businessunit_nm"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($data[r_pos_cd=$posCd]/r_total,'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($data[r_pos_cd=$posCd]/r_amount_customer,'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($data[r_pos_cd=$posCd]/r_total_per_customer,'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($dataCompare[r_pos_cd=$posCd]/r_total,'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($dataCompare[r_pos_cd=$posCd]/r_amount_customer,'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number($dataCompare[r_pos_cd=$posCd]/r_total_per_customer,'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					
				
					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_total"/>
						<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_total"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_total"/>
								<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_total"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_amount_customer"/>
						<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_amount_customer"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_amount_customer"/>
								<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_amount_customer"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_total_per_customer"/>
						<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_total_per_customer"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				

					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="$data[r_pos_cd=$posCd]/r_total_per_customer"/>
								<xsl:with-param name="dataCompare" select="$dataCompare[r_pos_cd=$posCd]/r_total_per_customer"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data[r_pos_cd=$posCd]/r_rebate) +  sum($rebate[r_pos_cd=$posCd]/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="format-number(sum($dataCompare[r_pos_cd=$posCd]/r_rebate) +  sum($rebateCompare[r_pos_cd=$posCd]/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data[r_pos_cd=$posCd]/r_rebate) +  sum($rebate[r_pos_cd=$posCd]/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_pos_cd=$posCd]/r_rebate) +  sum($rebateCompare[r_pos_cd=$posCd]/r_rebate)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data[r_pos_cd=$posCd]/r_rebate) +  sum($rebate[r_pos_cd=$posCd]/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_pos_cd=$posCd]/r_rebate) +  sum($rebateCompare[r_pos_cd=$posCd]/r_rebate)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>



		</xsl:for-each>


		<fo:table-row>
			<fo:table-cell text-align="left" 
				xsl:use-attribute-sets="cell-style-no-border">
				<fo:block>
					<xsl:value-of select="''"/>	
				</fo:block>
			</fo:table-cell>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_total),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_amount_customer),'###.##0,##' , 'amount')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_total) div sum($data/r_amount_customer),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_total),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_amount_customer),'###.##0,##' , 'amount')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			
		
			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_total)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_total)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_amount_customer)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_amount_customer)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_amount_customer)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		

			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
			
			
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_rebate) +  sum($rebate/r_rebate),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
						<xsl:value-of select="format-number(sum($dataCompare/r_rebate) + sum($rebateCompare/r_rebate),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data/r_rebate) + sum( $rebate/r_rebate)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_rebate) +  sum($rebate/r_rebate)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>



	</xsl:template>



	<xsl:template name="displayCompanyTotal">
		
		<xsl:param name="departments" />
		<xsl:param name="data" />
		<xsl:param name="dataCompare" />
		<xsl:param name="rebate" />
		<xsl:param name="rebateCompare" />

		<!-- department name-->
		<fo:table-row>
			<fo:table-cell text-align="left" number-columns-spanned="17" 
				xsl:use-attribute-sets="cell-style text-bold">
				<fo:block>
					<xsl:value-of select="'Gesamt Übersicht'" />	
				</fo:block>
			</fo:table-cell>
		
		</fo:table-row>

		<xsl:for-each select="$departments">
			<xsl:variable name="departmentNo" select="department_no"/>

				<fo:table-row>
					<fo:table-cell text-align="left" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="department_nm"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data[r_department_no=$departmentNo]/r_total),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data[r_department_no=$departmentNo]/r_amount_customer),'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data[r_department_no=$departmentNo]/r_total) div sum($data[r_department_no=$departmentNo]/r_amount_customer),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare[r_department_no=$departmentNo]/r_total),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer),'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare[r_department_no=$departmentNo]/r_total) div sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					
				
					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_total)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_total)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_total)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_total)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_total) div sum($data[r_department_no=$departmentNo]/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_total) div sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				

					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_total) div sum($data[r_department_no=$departmentNo]/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_total) div sum($dataCompare[r_department_no=$departmentNo]/r_amount_customer)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data[r_department_no=$departmentNo]/r_rebate) +  sum($rebate[r_department_no=$departmentNo]/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="format-number(sum($dataCompare[r_department_no=$departmentNo]/r_rebate) +  sum($rebateCompare[r_department_no=$departmentNo]/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>

					<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_rebate) +  sum($rebate[r_department_no=$departmentNo]/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_rebate) +  sum($rebateCompare[r_department_no=$departmentNo]/r_rebate)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data[r_department_no=$departmentNo]/r_rebate) +  sum($rebate[r_department_no=$departmentNo]/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_department_no=$departmentNo]/r_rebate) +  sum($rebateCompare[r_department_no=$departmentNo]/r_rebate)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>



		</xsl:for-each>


		<fo:table-row>
			<fo:table-cell text-align="left" 
				xsl:use-attribute-sets="cell-style-no-border">
				<fo:block>
					<xsl:value-of select="''"/>	
				</fo:block>
			</fo:table-cell>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_total),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_amount_customer),'###.##0,##' , 'amount')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_total) div sum($data/r_amount_customer),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_total),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_amount_customer),'###.##0,##' , 'amount')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			
		
			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_total)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_total)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_amount_customer)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_amount_customer)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
				<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
				<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
				<xsl:with-param name="format" select="'money'"/>
				<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		

			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
			
			
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
					<xsl:value-of select="format-number(sum($data/r_rebate) +  sum($rebate/r_rebate),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block>
						<xsl:value-of select="format-number(sum($dataCompare/r_rebate) + sum($rebateCompare/r_rebate),'###.##0,00' , 'money')"/>
				</fo:block>
			</fo:table-cell>

			<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data/r_rebate) + sum( $rebate/r_rebate)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
			</xsl:call-template>
		
			<fo:table-cell text-align="center"  
				xsl:use-attribute-sets="cell-style">
				<fo:block >
					<xsl:call-template name="prozentAbw">
						<xsl:with-param name="data" select="sum($data/r_rebate) +  sum($rebate/r_rebate)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>



	</xsl:template>


	<xsl:template name="displayCompany">
		<xsl:param name="dateFrom" />
		<xsl:param name="dateTo" />
		<xsl:param name="companyNm" />
		<xsl:param name="departments" />
		<xsl:param name="businessunits" />
		<xsl:param name="data" />
		<xsl:param name="dataCompare" />
		<xsl:param name="rebate" />
		<xsl:param name="rebateCompare" />

		
		<fo:table page-break-after="always">
			<fo:table-column column-width="14%"></fo:table-column>
			<fo:table-column column-width="8%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="8%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="7%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>

			<fo:table-header>
				<!-- company name-->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="th3bold">
						<fo:block>
							<xsl:value-of select="$companyNm"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
				<!-- leere Zeile -->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
				<!-- Überschrift 1 -->
				<fo:table-row>
					<fo:table-cell text-align="center" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center" number-columns-spanned="3" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Zeitraum'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="3" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Vorjahr'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="6" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Differenz'"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="4" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Rabatte'"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<!-- Überschrift 2 -->
				<fo:table-row>
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style" number-columns-spanned="2" >
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					
					
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Zeitraum'"/>
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Vorjahr'"/>
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center" number-columns-spanned="2" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Differenz'"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!-- Überschrift 3 -->
				<fo:table-row>
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'Diff'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
				
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'Diff'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>



					<!-- leere Zeile -->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
			
			</fo:table-header>

			<fo:table-body>
				<xsl:for-each select="$departments">
					<xsl:variable name="departmentNo" select="department_no"/>
			
								
								
					<xsl:call-template name="displayDepartment">
					
						<xsl:with-param name="departmentNm" select="$departments[department_no=$departmentNo]/department_nm"/>
						<xsl:with-param name="businessunits" select="$businessunits[department_no=$departmentNo]"/>
						<xsl:with-param name="data" select="$data[r_department_no=$departmentNo]"/>
						<xsl:with-param name="dataCompare" select="$dataCompare[r_department_no=$departmentNo]"/>
						<xsl:with-param name="rebate" select="$rebate[r_department_no=$departmentNo]"/>
						<xsl:with-param name="rebateCompare" select="$rebateCompare[r_department_no=$departmentNo]"/>
					</xsl:call-template>
					<!-- leere Zeile -->
					<fo:table-row>
						<fo:table-cell text-align="left" number-columns-spanned="17" 
							xsl:use-attribute-sets="cell-style-no-border">
							<fo:block>
								<xsl:value-of select="''"/>
							</fo:block>
						</fo:table-cell>
					
					</fo:table-row>
				
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>

				<xsl:call-template name="displayCompanyTotal">
					<xsl:with-param name= "departments" select="$departments" />
					<xsl:with-param name= "data" select="$data" />
					<xsl:with-param name= "dataCompare" select="$dataCompare" />
					<xsl:with-param name= "rebate" select="$rebate" />
					<xsl:with-param name= "rebateCompare" select="$rebateCompare" />
				</xsl:call-template>	

				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
			</fo:table-body>

		</fo:table>







	</xsl:template>
								



	<xsl:template name="displayOverviewCompanies">
		<xsl:param name="dateFrom" />
		<xsl:param name="dateTo" />
		<xsl:param name="companies" />
		<xsl:param name="data" />
		<xsl:param name="dataCompare" />
		<xsl:param name="rebate" />
		<xsl:param name="rebateCompare" />

		
		<fo:table>
			<fo:table-column column-width="14%"></fo:table-column>
			<fo:table-column column-width="8%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="8%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="7%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>
			<fo:table-column column-width="5%"></fo:table-column>

			<fo:table-header>
				<!-- company name-->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="th3bold">
						<fo:block>
							<xsl:value-of select="'Gesamtübersicht'"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
				<!-- leere Zeile -->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
				<!-- Überschrift 1 -->
				<fo:table-row>
					<fo:table-cell text-align="center" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center" number-columns-spanned="3" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Zeitraum'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="3" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Vorjahr'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="6" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Differenz'"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-columns-spanned="4" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Rabatte'"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<!-- Überschrift 2 -->
				<fo:table-row>
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Umsatz'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'Besuche'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style" number-columns-spanned="2" >
						<fo:block>
								<xsl:value-of select="'Umsatz pro Besuch'"/>	
						</fo:block>
					</fo:table-cell>
					
					
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Zeitraum'"/>
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center" number-rows-spanned="2" display-align="center"
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Vorjahr'"/>
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell text-align="center" number-columns-spanned="2" 
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="'Differenz'"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!-- Überschrift 3 -->
				<fo:table-row>
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'Diff'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
				
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'Diff'"/>	
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style"  >
						<fo:block>
								<xsl:value-of select="'%'"/>	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>



					<!-- leere Zeile -->
				<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
			
			</fo:table-header>

			<fo:table-body>
			<fo:table-row>
					<fo:table-cell text-align="left" number-columns-spanned="17" 
						xsl:use-attribute-sets="cell-style text-bold">
						<fo:block>
							<xsl:value-of select="'Gesamt Übersicht'" />	
						</fo:block>
					</fo:table-cell>
				
				</fo:table-row>
		
				<xsl:for-each select="$companies">
					<xsl:variable name="companyNo" select="company_no"/>
		
		
					<xsl:choose>
						<xsl:when test="not($data[r_company_no=$companyNo]) and not($dataCompare[r_company_no=$companyNo])">
						</xsl:when>
						<xsl:otherwise>
		
						<fo:table-row>
							<fo:table-cell text-align="left" 
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="company_nm"/>	
								</fo:block>
							</fo:table-cell>
						
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($data[r_company_no=$companyNo]/r_total),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($data[r_company_no=$companyNo]/r_amount_customer),'###.##0,##' , 'amount')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($data[r_company_no=$companyNo]/r_total) div sum($data[r_company_no=$companyNo]/r_amount_customer),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($dataCompare[r_company_no=$companyNo]/r_total),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($dataCompare[r_company_no=$companyNo]/r_amount_customer),'###.##0,##' , 'amount')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($dataCompare[r_company_no=$companyNo]/r_total) div sum($dataCompare[r_company_no=$companyNo]/r_amount_customer),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
							
						
							<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_total)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_total)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
							</xsl:call-template>
						
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block >
									<xsl:call-template name="prozentAbw">
										<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_total)"/>
										<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_total)"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
		
							<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_amount_customer)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
							</xsl:call-template>
						
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block >
									<xsl:call-template name="prozentAbw">
										<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_amount_customer)"/>
										<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_amount_customer)"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
		
							<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_total) div sum($data[r_company_no=$companyNo]/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_total) div sum($dataCompare[r_company_no=$companyNo]/r_amount_customer)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
							</xsl:call-template>
						
		
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block >
									<xsl:call-template name="prozentAbw">
										<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_total) div sum($data[r_company_no=$companyNo]/r_amount_customer)"/>
										<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_total) div sum($dataCompare[r_company_no=$companyNo]/r_amount_customer)"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
							
							
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
									<xsl:value-of select="format-number(sum($data[r_company_no=$companyNo]/r_rebate) +  sum($rebate[r_company_no=$companyNo]/r_rebate),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block>
										<xsl:value-of select="format-number(sum($dataCompare[r_company_no=$companyNo]/r_rebate) +  sum($rebateCompare[r_company_no=$companyNo]/r_rebate),'###.##0,00' , 'money')"/>
								</fo:block>
							</fo:table-cell>
		
							<xsl:call-template name="differenzCell">
										<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_rebate) +  sum($rebate[r_company_no=$companyNo]/r_rebate)"/>
										<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_rebate) +  sum($rebateCompare[r_company_no=$companyNo]/r_rebate)"/>
										<xsl:with-param name="format" select="'money'"/>
										<xsl:with-param name="pattern" select="'###.##0,00'"/>
							</xsl:call-template>
						
							<fo:table-cell text-align="center"  
								xsl:use-attribute-sets="cell-style">
								<fo:block >
									<xsl:call-template name="prozentAbw">
										<xsl:with-param name="data" select="sum($data[r_company_no=$companyNo]/r_rebate) +  sum($rebate[r_company_no=$companyNo]/r_rebate)"/>
										<xsl:with-param name="dataCompare" select="sum($dataCompare[r_company_no=$companyNo]/r_rebate) +  sum($rebateCompare[r_company_no=$companyNo]/r_rebate)"/>
									</xsl:call-template>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
		
				</xsl:otherwise>
				</xsl:choose>
		
				</xsl:for-each>
		
		
				<fo:table-row>
					<fo:table-cell text-align="left" 
						xsl:use-attribute-sets="cell-style-no-border">
						<fo:block>
							<xsl:value-of select="''"/>	
						</fo:block>
					</fo:table-cell>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data/r_total),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data/r_amount_customer),'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data/r_total) div sum($data/r_amount_customer),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare/r_total),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare/r_amount_customer),'###.##0,##' , 'amount')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					
				
					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data/r_total)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data/r_total)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
		
					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_amount_customer)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
		
					<xsl:call-template name="differenzCell">
						<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
						<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
						<xsl:with-param name="format" select="'money'"/>
						<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
		
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data/r_total) div sum($data/r_amount_customer)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare/r_total) div sum($dataCompare/r_amount_customer)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					
					
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
							<xsl:value-of select="format-number(sum($data/r_rebate) +  sum($rebate/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block>
								<xsl:value-of select="format-number(sum($dataCompare/r_rebate) + sum($rebateCompare/r_rebate),'###.##0,00' , 'money')"/>
						</fo:block>
					</fo:table-cell>
		
					<xsl:call-template name="differenzCell">
								<xsl:with-param name="data" select="sum($data/r_rebate) + sum( $rebate/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
								<xsl:with-param name="format" select="'money'"/>
								<xsl:with-param name="pattern" select="'###.##0,00'"/>
					</xsl:call-template>
				
					<fo:table-cell text-align="center"  
						xsl:use-attribute-sets="cell-style">
						<fo:block >
							<xsl:call-template name="prozentAbw">
								<xsl:with-param name="data" select="sum($data/r_rebate) +  sum($rebate/r_rebate)"/>
								<xsl:with-param name="dataCompare" select="sum($dataCompare/r_rebate) +  sum($rebateCompare/r_rebate)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>


			</fo:table-body>

		</fo:table>







	</xsl:template>






	<xsl:template match="/">



		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="20mm">
					<fo:region-body margin-top="10mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">

				    <xsl:call-template name="header">
						<xsl:with-param name="title" select='"Hitliste Salongruppe BV"' />
						
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
					</xsl:call-template>

				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
								<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Hitliste Salongruppe BV von &#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											&#160;bis&#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:for-each select="report/companies/row">
							<xsl:variable name="companyNo" select="company_no"/>
							<xsl:choose>
								<xsl:when test="not(/report/posRevenue/sumBuRevenueSalon/data/row[r_company_no=$companyNo]) and not(report/posRevenue/sumPrevYearBuRevenueSalon/data/row[r_company_no=$companyNo])">
									
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="displayCompany">
										<xsl:with-param name="dateFrom" select="/report/report-params/DATE" />
										<xsl:with-param name="dateTo" select="/report/report-params/TODATE" />
										<xsl:with-param name="companyNm" select="company_nm"/>
										<xsl:with-param name="departments" select="/report/departments/row[company_no=$companyNo]"/>
										<xsl:with-param name="businessunits" select="/report/businessunits/row[company_no=$companyNo]"/>
										<xsl:with-param name="data" select="/report/posRevenue/sumBuRevenueSalon/data/row[r_company_no=$companyNo]"/>
										<xsl:with-param name="dataCompare" select="/report/posRevenue/sumPrevYearBuRevenueSalon/data/row[r_company_no=$companyNo]"/>
										<xsl:with-param name="rebate" select="/report/disounts/row[r_company_no=$companyNo]"/>
										<xsl:with-param name="rebateCompare" select="/report/disountsPrevYear/row[r_company_no=$companyNo]"/>
									</xsl:call-template>
								
																
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					
						<xsl:call-template name="displayOverviewCompanies">
							<xsl:with-param name="dateFrom" select="/report/report-params/DATE" />
							<xsl:with-param name="dateTo" select="/report/report-params/TODATE" />
							<xsl:with-param name="companies" select="/report/companies/row"/>
							<xsl:with-param name="data" select="/report/posRevenue/sumBuRevenueSalon/data/row"/>
							<xsl:with-param name="dataCompare" select="/report/posRevenue/sumPrevYearBuRevenueSalon/data/row"/>
							<xsl:with-param name="rebate" select="/report/disounts/row"/>
							<xsl:with-param name="rebateCompare" select="/report/disountsPrevYear/row"/>
						</xsl:call-template>
					
					
					
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>



	</xsl:template>



</xsl:stylesheet>