<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="barcode date exsl">


	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	
	<xsl:attribute-set name="row">
		<xsl:attribute name="padding-top">2mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">2mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">1mm</xsl:attribute>
		<xsl:attribute name="padding-left">0mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.0mm</xsl:attribute>
		<xsl:attribute name="background-color">#ffffff</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>







	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4" page-height="21cm" page-width="14.9cm" margin-top="0mm" margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="10mm" margin-bottom="5mm" margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="0mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title">
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:block>&#160;</fo:block>
						<fo:block>&#160;</fo:block>
						<fo:block>&#160;</fo:block>

						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>

								<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>

					</fo:block>
				</fo:static-content>


				<fo:flow flow-name="xsl-region-body">
				
					<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
				
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="50%"></fo:table-column>
						<fo:table-column column-width="50%"></fo:table-column>


						<fo:table-body>
						<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
							<fo:table-row >
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:table table-layout="fixed" width="84mm">
										<fo:table-column column-width="32mm"></fo:table-column>
										<fo:table-column column-width="3mm"></fo:table-column>
										<fo:table-column column-width="49mm"></fo:table-column>

										<fo:table-body>
										<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														Kundenname
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2"  font-weight="bold">
													<fo:block  font-weight="bold">
														<xsl:choose>
															<xsl:when test="report/contact/row/first_nm != ''">
																<xsl:value-of select="report/contact/row/first_nm" />&#160;
																<xsl:value-of select="report/contact/row/contact_nm" />
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="report/contact/row/contact_nm" />
															</xsl:otherwise>
														</xsl:choose>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														Kundennummer
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														<xsl:value-of select="report/contact/row/contact_no" />
													</fo:block>
													
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														Kundengruppe
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">

													<fo:block>
														<xsl:value-of select="report/contact/row/customer_group_nm" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														Adresse
													</fo:block>
												</fo:table-cell>
											<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell2">
													<fo:block>
														:
													</fo:block>
												</fo:table-cell>
											<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
												<fo:block overflow="hidden">
													<xsl:value-of select="report/contact/row/street" />&#x2028;
													<xsl:choose>
														<xsl:when test="report/contact/row/postal_cd != ''">
															<xsl:value-of select="report/contact/row/postal_cd" />&#160;
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="report/contact/row/postal_cd" />
														</xsl:otherwise>
													</xsl:choose>
													
													<xsl:value-of select="report/contact/row/city" />&#x2028;
													<xsl:value-of select="report/contact/row/country_cd" />
												</fo:block>
											</fo:table-cell>
							</fo:table-row>
							
					
							
						</fo:table-body>


					</fo:table>
					</fo:table-cell>
				
					<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell2">
									<fo:table table-layout="fixed" width="84mm">
										<fo:table-column column-width="32mm"></fo:table-column>
										<fo:table-column column-width="3mm"></fo:table-column>
										<fo:table-column column-width="49mm"></fo:table-column>

										<fo:table-body>
										<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
											
							
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Telefon
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									
									<fo:block>
										<xsl:value-of select="report/contact/row/phone" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Mobiltelefon
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									
									<fo:block>
										<xsl:value-of select="report/contact/row/mobile" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Email
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									
									<fo:block>
										<xsl:value-of select="report/contact/row/email" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Geburtstag
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									
									<fo:block>
										<xsl:call-template name="formatdate">
											<xsl:with-param name="datestr" select="report/contact/row/birthday" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						<fo:table-row>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										Notiz
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left" xsl:use-attribute-sets="cell2">
									
									<fo:block linefeed-treatment="preserve">
										<xsl:value-of select="report/contact/row/comment" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
						</fo:table-body>
						
						
					</fo:table>
					</fo:table-cell>
					</fo:table-row>
					</fo:table-body>							
	</fo:table>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>
						<fo:table-body>
						<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>

						<xsl:variable name="cards" select="exsl:node-set(/report/contactDataReport/data/conditions)" />
						<xsl:if test="count($cards/condition) != 0">
						<!-- Kundenkarten -->
							<fo:table-row >
								<fo:table-cell text-align="left" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" number-columns-spanned="2" xsl:use-attribute-sets="table-title">
									<fo:block>Kundenkarten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="33mm"></fo:table-column>
											<fo:table-column column-width="38mm"></fo:table-column>
											<fo:table-column column-width="28mm"></fo:table-column>
											<fo:table-column column-width="28mm"></fo:table-column>
											
											<fo:table-body>
											<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
												<fo:table-row  >
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" padding-left="2mm">
														<fo:block>Kartennummer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Name</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>gültig ab</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>gültig bis</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
												
												<xsl:for-each select="/report/contactDataReport/data/conditions/condition">
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#d9d9d9</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" padding-left="2mm">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:choose>
														            <xsl:when test="cardNo != ''"><xsl:value-of select="cardNo" /></xsl:when>
														            <xsl:otherwise>Keine</xsl:otherwise>
														        </xsl:choose>
														
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block margin-top="2mm" margin-bottom="2mm">
															<xsl:value-of select="conditionNm" />
																<xsl:choose>
														            <xsl:when test="contractNo = '4'">&#160;-&#160;(<xsl:value-of select="salesCreditPoints"/>)</xsl:when>
														        </xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr" select="validFrom" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr"
																		select="validTo" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
						<xsl:variable name="treatments" select="exsl:node-set(/report/contactDataReport/data/treatments)" />
						<xsl:if test="count($treatments/treatment) != 0">
							<!-- Behandlungen -->
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left" number-columns-spanned="2"
									xsl:use-attribute-sets="table-title">
									<fo:block>Letzte Behandlungen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="39mm"></fo:table-column>
											<fo:table-column column-width="50mm"></fo:table-column>
											
											<fo:table-body>
											<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" padding-left="2mm">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Bereich</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Behandlung</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" margin-left="5mm">
														<fo:block>Mitarbeiter</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
												
											<xsl:for-each select="/report/contactDataReport/data/treatments/treatment">
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#d9d9d9</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}" >
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" padding-left="2mm" margin-top="2mm" margin-bottom="2mm" number-columns-spanned="4">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																
																	<xsl:value-of select="treatmentBuNm" />
																
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" padding-left="2mm" margin-top="2mm" margin-bottom="2mm">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr" select="treatmentTs" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<xsl:for-each select="treatmentGroups/treatmentGroup">
																<fo:block margin-top="2mm" margin-bottom="2mm">
																	<xsl:value-of select="treatmentGroupName" />
																</fo:block>
																<xsl:for-each select="treatmentGroupFields/field">
																	<fo:block margin-top="2mm" margin-bottom="2mm" wrap-option="wrap">
																		&#160;
																	</fo:block>
																</xsl:for-each>
															</xsl:for-each>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" margin-top="2mm" margin-bottom="2mm">
															<xsl:for-each select="treatmentGroups/treatmentGroup">
																<xsl:for-each select="treatmentGroupFields/field">
																	<fo:block margin-top="2mm" margin-bottom="2mm" wrap-option="wrap">
																		<xsl:value-of select="fieldName" />: <xsl:value-of select="fieldValue" />
																	</fo:block>
																</xsl:for-each>

																<xsl:choose>
																	<xsl:when test="treatmentGroupComment != ''">
																	<fo:block margin-top="2mm" margin-bottom="2mm" wrap-option="wrap">
																		Kommentar: <xsl:value-of select="treatmentGroupComment" />
																	</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		&#160;
																	</xsl:otherwise>
																</xsl:choose>
																
															</xsl:for-each>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" margin-top="2mm" margin-bottom="2mm" margin-left="6mm">
															<xsl:for-each select="treatmentGroups/treatmentGroup">
																<fo:block margin-top="2mm" margin-bottom="2mm">
																	<xsl:value-of select="treatmentGroupEmployee" />
																</fo:block>
																<xsl:for-each select="treatmentGroupFields/field">
																	<fo:block margin-top="2mm" margin-bottom="2mm" wrap-option="wrap">
																		&#160;
																	</fo:block>
																</xsl:for-each>
															</xsl:for-each>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:variable name="visits" select="exsl:node-set(/report/contactDataReport/data/notes)" />
						<xsl:if test="count($visits/salesInvoice) != 0">	
							<!-- Besuche -->
							<fo:table-row>
								<fo:table-cell text-align="left" number-columns-spanned="2"
									xsl:use-attribute-sets="table-title">
									<fo:block>Letze Besuche</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row >
								<fo:table-cell number-columns-spanned="2"  keep-together="auto" >
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="41mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="48mm"></fo:table-column>
											
											<fo:table-body>
											<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title"  padding-left="2mm">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Positionen</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" margin-left="2cm">
														<fo:block>Mitarbeiter</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<!--Notes-->
												<xsl:for-each select="/report/contactDataReport/data/notes/salesInvoice">
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#d9d9d9</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}"  >
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center" padding-left="2mm"> 
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr" select="salesInvoiceTs" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<!--Positionen-->
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" number-columns-spanned="3">
															<fo:block-container margin-top="2mm" margin-bottom="2mm">
															<fo:table table-layout="fixed" width="100%">
																<fo:table-column column-width="6mm"></fo:table-column>
																<fo:table-column column-width="35mm"></fo:table-column>
																<fo:table-column column-width="19mm"></fo:table-column>
																<fo:table-column column-width="48mm"></fo:table-column>
																<fo:table-body>
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block></fo:block>
																	</fo:table-cell>
																</fo:table-row>
																	<xsl:for-each select="positions/position">
																		<fo:table-row >
																			<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center">
																				<fo:block >
																					<xsl:value-of select="format-number(amount, '0')" />x
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center">
																				<fo:block >
																					<xsl:value-of select="name" />
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="right" xsl:use-attribute-sets="cell" display-align="center">
																				<fo:block >
																					
																					<xsl:value-of select="value"/>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" margin-left="2.1cm" display-align="center">
																				<fo:block >
																					<xsl:value-of select="employees" />
																				</fo:block>
																			</fo:table-cell>																			
																		</fo:table-row>
																		<xsl:for-each select="packagePositions/position">
																			<fo:table-row >
																				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center">
																					<fo:block >
																						
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center" padding-left="5mm">
																					<fo:block >
																						<xsl:value-of select="name" />
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell text-align="right" xsl:use-attribute-sets="cell" display-align="center">
																					<fo:block >
																						
																						<xsl:value-of select="value"/>
																						
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" margin-left="2.1cm" display-align="center">
																					<fo:block >
																						<xsl:value-of select="employees" />
																					</fo:block>
																				</fo:table-cell>																			
																			</fo:table-row>
																		</xsl:for-each>

																	</xsl:for-each>
																</fo:table-body>
															</fo:table>
															</fo:block-container>

														</fo:table-cell>

													</fo:table-row>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
						<xsl:variable name="products" select="exsl:node-set(/report/contactDataReport/data/products)" />
						<xsl:if test="count($products/product) != 0">
							<!-- Produkte -->
							<fo:table-row>
								<fo:table-cell text-align="left" number-columns-spanned="2"
									xsl:use-attribute-sets="table-title">
									<fo:block>Produktverkauf</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
									<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="6mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="48mm"></fo:table-column>
											
											<fo:table-body>
											<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>
												<fo:table-row>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title"  padding-left="2mm">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" number-columns-spanned="2">
														<fo:block>Positionen</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-title" >
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title" margin-left="2cm">
														<fo:block>Mitarbeiter</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<!--Notes-->
												<xsl:for-each select="/report/contactDataReport/data/products/product">
													 <xsl:variable name="salesInvPositionId" >												
													   <xsl:value-of select="sales_inv_position_id" />
													</xsl:variable>
	                                                <xsl:variable name="salesInvId" >												
													   <xsl:value-of select="sales_inv_id" />
													</xsl:variable>
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#d9d9d9</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}" >
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" padding-left="2mm" display-align="center">
															<fo:block margin-top="2mm" margin-bottom="2mm">
																<xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr" select="date" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center">
															<fo:block >
																<xsl:value-of select="amount" />x
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" display-align="center">
															<fo:block >
																<xsl:value-of select="item_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right" xsl:use-attribute-sets="cell" display-align="center" >
															<fo:block >
																<xsl:value-of select="format-number(value, '###.##0,00', 'money')" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell" margin-left="2cm" display-align="center">
															<fo:block >
																<xsl:value-of select="employees" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>	
							
						</fo:table-body>
					</fo:table>
					
					
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>