<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
	extension-element-prefixes="barcode date exsl fox" xmlns:csv="csv:csv">


	<xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	
	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<!-- <xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>-->
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="right-cell-style">
	
		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bottom-cell-style">
	
		<xsl:attribute name="border-bottom-color">#000000</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1px</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


<xsl:template name="employee-row-data">
	<xsl:param name="title"/>
	<xsl:param name="data"/>
	<xsl:param name="dataCompare"/>
	<xsl:param name="formatPattern" select="'###.##0,00'" />
	<xsl:param name="format" select="'money'" />
	<xsl:param name="sign" select="''" />
	<xsl:param name="grey_bg" select="'#ffffff'" />
	<xsl:param name="borderBottom" select="'none'" />

	
		


	
	<fo:table-cell text-align="center" background-color="{$grey_bg}"  border-bottom="{$borderBottom}"
			xsl:use-attribute-sets= "cell-style0" > 
		<fo:block>
				<xsl:value-of select="format-number($data, $formatPattern, $format)" /><xsl:value-of select="$sign" />
		</fo:block>
	</fo:table-cell>
	
	<fo:table-cell text-align="center" background-color="{$grey_bg}" border-bottom="{$borderBottom}"
		 xsl:use-attribute-sets="cell-style0">
		<fo:block>
			<xsl:value-of select="format-number($dataCompare, $formatPattern, $format)" /><xsl:value-of select="$sign" />
		</fo:block>
	</fo:table-cell>
	<fo:table-cell text-align="center" background-color="{$grey_bg}"  border-bottom="{$borderBottom}"
		 xsl:use-attribute-sets="cell-style0">
		<fo:block>
			<xsl:choose>
				<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
					<xsl:value-of select="format-number(0, $formatPattern, $format)"/><xsl:value-of select="$sign" />
				</xsl:when>
				<xsl:when test="string(number($dataCompare)) = 'NaN'">
					<xsl:value-of select="format-number($data, $formatPattern, $format)"/><xsl:value-of select="$sign" />
				</xsl:when>
				<xsl:when test="string(number($data)) = 'NaN'">
					<xsl:value-of select="format-number(0 -$dataCompare, $formatPattern, $format)"/><xsl:value-of select="$sign" />
				</xsl:when>
				<xsl:otherwise>
						<xsl:value-of select="format-number($data - $dataCompare, $formatPattern, $format)" /><xsl:value-of select="$sign" />
				</xsl:otherwise>
			</xsl:choose>
	
		</fo:block>
	</fo:table-cell>
	<fo:table-cell text-align="center" background-color="{$grey_bg}"  border-bottom="{$borderBottom}"
		 xsl:use-attribute-sets="cell-style0 right-cell-style">
		<fo:block>
				<xsl:choose>
					<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($dataCompare)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($data)) = 'NaN'">
						<xsl:value-of select="format-number(0 ,'###.##0,##' , 'percent')"/>%
					</xsl:when>
					<xsl:when test="$dataCompare = 0">
						<xsl:value-of select="'-'" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((($data div $dataCompare ) -1) * 100 ,'###.##0,##' , 'percent')"/>%
					</xsl:otherwise>
				</xsl:choose>
		</fo:block>
	</fo:table-cell>



	</xsl:template>


	<xsl:template name="main-table">
		<xsl:param name="dataList"/>
		<xsl:param name="businessunits" />
	

		<xsl:variable name="greyBGColor" select="'#CCCCCC'"/>

		<fo:table table-layout="fixed" border-collapse="collapse"
			width="100%" margin-top="0cm">
			
			<fo:table-column column-width="15mm"></fo:table-column>
			<fo:table-column column-width="30mm"></fo:table-column>

			<xsl:for-each select="$dataList">
				<fo:table-column ></fo:table-column>
				<fo:table-column ></fo:table-column>
				<fo:table-column ></fo:table-column>
				<fo:table-column ></fo:table-column>
			</xsl:for-each>

					

			<fo:table-header>
				<fo:table-row>

					<fo:table-cell text-align="center"
						number-columns-spanned="2" xsl:use-attribute-sets="cell-style0  right-cell-style">
						<fo:block></fo:block>
					</fo:table-cell>

					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<fo:table-cell text-align="center"
							number-columns-spanned="4" xsl:use-attribute-sets="cell-style0">
							<fo:block>
								<xsl:choose>
									<xsl:when test="$posCd = '-100'">
										<xsl:value-of select="'Gesamt'"/>
									</xsl:when>
									<xsl:otherwise>
									<xsl:value-of select="$businessunits[pos_cd_hint = $posCd]/businessunit_nm"/>
									</xsl:otherwise>
								</xsl:choose>
		
							</fo:block>
						</fo:table-cell>
					
						
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>

					<fo:table-cell text-align="center"
						number-columns-spanned="2" xsl:use-attribute-sets="cell-style0  bottom-cell-style right-cell-style">
						<fo:block></fo:block>
					</fo:table-cell>

					<xsl:for-each select="$dataList">
						<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
							<fo:block>
								<xsl:value-of select="'Zeitraum'"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
							<fo:block>
								<xsl:value-of select="'Vorjahr'"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
							<fo:block>
								<xsl:value-of select="'Differenz'"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style  bottom-cell-style">
							<fo:block>
								<xsl:value-of select="'%'"/>
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
				</fo:table-row>	

			</fo:table-header>	

			<fo:table-body>

				<!--Arbeitstage -->
					<fo:table-row> 	
					<fo:table-cell text-align="center" display-align="center" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block></fo:block>
					</fo:table-cell>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Arbeitstage'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	



				<!-- Damen -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="7" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>Damen</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total_g1"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g1"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total_g1 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g1 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_group1"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group1"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_group1 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group1 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total_g1 div r_amount_group1"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g1 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group1"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>

				<fo:table-row>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'% Anteil Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_total_g1 div r_total * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g1 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total * 100"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	
		
				<fo:table-row> 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'% Anteil Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_amount_group1 div r_amount_customer * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group1 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer * 100"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	


				<!-- Herren -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="7" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>Herren</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total_g2"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g2"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
							<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total_g2 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g2 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_group2"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group2"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_group2 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group2 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total_g2 div r_amount_group2"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g2 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group2"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>

				<fo:table-row>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'% Anteil Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_total_g2 div r_total * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g2 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total  * 100"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	
		
				<fo:table-row> 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'% Anteil Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
					<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_amount_group2 div r_amount_customer * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group2 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer * 100"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	


				<!-- Kinder -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="7" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>Kinder</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total_g3"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g3"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
							<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>	
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total_g3 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g3 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_group3"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group3"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_group3 div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group3 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total_g3 div r_amount_group3"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g3 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group3"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>

				<fo:table-row>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'% Anteil Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_total_g3 div r_total * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_g3 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total * 100"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	
		
				<fo:table-row> 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'% Anteil Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_amount_group3 div r_amount_customer * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_group3 div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer * 100"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	

				<!-- DL Gesamt -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="7" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>DL Gesamt</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total_services"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_services"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
							<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total_services div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_services div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_customer_service"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_service"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_customer_service div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_service div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total_services div r_amount_customer_service"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_services div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_service"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>

				<fo:table-row>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'% Anteil Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_total_services div r_total * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_services div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total * 100"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	
		
				<fo:table-row> 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'% Anteil Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_amount_customer_service div r_amount_customer * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_service div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer * 100"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	

				<!-- Verkauf -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="7" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>Verkauf</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total_products"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_products"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
							<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total_products div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_products div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_customer_product"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_product"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_customer_product div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_product div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total_products div r_amount_customer_product"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_products div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_product"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>

				<fo:table-row>	
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'% Anteil Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_total_products div r_total * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total_products div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total * 100"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	
		
				<fo:table-row> 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'% Anteil Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'% Anteil Umsatz'"/>
							<xsl:with-param name="data" select="r_amount_customer_product div r_amount_customer * 100"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer_product div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer * 100"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>					
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>			
					</xsl:for-each>
				</fo:table-row>	



				<!-- Gesamt -->
				<fo:table-row>
					<fo:table-cell text-align="center" display-align="center" number-rows-spanned="5" xsl:use-attribute-sets="cell-style0 bottom-cell-style">
						<fo:block>Gesamt</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
								<xsl:with-param name="title" select="'Umsatz'"/>
								<xsl:with-param name="data" select="r_total"/>
								<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total"/>
								<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
							<fo:block><xsl:value-of select="'Umsatz pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Tag'"/>
							<xsl:with-param name="data" select="r_total div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Besuche'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche'"/>
							<xsl:with-param name="data" select="r_amount_customer"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>	 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style">
						<fo:block><xsl:value-of select="'Besuche pro Tag'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Besuche pro Tag'"/>
							<xsl:with-param name="data" select="r_amount_customer div r_cnt_dt"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_cnt_dt"/>
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-row>	

				<fo:table-row>		 		
					<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style  bottom-cell-style" background-color="{$greyBGColor}">
						<fo:block><xsl:value-of select="'Umsatz pro Besuch'"/></fo:block>
					</fo:table-cell>
					<xsl:for-each select="$dataList">
						<xsl:variable name="posCd" select="r_pos_cd"/>
						<xsl:call-template name="employee-row-data" >
							<xsl:with-param name="title" select="'Umsatz pro Besuch'"/>
							<xsl:with-param name="data" select="r_total div r_amount_customer"/>
							<xsl:with-param name="dataCompare" select="/report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_total div /report/periodenExpert/comparePeriod/data/table/row[r_pos_cd=$posCd]/r_amount_customer"/>
							<xsl:with-param name="grey_bg" select="$greyBGColor"/>
							<xsl:with-param name="borderBottom" select="'solid 1pt #000000'" />
						</xsl:call-template>				
					</xsl:for-each>
				</fo:table-row>



			</fo:table-body>	


		</fo:table>




	</xsl:template>
	
	<xsl:template match="/">

		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="10mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="10mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">
<fo:block>
<xsl:variable name="title">
				Periodenvergleich kompakt Filialen	<xsl:choose>
											<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
												(ausführende)
											</xsl:when>
										
											<xsl:otherwise>
												(beratende)
											</xsl:otherwise>
										</xsl:choose>				
</xsl:variable>
					<xsl:call-template name="header">
						<xsl:with-param name="title" select="$title"/>
						<xsl:with-param name="businessunit" select="report/businessunits" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
					</xsl:call-template>
</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Periodenvergleich kompakt Filialen	<xsl:choose>
											<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
												(ausführende)
											</xsl:when>
										
											<xsl:otherwise>
												(beratende)
											</xsl:otherwise>
										</xsl:choose>			
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
										-
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

				<xsl:for-each select="report/periodenExpert/period/data/table">
						<xsl:if test="position() > 1">
						<fo:block page-break-after="always"> 
						 </fo:block> 
						 </xsl:if>
						<xsl:call-template name="main-table">
							<xsl:with-param name="dataList" select="row"/>
							<xsl:with-param name="businessunits" select="/report/businessunits/row"/>
							
						</xsl:call-template>
					
					</xsl:for-each>


				
	
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>


	</xsl:template>



</xsl:stylesheet>