<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" 
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions" extension-element-prefixes="barcode date exsl fox">
   <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="th1Rotated">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>
	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="borderRotated">
		<xsl:attribute name="border-top-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableInnerSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
		<!-- <xsl:attribute name="font-weight">bold</xsl:attribute> -->
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableOuterSum" use-attribute-sets="cell-style">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderInnerSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#e6e6e6</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="tableHeaderOuterSum" use-attribute-sets="th1bold">
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="container_header">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.85cm</xsl:attribute>
	</xsl:attribute-set>
	
		<xsl:attribute-set name="containerHeader">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.00m</xsl:attribute>
		 <xsl:attribute name="width">3.0cm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	<xsl:attribute-set name="containerHeaderLabel">
		 <xsl:attribute name="position">absolute</xsl:attribute>
		 <xsl:attribute name="top">0.0cm</xsl:attribute>
		 <xsl:attribute name="margin-left">2mm</xsl:attribute>
		 <xsl:attribute name="keep-together">always</xsl:attribute>
		  <xsl:attribute name="padding-top">3mm</xsl:attribute>
		 
	</xsl:attribute-set>
	
	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template name="periodeCompareRow">
		<xsl:param name="compareValue" />
		<xsl:param name="baseValue" />
		<xsl:param name="title" /> 
		<xsl:param name="formatPattern" />
		<xsl:param name="format" />
		<xsl:param name="backgroundColor" select="'#ffffff'"/>
		<xsl:param name="fontWeight" select="'normal'" />
<xsl:param name="sign" select="''" />

		<fo:table-row background-color="{$backgroundColor}">
			<xsl:variable name="compareF">
				<xsl:value-of select="format-number($compareValue , $formatPattern, $format)" />
			</xsl:variable>
			<xsl:variable name="baseF">
				<xsl:value-of select="format-number($baseValue , $formatPattern, $format)" />
			</xsl:variable>

			<xsl:variable name="compare">
				<xsl:choose>
					<xsl:when test="$compareValue > 0">
						<xsl:value-of select="$compareValue" />
					</xsl:when>
					<xsl:otherwise>	
					0
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="base">
				<xsl:choose>
					<xsl:when test="$baseValue > 0">
						<xsl:value-of select="$baseValue" />
					</xsl:when>
					<xsl:otherwise>	
					0
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style0" font-weight="{$fontWeight}">
				<fo:block>
					<xsl:value-of select="$title" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style" number-columns-spanned="2" font-weight="{$fontWeight}">
				<fo:block>
					<xsl:value-of select="$compareF" /><xsl:value-of select="$sign" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style" number-columns-spanned="2" font-weight="{$fontWeight}">
				<fo:block>
					<xsl:value-of select="$baseF" /><xsl:value-of select="$sign" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style"  font-weight="{$fontWeight}">
				<fo:block>
					<xsl:choose>
						<xsl:when test="$compare > $base">
							-<xsl:value-of select="format-number($compare - $base, $formatPattern, $format)" /><xsl:value-of select="$sign" />
						</xsl:when>
						<xsl:when test="$base > $compare">
							<xsl:value-of select="format-number($base - $compare, $formatPattern, $format)" /><xsl:value-of select="$sign" />
						</xsl:when>
						<xsl:otherwise>
						0<xsl:value-of select="$sign" />
						</xsl:otherwise>	
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="right" xsl:use-attribute-sets="cell-style" font-weight="{$fontWeight}">
				<fo:block>
				<xsl:choose>
							<xsl:when test="$compare != 0">
								<xsl:value-of select="format-number(($base div $compare - 1) * 100, '###.##0,00', 'amount')" />%
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>-</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>

	</xsl:template>

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm" >
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">


				<xsl:variable name="title">
					Periodenvergleich				
				</xsl:variable>

					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								Zeitraum 1:&#160; 
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/DATE_COMPARE" />
								</xsl:call-template>
								&#160;-&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/TODATE_COMPARE" />
								</xsl:call-template>
							</content>
						</filterRow>
						<filterRow>
							<content>
								Zeitraum 2:&#160; 
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/DATE" />
								</xsl:call-template>
								&#160;-&#160;
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/TODATE" />
								</xsl:call-template>
							</content>
						</filterRow>
						<filterRow>
							<content>
								Modus:&#160; 
								<xsl:choose>
									<xsl:when test="report/report-params/EMPLOYEE_MODE = 'operatingEmployee'">
										Ausführender MA
									</xsl:when>
									<xsl:when test="report/report-params/EMPLOYEE_MODE = 'consultingEmployee'">
										Beratender MA
									</xsl:when>
									<xsl:otherwise>
										Salon
									</xsl:otherwise>
								</xsl:choose>	
							</content>
						</filterRow>
						<filterRow>
							<content>
								<xsl:choose>
									<xsl:when test="report/compareRevenueReport/reportMode = 'salon'">
										Ansicht: Salon
									</xsl:when>
									<xsl:otherwise>	
										Mitarbeiter: <xsl:value-of select="/report/employee/row/employee_nm" />
									</xsl:otherwise>
								</xsl:choose>
							</content>
						</filterRow>
					</xsl:variable>

				    <xsl:call-template name="header">
						<xsl:with-param name="title" select="$title" />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>

					
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="65%"></fo:table-column>
							<fo:table-column column-width="15%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Periodenvergleich zwischen
<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/DATE_COMPARE" />
								</xsl:call-template>
								-
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/TODATE_COMPARE" />
								</xsl:call-template>
				
											und
											
<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/DATE" />
								</xsl:call-template>
								-
								<xsl:call-template name="formatdate">
									<xsl:with-param name="datestr" select="report/report-params/TODATE" />
								</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:choose>
						<xsl:when test="report/compareRevenueReport/reportMode = 'salon'">
							<fo:table table-layout="fixed" border-collapse="collapse"
								width="100%" margin-top="0cm">
								<fo:table-column column-width="28%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								
								<fo:table-header >
									<fo:table-row>
									<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold-left">
												<fo:block>&#160;</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold" number-columns-spanned="2">
											<fo:block >
												Periode 1&#xA;
											</fo:block>

											<fo:block >
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="report/report-params/DATE_COMPARE" />
												</xsl:call-template>
												-
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="report/report-params/TODATE_COMPARE" />
												</xsl:call-template>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold" number-columns-spanned="2">
											<fo:block >
												Periode 2&#xA;
											</fo:block>

											<fo:block >
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="report/report-params/DATE" />
												</xsl:call-template>
												-
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="report/report-params/TODATE" />
												</xsl:call-template>
											</fo:block>
										</fo:table-cell> 
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold">
											<fo:block linefeed-treatment="preserve">Abweichung&#xA;absolut</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold">
											<fo:block linefeed-treatment="preserve">Abweichung&#xA;prozentual</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-header>
								
								<fo:table-body>
									<!-- Arbeisttage -->
									
									
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/dayCnt "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Arbeitstage'"/>
										<xsl:with-param name="formatPattern" select="'###.##0'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalGroup1Services "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalGroup1Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									

									<!-- DL Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalGroup2Services "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalGroup2Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Kind -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalGroup3Services "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalGroup3Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalServices "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalServices"/>
										<xsl:with-param name="title" select="'Umsatz DL Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Verkauf Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalProducts "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalProducts"/>
										<xsl:with-param name="title" select="'Umsatz Verkauf Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
								
									<!-- Umsatz Dame Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalG1 "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalG1"/>
										<xsl:with-param name="title" select="'Umsatz Damen Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

								
									<!-- Umsatz Herren Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalG2 "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalG2"/>
										<xsl:with-param name="title" select="'Umsatz Herren Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

									

									<!-- Umsatz Kinder Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalG3 "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalG3"/>
										<xsl:with-param name="title" select="'Umsatz Kinder Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									

									<!-- Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/total "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/total"/>
										<xsl:with-param name="title" select="'Umsatz Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
								

									<!-- Umsatz pro Tag -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/total div report/compareRevenueReport/compareRevenue/dayCnt"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/total  div report/compareRevenueReport/baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Ø Umsatz pro Tag'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								
									<!-- Verkaufsanteil -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="100 div report/compareRevenueReport/compareRevenue/total * report/compareRevenueReport/compareRevenue/totalProducts"/>
										<xsl:with-param name="baseValue" select="100 div report/compareRevenueReport/baseRevenue/total * report/compareRevenueReport/baseRevenue/totalProducts"/>
										<xsl:with-param name="title" select="'VK Anteil am Umsatz'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="sign" select="'%'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/amountGroup1"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/amountGroup1"/>
										<xsl:with-param name="title" select="'Anzahl Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/amountGroup2"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/amountGroup2"/>
										<xsl:with-param name="title" select="'Anzahl Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Kinder -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/amountGroup3"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/amountGroup3"/>
										<xsl:with-param name="title" select="'Anzahl Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									
									
									<!-- Anzahl Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/amountCustomer "/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Anzahl Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Ø Anzahl Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/amountCustomer div report/compareRevenueReport/compareRevenue/dayCnt"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/amountCustomer div report/compareRevenueReport/baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Ø Besuche pro Tag'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Ø DL Pro Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/servicePerG1"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/servicePerG1"/>
										<xsl:with-param name="title" select="'Ø DL pro Dame'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								

									<!-- Ø DL Pro Herren -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/servicePerG2"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/servicePerG2"/>
										<xsl:with-param name="title" select="'Ø DL pro Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

									
									<!-- Ø DL Pro Kind -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/servicePerG3"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/servicePerG3"/>
										<xsl:with-param name="title" select="'Ø DL pro Kind'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

								

									<!-- Ø DL Pro Besucht -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/countServices div report/compareRevenueReport/compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/countServices div report/compareRevenueReport/baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø DL pro Besuch'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- # DL Pro Besuch -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/countServices"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/countServices"/>
										<xsl:with-param name="title" select="'Anzahl DL Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
									
								
									<!-- Ø Umsatz Dame -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalPerG1"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalPerG1"/>
										<xsl:with-param name="title" select="'Ø Umsatz Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									
									<!-- Ø Umsatz Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalPerG2"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalPerG2"/>
										<xsl:with-param name="title" select="'Ø Umsatz Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								

									<!-- Ø Umsatz Kinder -->
								<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalPerG3"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalPerG3"/>
										<xsl:with-param name="title" select="'Ø Umsatz Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								

									<!-- Ø Umsatz Besuch -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/total div report/compareRevenueReport/compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/total  div report/compareRevenueReport/baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz Besuch'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
									
								

									<!-- Ø Umsatz DL Besuche -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalServices  div report/compareRevenueReport/compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalServices  div report/compareRevenueReport/baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz DL Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									
									<!-- Ø Umsatz Verkauf Besuche -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="report/compareRevenueReport/compareRevenue/totalProducts  div report/compareRevenueReport/compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="report/compareRevenueReport/baseRevenue/totalProducts  div report/compareRevenueReport/baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz Verkauf Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								


								</fo:table-body>
							</fo:table>
						</xsl:when>
						<xsl:otherwise>

						<xsl:for-each select="report/compareRevenueReport/employee">

							<fo:block>
								<xsl:value-of select="employeeNm" />
							</fo:block>
							<fo:table table-layout="fixed" border-collapse="collapse"
								width="100%" margin-top="0cm" page-break-after="always">
								<fo:table-column column-width="28%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								<fo:table-column column-width="12%"></fo:table-column>
								
								<fo:table-header >
									<fo:table-row>
									<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold-left">
												<fo:block>&#160;</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold" number-columns-spanned="2">
											<fo:block >
												Periode 1&#xA;
											</fo:block>

											<fo:block >
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="/report/report-params/DATE_COMPARE" />
												</xsl:call-template>
												-
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="/report/report-params/TODATE_COMPARE" />
												</xsl:call-template>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold" number-columns-spanned="2">
											<fo:block >
												Periode 2&#xA;
											</fo:block>

											<fo:block >
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="/report/report-params/DATE" />
												</xsl:call-template>
												-
												<xsl:call-template name="formatdate">
													<xsl:with-param name="datestr" select="/report/report-params/TODATE" />
												</xsl:call-template>
											</fo:block>
										</fo:table-cell> 
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold">
											<fo:block linefeed-treatment="preserve">Abweichung&#xA;absolut</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="th1bold">
											<fo:block linefeed-treatment="preserve">Abweichung&#xA;prozentual</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-header>
								
								<fo:table-body>
									<!-- Arbeisttage -->
									
									
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/dayCnt "/>
										<xsl:with-param name="baseValue" select="baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Arbeitstage'"/>
										<xsl:with-param name="formatPattern" select="'###.##0'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalGroup1Services "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalGroup1Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									

									<!-- DL Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalGroup2Services "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalGroup2Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Kind -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalGroup3Services "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalGroup3Services"/>
										<xsl:with-param name="title" select="'Umsatz DL Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									</xsl:call-template>
									
								
									<!-- DL Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalServices "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalServices"/>
										<xsl:with-param name="title" select="'Umsatz DL Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Verkauf Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalProducts "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalProducts"/>
										<xsl:with-param name="title" select="'Umsatz Verkauf Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
								
									<!-- Umsatz Dame Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalG1 "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalG1"/>
										<xsl:with-param name="title" select="'Umsatz Damen Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

								
									<!-- Umsatz Herren Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalG2 "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalG2"/>
										<xsl:with-param name="title" select="'Umsatz Herren Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

									

									<!-- Umsatz Kinder Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalG3 "/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalG3"/>
										<xsl:with-param name="title" select="'Umsatz Kinder Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									

									<!-- Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/total "/>
										<xsl:with-param name="baseValue" select="baseRevenue/total"/>
										<xsl:with-param name="title" select="'Umsatz Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
								

									<!-- Umsatz pro Tag -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/total div compareRevenue/dayCnt"/>
										<xsl:with-param name="baseValue" select="baseRevenue/total  div baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Ø Umsatz pro Tag'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								
									<!-- Verkaufsanteil -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="100 div compareRevenue/total * compareRevenue/totalProducts"/>
										<xsl:with-param name="baseValue" select="100 div baseRevenue/total * baseRevenue/totalProducts"/>
										<xsl:with-param name="title" select="'VK Anteil am Umsatz'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="sign" select="'%'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/amountGroup1"/>
										<xsl:with-param name="baseValue" select="baseRevenue/amountGroup1"/>
										<xsl:with-param name="title" select="'Anzahl Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/amountGroup2"/>
										<xsl:with-param name="baseValue" select="baseRevenue/amountGroup2"/>
										<xsl:with-param name="title" select="'Anzahl Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									

									<!-- Anzahl Kinder -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/amountGroup3"/>
										<xsl:with-param name="baseValue" select="baseRevenue/amountGroup3"/>
										<xsl:with-param name="title" select="'Anzahl Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
									
									</xsl:call-template>
									
									
									<!-- Anzahl Gesamt -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/amountCustomer "/>
										<xsl:with-param name="baseValue" select="baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Anzahl Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,##'" />
										<xsl:with-param name="format" select="'amount'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Ø Anzahl Gesamt -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/amountCustomer div compareRevenue/dayCnt"/>
										<xsl:with-param name="baseValue" select="baseRevenue/amountCustomer div baseRevenue/dayCnt"/>
										<xsl:with-param name="title" select="'Ø Besuche pro Tag'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- Ø DL Pro Damen -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/servicePerG1"/>
										<xsl:with-param name="baseValue" select="baseRevenue/servicePerG1"/>
										<xsl:with-param name="title" select="'Ø DL pro Dame'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								

									<!-- Ø DL Pro Herren -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/servicePerG2"/>
										<xsl:with-param name="baseValue" select="baseRevenue/servicePerG2"/>
										<xsl:with-param name="title" select="'Ø DL pro Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

									
									<!-- Ø DL Pro Kind -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/servicePerG3"/>
										<xsl:with-param name="baseValue" select="baseRevenue/servicePerG3"/>
										<xsl:with-param name="title" select="'Ø DL pro Kind'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>

								

									<!-- Ø DL Pro Besucht -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/countServices div compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="baseRevenue/countServices div baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø DL pro Besuch'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>

								

									<!-- # DL Pro Besuch -->

									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/countServices"/>
										<xsl:with-param name="baseValue" select="baseRevenue/countServices"/>
										<xsl:with-param name="title" select="'Anzahl DL Gesamt'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
									
								
									<!-- Ø Umsatz Dame -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalPerG1"/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalPerG1"/>
										<xsl:with-param name="title" select="'Ø Umsatz Damen'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									
									<!-- Ø Umsatz Herren -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalPerG2"/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalPerG2"/>
										<xsl:with-param name="title" select="'Ø Umsatz Herren'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								

									<!-- Ø Umsatz Kinder -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalPerG3"/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalPerG3"/>
										<xsl:with-param name="title" select="'Ø Umsatz Kinder'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								
								

									<!-- Ø Umsatz Besuch -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/total div compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="baseRevenue/total  div baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz Besuch'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
										<xsl:with-param name="backgroundColor" select="'#ebebeb'" />
										<xsl:with-param name="fontWeight" select="'bold'" />
									</xsl:call-template>
									
								

									<!-- Ø Umsatz DL Besuche -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalServices  div compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalServices  div baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz DL Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
									
									<!-- Ø Umsatz Verkauf Besuche -->
									<xsl:call-template name="periodeCompareRow">
										<xsl:with-param name="compareValue" select="compareRevenue/totalProducts  div compareRevenue/amountCustomer"/>
										<xsl:with-param name="baseValue" select="baseRevenue/totalProducts  div baseRevenue/amountCustomer"/>
										<xsl:with-param name="title" select="'Ø Umsatz Verkauf Besuche'"/>
										<xsl:with-param name="formatPattern" select="'###.##0,00'" />
										<xsl:with-param name="format" select="'money'" />
									
									</xsl:call-template>
								


								</fo:table-body>
							</fo:table>

						</xsl:for-each>
							
						</xsl:otherwise>
					</xsl:choose>
					<fo:block id="LastPage"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
