<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />

	<xsl:decimal-format name="money" decimal-separator="," grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator="," grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent" decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>

	</xsl:template>



	<xsl:template match="/">


		<!-- HEADER -->
		<xsl:text>&#xa;</xsl:text>
		<xsl:value-of select='"Ansicht nach Wertstellungsdatum"' />
		<xsl:text>&#xa;</xsl:text>

		<xsl:text>Von</xsl:text><xsl:value-of select="$delimiter" />

		<xsl:call-template name="formatdate">
			<xsl:with-param name="datestr" select="report/report-params/DATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />

		<xsl:text>Bis</xsl:text><xsl:value-of select="$delimiter" />
		<xsl:call-template name="formatdate">
			<xsl:with-param name="datestr" select="report/report-params/TODATE" />
		</xsl:call-template>
		<xsl:value-of select="$delimiter" />


		<xsl:variable name="pos_sales_tip_employees_sum" select="exsl:node-set(report/pos_sales_tip_employees_sum)" />
			<xsl:if test="count($pos_sales_tip_employees_sum/row) != 0">
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>Trinkgeld Summen</xsl:text>
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>&#xa;</xsl:text>

			<xsl:text>Datum</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Mitarbeiter-Nr.</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Mitarbeitername</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Wert</xsl:text>
			<xsl:value-of select="$delimiter" />
			

			<xsl:text>&#xa;</xsl:text>

			<xsl:for-each select="$pos_sales_tip_employees_sum/row">

				
				<xsl:value-of select="employee_no" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="employee_nm" />
				<xsl:value-of select="$delimiter" />
				<xsl:value-of select="format-number(tip_value, '###.##0,00', 'money')" />
				<xsl:value-of select="$delimiter" />
				<xsl:text>&#xa;</xsl:text>
			</xsl:for-each>

		
			<xsl:value-of select="$delimiter" />
			<xsl:text>Summe</xsl:text>
			<xsl:value-of select="$delimiter" />

			<xsl:value-of select="format-number(sum($pos_sales_tip_employees_sum/row/tip_value ), '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:text>&#xa;</xsl:text>

		</xsl:if>
		
		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>

		<!-- AUSGEGEBEN -->

			<xsl:variable name="pos_sales_tip" select="exsl:node-set(report/pos_sales_tip)" />
			<xsl:if test="count($pos_sales_tip/row) != 0">
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>Trinkgeld</xsl:text>
			<xsl:text>&#xa;</xsl:text>
			<xsl:text>&#xa;</xsl:text>

			<xsl:text>Datum</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Mitarbeiter-Nr.</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Mitarbeitername</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>Wert</xsl:text>
			<xsl:value-of select="$delimiter" />
			

			<xsl:text>&#xa;</xsl:text>

			<xsl:for-each select="report/pos_sales_tip/row">

				<xsl:call-template name="formatdate">
					<xsl:with-param name="datestr" select="day" />
				</xsl:call-template>
			
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="employee_no" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="employee_nm" />
				<xsl:value-of select="$delimiter" />

				<xsl:value-of select="format-number(tip_value, '###.##0,00', 'money')" />
				<xsl:value-of select="$delimiter" />

			

				<xsl:text>&#xa;</xsl:text>
			</xsl:for-each>

			<xsl:value-of select="$delimiter" />
			<xsl:value-of select="$delimiter" />
			<xsl:text>Summe</xsl:text>
			<xsl:value-of select="$delimiter" />

			<xsl:value-of select="format-number(sum(report/pos_sales_tip/row/tip_value ), '###.##0,00', 'money')" />
			<xsl:value-of select="$delimiter" />
			<xsl:text>&#xa;</xsl:text>

		</xsl:if>






	</xsl:template>

</xsl:stylesheet>