<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
   <xsl:import href="Header.xsl"/>
<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="."  NaN="0"/>
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="."  NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>
	

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>
		
		
		<xsl:choose>
            <xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>
	
	<xsl:template name="currency">
		<xsl:param name="code" />

		<xsl:choose>
            <xsl:when test="$code = 'EUR'">
				€
			</xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	



	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">

					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								Ausgabentyp: <xsl:value-of select="report/purchase_note_list/purchase_note_type" />
							</content>
						</filterRow>
						<filterRow>
							<content>
								Buchungsperiode: <xsl:value-of select="report/purchase_note_list/booking_period" />
							</content>
						</filterRow>
						<filterRow>
							<content>
								Schublade: <xsl:choose>
												<xsl:when test="report/purchase_note_list/drawer_no = ''">
													alle
												</xsl:when>
												<xsl:otherwise>
												
												<xsl:variable name="selDrawerNo"
											select="report/purchase_note_list/drawer_no"/>
										<xsl:for-each select="report/drawers/row">
											<xsl:if test="id[text() = $selDrawerNo]">
											
												<xsl:value-of select="drawer_nm" />
											</xsl:if>


										</xsl:for-each>
													
												</xsl:otherwise>
											</xsl:choose>
							</content>
						</filterRow>
						<filterRow>
							<content>
								Summe (Ausgaben): <xsl:value-of select="format-number(sum(report/purchase_note_list/purchase_notes/row/totalGrossPrice), '###.##0,00', 'money')" />
							</content>
						</filterRow>
					</xsl:variable>
				    <xsl:call-template name="header">
						<xsl:with-param name="title" select='"Ausgaben"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left" 
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Ausgaben
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">
				
				

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2"
									xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="4%"></fo:table-column>
											<fo:table-column column-width="6%"></fo:table-column>
											<fo:table-column column-width="8%"></fo:table-column>
											<fo:table-column column-width="13%"></fo:table-column>
											<fo:table-column column-width="10%"></fo:table-column>
											<fo:table-column column-width="15%"></fo:table-column>
											<fo:table-column column-width="15%"></fo:table-column>
											<fo:table-column column-width="15%"></fo:table-column>
											<fo:table-column column-width="5%"></fo:table-column>
											<fo:table-column column-width="9%"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Id</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Buch.</fo:block>
														<fo:block>Periode</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>ext.</fo:block>
														<fo:block>RE-NR</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Schublade</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Kontonummer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Kontoname</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Notizen</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left" xsl:use-attribute-sets="cell-title">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
														<fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title">
														<fo:block>Anmerkung</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
												
											<xsl:for-each select="report/purchase_note_list/purchase_notes/row">
													<xsl:variable name="grey_bg">
												        <xsl:choose>
												            <xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
												            <xsl:otherwise>#CCCCCC</xsl:otherwise>
												        </xsl:choose>
												    </xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="purchaseInvId" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="bookingTs" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
															<!-- <xsl:value-of select="purchaseInvTs" /> -->
																 <xsl:call-template name="formatdate">
																	<xsl:with-param name="datestr" select="purchaseInvTs" />
																</xsl:call-template> 
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:if test="purchaseInvCd != 'null'">
																	<xsl:value-of select="purchaseInvCd" />
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:if test="drawerNm != 'null'">
																	<xsl:value-of select="drawerNm" />
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="accountNos" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="accountNms" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="remarks" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="totalGrossPriceDesc" />
																<xsl:call-template name="currency">
																	<xsl:with-param name="code" select="currencyCd" />
																</xsl:call-template> 
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="center" xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="noteHint" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
						</fo:table-body>
					</fo:table>
					
					
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>