<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO"
					page-height="25cm" page-width="70mm" margin-top="0mm"
					margin-bottom="0mm" margin-left="2mm" margin-right="2mm">
					<fo:region-body margin-top="5mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="7mm" />
					<fo:region-after region-name="footer" extent="7mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
					<fo:block>
						<!-- <fo:instream-foreign-object xmlns:svg="http://www.w3.org/2000/svg"> 
							<svg:svg width="70mm" height="150mm"> <svg:g style="fill:red; stroke:#000000; 
							fill-opacity=0.8"> <svg:text x="50" y="70" font-family="Verdana" font-size="30" 
							transform="rotate(60 20,40)"> Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> 
							</fo:instream-foreign-object> -->
					</fo:block>
				</fo:static-content>
				<!-- <fo:static-content flow-name="footer"> <fo:block xsl:use-attribute-sets="text-style" 
					text-align="center"> Seite <fo:page-number /> von <fo:page-number-citation 
					ref-id="LastPage" /> </fo:block> </fo:static-content> -->

				<fo:flow flow-name="xsl-region-body">
					<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:block-container width="7cm" text-align="center">
						<fo:block>
							<fo:external-graphic content-width="scale-to-fit" content-height="100%" width="100%" scaling="uniform">
								<xsl:attribute name="src"><xsl:value-of select="report/businessunits/row/buLogoUrl" /></xsl:attribute>
							</fo:external-graphic>
						</fo:block>
					</fo:block-container>

					<fo:block-container width="7cm">
						<!-- <fo:block xsl:use-attribute-sets="text-style" text-align="center">
							<xsl:value-of select="report/businessunits/row/businessunit_nm" />
						</fo:block> -->
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							<xsl:value-of select="report/businessunits/row/bu_nm_1" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							<xsl:value-of select="report/businessunits/row/bu_nm_2" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							<xsl:value-of select="report/businessunits/row/bu_street" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							<xsl:value-of select="report/businessunits/row/bu_postal_cd" />&#160;
							<xsl:value-of select="report/businessunits/row/bu_city" />
						</fo:block>

						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							EMail:
							<xsl:value-of select="report/businessunits/row/buEmail" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							Telefon:
							<xsl:value-of select="report/businessunits/row/buPhone" />
						</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							Web:
							<xsl:value-of select="report/businessunits/row/buWeb" />
						</fo:block>

						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					</fo:block-container>
					<fo:block-container width="70mm">

						<fo:block xsl:use-attribute-sets="title-style"
							text-align="center">
							<xsl:choose>

								<xsl:when test="report/purchase_note/PurchaseInv/purchaseInvType=2">
									Ausgabengutschrift
								</xsl:when>
								<xsl:otherwise>
									Ausgabe
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
						<fo:block xsl:use-attribute-sets="text-style" text-align="center">
							Beleg-Nr.:
							<xsl:value-of select="report/purchase_note/PurchaseInv/purchaseInvId" />
						</fo:block>
						

						<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					</fo:block-container>


					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:table border-collapse="separate" table-layout="fixed"
						border="1" width="100%">
						<fo:table-column column-width="5.05cm"></fo:table-column>

						<fo:table-column column-width="1.55cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Bezeichnung</fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Betrag</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each
								select="report/purchase_note/PurchaseInv/PurchaseInvPosition">
								<fo:table-row>
									<!-- Artikel, Rabatte -->
									<fo:table-cell padding="0.5mm" text-align="right"
										font-size="6pt">
										<fo:block>
											<fo:table border-collapse="separate" table-layout="fixed"
												width="100%" border="1">
												<fo:table-column column-width="2.5cm"></fo:table-column>

												<fo:table-body>
													<!-- Artikel/Simpleaccounts -->
													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-style">
															<fo:block>
															<xsl:value-of select='format-number(amount, "###.##0,00", "amount")' />
															<xsl:text disable-output-escaping="yes"><![CDATA[ ]]></xsl:text>
															x
															<xsl:value-of select="itemNm" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>






												</fo:table-body>
											</fo:table>



										</fo:block>
									</fo:table-cell>

									<!-- Brutto Position -->
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
										<xsl:choose>

											<xsl:when
												test="/report/purchase_note/PurchaseInv/purchaseInvType = 2">
												-<xsl:value-of
												select='format-number(positionGrossPrice, "###.##0,00", "money")' />
											&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</xsl:when>
											<xsl:otherwise>
<xsl:value-of
												select='format-number(positionGrossPrice, "###.##0,00", "money")' />
											&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</xsl:otherwise>
										</xsl:choose>
											
										</fo:block>
									</fo:table-cell>

								</fo:table-row>
							</xsl:for-each>
						</fo:table-body>
					</fo:table>

					<fo:table border-collapse="separate" table-layout="fixed"
						width="100%">
						<fo:table-column column-width="5.05cm"></fo:table-column>
						<fo:table-column column-width="1.55cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th2bold">
									<fo:block>Rechnungsbetrag:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th2bold">
									<fo:block>
									<xsl:choose>

											<xsl:when
												test="report/purchase_note/PurchaseInv/purchaseInvType = 2">
												-<xsl:value-of
											select='format-number(report/purchase_note/PurchaseInv/totalGrossPrice, "###.##0,00", "money")' />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</xsl:when>
											<xsl:otherwise>
<xsl:value-of
											select='format-number(report/purchase_note/PurchaseInv/totalGrossPrice, "###.##0,00", "money")' />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
											</xsl:otherwise>
										</xsl:choose>
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>





					<fo:table border-collapse="separate" table-layout="fixed"
						width="100%">
						<fo:table-column column-width="2.50cm"></fo:table-column>
						<fo:table-column column-width="2.55cm"></fo:table-column>
						<fo:table-column column-width="1.55cm"></fo:table-column>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th1">
									<fo:block>Kassenlade</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th1">
									<fo:block>Zahlart</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="th1">
									<fo:block>Zahlbetrag</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:for-each select="report/purchase_note/PurchaseInv/PosPayment">

								<fo:table-row>
								
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:variable name="selDrawerNo"
											select="drawerNo"/>
										<xsl:for-each select="/report/drawers/row">
											<xsl:if test="id[text() = $selDrawerNo]">
											
												<xsl:value-of select="drawer_nm" />
											</xsl:if>


										</xsl:for-each>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:choose>
												<xsl:when test="paymentType=1">
													<xsl:choose>
														<xsl:when test="paymentDirection=1">
															Gegeben Bar
														</xsl:when>
														<xsl:otherwise>
															Ausgezahlt Bar
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>


												<xsl:otherwise>
													<xsl:value-of select='paymentType' />
													&#160;
													<xsl:value-of select='paymentDirection' />
													&#160;
													<xsl:value-of select="paymentRef" />
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="cell-style">
										<fo:block>
											<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
											&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="right" number-columns-spanned="2"
										xsl:use-attribute-sets="cell-style">

										<fo:block xsl:use-attribute-sets="text-style"
											text-align="right">
											Datum:
											<xsl:value-of
												select="paymentTsD" />
											&#160;
											<xsl:value-of
												select="paymentTsT" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</xsl:for-each>


						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>