<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.1mm</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-width">0.1mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="footer-text">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO"
					page-height="25cm" page-width="70mm" margin-top="3mm"
					margin-bottom="3mm" margin-left="3mm" margin-right="3mm">
					<fo:region-body margin-top="18mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="18mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="THERMO">
				<fo:static-content flow-name="header">
    <xsl:call-template name="header">
        <xsl:with-param name="title" select='"Sitzungsbericht"' />
        <xsl:with-param name="businessunit" select="report/businessunits/row" />
    </xsl:call-template>
				</fo:static-content>
				<!-- <fo:static-content flow-name="footer"> <fo:block xsl:use-attribute-sets="footer-text" 
					text-align="left" font-size="8pt"> <fo:table width="100%"> <fo:table-column 
					column-width="20%"></fo:table-column> <fo:table-column column-width="60%"></fo:table-column> 
					<fo:table-column column-width="20%"></fo:table-column> <fo:table-body> <fo:table-row> 
					<fo:table-cell text-align="left" xsl:use-attribute-sets="footer-text"> <fo:block> 
					<xsl:call-template name="formatdate"> <xsl:with-param name="datestr" select="report/report-params/NOW" 
					/> </xsl:call-template> </fo:block> </fo:table-cell> <fo:table-cell text-align="center" 
					xsl:use-attribute-sets="footer-text"> <fo:block> Sitzungsbericht </fo:block> 
					</fo:table-cell> <fo:table-cell text-align="right" xsl:use-attribute-sets="footer-text"> 
					<fo:block> <fo:page-number /> / <fo:page-number-citation ref-id="LastPage" 
					/> </fo:block> </fo:table-cell> </fo:table-row> </fo:table-body> </fo:table> 
					</fo:block> </fo:static-content> -->

				<xsl:variable name="drawerNo">
					<xsl:value-of select="report/report-params/DRAWER_NO" />
				</xsl:variable>
				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="23mm"></fo:table-column>
						<fo:table-column column-width="2mm"></fo:table-column>
						<fo:table-column column-width="39mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzung
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/pospay_session_statistics/pos_session_stats/pos_session_cd"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Schublade
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of
											select="/report/drawers/row[drawer_no=$drawerNo]/drawer_nm" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzungsstart
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/pospay_session_statistics/pos_session_stats/pos_session_start_ts"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Sitzungsende
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
											<xsl:value-of select="report/pospay_session_statistics/pos_session_stats/pos_session_end_ts"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Erstellungsdatum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/NOW" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Zahlungsverkehr</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Bar</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Anfangsbestand:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/beforeCashValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Bareinnahmen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/daySalesCashInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


					
							<xsl:for-each select="report/pospay_session_statistics/pos_session_stats/drawerPaymentsIn/row">


								<xsl:variable name="acctCd">
									<xsl:value-of select="contra_acct_cd" />
								</xsl:variable>

								<xsl:choose>
									<xsl:when test="isTransit=0">
										<xsl:if test="payment>0">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														+&#160;Umbuchung

														von
														<xsl:value-of
															select="contra_simple_acct_nm" />


													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(payment, '###.##0,00', 'money')" />
														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>



													</fo:block>
												</fo:table-cell>
											</fo:table-row>

										</xsl:if>



									</xsl:when>

									<xsl:otherwise>

										<xsl:choose>
											<xsl:when test="contra_acct_cd">
												<xsl:if test="payment>0">


													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																+&#160;Einlage
																-
																<xsl:value-of
																	select="contra_simple_acct_nm" />

															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>


																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
											</xsl:when>

											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															+&#160;Einlage

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>

															<xsl:value-of
																select="format-number(payment, '###.##0,00', 'money')" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>


									</xsl:otherwise>
								</xsl:choose>

							</xsl:for-each>




							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										-&#160;Barausgaben
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/dayPurchaseCashOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>



							<xsl:for-each select="report/pospay_session_statistics/pos_session_stats/drawerPaymentsOut/row">


								<xsl:variable name="acctCd">
									<xsl:value-of select="contra_acct_cd" />
								</xsl:variable>

								<xsl:choose>
									<xsl:when test="isTransit=0">
										<xsl:if test="payment>0">


											<fo:table-row>
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell">
													<fo:block>
														-&#160;Umbuchung

														nach
														<xsl:value-of
															select="contra_simple_acct_nm" />


													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right"
													xsl:use-attribute-sets="cell">
													<fo:block>


														<xsl:value-of
															select="format-number(payment, '###.##0,00', 'money')" />
														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>



													</fo:block>
												</fo:table-cell>
											</fo:table-row>

										</xsl:if>



									</xsl:when>

									<xsl:otherwise>

										<xsl:choose>
											<xsl:when test="contra_acct_cd">
												<xsl:if test="payment>0">


													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																-&#160;Entnahme
																-
																<xsl:value-of
																	select="contra_simple_acct_nm" />

															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell">
															<fo:block>


																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
											</xsl:when>

											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>
															-&#160;Entnahme

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell">
														<fo:block>

															<xsl:value-of
																select="format-number(payment, '###.##0,00', 'money')" />
															&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>





														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>


									</xsl:otherwise>
								</xsl:choose>

							</xsl:for-each>


							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										Endbestand:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/endCashValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Bargeldlos</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;EC-Einnahmen / EC-Schnitt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/ecValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Kreditkarten-Einnahmen
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/ccValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										+&#160;Einnahmen zur Überweisung vorgemerkt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/transferSIValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										-&#160;Ausgaben zur Überweisung vorgemerkt
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/transferPurchaseOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/voucherOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutscheine
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/voucherInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Ausgegebene Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/creditNoteOutValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell">
									<fo:block>
										Eingelöste Gutschriften
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<xsl:value-of
											select="format-number(report/pospay_session_statistics/pos_session_stats/creditNoteInValue, '###.##0,00', 'money')" />
										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>


					<fo:block page-break-inside="avoid">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-body>
								<fo:table-row height="50mm">
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
									<fo:table-cell border-top-style="solid"
										text-align="center" xsl:use-attribute-sets="cell">
										<fo:block>Ort, Datum, Unterschrift</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</fo:table-body>

						</fo:table>
					</fo:block>

					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>