<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:csv="csv:csv"
	xmlns:exsl="http://exslt.org/common" 
	extension-element-prefixes="barcode date exsl">




	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	
	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="itemGroup">
		<xsl:param name="groupId" />

		<xsl:for-each select="/report/item_groups/row">

			<xsl:if test="id[text() = $groupId]">
				<xsl:if test="parent_item_group_cd[text() != '']">
					<xsl:call-template name="itemGroup">
						<xsl:with-param name="groupId" select="parent_item_group_cd" />
					</xsl:call-template>
					<xsl:text>/</xsl:text>
				</xsl:if>
				<xsl:value-of select="item_group_nm" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


 <xsl:template name="numberEFormat" >
  <xsl:param name="value" />
 
	<xsl:choose>
		<xsl:when test="not(contains($value,'E'))">
			<xsl:value-of select="$value"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="vExponent" select="substring-after($value,'E')"/>
			<xsl:variable name="vMantissa" select="substring-before($value,'E')"/>
			
			<xsl:variable name="vFactor">
				<xsl:choose>
					<xsl:when test="starts-with($vExponent,'-')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>		
					<xsl:when test="starts-with($vExponent,'+')">
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,2) + 1)" />
					</xsl:when>							
					<xsl:otherwise>
						<xsl:value-of select="substring('100000000000000000000000000000000000000000000',
								   1, substring($vExponent,1) + 1)" />
					</xsl:otherwise>
				</xsl:choose>				   
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($vExponent,'-')">
					<xsl:value-of select="$vMantissa div $vFactor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$vMantissa * $vFactor"/>
				</xsl:otherwise>
			</xsl:choose>
		
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>




	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
	    <column>itemNm<desc>Artikelname</desc></column>
        <column>itemCd<desc>Art.-Nr.</desc></column>
		<column>itemEAN<desc>EAN</desc></column>
		<column>amount<desc>Bestand</desc></column>
		<column>itemPurchasePrice<desc>EK</desc></column>
		<column>itemPurchaseTotalPrice<desc>EK-Wert</desc></column>
		<column>itemSellable<desc>Verkauf</desc></column>
		<column>itemSalesPrice<desc>VK</desc></column>
		
	</csv:columns>


		

	<xsl:template match="/">


	<xsl:variable name="title">Lagerbestand : <xsl:value-of select="report/businessunits/row/bu_nm_1" /></xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$title"/><xsl:text>"</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		
		<xsl:variable name="selStockNo" select="report/report-params/STOCK_NO"></xsl:variable>
		<xsl:if test="/report/stocks/row[id=$selStockNo]/txt">
			<xsl:variable name="filterStockLocation">Lagerort: <xsl:value-of select="/report/stocks/row[id=$selStockNo]/txt" /></xsl:variable>
			<xsl:text>"</xsl:text><xsl:value-of select="$filterStockLocation"/><xsl:text>"</xsl:text>
			<xsl:text>&#xa;</xsl:text>
			
		</xsl:if>

		<xsl:variable name="filterSupplier">
			<xsl:choose>
				<xsl:when test="report/report-params/SUPPLIER_NO = 'null'">Lieferant: Alle Lieferanten</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="selSupplierNo"
						select="report/report-params/SUPPLIER_NO"></xsl:variable>
					<xsl:for-each select="report/supplier/row">

						<xsl:if test="id[text() = $selSupplierNo]">
							<xsl:choose>
								<xsl:when test="first_nm != ''">Lieferant: <xsl:value-of select="first_nm" />&#160;<xsl:value-of select="contact_nm" /></xsl:when>
								<xsl:otherwise>Lieferant: <xsl:value-of select="contact_nm" /></xsl:otherwise>
							</xsl:choose>
						</xsl:if>

					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterSupplier"/><xsl:text>"</xsl:text>		
		<xsl:text>&#xa;</xsl:text>

		<xsl:variable name="filterPurchaseGroup">
				<xsl:choose>
					<xsl:when test="report/report-params/ITEM_PURCHASE_GROUP_CD = 'null'">Einkaufsgruppe: Alle Einkaufsgruppen</xsl:when>
					<xsl:otherwise>Einkaufsgruppe: <xsl:variable name="selItemPurchaseGroupNo" select="report/report-params/ITEM_PURCHASE_GROUP_CD"></xsl:variable><xsl:for-each select="report/item_purchase_groups/row">
							<xsl:if test="id[text() = $selItemPurchaseGroupNo]"><xsl:value-of select="item_purchase_group_nm" /></xsl:if>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterPurchaseGroup"/><xsl:text>"</xsl:text>			
		<xsl:text>&#xa;</xsl:text>
		
		<xsl:variable name="filterItemGroup">
				<xsl:choose>
					<xsl:when test="report/report-params/ITEM_GROUP_CD = 'null'">Artikelgruppe: Alle Artikelgruppen</xsl:when>
					<xsl:otherwise>Artikelgruppe: <xsl:call-template name="itemGroup">
							<xsl:with-param name="groupId"
								select="report/report-params/ITEM_GROUP_CD" />
						</xsl:call-template></xsl:otherwise>
				</xsl:choose>
		</xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterItemGroup"/><xsl:text>"</xsl:text>			
		<xsl:text>&#xa;</xsl:text>

		
		<xsl:variable name="filterDate">Datum :  <xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/DATE" />
										</xsl:call-template></xsl:variable>
		<xsl:text>"</xsl:text><xsl:value-of select="$filterDate"/><xsl:text>"</xsl:text>			
		<xsl:text>&#xa;</xsl:text>

		<xsl:variable name="title">Suche : <xsl:value-of select="report/report-params/SEARCH_STRING" /></xsl:variable>

		<xsl:text>&#xa;</xsl:text>
		<xsl:text>&#xa;</xsl:text>
		
				<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="report/inventory-item-list/stockItemList/stockItem">

			

			<xsl:variable name="property" select="." />
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
				
					<xsl:when test="$column='itemNm'"><xsl:text>"</xsl:text><xsl:value-of select="$value"  /><xsl:text>"</xsl:text> 
					</xsl:when>
					<xsl:when test="$column='itemCd'"><xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text> 
					</xsl:when>
					
					<xsl:when test="$column='amount'"><xsl:variable name="priceValue">
														<xsl:call-template name="numberEFormat"><xsl:with-param name="value" select="$value" />
													</xsl:call-template>
													</xsl:variable><xsl:value-of select="format-number($priceValue, '##0', 'amount')" /> 
					</xsl:when>
					<xsl:when test="$column='itemPurchasePrice'"><xsl:value-of	select="format-number($value, '##0,00', 'money')" />
					</xsl:when>
					<xsl:when test="$column='itemPurchaseTotalPrice'"><xsl:variable name="priceValue">
													<xsl:call-template name="numberEFormat">
														<xsl:with-param name="value" select="$value" />
													</xsl:call-template>	
													</xsl:variable><xsl:value-of	select="format-number($priceValue, '##0,00', 'money')" />
					</xsl:when>
					<xsl:when test="$column='itemSalesPrice'">	<xsl:value-of select="format-number($value, '##0,00', 'money')" />
					</xsl:when>
			
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>
	</xsl:template>



</xsl:stylesheet>