<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

    <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>
	
	<xsl:template name="formatdate2">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="substring($dd,1,1) = 0">
						<xsl:value-of select="substring($dd,2,1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$mm" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="currency">
		<xsl:param name="code" />

		<xsl:choose>
			<xsl:when test="$code = 'EUR'">
				€
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>





	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
				    <xsl:call-template name="header">
				        <xsl:with-param name="title" select="report/stock_note_detail/stockNote/name" />
				        <xsl:with-param name="businessunit" select="report/businessunits/row" />
				    </xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%" />
							<fo:table-column column-width="60%" />
							<fo:table-column column-width="20%" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:value-of select="report/stock_note_list/stockNoteList/name" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>



				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm" />
						<fo:table-column column-width="3mm" />
						<fo:table-column column-width="65mm" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Suche
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of
											select="report/stock_note_list/stockNoteList/searchString" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">

									<fo:block>
										<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template> - 
										<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Status
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:value-of select="report/stock_note_list/stockNoteList/noteType" />
									</fo:block>

								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Lagerort
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
									<xsl:choose>
												<xsl:when test="report/stock_note_list/stockNoteList/stockNo = ''">
													Alle Lagerorte
												</xsl:when>
												<xsl:otherwise>
												
												<xsl:variable name="selStockNo"
											select="report/stock_note_list/stockNoteList/stockNo"/>
										<xsl:for-each select="report/stocks/row">
											<xsl:if test="id[text() = $selStockNo]">
											
												<xsl:value-of select="stock_nm" />
											</xsl:if>


										</xsl:for-each>
													
												</xsl:otherwise>
											</xsl:choose>
									</fo:block>

								</fo:table-cell>
							</fo:table-row>
							<xsl:if test="report/stock_note_list/stockNoteList/stockDlnType = 2 or report/stock_note_list/stockNoteList/stockDlnType = 6">
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											Lieferant
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											<xsl:choose>
												<xsl:when test="report/stock_note_list/stockNoteList/supplierNo = ''">
													Alle Lieferanten
												</xsl:when>
												<xsl:otherwise>
													<xsl:variable name="selSupplierNo"
											select="report/stock_note_list/stockNoteList/supplierNo"/>
										
										<xsl:for-each select="report/supplier/row">
											<xsl:if test="id[text() = $selSupplierNo]">
												<xsl:choose>
													<xsl:when test="first_nm != ''">
														<xsl:value-of select="first_nm" />
														&#160;
														<xsl:value-of select="contact_nm" />
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="contact_nm" />
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>


										</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>

									</fo:table-cell>
								</fo:table-row>

							</xsl:if>
							
							<xsl:if test="report/stock_note_list/stockNoteList/stockDlnType = 3">
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											Korrekturart
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											<xsl:choose>
												<xsl:when test="report/stock_note_list/stockNoteList/correctionType = ''">
													Alle Korrekturarten
												</xsl:when>
												<xsl:otherwise>
													<xsl:variable name="selCorrectionType"
											select="report/stock_note_list/stockNoteList/correctionType"/>
										
										<xsl:for-each select="report/stock_revision_types/row">
											<xsl:if test="id[text() = $selCorrectionType]">
												
													<xsl:value-of select="stock_revision_type_nm" />
													
											</xsl:if>


										</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>

									</fo:table-cell>
								</fo:table-row>

							</xsl:if>
							<xsl:if test="report/stock_note_list/stockNoteList/stockDlnType = 6">
							<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											Einkaufsgruppe
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
										
											<xsl:choose>
												<xsl:when test="report/stock_note_list/stockNoteList/itemPurchaseGroupCd = ''">
													Alle Einkaufsgruppe
												</xsl:when>
												<xsl:otherwise>
													<xsl:variable name="selPurchaseGroupCd"
											select="report/stock_note_list/stockNoteList/itemPurchaseGroupCd"/>
										
										<xsl:for-each select="report/item_purchase_groups/row">
											<xsl:if test="id[text() = $selPurchaseGroupCd]">
												
													<xsl:value-of select="item_purchase_group_nm" />
													
											</xsl:if>


										</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>

									</fo:table-cell>
								</fo:table-row>
								
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											Artikelgruppe
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											:
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="cell2">
										<fo:block>
											<xsl:choose>
												<xsl:when test="report/stock_note_list/stockNoteList/itemGroupCd = ''">
													Alle Artikelgruppe
												</xsl:when>
												<xsl:otherwise>
													<xsl:variable name="selItemGroupCd"
											select="report/stock_note_list/stockNoteList/itemGroupCd"/>
										
										<xsl:for-each select="report/item_groups/row">
											<xsl:if test="id[text() = $selItemGroupCd]">
												
													<xsl:value-of select="item_group_nm" />
													
											</xsl:if>


										</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											
										</fo:block>

									</fo:table-cell>
								</fo:table-row>
							</xsl:if>

						</fo:table-body>
					</fo:table>
					
					

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="70%" />
						<fo:table-column column-width="30%" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
									<xsl:choose>
										<xsl:when test="report/stock_note_list/stockNoteList/stockDlnType = 6">
											<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="25mm" />
											<fo:table-column column-width="25mm" />
											<fo:table-column column-width="25mm" />
											<fo:table-column column-width="15mm" />
											<fo:table-column column-width="20mm" />
											<fo:table-column column-width="20mm" />
											
											<fo:table-column column-width="20mm" />
											<fo:table-column column-width="20mm" />


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
						
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell-title">
																<fo:block>Lager</fo:block>
															</fo:table-cell>
	
<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Inv.Name</fo:block>
													</fo:table-cell>
												

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Lieferant</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>EK-Gruppe</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Art.-Gruppe</fo:block>
													</fo:table-cell>
													
													
													
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>MA</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Status</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											
											<fo:table-body>
											<xsl:choose>
													<xsl:when test="report/stock_note_list/stockNoteList/count != 0">
													

												<xsl:for-each
													select="report/stock_note_list/stockNoteList/stockNotes/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="datetime" />
															</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="stockNm" />
															</fo:block>
														</fo:table-cell>
														
														<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of select="inventoryProcessNm" />
																</fo:block>
															</fo:table-cell>
														
														<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of select="supplierNm" />
																</fo:block>
															</fo:table-cell>
															
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:variable name="selPurchaseGroupCd"
											select="itemPurchaseGroupCd"/>
										
										
										<xsl:for-each select="/report/item_purchase_groups/row">
											<xsl:if test="id[text() = $selPurchaseGroupCd]">
												
													<xsl:value-of select="item_purchase_group_nm" />
													
											</xsl:if>


										</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:variable name="selItemGroupCd"
											select="itemGroupCd"/>
										
										<xsl:for-each select="/report/item_groups/row">
											<xsl:if test="id[text() = $selItemGroupCd]">
												
													<xsl:value-of select="item_group_nm" />
													
											</xsl:if>


										</xsl:for-each>
																</fo:block>
															</fo:table-cell>


														

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="employeeNm" />
															</fo:block>
														</fo:table-cell>



															
											

														

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="status" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
													
													</xsl:when>
													<xsl:otherwise>
													<fo:table-row>
														<fo:table-cell number-columns-spanned="6" text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																&#160;
															</fo:block>
														</fo:table-cell>
														</fo:table-row>
													</xsl:otherwise>
												</xsl:choose>
												
												

											</fo:table-body>
											
										</fo:table>
										</xsl:when>
										<xsl:otherwise>
											<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="25mm" />
											<fo:table-column column-width="30mm" />
											<fo:table-column column-width="30mm" />
											<fo:table-column column-width="30mm" />
											<fo:table-column column-width="30mm" />
											<fo:table-column column-width="25mm" />


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Datum</fo:block>
													</fo:table-cell>
													<xsl:choose>
														<xsl:when
															test="report/stock_note_list/stockNoteList/stockDlnType = 5">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell-title">
																<fo:block>Ausgangslager</fo:block>
															</fo:table-cell>
														</xsl:when>
														<xsl:when test="stockDlnType = 4">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell-title" number-columns-spanned="2">
																<fo:block>Lager</fo:block>
															</fo:table-cell>
														</xsl:when>
														<xsl:otherwise>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell-title">
																<fo:block>Lager</fo:block>
															</fo:table-cell>
														</xsl:otherwise>
													</xsl:choose>

													<xsl:if
														test="report/stock_note_list/stockNoteList/stockDlnType = 5">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title">
															<fo:block>Ziellager</fo:block>
														</fo:table-cell>
													</xsl:if>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>int.Nr.</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Mitarbeiter</fo:block>
													</fo:table-cell>

													<xsl:if
														test="report/stock_note_list/stockNoteList/stockDlnType = 1">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title">
															<fo:block>Kunde</fo:block>
														</fo:table-cell>
													</xsl:if>

													<xsl:if
														test="report/stock_note_list/stockNoteList/stockDlnType = 2">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title">
															<fo:block>Lieferant</fo:block>
														</fo:table-cell>
													</xsl:if>

													<xsl:if
														test="report/stock_note_list/stockNoteList/stockDlnType = 3">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title">
															<fo:block>Korrekturart</fo:block>
														</fo:table-cell>
													</xsl:if>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title">
														<fo:block>Status</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											
											<fo:table-body>
											<xsl:choose>
													<xsl:when test="report/stock_note_list/stockNoteList/count != 0">
													

												<xsl:for-each
													select="report/stock_note_list/stockNoteList/stockNotes/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="datetime" />
															</fo:block>
														</fo:table-cell>
														
														<xsl:choose>
															<xsl:when test="stockDlnType = 4">
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="cell" number-columns-spanned="2">
																	<fo:block>
																		<xsl:value-of select="stockNm" />
																	</fo:block>
																</fo:table-cell>
															</xsl:when>
															<xsl:otherwise>
																<fo:table-cell text-align="left"
																	xsl:use-attribute-sets="cell">
																	<fo:block>
																		<xsl:value-of select="stockNm" />
																	</fo:block>
																</fo:table-cell>
															</xsl:otherwise>
														</xsl:choose>

														


														<xsl:if test="stockDlnType = 5">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of select="sinkStockNm" />
																</fo:block>
															</fo:table-cell>
														</xsl:if>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
															<xsl:value-of select="stockDlnId" />
																
															</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="employeeNm" />
															</fo:block>
														</fo:table-cell>

														<xsl:if test="stockDlnType = 1">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of select="custNm" />
																</fo:block>
															</fo:table-cell>
														</xsl:if>

														<xsl:if test="stockDlnType = 2">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of select="supplierNm" />
																</fo:block>
															</fo:table-cell>
														</xsl:if>

														<xsl:if test="stockDlnType = 3">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="cell">
																
																<fo:block>
																
																<xsl:variable name="selStockRevision"
											select="stockRevision"/>
										<xsl:for-each select="/report/stock_revision_types/row">
											<xsl:if test="id[text() = $selStockRevision]">
												
													<xsl:value-of select="stock_revision_type_nm" />
													
											</xsl:if>


										</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</xsl:if>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																<xsl:value-of select="status" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
													
													</xsl:when>
													<xsl:otherwise>
													<fo:table-row>
														<fo:table-cell number-columns-spanned="6" text-align="left"
															xsl:use-attribute-sets="cell">
															<fo:block>
																&#160;
															</fo:block>
														</fo:table-cell>
														</fo:table-row>
													</xsl:otherwise>
												</xsl:choose>
												
												

											</fo:table-body>
											
										</fo:table>
										</xsl:otherwise>
									</xsl:choose>
										
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>