<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">
<xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#e9e9e9</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="minicell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.25mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>


	<xsl:attribute-set name="row_underline">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom">0.5pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="valueCell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellTitle">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom">2pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableLastRow">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-top">1.5pt</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="tableCellValue">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-color">#c3c3c3</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">2pt</xsl:attribute>
		<xsl:attribute name="padding-right">1pt</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>

	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>







	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="10mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="18mm" margin-bottom="10mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
			
					<xsl:variable name="viewMode">
						<xsl:choose>
						<xsl:when test="report/report-params/USE_BOOKUNG_TS = 'true'">
							<xsl:value-of select="'Ansicht nach Buchungsdatum'"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'Ansicht nach Wertstellungsdatum'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
			
				<fo:static-content flow-name="header">


					<xsl:call-template name="header">
						<xsl:with-param name="title" select='"Filialbericht"' />
						<xsl:with-param name="businessunit" select="report/businessunits/row" />
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="viewMode" select="$viewMode" />
					</xsl:call-template>

					<fo:table table-layout="fixed" width="100%" page-break-after="always" margin-top="5mm">
						<fo:table-column column-width="50%"></fo:table-column>
						<fo:table-column column-width="50%"></fo:table-column>
						

						<fo:table-body>

							<fo:table-row>
								<fo:table-cell font-weight="bold"
									xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="2mm"></fo:table-column>
											<fo:table-column column-width="45mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Auswertung für den
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:call-template name="formatdate">
																<xsl:with-param name="datestr"
																	select="report/report-params/DATE" />
															</xsl:call-template>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Erstellungsdatum
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:call-template name="formatdatetime">
																<xsl:with-param name="datetimestr"
																	select="report/report-params/NOW" />
															</xsl:call-template>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
									</fo:block>
								</fo:table-cell>
							
							</fo:table-row>
							
					</fo:table-body>
				</fo:table>
						


				</fo:static-content>

				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Fillialbericht
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
	<xsl:variable name="currencySymbol">
					<xsl:value-of select="report/departmentCurrency/row/currency_symbol"></xsl:value-of>
					</xsl:variable>

					<fo:table table-layout="fixed" width="100%" page-break-after="always" margin-top="5mm">
						<fo:table-column column-width="50%"></fo:table-column>
						<fo:table-column column-width="50%"></fo:table-column>
						

						<fo:table-body>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block margin-top="5mm">
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="2mm"></fo:table-column>
											<fo:table-column column-width="45mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Erster Bon
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of select="report/firstNote/row/sales_inv_cd" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Letzer Bon
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of select="report/lastNote/row/sales_inv_cd" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="2mm"></fo:table-column>
											<fo:table-column column-width="45mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Anzahl Belege
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block margin-top="5mm">
															<xsl:value-of
																select="/report/salesInvCnts/row/cnt_sales_invs" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<!-- <fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Stornos
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="/report/salesInvCnts/row/type2_cancel" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row> -->
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Besuche
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															:
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="/report/salesInvCnts/row/cnt_customer_visits" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block margin-top="0mm" xsl:use-attribute-sets="subtitle">
										Zusammenstellung Umsätze
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
									</fo:block>
								</fo:table-cell>
								
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block margin-top="5mm">
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block font-weight="bold">
															Tagesumsatz
															Gesamt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/revenueGrossPrice, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<xsl:if
													test="report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_rev_acct_not_stockable/revenueNotStockable > 0">
													<xsl:for-each
														select="report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_rev_acct_not_stockable/row">
														<xsl:variable name="itemRevenueAcctNo"
															select="itemRevenueAcctNo/text()" />
														<fo:table-row xsl:use-attribute-sets="row_underline">
															<fo:table-cell xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of
																		select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/simple_acct_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="valueCell">
																<fo:block>
																	<xsl:value-of
																		select="format-number(grossPrice, '###.##0,00', 'money')" />
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:if>
												<xsl:if
													test="report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_rev_acct_stockable/revenueStockable > 0">
													<xsl:for-each
														select="report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_rev_acct_stockable/row">


														<xsl:variable name="itemRevenueAcctNo"
															select="itemRevenueAcctNo/text()" />

														<fo:table-row xsl:use-attribute-sets="row_underline">
															<fo:table-cell xsl:use-attribute-sets="cell">
																<fo:block>
																	<xsl:value-of
																		select="/report/simple_accounts/row[simple_acct_cd=$itemRevenueAcctNo]/simple_acct_nm" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="valueCell">
																<fo:block>
																	<xsl:value-of
																		select="format-number(grossPrice, '###.##0,00', 'money')" />
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:if>

												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															VK in % </fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="valueCell">
														<fo:block>
														<xsl:value-of
															select="format-number(sum(report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_rev_acct_stockable/row/grossPrice) div (report/pos_payment_statistics/pos_stats/pos_stats_day/revenueGrossPrice) * 100 , '###.##0,00', 'money')" />
													&#160;%
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>

								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm" font-weight="bold">
															Offene
															Posten
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block margin-top="5mm">
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/openNotesToPayValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Offene Posten Sitzung-Start
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/prevOpenNotesToPayValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															+&#160;offene Posten neu
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/dayOpenNotesToPayValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>		
								</fo:table-cell>
								
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
								<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm" font-weight="bold">
															Stornos
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Stornos
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="report/pos_payment_statistics/pos_stats/pos_stats_day/cntSiCanceled" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Stornos (Summe)
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/siCanceledValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
											
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Gutschriften
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Anzahl Gutschriften
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="report/pos_payment_statistics/pos_stats/pos_stats_day/cntSiCreditNotes" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Gutschriften (Summe)
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/siCreditNotesValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
	
							</fo:table-row>



							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block margin-top="5mm">
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												
<!--report/pos_payment_statistics/pos_stats/pos_stats_day/revenueGrossPrice  -->
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Rabatte
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block >
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/rebate, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Nachlässe
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block >
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/cashDiscountValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block >
															Treuerabatte
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block >
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/creditPointsValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block >
															Gutscheinrabatte
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block >
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/voucherRebate, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
											
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Gutscheine
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Ausgegebene Gutscheine
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/voucherOutValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row xsl:use-attribute-sets="row_underline">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block>
															Eingelöste Gutscheine
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="valueCell">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/voucherInValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
	
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												

												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Ausgaben(Summe)
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block margin-top="5mm">
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/totalGrossPurchasePrice, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
											
												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Trinkgeld(Summe)
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block margin-top="5mm">
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/tipValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
	
							</fo:table-row>

<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="47mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-body>
												

												<fo:table-row xsl:use-attribute-sets="row_underline"
													font-weight="bold">
													<fo:table-cell xsl:use-attribute-sets="cell">
														<fo:block margin-top="5mm">
															Verlust
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right">
														<fo:block margin-top="5mm">
															<xsl:value-of
																select="format-number(report/pos_payment_statistics/pos_stats/pos_stats_day/lossValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell">
									<fo:block>
									</fo:block>
								</fo:table-cell>
	
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="report-title">
									<fo:block margin-top="5mm">
										Zahlungsverkehr
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block>
									</fo:block>
								</fo:table-cell>
								
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block margin-top="5mm">
										<fo:table  width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
											<fo:table-column column-width="24mm"></fo:table-column>
										

											<fo:table-body>
												<fo:table-row>
													<fo:table-cell padding="1mm">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell number-columns-spanned="6"
														text-align="center" background-color="#cfcfcf" padding="1mm"
														font-size="10pt">
														<fo:block>
															Bar
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle"
														border-left="0pt">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt" >
															Anfangsbestand
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Einnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Ausgaben
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Einlagen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Entnahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block font-weight="bold" margin-top="12pt">
															Endbestand
														</fo:block>
													</fo:table-cell>

							
												</fo:table-row>
												<!-- foreach -->
												<xsl:for-each select="report/drawers/row">
													<xsl:variable name="drawerNo" select="drawer_no/text()" />
													<fo:table-row>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue"
															border-left="0pt" border-top="0pt" text-align="left">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/beforeCashValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>

																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/daySalesCashInValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayPurchaseCashOutValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayCashInValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/dayCashOutValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/endCashValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
									

													</fo:table-row>
												</xsl:for-each>



												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow"
														border-left="0pt" border-top="1.5pt" text-align="left">
														<fo:block font-weight="bold">
															Gesamt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/beforeCashValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">

															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/daySalesCashInValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/dayPurchaseCashOutValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/dayCashInValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/dayCashOutValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/endCashValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													
												</fo:table-row>

											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block margin-top="5mm">
										<fo:table  width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
										
										
											<fo:table-column column-width="29mm"></fo:table-column>
											<fo:table-column column-width="29mm"></fo:table-column>
											<fo:table-column column-width="29mm"></fo:table-column>
											<fo:table-column column-width="29mm"></fo:table-column>
											<fo:table-column column-width="28mm"></fo:table-column>

											<fo:table-body>
												<fo:table-row>
													<fo:table-cell padding="1mm">
														<fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell number-columns-spanned="5"
														text-align="center" background-color="#cfcfcf" padding="1mm"
														font-size="10pt">
														<fo:block>
															Bargeldlos
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle"
														border-left="0pt">
														<fo:block>
														</fo:block>
													</fo:table-cell>
											
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="6pt">
															EC-Einahmen / EC-Schnitt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="6pt">
															Kreditkarten-Einahmen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block >
															Einnahmen zur Überweisung vorgemerkt
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Überweisungen
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableCellTitle">
														<fo:block margin-top="12pt">
															Onlinezahlungen
														</fo:block>
													</fo:table-cell>
							
												</fo:table-row>
												<!-- foreach -->
												<xsl:for-each select="report/drawers/row">
													<xsl:variable name="drawerNo" select="drawer_no/text()" />
													<fo:table-row>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue"
															border-left="0pt" border-top="0pt" text-align="left">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
								
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/ecValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/ccValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/transferSIValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/transferPurchaseOutValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>

														<fo:table-cell xsl:use-attribute-sets="tableCellValue">
															<fo:block>
																<xsl:value-of
																	select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/pos_stats_drawer/row[drawer_no=$drawerNo]/onlineValue, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>

													</fo:table-row>
												</xsl:for-each>



												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow"
														border-left="0pt" border-top="1.5pt" text-align="left">
														<fo:block font-weight="bold">
															Gesamt
														</fo:block>
													</fo:table-cell>
													
								
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">


															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/ecValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/ccValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">
														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/transferSIValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">

														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/transferPurchaseOutValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="tableLastRow">

														<fo:block font-weight="bold">
															<xsl:value-of
																select="format-number(/report/pos_payment_statistics/pos_stats/pos_stats_day/onlineValue, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>

											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						


						</fo:table-body>
					</fo:table>

			
					<fo:table table-layout="fixed" width="100%" >
						<fo:table-column column-width="70%"></fo:table-column>
						<fo:table-column column-width="30%"></fo:table-column>

						<fo:table-body>



							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<xsl:if test="report/purchase_notes/row">
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row margin-top="20mm">
									<fo:table-cell text-align="left"
										number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
										<fo:block>Ausgaben</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										number-columns-spanned="2" xsl:use-attribute-sets="cell">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell number-columns-spanned="2">
										<fo:block>
											<fo:table table-layout="fixed" width="100%">
												<fo:table-column column-width="20mm"></fo:table-column>
												<fo:table-column column-width="40mm"></fo:table-column>
												<fo:table-column column-width="35mm"></fo:table-column>
												<fo:table-column column-width="15mm"></fo:table-column>
												<fo:table-column column-width="35mm"></fo:table-column>
												<fo:table-column column-width="25mm"></fo:table-column>


												<fo:table-header>
													<fo:table-row>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Beleg Nr</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>ext. Beleg Nr</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Kasse</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Zeit</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="cell-title2">
															<fo:block>Betrag</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="cell-title2">
															<fo:block margin-left="5mm">Zahlart</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body>
													<xsl:for-each select="report/purchase_notes/row">


														<xsl:variable name="drawerNo">


															<xsl:value-of select="drawer_no" />

														</xsl:variable>

														<xsl:variable name="grey_bg">
															<xsl:choose>
																<xsl:when test="position() mod 2 = 1">
																	#FFFFFF
																</xsl:when>
																<xsl:otherwise>
																	#CCCCCC
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<fo:table-row background-color="{$grey_bg}">
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="purchase_inv_id" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of select="purchase_inv_cd" />
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of
																		select="/report/drawers/row[drawer_no=$drawerNo]/drawer_nm" />
																</fo:block>
															</fo:table-cell>

															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block>


																	<xsl:call-template name="formattime">
																		<xsl:with-param name="timestr" select="payment_ts" />
																	</xsl:call-template>
																</fo:block>
															</fo:table-cell>


															<fo:table-cell text-align="right"
																xsl:use-attribute-sets="minicell">
																<fo:block>
																	<xsl:value-of
																		select="format-number(total_gross_price, '###.##0,00', 'money')" />
																	<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
																</fo:block>
															</fo:table-cell>
															<fo:table-cell text-align="left"
																xsl:use-attribute-sets="minicell">
																<fo:block margin-left="5mm">
																		<xsl:variable name="paymentType">
																	<xsl:value-of select="payment_type" />
																</xsl:variable>
																<xsl:variable name="paymentDirection">
																	<xsl:value-of select="payment_direction" />
																</xsl:variable>
																<xsl:value-of
																	select="/report/payment_types/row[payment_direction=2][payment_type=$paymentType]/report_nm" />
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
													<fo:table-row>
														<fo:table-cell text-align="left"
															number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
															<fo:block>SUMME</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell-bold">
															<fo:block>
																<xsl:value-of
																	select="format-number(sum(report/purchase_notes/row/total_gross_price), '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell-bold">
															<fo:block>&#160;</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</xsl:if>
					
						<xsl:if test="report/canceled_purchase_notes/row">
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block> Stornierte Ausgaben</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>


											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>ext. Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>

													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Zahlart</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/canceled_purchase_notes/row">


													<xsl:variable name="drawerNo">


														<xsl:value-of select="drawer_no" />

													</xsl:variable>

													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="purchase_inv_id" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="purchase_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="/report/drawers/row[drawer_no=$drawerNo]/drawer_nm" />
															</fo:block>
														</fo:table-cell>

														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>


																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr" select="payment_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>


														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(total_gross_price, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																	<xsl:variable name="paymentType">
																	<xsl:value-of select="payment_type" />
																</xsl:variable>
																<xsl:variable name="paymentDirection">
																	<xsl:value-of select="payment_direction" />
																</xsl:variable>
																<xsl:value-of
																	select="/report/payment_types/row[payment_direction=1][payment_type=$paymentType]/report_nm" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/canceled_purchase_notes/row/total_gross_price), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
					
						<xsl:if test="report/cashOut/row">
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Entnahmen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="50mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Notiz</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/cashOut/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="employee_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr" select="payment_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="payment_ref" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
															
																
															</fo:block>
														</fo:table-cell>
													
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/cashOut/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
					
						<xsl:if test="report/cashIn/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Einlagen</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="50mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Notiz</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/cashIn/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="employee_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr" select="payment_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="payment_ref" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
															
																
															</fo:block>
														</fo:table-cell>
													
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/cashIn/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
					
						<xsl:if test="report/vouchers_out/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block >Gutscheine</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Ausgegeben</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutschein Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/vouchers_out/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_out/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


						</xsl:if>
					
						<xsl:if test="report/vouchers_in/row">

							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Eingelöst</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutschein Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/vouchers_in/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_in/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														number-columns-spanned="2" xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>


											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>


				<xsl:if test="report/vouchers_rebate_out/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block >Gutscheine mit Rabatten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Ausgegeben</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutschein Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Enthaltener Rabatt</fo:block>
													</fo:table-cell>
													
													
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/vouchers_rebate_out/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(sales_voucher_value_rebate, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_rebate_out/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
													
												
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


						</xsl:if>
					
						<xsl:if test="report/vouchers_rebate_in/row">
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block >Gutscheine mit Rabatten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Eingelöst</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutschein Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
												<!-- <fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gegebener Rabatt</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Übertragener Rabatt</fo:block>
													</fo:table-cell> -->	
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>angerechneter Rabatt</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/vouchers_rebate_in/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
													<!-- 	<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(sales_voucher_value_rebate, '###.##0,00', 'money')" />
															
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(sales_voucher_value_rebate_dist, '###.##0,00', 'money')" />
																
															</fo:block>
														</fo:table-cell> -->
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of	select="format-number(sales_voucher_value_rebate_eff, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_rebate_in/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														number-columns-spanned="2" xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												<!-- <fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_rebate_in/row/sales_voucher_value_rebate), '###.##0,00', 'money')" />
													

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_rebate_in/row/sales_voucher_value_rebate_dist), '###.##0,00', 'money')" />
													
														</fo:block>
													</fo:table-cell> -->
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/vouchers_rebate_in/row/sales_voucher_value_rebate_eff), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
												</fo:table-row>


											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>



						<xsl:if test="report/voucher_cards_out/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block >Gutscheinkarten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Ausgegeben </fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutscheinkarten Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/voucher_cards_out/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/voucher_cards_out/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


						</xsl:if>
					
						<xsl:if test="report/voucher_cards_in/row">
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block >Gutscheinkarten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center" number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-subtitle">
									<fo:block>Eingelöst </fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="30mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Gutscheinkarten Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Betrag</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/voucher_cards_in/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cashier_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="voucher_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/voucher_cards_in/row/payment), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														number-columns-spanned="2" xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>


											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>


						<xsl:if test="report/canceled_notes/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Übersicht stornierte Bons</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<!-- <fo:table-column column-width="20mm"></fo:table-column> -->
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title2"> 
														<fo:block>Terminal</fo:block> </fo:table-cell> -->
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Umsatz</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Grund</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/canceled_notes/row">
													<!-- <xsl:variable name="salesInvId" select="sales_inv_id/text()" 
														/> <xsl:variable name="employeeNm"> <xsl:for-each select="/report/canceled_note_payments/row[sales_inv_id=$salesInvId]/employee_nm"> 
														<xsl:value-of select="concat(substring(', ', 1 div (position()!=1)), .)" 
														/> </xsl:for-each> </xsl:variable> -->
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="minicell"> 
															<fo:block>-</fo:block> </fo:table-cell> -->
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="employee_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr"
																		select="sales_inv_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(total_gross_price, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="cancel_reason" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/canceled_notes/row/total_gross_price), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
					
						<xsl:if test="report/credit_notes/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Übersicht Gutschriften</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<!-- <fo:table-column column-width="20mm"></fo:table-column> -->
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title2"> 
														<fo:block>Terminal</fo:block> </fo:table-cell> -->
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Umsatz</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Storno-Grund</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/credit_notes/row">
													<!-- <xsl:variable name="salesInvId" select="sales_inv_id/text()" 
														/> <xsl:variable name="employeeNm"> <xsl:for-each select="/report/canceled_note_payments/row[sales_inv_id=$salesInvId]/employee_nm"> 
														<xsl:value-of select="concat(substring(', ', 1 div (position()!=1)), .)" 
														/> </xsl:for-each> </xsl:variable> -->
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="minicell"> 
															<fo:block>-</fo:block> </fo:table-cell> -->
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="employee_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:call-template name="formattime">
																	<xsl:with-param name="timestr"
																		select="sales_inv_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(total_gross_price, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:value-of select="cancel_reason" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="4" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/credit_notes/row/total_gross_price), '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->

														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if>
					
						<!-- <xsl:if test="report/canceled_payments/row">

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Übersicht Zahlartstornos</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="15mm"></fo:table-column>
											<fo:table-column column-width="15mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="20mm"></fo:table-column>
											<fo:table-column column-width="25mm"></fo:table-column>

											<fo:table-header>
												<fo:table-row>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kasse</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kassierer</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Umsatz</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block margin-left="5mm">Storniert</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Grund</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each select="report/canceled_payments/row">
													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="drawer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="employee_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:call-template name="formatdatetime">
																	<xsl:with-param name="datetimestr"
																		select="payment_ts" />
																</xsl:call-template>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">

															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>


														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(payment, '###.##0,00', 'money')" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block margin-left="5mm">
																<xsl:variable name="paymentType">
																	<xsl:value-of select="payment_type" />
																</xsl:variable>
																<xsl:value-of
																	select="/report/payment_types/row[payment_direction=0][payment_type=$paymentType]/report_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="cancel_reason" />
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="5" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(sum(report/canceled_payments/row/payment), '###.##0,00', 'money')" />
															
														</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														number-columns-spanned="2" xsl:use-attribute-sets="cell">
														<fo:block>&#160;</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:if> -->
					
						<xsl:if test="report/pos_notes_statistics/pos_note_stats/pos_stats_day/open_sis">
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									number-columns-spanned="2" xsl:use-attribute-sets="cell-title">
									<fo:block>Neue offene Posten</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="2" xsl:use-attribute-sets="cell">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2">
									<fo:block>
										<fo:table table-layout="fixed" width="100%">
											<!-- <fo:table-column column-width="20mm"></fo:table-column> <fo:table-column 
												column-width="20mm"></fo:table-column> -->
											<fo:table-column column-width="40mm"></fo:table-column>
											<fo:table-column column-width="50mm"></fo:table-column>
											<fo:table-column column-width="45mm"></fo:table-column>
											<fo:table-column column-width="35mm"></fo:table-column>
											<fo:table-header>

												<fo:table-row>
													<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title2"> 
														<fo:block>Kasse</fo:block> </fo:table-cell> -->
													<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title2"> 
														<fo:block>Kassierer</fo:block> </fo:table-cell> -->
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Zeit</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Beleg Nr</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="left"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Kunde</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="cell-title2">
														<fo:block>Offen</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body>
												<xsl:for-each
													select="report/pos_notes_statistics/pos_note_stats/pos_stats_day/open_sis">




													<xsl:variable name="grey_bg">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">
																#FFFFFF
															</xsl:when>
															<xsl:otherwise>
																#CCCCCC
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
													<fo:table-row background-color="{$grey_bg}">
														<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="minicell"> 
															<fo:block> <xsl:value-of select="$drawerNm" /> </fo:block> </fo:table-cell> -->
														<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="minicell"> 
															<fo:block> <xsl:value-of select="$employeeNm" /> </fo:block> </fo:table-cell> -->
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_ts" />

															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="sales_inv_cd" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="left"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of select="customer_nm" />
															</fo:block>
														</fo:table-cell>
														<fo:table-cell text-align="right"
															xsl:use-attribute-sets="minicell">
															<fo:block>
																<xsl:value-of
																	select="format-number(open_value, '###.##0,00', 'money')" />
																<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell text-align="left"
														number-columns-spanned="3" xsl:use-attribute-sets="minicell-bold">
														<fo:block>SUMME</fo:block>
													</fo:table-cell>
													<fo:table-cell text-align="right"
														xsl:use-attribute-sets="minicell-bold">
														<fo:block>
															<xsl:value-of
																select="format-number(report/pos_notes_statistics/pos_note_stats/pos_stats_day/open_values, '###.##0,00', 'money')" />
															<!-- &#160;<xsl:value-of select="$currencySymbol"></xsl:value-of> -->
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:if>
					
					
						
						
							
						</fo:table-body>
					</fo:table>





					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>