<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." />


	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>
		<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="THERMO"
					page-height="25cm" page-width="80mm" margin-top="0mm"
					margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
					<fo:region-body margin-top="0mm" margin-bottom="0mm"
						margin-left="5mm" margin-right="5mm" />
					<fo:region-before region-name="header" extent="7mm" />
					<fo:region-after region-name="footer" extent="7mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="THERMO">

				<fo:static-content flow-name="header">
					<fo:block text-align="center">
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block text-align="center">
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
				
								<xsl:variable name="currencySymbol">
					<xsl:value-of select="/SalesVoucher/departmentCurrencySymbol"></xsl:value-of>
				</xsl:variable>
				
				<fo:block-container width="100%" text-align="center">
					<fo:block>
						<fo:external-graphic content-width="scale-to-fit" content-height="100%" width="100%" scaling="uniform">
							<xsl:attribute name="src"><xsl:value-of select="/SalesVoucher/Businessunit/buLogoUrl" /></xsl:attribute>
						</fo:external-graphic>
					</fo:block>
				</fo:block-container>

				<fo:block-container width="100%">
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">
						<xsl:value-of select="/SalesVoucher/Businessunit/buNm1" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">
						<xsl:value-of select="/SalesVoucher/Businessunit/buNm2" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">
						<xsl:value-of select="/SalesVoucher/Businessunit/businessunitAdr2" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">
						<xsl:value-of select="/SalesVoucher/Businessunit/businessunitAdr3" />
					</fo:block>

					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">

						<xsl:value-of select="/SalesVoucher/Businessunit/buEmail" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">

						<xsl:value-of select="/SalesVoucher/Businessunit/buPhone" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="text-style" text-align="center">

						<xsl:value-of select="/SalesVoucher/Businessunit/buWeb" />
					</fo:block>

					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
					<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
				</fo:block-container>
				
				
				
				 
					<fo:block-container width="70mm">
					 <fo:block xsl:use-attribute-sets="title-style" text-align="center" padding-bottom="4mm">
							Rabattgutschein
						</fo:block>
						<fo:block xsl:use-attribute-sets="title-style" text-align="center" padding-bottom="4mm">
							Kunde: <xsl:value-of select="/SalesVoucher/CustomerName" />
						</fo:block>
						<fo:block text-align="center" font-size="12pt">
							<fo:instream-foreign-object>
								<xsl:variable name="barcode-cfg">
									<barcode width="40mm">
										<code128>
											<human-readable>none</human-readable>
											<height>16mm</height>
											<module-width>0.25mm</module-width>
											<quiet-zone enabled="false" />
										</code128>
									</barcode>
								</xsl:variable>
								<xsl:copy-of
									select="barcode:generate($barcode-cfg, /SalesVoucher/salesVoucherCd)" />
							</fo:instream-foreign-object>
						</fo:block>
						<fo:block font-size="9pt" text-align="center">
							<xsl:value-of select="/SalesVoucher/salesVoucherCd" />
						</fo:block>
						<fo:block font-size="9pt" text-align="center" padding-top="3mm" padding-bottom="2mm">
							Bei Ihrem nächsten Besuch erhalten Sie
							<xsl:value-of
								select='format-number(/SalesVoucher/voucherValue, "###.##0,00", "money")' />
							&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
							Rabatt für Ihre Treue.
						</fo:block>
					</fo:block-container>
					
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>