<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." />
		<xsl:decimal-format name="amount" decimal-separator=","
			grouping-separator="." />
			<xsl:decimal-format name="percent"
				decimal-separator="," grouping-separator="." />

				<xsl:attribute-set name="debug">
					<xsl:attribute name="border-color">red</xsl:attribute>
					<xsl:attribute name="border-width">0.5mm</xsl:attribute>
					<xsl:attribute name="border-style">solid</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="th1">
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="padding">0.5mm</xsl:attribute>
					<xsl:attribute name="border-color">black</xsl:attribute>
					<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-top-style">dotted</xsl:attribute>
					<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="th1bold">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="padding">0.5mm</xsl:attribute>
					<xsl:attribute name="border-color">black</xsl:attribute>
					<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-top-style">dotted</xsl:attribute>
					<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="th2bold">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="padding">0.5mm</xsl:attribute>
					<xsl:attribute name="border-color">black</xsl:attribute>
					<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-top-style">dotted</xsl:attribute>
					<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="tf2">
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="padding">0.5mm</xsl:attribute>
					<xsl:attribute name="border-color">black</xsl:attribute>
					<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
					<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
				</xsl:attribute-set>


				<xsl:attribute-set name="cell-style">
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="padding">0.5mm</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="text-style">
					<xsl:attribute name="font-size">8pt</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="text-small">
					<xsl:attribute name="font-size">6pt</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="text-bold">
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					<xsl:attribute name="font-weight">bold</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="spacer">
					<xsl:attribute name="font-size">3pt</xsl:attribute>
					<xsl:attribute name="line-height">1mm</xsl:attribute>
				</xsl:attribute-set>

				<xsl:attribute-set name="title-style">
					<xsl:attribute name="font-size">10pt</xsl:attribute>
					<xsl:attribute name="font-weight">bold</xsl:attribute>
				</xsl:attribute-set>


				<xsl:template match="/">
					<fo:root>
						<fo:layout-master-set>
							<fo:simple-page-master master-name="THERMO"
								page-height="25cm" page-width="70mm" margin-top="0mm"
								margin-bottom="0mm" margin-left="0mm" margin-right="0mm">
								<fo:region-body margin-top="5mm" margin-bottom="5mm"
									margin-left="0mm" margin-right="0mm" />
									<fo:region-before region-name="header" extent="7mm" />
									<fo:region-after region-name="footer" extent="7mm" />
								</fo:simple-page-master>
							</fo:layout-master-set>

							<fo:page-sequence master-reference="THERMO">
								<fo:static-content flow-name="header">
									<fo:block>
										<fo:instream-foreign-object xmlns:svg="http://www.w3.org/2000/svg">
											<svg:svg width="70mm" height="150mm">
												<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8">
													<svg:text x="50" y="70" font-family="Verdana"
														font-size="30" transform="rotate(60 20,40)">
														Muster, kein Beleg!
													</svg:text>
												</svg:g>
											</svg:svg>
										</fo:instream-foreign-object>
									</fo:block>
								</fo:static-content>
				<!-- <fo:static-content flow-name="footer"> <fo:block xsl:use-attribute-sets="text-style" 
					text-align="center"> Seite <fo:page-number /> von <fo:page-number-citation 
					ref-id="LastPage" /> </fo:block> </fo:static-content> -->

					<fo:flow flow-name="xsl-region-body">
						<xsl:variable name="currencySymbol">
							<xsl:value-of select="SalesInv/departmentCurrencySymbol"></xsl:value-of>
						</xsl:variable>
						
						<fo:block-container width="7cm" text-align="center">
							<fo:block>
								<fo:external-graphic content-width="scale-to-fit"
									content-height="100%" width="100%" scaling="uniform">
									<xsl:attribute name="src"><xsl:value-of
										select="SalesInv/buLogoUrl" /></xsl:attribute>
									</fo:external-graphic>
								</fo:block>
							</fo:block-container>

							<fo:block-container width="7cm">
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									<xsl:value-of select="SalesInv/businessunitAdr0" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									<xsl:value-of select="SalesInv/buNm1" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									<xsl:value-of select="SalesInv/buNm2" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									<xsl:value-of select="SalesInv/businessunitAdr2" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									<xsl:value-of select="SalesInv/businessunitAdr3" />
								</fo:block>

								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									EMail:
									<xsl:value-of select="SalesInv/buEmail" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									Telefon:
									<xsl:value-of select="SalesInv/buPhone" />
								</fo:block>
								<fo:block xsl:use-attribute-sets="text-style" text-align="center">
									Web:
									<xsl:value-of select="SalesInv/buWeb" />
								</fo:block>

								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
							</fo:block-container>
							<fo:block-container width="70mm">

								<xsl:choose>
									<xsl:when test='SalesInv/salesInvType=2'>
										<fo:block xsl:use-attribute-sets="title-style"
											text-align="center">
											Gutschrift
										</fo:block>
										<fo:block xsl:use-attribute-sets="text-style"
											text-align="center">
											Beleg-Nr.:
											<xsl:value-of select="SalesInv/salesInvCd" />
										</fo:block>
										<fo:block xsl:use-attribute-sets="text-style"
											text-align="center">
											Datum:
											<xsl:value-of select="SalesInv/salesInvTsD" />
											&#160;
											<xsl:value-of select="SalesInv/salesInvTsT" />
										</fo:block>
										<fo:block xsl:use-attribute-sets="text-small"
											text-align="center">
											(Rechnungskorrektur für Beleg-Nr.
											<xsl:value-of select="SalesInv/cancelForSalesInvCd" />
											vom
											<xsl:value-of select="SalesInv/cancelForSalesInvTsD" />
											&#160;
											<xsl:value-of select="SalesInv/cancelForSalesInvTsT" />
											)
										</fo:block>
									</xsl:when>
									<xsl:otherwise>
										<fo:block xsl:use-attribute-sets="title-style"
											text-align="center">
											Bon
										</fo:block>
										<fo:block xsl:use-attribute-sets="text-style"
											text-align="center">
											Beleg-Nr.:
											<xsl:value-of select="SalesInv/salesInvCd" />
										</fo:block>
										<fo:block xsl:use-attribute-sets="text-style"
											text-align="center">
											Datum:
											<xsl:value-of select="SalesInv/salesInvTsD" />
											&#160;
											<xsl:value-of select="SalesInv/salesInvTsT" />
										</fo:block>
									</xsl:otherwise>
								</xsl:choose>
								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
							</fo:block-container>
							<fo:block-container width="70mm">
								<fo:block text-align="center">
									<fo:instream-foreign-object>
										<xsl:variable name="barcode-cfg">
											<barcode>
												<code128>
													<human-readable>none</human-readable>
													<height>10mm</height>
													<quiet-zone enabled="false" />
												</code128>
											</barcode>
										</xsl:variable>
										<xsl:copy-of
											select="barcode:generate($barcode-cfg, /SalesInv/salesInvCd)" />
										</fo:instream-foreign-object>
									</fo:block>
									<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								</fo:block-container>

								<fo:block-container width="70mm">
									<fo:block xsl:use-attribute-sets="text-style" text-align="center">
										Kassiert von:
										<xsl:value-of select="SalesInv/employeeNm" />
										(
										<xsl:value-of select="SalesInv/employeeNo" />
										)
									</fo:block>
									<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								</fo:block-container>
								<fo:block-container width="70mm">
									<fo:block xsl:use-attribute-sets="text-style" text-align="center">
										Kunde:
										<xsl:value-of select="SalesInv/customerAdr1" />
									</fo:block>
									<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								</fo:block-container>
								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
								<fo:table border-collapse="separate" table-layout="fixed"
									border="1" width="100%">
									<fo:table-column column-width="4.00cm"></fo:table-column>
									<fo:table-column column-width="1.25cm"></fo:table-column>
									<fo:table-column column-width="1.75cm"></fo:table-column>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="left"
												xsl:use-attribute-sets="th1bold">
												<fo:block>Bezeichnung</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="th1bold">
												<fo:block>MwSt.</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="right"
												xsl:use-attribute-sets="th1bold">
												<fo:block>Betrag</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<xsl:for-each select="SalesInv/SalesInvPosition">
											<fo:table-row>
												<!-- Artikel, Rabatte -->
												<fo:table-cell padding="0.5mm" text-align="right"
													font-size="6pt">
													<fo:block>
														<fo:table border-collapse="separate" table-layout="fixed"
															width="100%" border="1">
															<fo:table-column column-width="2.5cm"></fo:table-column>
															<fo:table-column column-width="1.5cm"></fo:table-column>
															<fo:table-body>
																<!-- Artikel -->
																<fo:table-row>
																	<fo:table-cell text-align="left"
																		number-columns-spanned="2" xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="itemNm" />
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell text-align="left"
																		number-columns-spanned="2" xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="itemCd" />
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell text-align="left"
																		number-columns-spanned="2" xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of select="Employees" />
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>

																<!-- Menge, Einzelpreis, Preis -->
																<fo:table-row>
																	<fo:table-cell text-align="left"
																		xsl:use-attribute-sets="cell-style">
																		<fo:block>
																			<xsl:value-of
																				select='format-number(amount, "###.##0,00", "amount")' />
																				<xsl:text disable-output-escaping="yes"><![CDATA[ ]]></xsl:text>
																				x á
																				<xsl:value-of
																					select='format-number(itemPrice, "###.##0,00", "money")' />
																					&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell text-align="right"
																				xsl:use-attribute-sets="cell-style">
																				<fo:block>

																					<xsl:value-of
																						select='format-number(posRebateBasePrice, "###.##0,00", "money")' />
																						&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>


																			<!-- Positionsrabatt -->

																			<xsl:if test='appliedPosRebatePrice!=0'>
																				<fo:table-row>
																					<fo:table-cell text-align="left"
																						xsl:use-attribute-sets="cell-style">
																						<fo:block>
																							<xsl:choose>
																								<xsl:when test='posRebateRatePercent>0'>
																									<xsl:value-of
																										select='format-number(posRebateRatePercent, "#0,00", "percent")' />
																										% von
																										<xsl:value-of
																											select='format-number(posRebateBasePrice,
																											"###.##0,00", "money")' />
																											&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>

																										</xsl:when>
																										<xsl:otherwise>
																											Nachlass
																										</xsl:otherwise>
																									</xsl:choose>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell text-align="right"
																								xsl:use-attribute-sets="cell-style">
																								<fo:block>
																									<xsl:value-of
																										select='format-number(-appliedPosRebatePrice,
																										"###.##0,00", "money")' />
																										&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																						</xsl:if>
																						<!-- Belegrabatt -->
																						<xsl:if test='appliedInvRebatePrice!=0'>
																							<fo:table-row>
																								<fo:table-cell text-align="left"
																									xsl:use-attribute-sets="cell-style">
																									<fo:block>
																										<xsl:value-of
																											select='format-number(invRebateRatePercent, "#0,00", "percent")' />
																											% von
																											<xsl:value-of
																												select='format-number(invRebateBasePrice,
																												"###.##0,00", "money")' />
																												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>

																											</fo:block>
																										</fo:table-cell>
																										<fo:table-cell text-align="right"
																											xsl:use-attribute-sets="cell-style">
																											<fo:block>
																												<xsl:value-of
																													select='format-number(-appliedInvRebatePrice,
																													"###.##0,00", "money")' />
																													&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																												</fo:block>
																											</fo:table-cell>
																										</fo:table-row>
																									</xsl:if>
																								</fo:table-body>
																							</fo:table>



																						</fo:block>
																					</fo:table-cell>
																					<!-- Steuersatz -->
																					<fo:table-cell text-align="right"
																						xsl:use-attribute-sets="cell-style">
																						<fo:block>
																							<xsl:if test='taxRatePercent>0'>
																								<xsl:value-of
																									select='format-number(taxRatePercent, "#0", "percent")' />
																									%
																								</xsl:if>
																							</fo:block>
																						</fo:table-cell>
																						<!-- Brutto Position -->
																						<fo:table-cell text-align="right"
																							xsl:use-attribute-sets="cell-style">
																							<fo:block>
																								<xsl:value-of
																									select='format-number(positionGrossPrice, "###.##0,00", "money")' />
																									&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																								</fo:block>
																							</fo:table-cell>

																						</fo:table-row>
																					</xsl:for-each>
																				</fo:table-body>
																			</fo:table>

																			<fo:table border-collapse="separate" table-layout="fixed"
																				width="100%">
																				<fo:table-column column-width="5.25cm"></fo:table-column>
																				<fo:table-column column-width="1.75cm"></fo:table-column>
																				<fo:table-body>
																					<fo:table-row>
																						<fo:table-cell text-align="right"
																							xsl:use-attribute-sets="th2bold">
																							<fo:block>Rechnungsbetrag:
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell text-align="right"
																							xsl:use-attribute-sets="th2bold">
																							<fo:block>
																								<xsl:value-of
																									select='format-number(SalesInv/totalGrossPrice, "###.##0,00", "money")' />
																									&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>

																				<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>
																				<fo:table border-collapse="separate" table-layout="fixed"
																					width="100%">
																					<fo:table-column column-width="5.25cm"></fo:table-column>
																					<fo:table-column column-width="1.75cm"></fo:table-column>
																					<fo:table-body>
																						<xsl:for-each select="SalesInv/SalesInvTaxTotal">
																							<fo:table-row>
																								<fo:table-cell text-align="right"
																									xsl:use-attribute-sets="cell-style">
																									<fo:block>
																										<xsl:value-of select="taxDesc" />
																										&#160;
																										<xsl:value-of
																											select='format-number(taxRatePercent, "#0", "percent")' />
																											%
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="0.5mm" text-align="right"
																										xsl:use-attribute-sets="cell-style">
																										<fo:block>
																											<xsl:value-of
																												select='format-number(totalTaxPrice, "###.##0,00", "money")' />
																												&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																											</fo:block>
																										</fo:table-cell>
																									</fo:table-row>

																									<fo:table-row>
																										<fo:table-cell text-align="right"
																											xsl:use-attribute-sets="cell-style">
																											<fo:block>Nettoumsatz</fo:block>
																										</fo:table-cell>
																										<fo:table-cell text-align="right"
																											xsl:use-attribute-sets="cell-style">
																											<fo:block>
																												<xsl:value-of
																													select='format-number(totalNetPrice, "###.##0,00", "money")' />
																													&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																												</fo:block>
																											</fo:table-cell>
																										</fo:table-row>
																										<fo:table-row>
																											<fo:table-cell text-align="right"
																												xsl:use-attribute-sets="cell-style">
																												<fo:block>Bruttoumsatz</fo:block>
																											</fo:table-cell>
																											<fo:table-cell text-align="right"
																												xsl:use-attribute-sets="cell-style">
																												<fo:block>
																													<xsl:value-of
																														select='format-number(totalGrossPrice, "###.##0,00", "money")' />
																														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</xsl:for-each>
																									</fo:table-body>
																								</fo:table>

																								<fo:block xsl:use-attribute-sets="spacer">&#160;</fo:block>


																								<fo:table border-collapse="separate" table-layout="fixed"
																									width="100%">
																									<fo:table-column column-width="5.25cm"></fo:table-column>
																									<fo:table-column column-width="1.75cm"></fo:table-column>
																									<fo:table-body>
																										<fo:table-row>
																											<fo:table-cell text-align="right"
																												xsl:use-attribute-sets="th1">
																												<fo:block>Zahlart</fo:block>
																											</fo:table-cell>
																											<fo:table-cell text-align="right"
																												xsl:use-attribute-sets="th1">
																												<fo:block>Zahlbetrag</fo:block>
																											</fo:table-cell>
																										</fo:table-row>
																										<xsl:for-each select="SalesInv/PosPayment">

																											<fo:table-row>
																												<fo:table-cell text-align="right"
																													xsl:use-attribute-sets="cell-style">
																													<fo:block>
																														<xsl:choose>
																															<xsl:when test="paymentType=1">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Gegeben Bar
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Ausgezahlt Bar
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=2">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Gutscheineinreichung
																																		&#160;
																																		<xsl:value-of select="paymentRef" />
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Gutscheinausgabe
																																		&#160;
																																		<xsl:value-of select="paymentRef" />
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=3">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Einzahlung
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Rückgeld Bar
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=4">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		EC-Zahlung
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Überweisung
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=5">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Kreditkarte
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Kreditkarte
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=6">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Barnachlass
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Barnachlass
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:when test="paymentType=7">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Anrechnung Rechnungskorrektur
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Guthaben Rechnungskorrektur
																																	</xsl:otherwise>
																																</xsl:choose>
																																&#160;Beleg Nr.
																																<xsl:value-of select="paymentRef" />
																															</xsl:when>
																															<xsl:when test="paymentType=8">
													<xsl:choose>
														<xsl:when test="paymentDirection=1">
															Überweisung
														</xsl:when>
														<xsl:otherwise>
															Überweisung
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
																															<xsl:when test="paymentType=10">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Punktenachlass
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Punktenachlass
																																	</xsl:otherwise>
																																</xsl:choose>

																															</xsl:when>
																															<xsl:when test="paymentType=11">
																																<xsl:choose>
																																	<xsl:when test="paymentDirection=1">
																																		Gutscheineinreichung
																																		&#160;
																																		<xsl:value-of select="paymentRef" />
																																	</xsl:when>
																																	<xsl:otherwise>
																																		Gutscheinausgabe
																																		&#160;
																																		<xsl:value-of select="paymentRef" />
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:when>
																															<xsl:otherwise>
																																<xsl:value-of select='paymentType' />
																																&#160;
																																<xsl:value-of select='paymentDirection' />
																																&#160;
																																<xsl:value-of select="paymentRef" />
																															</xsl:otherwise>
																														</xsl:choose>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell text-align="right"
																													xsl:use-attribute-sets="cell-style">
																													<fo:block>
																														<xsl:value-of select='format-number(payment, "###.##0,00", "money")' />
																														&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>

																											<xsl:if test="paymentChange > 0">
																												<fo:table-row>
																													<fo:table-cell text-align="right"
																														xsl:use-attribute-sets="cell-style">
																														<fo:block>
																															Rückgeld Bar
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell text-align="right"
																														xsl:use-attribute-sets="cell-style">
																														<fo:block>
																															<xsl:value-of
																																select='format-number(paymentChange, "###.##0,00", "money")' />
																																&#160;<xsl:value-of select="$currencySymbol"></xsl:value-of>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</xsl:if>

																											</xsl:for-each>
																											<fo:table-row>
																												<fo:table-cell text-align="right" font-size="6pt"
																													font-weight="bold" border-top-style="dotted" border-top-width="0.25mm"
																													border-color="black">
																													<fo:block>&#160;</fo:block>
																												</fo:table-cell>
																												<fo:table-cell text-align="right" font-size="6pt"
																													font-weight="bold" border-top-style="dotted" border-top-width="0.25mm"
																													border-color="black">
																													<fo:block>&#160;</fo:block>
																												</fo:table-cell>
																											</fo:table-row>


																										</fo:table-body>
																									</fo:table>
			<!-- 		<xsl:if test="SalesInv/currentSalesCreditPoints">
						<fo:table border-collapse="separate" table-layout="fixed"
							border="1" width="100%">
							<fo:table-column column-width="7cm"></fo:table-column>
							<fo:table-body>
								<fo:table-row>

									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style">
										<fo:block xsl:use-attribute-sets="text-bold">
											Punktestand:&#160;
											<xsl:value-of select="SalesInv/currentSalesCreditPoints" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>

									<fo:table-cell text-align="right" font-size="6pt"
										font-weight="bold" border-top-style="dotted" border-top-width="0.25mm"
										border-color="black">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</fo:table-body>
						</fo:table>

					</xsl:if> -->
					<fo:block-container width="70mm" left="0cm"
						keep-together.within-page="always">
						<fo:table border-collapse="separate" table-layout="fixed"
							border="1" width="100%">
							<fo:table-column column-width="2.25cm"></fo:table-column>
							<fo:table-column column-width="4.75cm"></fo:table-column>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="cell-style" number-columns-spanned="2">
										<fo:block xsl:use-attribute-sets="text-style">
											<xsl:value-of select="SalesInv/buNoteTxt" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="tf2" number-columns-spanned="2">
										<fo:block xsl:use-attribute-sets="text-style">&#160; </fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- <fo:table-row> <fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style"> 
									<fo:block> Steuernummer: </fo:block> </fo:table-cell> <fo:table-cell text-align="left" 
									xsl:use-attribute-sets="cell-style"> <fo:block> <xsl:value-of select="SalesInv/buTaxId" 
									/> </fo:block> </fo:table-cell> </fo:table-row> -->
									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												USt-ID:
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of select="SalesInv/buEuTaxId" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												Bank:
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of select="SalesInv/buBankNm" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								<!-- <fo:table-row> <fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style"> 
									<fo:block> Kontoinhaber: </fo:block> </fo:table-cell> <fo:table-cell text-align="left" 
									xsl:use-attribute-sets="cell-style"> <fo:block> <xsl:value-of select="SalesInv/buBankAcctHolder" 
									/> </fo:block> </fo:table-cell> </fo:table-row> -->
									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												IBAN:
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of select="SalesInv/buIban" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="tf2">
											<fo:block>
												BIC:
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="tf2">
											<fo:block>
												<xsl:value-of select="SalesInv/buBic" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block-container>
						<fo:block id="LastPage" />
					</fo:flow>
				</fo:page-sequence>
			</fo:root>
		</xsl:template>

	</xsl:stylesheet>