<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell2">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-title">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-top-style">dotted</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dotted</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-subtitle">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="itemGroup">
		<xsl:param name="groupId" />

		<xsl:for-each select="/report/item_groups/row">

			<xsl:if test="id[text() = $groupId]">
				<xsl:if test="parent_item_group_cd[text() != '']">
					<xsl:call-template name="itemGroup">
						<xsl:with-param name="groupId" select="parent_item_group_cd" />
					</xsl:call-template>
					<xsl:text>/</xsl:text>
				</xsl:if>
				<xsl:value-of select="item_group_nm" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="sumPurchasePrice">
		<xsl:param name="itemList" />

		<xsl:param name="result" />


		<xsl:choose>
			<xsl:when test="not($itemList)">
				<xsl:choose>
					<xsl:when test="$result">

						<xsl:value-of select='format-number($result,"##0,00", "money")' />

					</xsl:when>
					<xsl:otherwise>


					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="itemCd" select="$itemList[1]/itemCd"></xsl:variable>
				<xsl:choose>
					<xsl:when test="/report/selectableItems/row[item_cd = $itemCd]">
						<xsl:call-template name="sumPurchasePrice">
							<xsl:with-param name="itemList"
								select="$itemList[position( ) &gt; 1]" />
							<xsl:with-param name="result"
								select="$result + ($itemList[1]/itemPurchaseTotalPrice)" />

						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>

						<xsl:call-template name="sumPurchasePrice">
							<xsl:with-param name="itemList"
								select="$itemList[position( ) &gt; 1]" />


							<xsl:with-param name="result" select="$result" />

						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>


	</xsl:template>


	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="29.7cm" page-width="21cm" margin-top="20mm"
					margin-bottom="20mm" margin-left="20mm" margin-right="20mm">
					<fo:region-body margin-top="25mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="25mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header">
					<fo:block text-align="center" xsl:use-attribute-sets="report-title">
						Lagerbestand
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_nm_2" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/bu_street" />
						,
						<xsl:value-of select="report/businessunits/row/bu_postal_cd" />
						&#160;
						<xsl:value-of select="report/businessunits/row/bu_city" />
						,
						<xsl:value-of select="report/businessunits/row/bu_country_cd" />
					</fo:block>
					<fo:block text-align="center" xsl:use-attribute-sets="report-subtitle">
						<xsl:value-of select="report/businessunits/row/businessunit_nm" />
						, Kostenstelle
						<xsl:value-of select="report/businessunits/row/bu_nm_1" />
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text" text-align="left"
						font-size="8pt">
						<fo:table width="100%">
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text">
										<fo:block>
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="center"
										xsl:use-attribute-sets="text">
										<fo:block>
											Lagerbestand
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" width="100mm">
						<fo:table-column column-width="32mm"></fo:table-column>
						<fo:table-column column-width="3mm"></fo:table-column>
						<fo:table-column column-width="65mm"></fo:table-column>

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Lagerort
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:variable name="selStockNo"
											select="report/report-params/STOCK_NO"></xsl:variable>
										<xsl:for-each select="report/stocks/row">
											<xsl:if test="id[text() = $selStockNo]">
												<xsl:value-of select="txt" />
											</xsl:if>


										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Lieferant
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/report-params/SUPPLIER_NO = 'null'">
												Alle Lieferanten
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="selSupplierNo"
													select="report/report-params/SUPPLIER_NO"></xsl:variable>
												<xsl:for-each select="report/supplier/row">

													<xsl:if test="id[text() = $selSupplierNo]">
														<xsl:choose>
															<xsl:when test="first_nm != ''">
																<xsl:value-of select="first_nm" />
																&#160;
																<xsl:value-of select="contact_nm" />
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="contact_nm" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>

												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Einkaufsgruppe
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
											<xsl:when
												test="report/report-params/ITEM_PURCHASE_GROUP_CD = 'null'">
												Alle Einkaufsgruppen
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="selItemPurchaseGroupNo"
													select="report/report-params/ITEM_PURCHASE_GROUP_CD"></xsl:variable>
												<xsl:for-each select="report/item_purchase_groups/row">

													<xsl:if test="id[text() = $selItemPurchaseGroupNo]">
														<xsl:value-of select="item_purchase_group_nm" />
													</xsl:if>
												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>

									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Artikelgruppe
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:choose>
											<xsl:when test="report/report-params/ITEM_GROUP_CD = 'null'">
												Alle Artikelgruppen
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="itemGroup">
													<xsl:with-param name="groupId"
														select="report/report-params/ITEM_GROUP_CD" />
												</xsl:call-template>
												<!-- <xsl:variable name="selItemGroupNo" select="report/item-list/itemGroupCd"></xsl:variable> 
													<xsl:for-each select="report/item_groups/row"> <xsl:if test="id[text() = 
													$selItemGroupNo]"> <xsl:value-of select="item_group_nm" /> </xsl:if> </xsl:for-each> -->
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Datum
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										<xsl:call-template name="formatdatetime">
											<xsl:with-param name="datetimestr"
												select="report/report-params/DATE" />
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										Suche
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell2">
									<fo:block>
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block>
										<xsl:value-of select="report/report-params/SEARCH_STRING" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell text-align="center"
									number-columns-spanned="3" xsl:use-attribute-sets="cell2">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>

					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="35%"></fo:table-column>
						<fo:table-column column-width="15%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<!-- <fo:table-column column-width="35mm"></fo:table-column> -->
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>

						<fo:table-header>
							<fo:table-row>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Artikelname</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Art.-Nr.</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Bestand</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>EK</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>EK-Wert</fo:block>
								</fo:table-cell>

								<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-title"> 
									<fo:block>EAN</fo:block> </fo:table-cell> -->
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>Verkauf</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-title">
									<fo:block>VK</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							<xsl:for-each
								select="report/inventory-item-list/stockItemList/stockItem">
								<xsl:variable name="itemCd" select="itemCd">
								</xsl:variable>
								<xsl:if test="/report/selectableItems/row[item_cd = $itemCd]">
									<!-- <xsl:variable name="grey_bg"> <xsl:choose> <xsl:when test="position() 
										mod 2 = 1"> #FFFFFF </xsl:when> <xsl:otherwise> #CCCCCC </xsl:otherwise> 
										</xsl:choose> </xsl:variable> -->


									<!-- <fo:table-row background-color="{$grey_bg}"> -->
									<fo:table-row>
										<fo:table-cell text-align="left"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of select="itemNm" />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="cell-style">
											<fo:block>

												<xsl:value-of select="itemCd" />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell-style">
											<fo:block>

												<xsl:value-of select="format-number(amount, '###.##0', 'amount')" />

											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell-style">
											<fo:block>

												<xsl:value-of
													select="format-number(itemPurchasePrice, '###.##0,00', 'money')" />


											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell-style">
											<fo:block>

												<xsl:value-of
													select="format-number(itemPurchaseTotalPrice, '###.##0,00', 'money')" />


											</fo:block>
										</fo:table-cell>

										<!-- <fo:table-cell text-align="left" xsl:use-attribute-sets="cell-style"> 
											<fo:block> <xsl:value-of select="itemEAN" /> </fo:block> </fo:table-cell> -->
										<fo:table-cell text-align="center"
											xsl:use-attribute-sets="cell-style">
											<fo:block>
												<xsl:value-of select="itemSellable" />
											</fo:block>
										</fo:table-cell>
										<fo:table-cell text-align="right"
											xsl:use-attribute-sets="cell-style">
											<fo:block>


												<xsl:value-of
													select="format-number(itemSalesPrice, '###.##0,00', 'money')" />



											</fo:block>
										</fo:table-cell>


									</fo:table-row>
								</xsl:if>
							</xsl:for-each>
							<fo:table-row>
								<fo:table-cell text-align="left"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>Summe
									</fo:block>
								</fo:table-cell>
								<!-- <fo:table-cell text-align="center" xsl:use-attribute-sets="cell-bold"> 
									<fo:block> </fo:block> </fo:table-cell> -->
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
							<!--		<xsl:call-template name="sumPurchasePrice">
        <xsl:with-param name="itemList" select="/report/inventory-item-list/stockItemList/stockItem"/>
        
          
        <xsl:with-param name="result" select="0"/>
      </xsl:call-template>-->
							<!-- 	
										<xsl:value-of
											select="format-number(sum(/report/inventory-item-list/stockItemList/stockItem/itemPurchaseTotalPrice), '###.##0,00', 'money')" />
											-->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>

									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right"
									xsl:use-attribute-sets="cell-bold">
									<fo:block>
									</fo:block>
								</fo:table-cell>


							</fo:table-row>
						</fo:table-body>
					</fo:table>


					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

</xsl:stylesheet>