<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="barcode date" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />



	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>

			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdate2">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdate3">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm" select="'01'">
			
		</xsl:variable>

		<xsl:variable name="dd" select="'01'">
			
		</xsl:variable>

		<xsl:choose>

			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$yyyy" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="$dd" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="formatdatedmm">
		<xsl:param name="datestr" />

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,4,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,1,2)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:choose>
					<xsl:when test="substring($dd,1,1) = 0">
						<xsl:value-of select="substring($dd,2,1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$dd" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$mm" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	
		<csv:columns>

		<column>payment_orig_unformated<desc>Buchungsbetrag</desc></column>
		<column>acct_cd<desc>Konto</desc></column>
		<column>day_dt<desc>Belegdatum</desc></column>
		<column>acct<desc>Gegenkonto</desc></column>
	
		<column>simple_acct_nm<desc>Buchungstext</desc></column>

	</csv:columns>

	<xsl:template match="/">
	
	


		<!-- Output the CSV column header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>

<xsl:for-each select="/report/businessunits/row">

<xsl:variable name="pointOfSales" select="pos_cd_hint" />
<xsl:variable name="buNm1" select="bu_nm_1" />

		<xsl:for-each select="/report/cash_journal/pos_cash_journal/point_of_sales[pos_cd=$pointOfSales]/data/row">
			<xsl:variable name="property" select="." />
					<xsl:call-template name="printbusinessunitdata">
			<xsl:with-param name="posCd" select="$pointOfSales"></xsl:with-param>
		<xsl:with-param name="buNm1" select="$buNm1"></xsl:with-param>
			<xsl:with-param name="property" select="$property"></xsl:with-param>
			</xsl:call-template>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>
</xsl:for-each>


	</xsl:template>
	
<xsl:template name="printbusinessunitdata">
<xsl:param name="posCd" />
<xsl:param name="buNm1" />
<xsl:param name="property" />

	<xsl:variable name="contraAcctCd" select="'1000'" />
	<xsl:variable name="acctCd" select="$property/acct_cd" />
	<xsl:variable name="direction" select="$property/direction" />
<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
					<xsl:when test="$column='acct'">
						<xsl:choose>	
							<xsl:when test="$direction = 1">
								<xsl:value-of select="$contraAcctCd" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$acctCd" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$column='acct_cd'">
						<xsl:choose>	
							<xsl:when test="$direction = 1">
								<xsl:value-of select="$acctCd" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$contraAcctCd" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$column='payment_orig_unformated'">
						<xsl:value-of select="format-number($value, '0,00', 'money')" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>


	</xsl:template>
	
</xsl:stylesheet>