<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	 xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
        <column>position<desc>Platz</desc></column>
		<column>r_businessunit_no<desc>Salon</desc></column>
		<column>r_employee_no<desc>Ma-Nr.</desc></column>
		<column>r_employee_nm<desc>Mitarbeiter</desc></column>
		<column>r_planed_week_working_hours<desc>Soll Std</desc></column>

		<column>r_cnt_dt<desc>AT</desc></column>
		<column>r_total_product_per_day<desc>VK pro Tag</desc></column>
		
		<column>r_cnt_dt_prev<desc>AT Vorjahr</desc></column>
		<column>r_total_product_per_day_prev<desc>VK pro Tag Vorjahr</desc></column>

		<column>r_total_product_per_day_diff<desc>VK pro Tag Differnenz</desc></column>
		<column>r_total_product_per_day_diff_percent<desc>%</desc></column>
		
		
		
	</csv:columns>

	<xsl:template match="/">
<xsl:text>Hitliste Mitarbeiter von </xsl:text><xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/DATE" />
							</xsl:call-template>
							<xsl:text> bis </xsl:text><xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/TODATE" />
							</xsl:call-template>
							
					<xsl:text>
</xsl:text>
	
						<xsl:text>
</xsl:text>	
		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="/report/employeeRevenue/period/data/row">
			
				<xsl:variable name="property" select="." />
		        <xsl:variable name="posCd" select="r_pos_cd" />
				
		        <xsl:variable name="companyNo" select="r_company_no" />
		      	<xsl:variable name="departmentNo" select="r_department_no" />
		        <xsl:variable name="employeeNo" select="r_employee_no" />
				<xsl:variable name="position" select="position()"></xsl:variable>
			    <xsl:variable name="prevYearRow" select="/report/employeeRevenue/comparePeriod/data/row[r_pos_cd = $posCd][r_employee_no = $employeeNo]"></xsl:variable>
				<xsl:variable name="buNm" select="/report/businessunits/row[pos_cd_hint = $posCd]/businessunit_nm"></xsl:variable>
				<xsl:variable name="companyNm" select="/report/companies/row[company_no = $companyNo]/company_nm"></xsl:variable>
				<xsl:variable name="departmentNm" select="/report/departments/row[company_no = $companyNo][department_no = $departmentNo]/department_nm"></xsl:variable>


				<xsl:variable name="r_total_products" select="r_total_products"></xsl:variable>
				<xsl:variable name="r_total_product_per_day" select="r_total_product_per_day"></xsl:variable>
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>

					<xsl:when test="$column='position'"><xsl:text>"</xsl:text><xsl:value-of select="$position" /><xsl:text>"</xsl:text></xsl:when>
					<xsl:when test="$column='r_businessunit_no'"><xsl:text>"</xsl:text><xsl:value-of select="$buNm" /><xsl:text>"</xsl:text></xsl:when>
					<xsl:when test="$column='r_employee_no'"><xsl:text>"</xsl:text><xsl:value-of select="$employeeNo" /><xsl:text>"</xsl:text></xsl:when>
					<xsl:when test="$column='r_employee_nm'"><xsl:text>"</xsl:text><xsl:value-of select="$value" /><xsl:text>"</xsl:text></xsl:when>
					<xsl:when test="$column='r_planed_week_working_hours'"><xsl:value-of select="format-number($value, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_cnt_dt'"><xsl:value-of select="format-number($value, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_total_products'"><xsl:value-of select="format-number($value, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_total_product_per_day'"><xsl:value-of select="format-number($value, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_cnt_dt_prev'"><xsl:value-of select="format-number($prevYearRow/r_cnt_dt, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_total_products_prev'"><xsl:value-of select="format-number($prevYearRow/r_total_products, '###.##0,##','amount')" /></xsl:when>
					<xsl:when test="$column='r_total_product_per_day_prev'"><xsl:value-of select="format-number($prevYearRow/r_total_product_per_day, '###.##0,##','amount')" /></xsl:when>

					<xsl:when test="$column='r_total_products_diff'">
						<xsl:value-of select="format-number(($r_total_products - $prevYearRow/r_total_products), '###.##0,00', 'money')" />
					</xsl:when>

					<xsl:when test="$column='r_total_products_diff_percent'">
						<xsl:variable name="compare">
							<xsl:choose>
								<xsl:when test="$prevYearRow/r_total_products > 0">
									<xsl:value-of select="$prevYearRow/r_total_products" />
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="base">
							<xsl:choose>
								<xsl:when test="$r_total_products > 0">
									<xsl:value-of select="$r_total_products" />
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$compare > $base">-<xsl:value-of select="format-number(($compare - $base) div $compare * 100, '###.##0,00', 'amount')" />
							</xsl:when>
							<xsl:when test="$base > $compare">
								<xsl:value-of select="format-number(($base - $compare) div $base * 100, '###.##0,00', 'amount')" />
							</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>	
					</xsl:when>

					<xsl:when test="$column='r_total_product_per_day_diff'">
						<xsl:value-of select="format-number(($r_total_product_per_day - $prevYearRow/r_total_product_per_day), '###.##0,00', 'money')" />
					</xsl:when>
					<xsl:when test="$column='r_total_product_per_day_diff_percent'">
						<xsl:variable name="compare">
							<xsl:choose>
								<xsl:when test="$prevYearRow/r_total_product_per_day > 0">
									<xsl:value-of select="$prevYearRow/r_total_product_per_day" />
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="base">
							<xsl:choose>
								<xsl:when test="$r_total_product_per_day > 0">
									<xsl:value-of select="$r_total_product_per_day" />
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$compare != 0">
								<xsl:value-of select="format-number(($base div $compare - 1) * 100, '###.##0,00', 'amount')" />
								<text>%</text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>-</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
		


		
		</xsl:template>

	

</xsl:stylesheet>