<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />





	<xsl:output method="text" encoding="ISO-8859-1" />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />


	<xsl:template match="/">

	<xsl:text>"Lieferant"</xsl:text>
			<xsl:value-of select="$delimiter" />
<xsl:text>"Artikelname"</xsl:text>
			
			<xsl:value-of select="$delimiter" />
			
			<xsl:text>"Artikel-Nr."</xsl:text>
			<xsl:value-of select="$delimiter" />

			<xsl:text>"Bestand"</xsl:text>
			<xsl:value-of select="$delimiter" />
			<xsl:text>"EK"</xsl:text>
			<xsl:value-of select="$delimiter" />
		
			<xsl:text>"vorgeschlagene Bestellmenge"</xsl:text>

			<xsl:value-of select="$delimiter" />



			<xsl:text>
</xsl:text>

		<xsl:for-each select="/report/item_suppliers_supplier/row">


			<xsl:variable name="supplierNo" select="supplier_no"></xsl:variable>


			



			<xsl:for-each select="/report/item_suppliers/row[contact_no=$supplierNo]">
				<xsl:variable name="minStockAmount">
					<xsl:value-of select="min_stock_amount" />
				</xsl:variable>
				<xsl:variable name="minOrderAmount">
					<xsl:value-of select="order_amount" />
				</xsl:variable>
				<xsl:variable name="itemCd">
					<xsl:value-of select="item_cd" />
				</xsl:variable>
				<xsl:variable name="itemSupplierNo">
					<xsl:value-of select="contact_no" />
				</xsl:variable>


				<xsl:variable name="itemAmount">
					<xsl:value-of
						select="/report/inventory-item-list/stockItemList/stockItem[itemCd=$itemCd]/amount" />
				</xsl:variable>


				<xsl:variable name="orderAmount">
					<xsl:choose>
						
						<xsl:when test="($minStockAmount - $itemAmount) > $minOrderAmount">
							<xsl:value-of select="$minStockAmount - $itemAmount" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$minOrderAmount" />
						</xsl:otherwise>
					
					</xsl:choose>
				</xsl:variable>


<xsl:if test="/report/selectable_items/row[itemcd=$itemCd]">	

				<xsl:if test="$itemAmount &lt;= $minStockAmount">


<xsl:text>"</xsl:text>
			<xsl:for-each select="/report/supplier/row">

				<xsl:if test="id[text() = $supplierNo]">
					<xsl:choose>
						<xsl:when test="first_nm != ''">
							<xsl:value-of select="first_nm" />
							&#160;
							<xsl:value-of select="contact_nm" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="contact_nm" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:for-each>
			<xsl:text>"</xsl:text>

<xsl:value-of select="$delimiter" />
		
				

					
						<xsl:value-of
						select="/report/inventory-item-list/stockItemList/stockItem[itemCd=$itemCd]/itemNm" />
					<xsl:value-of select="$delimiter" />
				<xsl:value-of
						select="/report/inventory-item-list/stockItemList/stockItem[itemCd=$itemCd]/itemCd" />
					<xsl:value-of select="$delimiter" />

					<xsl:value-of
						select="format-number(/report/inventory-item-list/stockItemList/stockItem[itemCd=$itemCd]/amount, '##0', 'amount')" />
					<xsl:value-of select="$delimiter" />
					<xsl:value-of
						select="format-number(/report/inventory-item-list/stockItemList/stockItem[itemCd=$itemCd]/itemPurchasePrice, '##0,00', 'money')" />
					<xsl:value-of select="$delimiter" />
				
					<xsl:value-of select="format-number($orderAmount, '##0', 'amount')" />

					<xsl:value-of select="$delimiter" />
					<xsl:text>
</xsl:text>
				</xsl:if>
</xsl:if>
			</xsl:for-each>

		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>