<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
	extension-element-prefixes="barcode date exsl fox" xmlns:csv="csv:csv">


	<xsl:import href="Header.xsl"/>

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	
	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="right-cell-style">
	
		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bottom-cell-style">
	
		<xsl:attribute name="border-bottom-color">#000000</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1px</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	</xsl:attribute-set>



	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:template name="differenz">
		<xsl:param name="data"/>
		<xsl:param name="dataCompare"/>
		<xsl:param name="formatPattern" select="'###.##0,00'" />
		<xsl:param name="format" select="'money'" />
		<xsl:param name="sign" select="''" />
		
		<xsl:choose>
			<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
				<xsl:value-of select="format-number(0, $formatPattern, $format)"/><xsl:value-of select="$sign" />
			</xsl:when>
			<xsl:when test="string(number($dataCompare)) = 'NaN'">
				<xsl:value-of select="format-number($data, $formatPattern, $format)"/><xsl:value-of select="$sign" />
			</xsl:when>
			<xsl:when test="string(number($data)) = 'NaN'">
				<xsl:value-of select="format-number(0 -$dataCompare, $formatPattern, $format)"/><xsl:value-of select="$sign" />
			</xsl:when>
			<xsl:otherwise>
					<xsl:value-of select="format-number($data - $dataCompare, $formatPattern, $format)" /><xsl:value-of select="$sign" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="abweichung">
		<xsl:param name="data"/>
		<xsl:param name="dataCompare"/>

		<xsl:choose>
			<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
				<xsl:value-of select="'-'"/>
			</xsl:when>
			<xsl:when test="string(number($dataCompare)) = 'NaN'">
				<xsl:value-of select="'-'"/>
			</xsl:when>
			<xsl:when test="string(number($data)) = 'NaN'">
				<xsl:value-of select="format-number(0 ,'###.##0,##' , 'percent')"/>%
			</xsl:when>
			<xsl:when test="$dataCompare = 0">
				<xsl:value-of select="'-'" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="format-number((($data div $dataCompare ) -1) * 100 ,'###.##0,##' , 'percent')"/>%
			</xsl:otherwise>
		</xsl:choose>


	</xsl:template>




	<xsl:template name="salon-table">
		<xsl:param name="salonData" />
		<xsl:param name="position" />
		<xsl:param name="businessunits" />
	

		<xsl:variable name="greyBGColor" select="'#CCCCCC'"/>

		<xsl:variable name="posCd" select="$salonData/pos_cd"/>	
		
		<xsl:variable name="grey_bg" select="'#CCCCCC'"/>
		<xsl:variable name="borderBottom" select="'solid 1pt #000000'"/>

				<!--Salon    number-rows-spanned="4" -->
				<fo:table-row> 	
					<fo:table-cell text-align="center" number-rows-spanned="4" display-align="center" xsl:use-attribute-sets="cell-style0 bottom-cell-style right-cell-style">
						<fo:block><xsl:value-of select="$position" /></fo:block>
					</fo:table-cell>	
					<fo:table-cell text-align="center" number-rows-spanned="4" display-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style">
						<fo:block><xsl:value-of select="$businessunits[pos_cd_hint = $posCd]/businessunit_nm"/></fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" number-rows-spanned="4" display-align="center" xsl:use-attribute-sets="cell-style0 right-cell-style bottom-cell-style">
						<fo:block><xsl:value-of select="format-number($salonData/data/total,'###.##0,00','money')"/></fo:block>
					</fo:table-cell>
					


					<!-- Zeitraum -->
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:value-of select="'Zeitraum'" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/cnt_days, '###.##0,##', 'amount')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total_products, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total_products div $salonData/data/total, '###.##0,00', 'percent')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total_per_ma_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/total_per_customer, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/amount_customer, '###.##0,##', 'amount')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/data/amount_customer_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>	



			<!-- Vorjahr -->
			<fo:table-row>	
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:value-of select="'Vorjahr'" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/cnt_days, '###.##0,##', 'amount')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total_products, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total_products div $salonData/dataCompare/total, '###.##0,00', 'percent')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total_per_ma_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/total_per_customer, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/amount_customer, '###.##0,##', 'amount')" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:value-of select="format-number($salonData/dataCompare/amount_customer_per_day, '###.##0,00', 'money')" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>	


			<!-- Differenz -->
			<fo:table-row>	
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:value-of select="'Differenz'" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/cnt_days"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/cnt_days"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total_products"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_products"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0 right-cell-style" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total_products div $salonData/data/total"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_products div $salonData/dataCompare/total"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
							
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_day"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
							
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total_per_ma_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_ma_per_day"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
							<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/total_per_customer"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_customer"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
							<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/amount_customer"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/amount_customer"/>
									<xsl:with-param name="formatPattern" select="'###.##0,##'" />
									<xsl:with-param name="format" select="'amount'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" background-color="{$grey_bg}"  
							xsl:use-attribute-sets= "cell-style0" > 
						<fo:block>
								<xsl:call-template name="differenz">
									<xsl:with-param name="data" select="$salonData/data/amount_customer_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/amount_customer_per_day"/>
									<xsl:with-param name="formatPattern" select="'###.##0,00'" />
									<xsl:with-param name="format" select="'money'" />
									<xsl:with-param name="sign" select="''" />
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
				</fo:table-row>	


	<!-- Abweichung -->
			<fo:table-row>	
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0 right-cell-style  bottom-cell-style" > 
						<fo:block>
								<xsl:value-of select="'% Abweichung'" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/cnt_days"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/cnt_days"/>
								
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total"/>
									
								</xsl:call-template>
								
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total_products"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_products"/>
									
								</xsl:call-template>
							
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0 right-cell-style  bottom-cell-style" > 
						<fo:block>
							<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total_products div $salonData/data/total"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_products div $salonData/dataCompare/total"/>
									
								</xsl:call-template>
							
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_day"/>
									
								</xsl:call-template>
							
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
							<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total_per_ma_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_ma_per_day"/>
									
								</xsl:call-template>
							
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/total_per_customer"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/total_per_customer"/>
									
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/amount_customer"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/amount_customer"/>
									
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" 
							xsl:use-attribute-sets= "cell-style0  bottom-cell-style" > 
						<fo:block>
								<xsl:call-template name="abweichung">
									<xsl:with-param name="data" select="$salonData/data/amount_customer_per_day"/>
									<xsl:with-param name="dataCompare" select="$salonData/dataCompare/amount_customer_per_day"/>
									
								</xsl:call-template>
								
						</fo:block>
					</fo:table-cell>
				</fo:table-row>	


	</xsl:template>
	
	<xsl:template match="/">

		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="10mm">
					<fo:region-body margin-top="15mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="10mm" />
					<fo:region-before region-name="header" extent="10mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">
<xsl:variable name="title">
				Hitliste Salons BV			
</xsl:variable>

					<xsl:variable name="filterRows">
						<filterRow>
							<content>
								Ansicht: <xsl:choose>
											<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
												ausführende MA
											</xsl:when>
										
											<xsl:otherwise>
												beratende MA
											</xsl:otherwise>
										</xsl:choose>
							</content>
						</filterRow>
					</xsl:variable>

				    <xsl:call-template name="header">
						<xsl:with-param name="title" select="$title" />
						
						<xsl:with-param name="period1" select="report/report-params/DATE" />
						<xsl:with-param name="period2" select="report/report-params/TODATE" />
						<xsl:with-param name="filterRows" select="$filterRows" />
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
								
								<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Hitliste Salons BV	<xsl:choose>
											<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'">
												(ausführende)
											</xsl:when>
										
											<xsl:otherwise>
												(beratende)
											</xsl:otherwise>
										</xsl:choose>	Salon		
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
										&#160;bis&#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">


	<fo:table table-layout="fixed" border-collapse="collapse"
						width="100%" margin-top="0cm">

						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="12%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="9%"></fo:table-column>
						<fo:table-column column-width="5%"></fo:table-column>
						<fo:table-column column-width="10%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="9%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
					


						<fo:table-header>
							

								
							<fo:table-row border-bottom="1px solid #000000">


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style">
									<fo:block>Platz </fo:block>
								</fo:table-cell>
							
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Salon</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center" border-top="1px solid #000000"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Gesamt Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>AT</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
								
									xsl:use-attribute-sets="th1bold">
									<fo:block>Gsamt Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
								
									xsl:use-attribute-sets="th1bold">
									<fo:block>davon Verkauf Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
								
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>% VK Anteil</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro MA /pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Besuche</fo:block>
								</fo:table-cell>
							


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block> Besuche</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Besuche pro Tag</fo:block>
								</fo:table-cell>
								



							</fo:table-row>
						</fo:table-header>

						<fo:table-body>







						<xsl:for-each select="report/htBvSalon/salonData">
							
								<xsl:call-template name="salon-table">
									<xsl:with-param name="salonData" select="."/>
									<xsl:with-param name="position" select="position()"/>
									<xsl:with-param name="businessunits" select="/report/businessunits/row"/>
									
								</xsl:call-template>
							
						</xsl:for-each>

					</fo:table-body>
				</fo:table>
				
	
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>


	</xsl:template>



</xsl:stylesheet>