<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="date exsl" xmlns:csv="csv:csv">
  <xsl:import href="Header.xsl"/>
	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="right-cell-style">

		<xsl:attribute name="border-right-color">#000000</xsl:attribute>
		<xsl:attribute name="border-right-width">1px</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<csv:columns>
		<column>position<desc>Platz</desc>
		</column>
		<column>r_department_no<desc>Marke</desc>
		</column>

		<column>r_businessunit_no<desc>Salon</desc>
		</column>
	
		<column>r_employee_nm<desc>Mitarbeiter</desc>
		</column>

		<column>r_planed_week_working_hours<desc>Std. Woche</desc>
		</column>
		<column>r_cnt_dt<desc>AT</desc>
		</column>
		<column>r_total<desc>Umsatz</desc>
		</column>
		<column>r_total_products<desc>davon Verkauf</desc>
		</column>
		<column>r_total_per_day<desc>Umsatz pro Tag</desc>
		</column>
		<column>r_total_product_per_day<desc>davon VK pro Tag</desc>
		</column>
		<column>r_total_per_customer<desc>Umsatz pro Besuch</desc>
		</column>
		<column>r_amount_customer_per_day<desc>Besuche pro Tag</desc>
		</column>
		<column>r_total_per_day_prev_year<desc>Umsatz pro Tag (Vorjahr gleicher Zeitraum)</desc>
		</column>
		<column>r_total_product_per_day_prev_year<desc>davon VK pro Tag (Vorjahr gleicher Zeitraum)</desc>
		</column>
		<column>r_total_per_customer_prev_year<desc>Umsatz pro Besuch (Vorjahr gleicher Zeitraum)</desc>
		</column>
		<column>r_amount_customer_per_day_prev_year<desc>Besuche pro Tag (Vorjahr gleicher Zeitraum)</desc>
		</column>
	</csv:columns>

<xsl:template name="prozentAbw">
	<xsl:param name="data"/>
	<xsl:param name="dataCompare"/>

	<xsl:choose>
					<xsl:when test="string(number($dataCompare)) = 'NaN' and string(number($data)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($dataCompare)) = 'NaN'">
						<xsl:value-of select="'-'"/>
					</xsl:when>
					<xsl:when test="string(number($data)) = 'NaN'">
						<xsl:value-of select="format-number(0 ,'###.##0,##' , 'percent')"/>%
					</xsl:when>
					<xsl:when test="$dataCompare = 0">
						<xsl:value-of select="'-'" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((($data div $dataCompare ) -1) * 100 ,'###.##0,##' , 'percent')"/>%
					</xsl:otherwise>
				</xsl:choose>

</xsl:template>


	<xsl:template match="/">

		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4"
					page-height="21cm" page-width="29.7cm" margin-top="10mm"
					margin-bottom="10mm" margin-left="10mm" margin-right="20mm">
					<fo:region-body margin-top="20mm" margin-bottom="5mm"
						margin-left="0mm" margin-right="0mm" />
					<fo:region-before region-name="header" extent="20mm" />
					<fo:region-after region-name="footer" extent="5mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="A4">
				<!-- <fo:static-content flow-name="header"> <fo:block> <fo:instream-foreign-object 
					xmlns:svg="http://www.w3.org/2000/svg"> <svg:svg width="90mm" height="150mm"> 
					<svg:g style="fill:red; stroke:#000000; fill-opacity=0.8"> <svg:text x="70" 
					y="70" font-family="Helvetica" font-size="30" transform="rotate(60 20,40)"> 
					Muster, kein Beleg! </svg:text> </svg:g> </svg:svg> </fo:instream-foreign-object> 
					</fo:block> </fo:static-content> -->
				<fo:static-content flow-name="header">
					<xsl:variable name="filterRows">
							<filterRow>
								<content>
									Ansicht: <xsl:choose>
												<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'operatingEmployee'">
													ausführende MA
												</xsl:when>
												<xsl:otherwise>
													beratende MA
												</xsl:otherwise>
											</xsl:choose>
								</content>
							</filterRow>
						</xsl:variable>

						<xsl:call-template name="header">
							<xsl:with-param name="title" select='"Hitliste Gesamtumsatz MA"' />
							
							<xsl:with-param name="period1" select="report/report-params/DATE" />
							<xsl:with-param name="period2" select="report/report-params/TODATE" />
							
							<xsl:with-param name="filterRows" select="$filterRows" />
						</xsl:call-template>

				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block xsl:use-attribute-sets="text-style" text-align="left"
						font-size="8pt">
						<fo:table>
							<fo:table-column column-width="20%"></fo:table-column>
							<fo:table-column column-width="60%"></fo:table-column>
							<fo:table-column column-width="20%"></fo:table-column>

							<fo:table-body>
								<fo:table-row>
								<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Erstellt:
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/NOW" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell text-align="left"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Hitliste Salon 
												<xsl:choose>
												<xsl:when test="/report/report-params/EMPLOYEE_MODE = 'operatingEmployee'">
													(ausführend) 
												</xsl:when>
												<xsl:otherwise>
													(beratend)
												</xsl:otherwise>
											</xsl:choose>
											 von &#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											&#160;bis&#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								
									<fo:table-cell text-align="right"
										xsl:use-attribute-sets="text-style">
										<fo:block>
											Seite
											<fo:page-number />
											von
											<fo:page-number-citation ref-id="LastPage" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>

						</fo:table>
					</fo:block>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">

					<fo:table table-layout="fixed" border-collapse="collapse"
						width="100%" margin-top="0cm">

						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="9%"></fo:table-column>
						<fo:table-column column-width="12%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="3%"></fo:table-column>
						<fo:table-column column-width="8%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
					

						<fo:table-column column-width="7%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>
						<fo:table-column column-width="6%"></fo:table-column>


						<fo:table-header>
							<fo:table-row>

								<fo:table-cell text-align="center"
									number-columns-spanned="5" xsl:use-attribute-sets="th1bold-left right-cell-style">
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="7" xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block><xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/DATE" />
											</xsl:call-template>
											&#160;bis&#160;
											<xsl:call-template name="formatdate">
												<xsl:with-param name="datestr"
													select="report/report-params/TODATE" />
											</xsl:call-template>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									number-columns-spanned="4" xsl:use-attribute-sets="th1bold">
									<fo:block>% Abweichung zum Vorjahr</fo:block>
								</fo:table-cell>


							</fo:table-row>
							<fo:table-row border-bottom="1px solid #000000">


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold right-cell-style">
									<fo:block>Platz </fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Marke</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Salon</fo:block>
								</fo:table-cell>
								
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Mitarbeiter</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Soll Std</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Ist AT</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center" border-left="1px solid #000000" border-top="1px solid #000000"
								
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Umsatz</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
								
									xsl:use-attribute-sets="th1bold">
									<fo:block>davon Verkauf</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
								
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>davon VK pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Besuch</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold  right-cell-style">
									<fo:block>Besuche pro Tag</fo:block>
								</fo:table-cell>
							


								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block> Umsatz pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>davon VK pro Tag</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Umsatz pro Besuch</fo:block>

								</fo:table-cell>
								<fo:table-cell text-align="center"
									xsl:use-attribute-sets="th1bold">
									<fo:block>Besuche pro Tag</fo:block>
								</fo:table-cell>



							</fo:table-row>
						</fo:table-header>

						<fo:table-body>
							<xsl:for-each select="/report/employeeRevenue/period/data/row">

								<xsl:variable name="grey_bg">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 1">
											#FFFFFF
										</xsl:when>
										<xsl:otherwise>
											#CCCCCC
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<fo:table-row background-color="{$grey_bg}">



									<xsl:variable name="property" select="." />
									<xsl:variable name="posCd" select="r_pos_cd" />

									<xsl:variable name="companyNo" select="r_company_no" />
									<xsl:variable name="departmentNo" select="r_department_no" />
									<xsl:variable name="employeeNo" select="r_employee_no" />
									<xsl:variable name="position" select="position()"></xsl:variable>


									<xsl:variable name="prevYearRow"
										select="/report/employeeRevenue/comparePeriod/data/row[r_pos_cd = $posCd][r_employee_no = $employeeNo]"></xsl:variable>


									<xsl:variable name="buNm"
										select="/report/businessunits/row[pos_cd_hint = $posCd]/businessunit_nm"></xsl:variable>
									<xsl:variable name="departmentNm"
										select="/report/departments/row[company_no = $companyNo][department_no = $departmentNo]/department_nm"></xsl:variable>
									<!-- Loop through the columns in order -->
									<xsl:for-each select="document('')/*/csv:columns/*">
										<!-- Extract the column name and value -->
										<xsl:variable name="column" select="./text()" />
										<xsl:variable name="value"
											select="$property/*[name() = $column]" />
										<xsl:choose>
											<xsl:when test="$column='r_pos_cd'"></xsl:when>
										
											<xsl:when test="$column='position'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0  right-cell-style">
													<fo:block>

														<xsl:value-of select="$position" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_department_no'">
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of select="$departmentNm" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_businessunit_no'">
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of select="$buNm" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											
											<xsl:when test="$column='r_employee_nm'">
												<fo:table-cell text-align="left"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of select="$value" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_planed_week_working_hours'">
											<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0 right-cell-style">
													<fo:block>
														<xsl:value-of select="$value" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_cnt_dt'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of select="$value" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>

											<xsl:when test="$column='r_cnt_dt_prev_year'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of select="$prevYearRow/r_cnt_dt" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
										
											<xsl:when test="$column='r_total_per_day_prev_year'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:call-template name="prozentAbw">
															<xsl:with-param name="data" select="$property/r_total_per_day"/>
															<xsl:with-param name="dataCompare" select="$prevYearRow/r_total_per_day"/>
														</xsl:call-template>
														
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_total_product_per_day_prev_year'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:call-template name="prozentAbw">
															<xsl:with-param name="data" select="$property/r_total_product_per_day"/>
															<xsl:with-param name="dataCompare" select="$prevYearRow/r_total_product_per_day"/>
														</xsl:call-template>
														
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_total_per_customer_prev_year'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:call-template name="prozentAbw">
															<xsl:with-param name="data" select="$property/r_total_per_customer"/>
															<xsl:with-param name="dataCompare" select="$prevYearRow/r_total_per_customer"/>
														</xsl:call-template>
													
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_amount_customer_per_day_prev_year'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:call-template name="prozentAbw">
															<xsl:with-param name="data" select="$property/r_amount_customer_per_day"/>
															<xsl:with-param name="dataCompare" select="$prevYearRow/r_amount_customer_per_day"/>
														</xsl:call-template>
													
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_amount_customer_per_day'">
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0 right-cell-style">
													<fo:block>
															<xsl:value-of
															select="format-number($value, '###.##0,##', 'money')" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_total_per_day'">
												<fo:table-cell text-align="center" 
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of
															select="format-number($value, '###.##0,00', 'money')" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_total'">
												<fo:table-cell text-align="center" border-left="1px solid #000000"
													xsl:use-attribute-sets="cell-style0 right-cell-style">
													<fo:block>
														<xsl:value-of
															select="format-number($value, '###.##0,00', 'money')" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:when test="$column='r_total_products'">
												<fo:table-cell text-align="center" 
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of
															select="format-number($value, '###.##0,00', 'money')" />
													</fo:block>
												</fo:table-cell>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-cell text-align="center"
													xsl:use-attribute-sets="cell-style0">
													<fo:block>
														<xsl:value-of
															select="format-number($value, '###.##0,00', 'money')" />
													</fo:block>
												</fo:table-cell>
											</xsl:otherwise>
										</xsl:choose>


									</xsl:for-each>
								</fo:table-row>
							</xsl:for-each>



						</fo:table-body>

					</fo:table>



					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>


	</xsl:template>



</xsl:stylesheet>