<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	 xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exsl="http://exslt.org/common" extension-element-prefixes="date exsl" xmlns:csv="csv:csv">

	<xsl:decimal-format name="money" decimal-separator=","
		grouping-separator="." NaN="0,00" />
	<xsl:decimal-format name="amount" decimal-separator=","
		grouping-separator="." NaN="0" />
	<xsl:decimal-format name="percent"
		decimal-separator="," grouping-separator="." NaN="0" />

	<xsl:attribute-set name="debug">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-width">0.5mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th3bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="background-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>

	</xsl:attribute-set>

	<xsl:attribute-set name="th1">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th1bold-left">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="th2bold">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="tf2">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style0">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="padding">0.5mm</xsl:attribute>
		<xsl:attribute name="border-color">#cccccc</xsl:attribute>
		<xsl:attribute name="border-width">0.25mm</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-style">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-small">
		<xsl:attribute name="font-size">6pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text-bold">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="spacer">
		<xsl:attribute name="font-size">3pt</xsl:attribute>
		<xsl:attribute name="line-height">1mm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="title-style">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="report-title">
		<xsl:attribute name="font-size">10pt</xsl:attribute>

	</xsl:attribute-set>

	<xsl:template name="formatdate">
		<xsl:param name="datestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datestr,9,2)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$datestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formattime">
		<xsl:param name="timestr" />

		<xsl:variable name="time">
			<xsl:value-of select="substring($timestr,12,8)" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$timestr != ''">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatdatetime">
		<xsl:param name="datetimestr" />

		<xsl:variable name="yyyy">
			<xsl:value-of select="substring($datetimestr,1,4)" />
		</xsl:variable>

		<xsl:variable name="mm">
			<xsl:value-of select="substring($datetimestr,6,2)" />
		</xsl:variable>

		<xsl:variable name="dd">
			<xsl:value-of select="substring($datetimestr,9,2)" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring($datetimestr,12,8)" />
		</xsl:variable>


		<xsl:choose>
			<xsl:when test="$datetimestr != ''">
				<xsl:value-of select="$dd" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$mm" />
				<xsl:value-of select="'.'" />
				<xsl:value-of select="$yyyy" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>




	<xsl:output method="text"  encoding="ISO-8859-1"  />
	<xsl:strip-space elements="*" />
	<xsl:variable name="delimiter" select="';'" />
	<csv:columns>
        <column>position<desc>Platz</desc></column>
		<column>r_department_no<desc>Marke</desc></column>
		
		<column>r_businessunit_no<desc>Salon</desc></column>
		
		<column>r_amount_group1_percent<desc>Prozentualer Anteil Damen</desc></column>
		<column>r_amount_group2_percent<desc>Prozentualer Anteil Herren</desc></column>
		<column>r_amount_group3_percent<desc>Prozentualer Anteil Kinder</desc></column>
		<column>r_amount_products_percent<desc>Prozentualer Anteil Verkauf</desc></column>
		
		<column>total_per_day_per_ma<desc>Umsatz pro Tag/pro MA</desc></column>
		<column>cnt_customer_per_day_per_ma<desc>Besuche pro Tag/pro MA</desc></column>
		<column>total_services_per_day_per_ma<desc>DL pro Tag/pro MA</desc></column>
		<column>total_products_per_day_per_ma<desc>Verkauf pro Tag/pro MA</desc></column>
		<column>r_total_per_customer<desc>Umsatz pro Besuch</desc></column>
		
		<column>r_total_prev_year<desc>Vergleich Vorjahr Gesamt Umsatz</desc></column>
		<column>r_amount_customer_prev_year<desc>Vergleich Vorjahr Anzahl Besuche</desc></column>
		<column>r_total_products_prev_year<desc>Vergleich Vorjahr Verkauf</desc></column>
		<column>r_total_per_customer_prev_year<desc>Vergleich Vorjahr Umsatz pro Besuch</desc></column>
		
		
		
	</csv:columns>

	<xsl:template match="/">
<xsl:text>Hitliste Salon </xsl:text><xsl:choose>
									<xsl:when test="report/report-params/EMPLOYEE_MODE= 'operatingEmployee'"> <xsl:text>(ausführend) </xsl:text> </xsl:when>
									<xsl:otherwise><xsl:text>	(beratend) </xsl:text>	</xsl:otherwise>
								</xsl:choose> <xsl:text>von </xsl:text><xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/DATE" />
							</xsl:call-template>
							<xsl:text> bis </xsl:text><xsl:call-template name="formatdate">
								<xsl:with-param name="datestr" select="report/report-params/TODATE" />
							</xsl:call-template>
							
					<xsl:text>
</xsl:text>
	
						<xsl:text>
</xsl:text>	
		<!-- Output the CSV header -->
		<xsl:for-each select="document('')/*/csv:columns/*">
			<xsl:value-of select="./desc" />
			<xsl:if test="position() != last()">
				<xsl:value-of select="$delimiter" />
			</xsl:if>
		</xsl:for-each>
		<!-- Add a newline at the end of the record -->
		<xsl:text>
</xsl:text>



			<xsl:for-each select="report/posRevenue/period/data/row">
			
			<xsl:variable name="property" select="." />
	<xsl:variable name="posCd" select="pos_cd" />

	<xsl:variable name="companyNo" select="company_no" />
	<xsl:variable name="departmentNo" select="department_no" />
			<xsl:variable name="position" select="position()"></xsl:variable>
			
			
			<xsl:variable name="sumPrevYearRows" select="/report/posRevenue/compareperiod/sumdata/row[r_pos_cd = $posCd]"></xsl:variable>
			<xsl:variable name="sumRows" select="/report/posRevenue/period/sumdata/row[r_pos_cd = $posCd]"></xsl:variable>
			
			<xsl:variable name="buNm" select="/report/businessunits/row[pos_cd_hint = $posCd]/businessunit_nm"></xsl:variable>
			<xsl:variable name="companyNm" select="/report/companies/row[company_no = $companyNo]/company_nm"></xsl:variable>
			<xsl:variable name="departmentNm" select="/report/departments/row[department_no = $departmentNo]/department_nm"></xsl:variable>
			<!-- Loop through the columns in order -->
			<xsl:for-each select="document('')/*/csv:columns/*">
				<!-- Extract the column name and value -->
				<xsl:variable name="column" select="./text()" />
				<xsl:variable name="value" select="$property/*[name() = $column]" />
				<xsl:choose>
				<xsl:when test="$column='r_pos_cd'"></xsl:when>
				
				<xsl:when test="$column='position'"><xsl:text>"</xsl:text><xsl:value-of select="$position" /><xsl:text>"</xsl:text></xsl:when>
				<xsl:when test="$column='r_department_no'"><xsl:text>"</xsl:text><xsl:value-of select="$departmentNm" /><xsl:text>"</xsl:text></xsl:when>
				<xsl:when test="$column='r_businessunit_no'"><xsl:text>"</xsl:text><xsl:value-of select="$buNm" /><xsl:text>"</xsl:text></xsl:when>
				
				<xsl:when test="$column='r_amount_group1_percent'">
				
				<xsl:value-of select="format-number(($property/r_total_g1_services div $property/r_total )* 100, '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
		
				</xsl:when>	
				
				<xsl:when test="$column='r_amount_group2_percent'">
				<xsl:value-of select="format-number(($property/r_total_g2_services div $property/r_total )* 100, '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
				</xsl:when>	
				<xsl:when test="$column='r_amount_group3_percent'">
				<xsl:value-of select="format-number(($property/r_total_g3_services div $property/r_total )* 100, '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
				</xsl:when>	
					<xsl:when test="$column='r_amount_products_percent'">
				<xsl:value-of select="format-number(($property/r_total_products div $property/r_total )* 100, '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
				</xsl:when>	
				<xsl:when test="$column='r_total_per_customer'">
				
							<xsl:value-of
														select="format-number($property/total_per_customer_per_ma, '###.##0,00', 'money')" />
																					
														
							<!-- 							<xsl:choose>
												<xsl:when test="$property/r_total_per_day_per_employee &lt; 0 and $property/r_amount_customer_per_day_per_employee &lt; 0">
													<xsl:value-of
														select="format-number($property/r_total_per_day_per_employee div  (-1 * $property/r_amount_customer_per_day_per_employee ), '###.##0,00', 'money')" />
													

												</xsl:when>
												<xsl:when test="$property/r_amount_customer_per_day_per_employee =0">
													0,00

												</xsl:when>
												<xsl:otherwise>
														<xsl:value-of
														select="format-number($property/r_total_per_day_per_employee div  $property/r_amount_customer_per_day_per_employee , '###.##0,00', 'money')" />
												</xsl:otherwise>
											</xsl:choose> -->
				
				  
				</xsl:when>	
				
				<xsl:when test="$column='r_total_prev_year'">
					<xsl:choose >
					   <xsl:when test="$sumPrevYearRows/r_total != 0">
					      <xsl:value-of select="format-number((($sumRows/r_total div $sumPrevYearRows/r_total)-1)*100 , '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
					   </xsl:when>
					   <xsl:otherwise>
					      <xsl:text>-</xsl:text>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:when>	
				<xsl:when test="$column='r_amount_customer_prev_year'">
					<xsl:choose >
					   <xsl:when test="$sumPrevYearRows/r_amount_customer != 0">
					      <xsl:value-of select="format-number((($sumRows/r_amount_customer div $sumPrevYearRows/r_amount_customer)-1)*100 , '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
					   </xsl:when>
					   <xsl:otherwise>
					      <xsl:text>-</xsl:text>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:when>	
				<xsl:when test="$column='r_total_products_prev_year'">
					<xsl:choose >
					   <xsl:when test="$sumPrevYearRows/r_total_products != 0">
					      <xsl:value-of select="format-number((($sumRows/r_amount_customer div $sumPrevYearRows/r_total_products)-1)*100 , '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
					   </xsl:when>
					   <xsl:otherwise>
					      <xsl:text>-</xsl:text>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:when>	
				<xsl:when test="$column='r_total_per_customer_prev_year'">
					<xsl:choose >
					   <xsl:when test="$sumPrevYearRows/r_total_per_customer != 0">
					      <xsl:value-of select="format-number((($sumRows/r_total_per_customer div $sumPrevYearRows/r_total_per_customer)-1)*100 , '###.##0,00', 'money')" /><xsl:text>%</xsl:text>
					   </xsl:when>
					   <xsl:otherwise>
					      <xsl:text>-</xsl:text>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:when>	
			
			
				
				<xsl:otherwise>
					<xsl:value-of select="format-number($value, '###.##0,00', 'money')" />
				</xsl:otherwise>
				</xsl:choose>


				<!-- Add the delimiter unless we are the last expression -->
				<xsl:if test="position() != last()">
					<xsl:value-of select="$delimiter" />
				</xsl:if>
			</xsl:for-each>
			<!-- Add a newline at the end of the record -->
			<xsl:text>
</xsl:text>
		</xsl:for-each>
		


		
		</xsl:template>

	

</xsl:stylesheet>